/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.converter;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.dmg.pmml.Application;
import org.dmg.pmml.Apply;
import org.dmg.pmml.Array;
import org.dmg.pmml.Constant;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Header;
import org.dmg.pmml.Interval;
import org.dmg.pmml.RealSparseArray;
import org.dmg.pmml.Timestamp;
import org.dmg.pmml.Value;
import org.jpmml.converter.ValueUtil;

public class PMMLUtil {
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");

    private PMMLUtil() {
    }

    public static Header createHeader(Class<?> clazz) {
        Package _package = clazz.getPackage();
        return PMMLUtil.createHeader(_package.getImplementationTitle(), _package.getImplementationVersion());
    }

    public static Header createHeader(String name, String version) {
        Application application = new Application().setName(name).setVersion(version);
        return PMMLUtil.createHeader(application);
    }

    public static Header createHeader(Application application) {
        Date now = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        dateFormat.setTimeZone(UTC);
        Timestamp timestamp = new Timestamp().addContent(new Object[]{dateFormat.format(now)});
        Header header = new Header().setApplication(application).setTimestamp(timestamp);
        return header;
    }

    public static List<String> getValues(DataField dataField) {
        return PMMLUtil.getValues(dataField, null);
    }

    public static List<String> getValues(DataField dataField, Value.Property property) {
        ArrayList<String> result = new ArrayList<String>();
        if (property == null) {
            property = Value.Property.VALID;
        }
        List pmmlValues = dataField.getValues();
        for (Value pmmlValue : pmmlValues) {
            if (!property.equals((Object)pmmlValue.getProperty())) continue;
            result.add(pmmlValue.getValue());
        }
        return result;
    }

    public static void addValues(DataField dataField, List<String> values) {
        PMMLUtil.addValues(dataField, values, null);
    }

    public static void addValues(DataField dataField, List<String> values, Value.Property property) {
        if (Value.Property.VALID.equals((Object)property)) {
            property = null;
        }
        List pmmlValues = dataField.getValues();
        for (String value : values) {
            Value pmmlValue = new Value(value).setProperty(property);
            pmmlValues.add(pmmlValue);
        }
    }

    public static void addIntervals(DataField dataField, List<Interval> intervals) {
        dataField.getIntervals().addAll(intervals);
    }

    public static Apply createApply(String function, Expression ... expressions) {
        Apply apply = new Apply(function).addExpressions(expressions);
        return apply;
    }

    public static Constant createConstant(Object value) {
        Constant constant = new Constant(ValueUtil.formatValue(value));
        if (value instanceof Double) {
            constant.setDataType(DataType.DOUBLE);
        }
        return constant;
    }

    public static Array createStringArray(List<?> values) {
        Array array = new Array(Array.Type.STRING, ValueUtil.formatArray(values));
        return array;
    }

    public static Array createIntArray(List<Integer> values) {
        Array array = new Array(Array.Type.INT, ValueUtil.formatArray(values));
        return array;
    }

    public static Array createRealArray(List<? extends Number> values) {
        Array array = new Array(Array.Type.REAL, ValueUtil.formatArray(values));
        return array;
    }

    public static RealSparseArray createRealSparseArray(List<? extends Number> values, Double defaultValue) {
        RealSparseArray sparseArray = new RealSparseArray().setN(Integer.valueOf(values.size())).setDefaultValue(defaultValue);
        int index = 1;
        for (Number number : values) {
            if (!ValueUtil.equals(number, defaultValue)) {
                sparseArray.addIndices(new Integer[]{index});
                sparseArray.addEntries(new Double[]{ValueUtil.asDouble(number)});
            }
            ++index;
        }
        return sparseArray;
    }
}

