#############################################################################
##
## Copyright (C) 2021 The Qt Company Ltd.
## Contact: https://www.qt.io/licensing/
##
## This file is part of Qt for Python.
##
## $QT_BEGIN_LICENSE:LGPL$
## Commercial License Usage
## Licensees holding valid commercial Qt licenses may use this file in
## accordance with the commercial license agreement provided with the
## Software or, alternatively, in accordance with the terms contained in
## a written agreement between you and The Qt Company. For licensing terms
## and conditions see https://www.qt.io/terms-conditions. For further
## information use the contact form at https://www.qt.io/contact-us.
##
## GNU Lesser General Public License Usage
## Alternatively, this file may be used under the terms of the GNU Lesser
## General Public License version 3 as published by the Free Software
## Foundation and appearing in the file LICENSE.LGPL3 included in the
## packaging of this file. Please review the following information to
## ensure the GNU Lesser General Public License version 3 requirements
## will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
##
## GNU General Public License Usage
## Alternatively, this file may be used under the terms of the GNU
## General Public License version 2.0 or (at your option) the GNU General
## Public license version 3 or any later version approved by the KDE Free
## Qt Foundation. The licenses are as published by the Free Software
## Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
## included in the packaging of this file. Please review the following
## information to ensure the GNU General Public License requirements will
## be met: https://www.gnu.org/licenses/gpl-2.0.html and
## https://www.gnu.org/licenses/gpl-3.0.html.
##
## $QT_END_LICENSE$
##
#############################################################################
"""
This file contains the exact signatures for all functions in module
PySide6.QtWebEngineWidgets, except for defaults which are replaced by "...".
"""

# Module `PySide6.QtWebEngineWidgets`

from shiboken6 import Shiboken

from typing import Optional, Union, overload

import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets
import PySide6.QtPrintSupport
import PySide6.QtWebEngineCore
import PySide6.QtWebEngineWidgets


class QWebEngineView(PySide6.QtWidgets.QWidget):

    def __init__(self, parent:Optional[PySide6.QtWidgets.QWidget]=...) -> None: ...

    def back(self) -> None: ...
    def closeEvent(self, arg__1:PySide6.QtGui.QCloseEvent) -> None: ...
    def contextMenuEvent(self, arg__1:PySide6.QtGui.QContextMenuEvent) -> None: ...
    def createStandardContextMenu(self) -> PySide6.QtWidgets.QMenu: ...
    def createWindow(self, type:PySide6.QtWebEngineCore.QWebEnginePage.WebWindowType) -> PySide6.QtWebEngineWidgets.QWebEngineView: ...
    def dragEnterEvent(self, e:PySide6.QtGui.QDragEnterEvent) -> None: ...
    def dragLeaveEvent(self, e:PySide6.QtGui.QDragLeaveEvent) -> None: ...
    def dragMoveEvent(self, e:PySide6.QtGui.QDragMoveEvent) -> None: ...
    def dropEvent(self, e:PySide6.QtGui.QDropEvent) -> None: ...
    def event(self, arg__1:PySide6.QtCore.QEvent) -> bool: ...
    @overload
    def findText(self, arg__1:str, arg__2:PySide6.QtWebEngineCore.QWebEnginePage.FindFlags, arg__3:object) -> None: ...
    @overload
    def findText(self, subString:str, options:PySide6.QtWebEngineCore.QWebEnginePage.FindFlags=...) -> None: ...
    @staticmethod
    def forPage(page:PySide6.QtWebEngineCore.QWebEnginePage) -> PySide6.QtWebEngineWidgets.QWebEngineView: ...
    def forward(self) -> None: ...
    def hasSelection(self) -> bool: ...
    def hideEvent(self, arg__1:PySide6.QtGui.QHideEvent) -> None: ...
    def history(self) -> PySide6.QtWebEngineCore.QWebEngineHistory: ...
    def icon(self) -> PySide6.QtGui.QIcon: ...
    def iconUrl(self) -> PySide6.QtCore.QUrl: ...
    def lastContextMenuRequest(self) -> PySide6.QtWebEngineCore.QWebEngineContextMenuRequest: ...
    @overload
    def load(self, request:PySide6.QtWebEngineCore.QWebEngineHttpRequest) -> None: ...
    @overload
    def load(self, url:Union[PySide6.QtCore.QUrl, str]) -> None: ...
    def page(self) -> PySide6.QtWebEngineCore.QWebEnginePage: ...
    def pageAction(self, action:PySide6.QtWebEngineCore.QWebEnginePage.WebAction) -> PySide6.QtGui.QAction: ...
    def print(self, printer:PySide6.QtPrintSupport.QPrinter) -> None: ...
    def printToPdf(self, filePath:str, layout:PySide6.QtGui.QPageLayout=..., ranges:PySide6.QtGui.QPageRanges=...) -> None: ...
    def reload(self) -> None: ...
    def selectedText(self) -> str: ...
    def setContent(self, data:Union[PySide6.QtCore.QByteArray, bytes], mimeType:str=..., baseUrl:Union[PySide6.QtCore.QUrl, str]=...) -> None: ...
    def setHtml(self, html:str, baseUrl:Union[PySide6.QtCore.QUrl, str]=...) -> None: ...
    def setPage(self, page:PySide6.QtWebEngineCore.QWebEnginePage) -> None: ...
    def setUrl(self, url:Union[PySide6.QtCore.QUrl, str]) -> None: ...
    def setZoomFactor(self, factor:float) -> None: ...
    def settings(self) -> PySide6.QtWebEngineCore.QWebEngineSettings: ...
    def showEvent(self, arg__1:PySide6.QtGui.QShowEvent) -> None: ...
    def sizeHint(self) -> PySide6.QtCore.QSize: ...
    def stop(self) -> None: ...
    def title(self) -> str: ...
    def triggerPageAction(self, action:PySide6.QtWebEngineCore.QWebEnginePage.WebAction, checked:bool=...) -> None: ...
    def url(self) -> PySide6.QtCore.QUrl: ...
    def zoomFactor(self) -> float: ...


# eof
