# coding: utf-8

"""
    RevEng.AI API

    RevEng.AI is Similarity Search Engine for executable binaries

    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from revengai.models.matched_function import MatchedFunction
from typing import Optional, Set
from typing_extensions import Self

class FunctionMatchingResultWithBestMatch(BaseModel):
    """
    FunctionMatchingResultWithBestMatch
    """ # noqa: E501
    function_id: StrictInt
    matched_function: MatchedFunction
    suggested_name: Optional[StrictStr] = None
    suggested_name_confidence: Optional[Union[StrictFloat, StrictInt]] = None
    __properties: ClassVar[List[str]] = ["function_id", "matched_function", "suggested_name", "suggested_name_confidence"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FunctionMatchingResultWithBestMatch from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of matched_function
        if self.matched_function:
            _dict['matched_function'] = self.matched_function.to_dict()
        # set to None if suggested_name (nullable) is None
        # and model_fields_set contains the field
        if self.suggested_name is None and "suggested_name" in self.model_fields_set:
            _dict['suggested_name'] = None

        # set to None if suggested_name_confidence (nullable) is None
        # and model_fields_set contains the field
        if self.suggested_name_confidence is None and "suggested_name_confidence" in self.model_fields_set:
            _dict['suggested_name_confidence'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FunctionMatchingResultWithBestMatch from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "function_id": obj.get("function_id"),
            "matched_function": MatchedFunction.from_dict(obj["matched_function"]) if obj.get("matched_function") is not None else None,
            "suggested_name": obj.get("suggested_name"),
            "suggested_name_confidence": obj.get("suggested_name_confidence")
        })
        return _obj


