# coding: utf-8

"""
    RevEng.AI API

    RevEng.AI is Similarity Search Engine for executable binaries

    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List
from revengai.models.generation_status_list import GenerationStatusList
from typing import Optional, Set
from typing_extensions import Self

class GenerateFunctionDataTypes(BaseModel):
    """
    GenerateFunctionDataTypes
    """ # noqa: E501
    queued: StrictBool = Field(description="[DEPRECATED] This value has been replaced with the `data_types_list` field")
    reference: StrictStr = Field(description="[DEPRECATED] This value has been replaced with the `data_types_list` field")
    data_types_list: GenerationStatusList = Field(description="List of function data types information that are either already generated, or now queued for generation")
    __properties: ClassVar[List[str]] = ["queued", "reference", "data_types_list"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GenerateFunctionDataTypes from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of data_types_list
        if self.data_types_list:
            _dict['data_types_list'] = self.data_types_list.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GenerateFunctionDataTypes from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "queued": obj.get("queued"),
            "reference": obj.get("reference"),
            "data_types_list": GenerationStatusList.from_dict(obj["data_types_list"]) if obj.get("data_types_list") is not None else None
        })
        return _obj


