"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
import google.protobuf.timestamp_pb2
import typing
import weaveapi.payment.v1.invoice_pb2
import weaveapi.payment.v1.subscription_pb2

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class CreateCheckoutSessionRequest(google.protobuf.message.Message):
    """Request/Response messages"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class MetadataEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(
            self, field_name: typing.Literal["key", b"key", "value", b"value"]
        ) -> None: ...

    PRICE_ID_FIELD_NUMBER: builtins.int
    SUCCESS_URL_FIELD_NUMBER: builtins.int
    CANCEL_URL_FIELD_NUMBER: builtins.int
    PROMO_CODE_FIELD_NUMBER: builtins.int
    ALLOW_PROMOTION_CODES_FIELD_NUMBER: builtins.int
    TRIAL_DAYS_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    CUSTOMER_EMAIL_FIELD_NUMBER: builtins.int
    AUTOMATIC_TAX_FIELD_NUMBER: builtins.int
    TAX_ID_COLLECTION_FIELD_NUMBER: builtins.int
    price_id: builtins.str
    """Stripe price ID for the plan"""
    success_url: builtins.str
    """Where to redirect on success"""
    cancel_url: builtins.str
    """Where to redirect on cancel"""
    promo_code: builtins.str
    """Optional parameters"""
    allow_promotion_codes: builtins.bool
    trial_days: builtins.int
    customer_email: builtins.str
    """Customer info (if not logged in)"""
    automatic_tax: builtins.bool
    """Tax"""
    @property
    def metadata(
        self,
    ) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]: ...
    @property
    def tax_id_collection(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Types of tax IDs to collect"""

    def __init__(
        self,
        *,
        price_id: builtins.str = ...,
        success_url: builtins.str = ...,
        cancel_url: builtins.str = ...,
        promo_code: builtins.str = ...,
        allow_promotion_codes: builtins.bool = ...,
        trial_days: builtins.int = ...,
        metadata: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        customer_email: builtins.str = ...,
        automatic_tax: builtins.bool = ...,
        tax_id_collection: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "allow_promotion_codes",
            b"allow_promotion_codes",
            "automatic_tax",
            b"automatic_tax",
            "cancel_url",
            b"cancel_url",
            "customer_email",
            b"customer_email",
            "metadata",
            b"metadata",
            "price_id",
            b"price_id",
            "promo_code",
            b"promo_code",
            "success_url",
            b"success_url",
            "tax_id_collection",
            b"tax_id_collection",
            "trial_days",
            b"trial_days",
        ],
    ) -> None: ...

global___CreateCheckoutSessionRequest = CreateCheckoutSessionRequest

@typing.final
class CreateCheckoutSessionResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SESSION_ID_FIELD_NUMBER: builtins.int
    CHECKOUT_URL_FIELD_NUMBER: builtins.int
    EXPIRES_AT_FIELD_NUMBER: builtins.int
    session_id: builtins.str
    checkout_url: builtins.str
    """Stripe hosted checkout URL"""
    @property
    def expires_at(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    def __init__(
        self,
        *,
        session_id: builtins.str = ...,
        checkout_url: builtins.str = ...,
        expires_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing.Literal["expires_at", b"expires_at"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "checkout_url",
            b"checkout_url",
            "expires_at",
            b"expires_at",
            "session_id",
            b"session_id",
        ],
    ) -> None: ...

global___CreateCheckoutSessionResponse = CreateCheckoutSessionResponse

@typing.final
class GetSubscriptionStatusRequest(google.protobuf.message.Message):
    """Uses JWT from Authorization header"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___GetSubscriptionStatusRequest = GetSubscriptionStatusRequest

@typing.final
class GetSubscriptionStatusResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SUBSCRIPTION_FIELD_NUMBER: builtins.int
    @property
    def subscription(
        self,
    ) -> weaveapi.payment.v1.subscription_pb2.SubscriptionStatus: ...
    def __init__(
        self,
        *,
        subscription: weaveapi.payment.v1.subscription_pb2.SubscriptionStatus
        | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing.Literal["subscription", b"subscription"]
    ) -> builtins.bool: ...
    def ClearField(
        self, field_name: typing.Literal["subscription", b"subscription"]
    ) -> None: ...

global___GetSubscriptionStatusResponse = GetSubscriptionStatusResponse

@typing.final
class UpdateSubscriptionRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class MetadataEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(
            self, field_name: typing.Literal["key", b"key", "value", b"value"]
        ) -> None: ...

    PAYMENT_METHOD_ID_FIELD_NUMBER: builtins.int
    PROMO_CODE_FIELD_NUMBER: builtins.int
    CANCEL_AT_PERIOD_END_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    payment_method_id: builtins.str
    promo_code: builtins.str
    cancel_at_period_end: builtins.bool
    @property
    def metadata(
        self,
    ) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]: ...
    def __init__(
        self,
        *,
        payment_method_id: builtins.str = ...,
        promo_code: builtins.str = ...,
        cancel_at_period_end: builtins.bool = ...,
        metadata: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "cancel_at_period_end",
            b"cancel_at_period_end",
            "metadata",
            b"metadata",
            "payment_method_id",
            b"payment_method_id",
            "promo_code",
            b"promo_code",
        ],
    ) -> None: ...

global___UpdateSubscriptionRequest = UpdateSubscriptionRequest

@typing.final
class UpdateSubscriptionResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SUBSCRIPTION_FIELD_NUMBER: builtins.int
    MESSAGE_FIELD_NUMBER: builtins.int
    message: builtins.str
    @property
    def subscription(
        self,
    ) -> weaveapi.payment.v1.subscription_pb2.SubscriptionStatus: ...
    def __init__(
        self,
        *,
        subscription: weaveapi.payment.v1.subscription_pb2.SubscriptionStatus
        | None = ...,
        message: builtins.str = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing.Literal["subscription", b"subscription"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "message", b"message", "subscription", b"subscription"
        ],
    ) -> None: ...

global___UpdateSubscriptionResponse = UpdateSubscriptionResponse

@typing.final
class CancelSubscriptionRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    IMMEDIATELY_FIELD_NUMBER: builtins.int
    REASON_FIELD_NUMBER: builtins.int
    FEEDBACK_FIELD_NUMBER: builtins.int
    immediately: builtins.bool
    """If true, cancel immediately; otherwise at period end"""
    reason: builtins.str
    """Optional cancellation reason"""
    feedback: builtins.str
    """Optional user feedback"""
    def __init__(
        self,
        *,
        immediately: builtins.bool = ...,
        reason: builtins.str = ...,
        feedback: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "feedback", b"feedback", "immediately", b"immediately", "reason", b"reason"
        ],
    ) -> None: ...

global___CancelSubscriptionRequest = CancelSubscriptionRequest

@typing.final
class CancelSubscriptionResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SUBSCRIPTION_FIELD_NUMBER: builtins.int
    EFFECTIVE_DATE_FIELD_NUMBER: builtins.int
    CONFIRMATION_FIELD_NUMBER: builtins.int
    confirmation: builtins.str
    @property
    def subscription(
        self,
    ) -> weaveapi.payment.v1.subscription_pb2.SubscriptionStatus: ...
    @property
    def effective_date(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    def __init__(
        self,
        *,
        subscription: weaveapi.payment.v1.subscription_pb2.SubscriptionStatus
        | None = ...,
        effective_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        confirmation: builtins.str = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing.Literal[
            "effective_date", b"effective_date", "subscription", b"subscription"
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "confirmation",
            b"confirmation",
            "effective_date",
            b"effective_date",
            "subscription",
            b"subscription",
        ],
    ) -> None: ...

global___CancelSubscriptionResponse = CancelSubscriptionResponse

@typing.final
class ResumeSubscriptionRequest(google.protobuf.message.Message):
    """Resume a subscription that was set to cancel at period end"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___ResumeSubscriptionRequest = ResumeSubscriptionRequest

@typing.final
class ResumeSubscriptionResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SUBSCRIPTION_FIELD_NUMBER: builtins.int
    MESSAGE_FIELD_NUMBER: builtins.int
    message: builtins.str
    @property
    def subscription(
        self,
    ) -> weaveapi.payment.v1.subscription_pb2.SubscriptionStatus: ...
    def __init__(
        self,
        *,
        subscription: weaveapi.payment.v1.subscription_pb2.SubscriptionStatus
        | None = ...,
        message: builtins.str = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing.Literal["subscription", b"subscription"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "message", b"message", "subscription", b"subscription"
        ],
    ) -> None: ...

global___ResumeSubscriptionResponse = ResumeSubscriptionResponse

@typing.final
class GetBillingHistoryRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LIMIT_FIELD_NUMBER: builtins.int
    STARTING_AFTER_FIELD_NUMBER: builtins.int
    ENDING_BEFORE_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    CREATED_AFTER_FIELD_NUMBER: builtins.int
    CREATED_BEFORE_FIELD_NUMBER: builtins.int
    limit: builtins.int
    """Default 10"""
    starting_after: builtins.str
    """Pagination cursor"""
    ending_before: builtins.str
    """Pagination cursor"""
    status: builtins.str
    """Filters
    paid, open, void
    """
    @property
    def created_after(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    @property
    def created_before(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    def __init__(
        self,
        *,
        limit: builtins.int = ...,
        starting_after: builtins.str = ...,
        ending_before: builtins.str = ...,
        status: builtins.str = ...,
        created_after: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        created_before: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing.Literal[
            "created_after", b"created_after", "created_before", b"created_before"
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "created_after",
            b"created_after",
            "created_before",
            b"created_before",
            "ending_before",
            b"ending_before",
            "limit",
            b"limit",
            "starting_after",
            b"starting_after",
            "status",
            b"status",
        ],
    ) -> None: ...

global___GetBillingHistoryRequest = GetBillingHistoryRequest

@typing.final
class GetBillingHistoryResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INVOICES_FIELD_NUMBER: builtins.int
    HAS_MORE_FIELD_NUMBER: builtins.int
    NEXT_CURSOR_FIELD_NUMBER: builtins.int
    PREVIOUS_CURSOR_FIELD_NUMBER: builtins.int
    has_more: builtins.bool
    next_cursor: builtins.str
    previous_cursor: builtins.str
    @property
    def invoices(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        weaveapi.payment.v1.invoice_pb2.Invoice
    ]: ...
    def __init__(
        self,
        *,
        invoices: collections.abc.Iterable[weaveapi.payment.v1.invoice_pb2.Invoice]
        | None = ...,
        has_more: builtins.bool = ...,
        next_cursor: builtins.str = ...,
        previous_cursor: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "has_more",
            b"has_more",
            "invoices",
            b"invoices",
            "next_cursor",
            b"next_cursor",
            "previous_cursor",
            b"previous_cursor",
        ],
    ) -> None: ...

global___GetBillingHistoryResponse = GetBillingHistoryResponse

@typing.final
class GetUpcomingInvoiceRequest(google.protobuf.message.Message):
    """Preview next invoice"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___GetUpcomingInvoiceRequest = GetUpcomingInvoiceRequest

@typing.final
class GetUpcomingInvoiceResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INVOICE_FIELD_NUMBER: builtins.int
    @property
    def invoice(self) -> weaveapi.payment.v1.invoice_pb2.Invoice: ...
    def __init__(
        self,
        *,
        invoice: weaveapi.payment.v1.invoice_pb2.Invoice | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing.Literal["invoice", b"invoice"]
    ) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["invoice", b"invoice"]) -> None: ...

global___GetUpcomingInvoiceResponse = GetUpcomingInvoiceResponse

@typing.final
class ListPaymentMethodsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TYPE_FIELD_NUMBER: builtins.int
    type: builtins.str
    """card, bank_account, or empty for all"""
    def __init__(
        self,
        *,
        type: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["type", b"type"]) -> None: ...

global___ListPaymentMethodsRequest = ListPaymentMethodsRequest

@typing.final
class ListPaymentMethodsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAYMENT_METHODS_FIELD_NUMBER: builtins.int
    DEFAULT_PAYMENT_METHOD_ID_FIELD_NUMBER: builtins.int
    default_payment_method_id: builtins.str
    @property
    def payment_methods(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        weaveapi.payment.v1.subscription_pb2.PaymentMethod
    ]: ...
    def __init__(
        self,
        *,
        payment_methods: collections.abc.Iterable[
            weaveapi.payment.v1.subscription_pb2.PaymentMethod
        ]
        | None = ...,
        default_payment_method_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "default_payment_method_id",
            b"default_payment_method_id",
            "payment_methods",
            b"payment_methods",
        ],
    ) -> None: ...

global___ListPaymentMethodsResponse = ListPaymentMethodsResponse

@typing.final
class AddPaymentMethodRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAYMENT_METHOD_ID_FIELD_NUMBER: builtins.int
    SET_AS_DEFAULT_FIELD_NUMBER: builtins.int
    payment_method_id: builtins.str
    """Stripe payment method ID from frontend"""
    set_as_default: builtins.bool
    def __init__(
        self,
        *,
        payment_method_id: builtins.str = ...,
        set_as_default: builtins.bool = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "payment_method_id",
            b"payment_method_id",
            "set_as_default",
            b"set_as_default",
        ],
    ) -> None: ...

global___AddPaymentMethodRequest = AddPaymentMethodRequest

@typing.final
class AddPaymentMethodResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAYMENT_METHOD_FIELD_NUMBER: builtins.int
    IS_DEFAULT_FIELD_NUMBER: builtins.int
    is_default: builtins.bool
    @property
    def payment_method(self) -> weaveapi.payment.v1.subscription_pb2.PaymentMethod: ...
    def __init__(
        self,
        *,
        payment_method: weaveapi.payment.v1.subscription_pb2.PaymentMethod | None = ...,
        is_default: builtins.bool = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing.Literal["payment_method", b"payment_method"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "is_default", b"is_default", "payment_method", b"payment_method"
        ],
    ) -> None: ...

global___AddPaymentMethodResponse = AddPaymentMethodResponse

@typing.final
class SetDefaultPaymentMethodRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAYMENT_METHOD_ID_FIELD_NUMBER: builtins.int
    payment_method_id: builtins.str
    def __init__(
        self,
        *,
        payment_method_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing.Literal["payment_method_id", b"payment_method_id"]
    ) -> None: ...

global___SetDefaultPaymentMethodRequest = SetDefaultPaymentMethodRequest

@typing.final
class SetDefaultPaymentMethodResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SUCCESS_FIELD_NUMBER: builtins.int
    MESSAGE_FIELD_NUMBER: builtins.int
    success: builtins.bool
    message: builtins.str
    def __init__(
        self,
        *,
        success: builtins.bool = ...,
        message: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing.Literal["message", b"message", "success", b"success"]
    ) -> None: ...

global___SetDefaultPaymentMethodResponse = SetDefaultPaymentMethodResponse

@typing.final
class RemovePaymentMethodRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAYMENT_METHOD_ID_FIELD_NUMBER: builtins.int
    payment_method_id: builtins.str
    def __init__(
        self,
        *,
        payment_method_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing.Literal["payment_method_id", b"payment_method_id"]
    ) -> None: ...

global___RemovePaymentMethodRequest = RemovePaymentMethodRequest

@typing.final
class RemovePaymentMethodResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SUCCESS_FIELD_NUMBER: builtins.int
    MESSAGE_FIELD_NUMBER: builtins.int
    REMAINING_METHODS_FIELD_NUMBER: builtins.int
    success: builtins.bool
    message: builtins.str
    remaining_methods: builtins.int
    def __init__(
        self,
        *,
        success: builtins.bool = ...,
        message: builtins.str = ...,
        remaining_methods: builtins.int = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "message",
            b"message",
            "remaining_methods",
            b"remaining_methods",
            "success",
            b"success",
        ],
    ) -> None: ...

global___RemovePaymentMethodResponse = RemovePaymentMethodResponse

@typing.final
class CreatePortalSessionRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RETURN_URL_FIELD_NUMBER: builtins.int
    return_url: builtins.str
    """Where to return after portal session"""
    def __init__(
        self,
        *,
        return_url: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing.Literal["return_url", b"return_url"]
    ) -> None: ...

global___CreatePortalSessionRequest = CreatePortalSessionRequest

@typing.final
class CreatePortalSessionResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PORTAL_URL_FIELD_NUMBER: builtins.int
    EXPIRES_AT_FIELD_NUMBER: builtins.int
    portal_url: builtins.str
    """Stripe customer portal URL"""
    @property
    def expires_at(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    def __init__(
        self,
        *,
        portal_url: builtins.str = ...,
        expires_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing.Literal["expires_at", b"expires_at"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "expires_at", b"expires_at", "portal_url", b"portal_url"
        ],
    ) -> None: ...

global___CreatePortalSessionResponse = CreatePortalSessionResponse

@typing.final
class GetPricingPlansRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CURRENCY_FIELD_NUMBER: builtins.int
    ACTIVE_ONLY_FIELD_NUMBER: builtins.int
    currency: builtins.str
    """Optional: filter by currency"""
    active_only: builtins.bool
    """Only show active plans"""
    def __init__(
        self,
        *,
        currency: builtins.str = ...,
        active_only: builtins.bool = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "active_only", b"active_only", "currency", b"currency"
        ],
    ) -> None: ...

global___GetPricingPlansRequest = GetPricingPlansRequest

@typing.final
class GetPricingPlansResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PLANS_FIELD_NUMBER: builtins.int
    RECOMMENDED_PLAN_ID_FIELD_NUMBER: builtins.int
    CURRENT_PLAN_FIELD_NUMBER: builtins.int
    recommended_plan_id: builtins.str
    @property
    def plans(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        weaveapi.payment.v1.subscription_pb2.PricingPlan
    ]: ...
    @property
    def current_plan(self) -> weaveapi.payment.v1.subscription_pb2.PricingPlan:
        """User's current plan if logged in"""

    def __init__(
        self,
        *,
        plans: collections.abc.Iterable[
            weaveapi.payment.v1.subscription_pb2.PricingPlan
        ]
        | None = ...,
        recommended_plan_id: builtins.str = ...,
        current_plan: weaveapi.payment.v1.subscription_pb2.PricingPlan | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing.Literal["current_plan", b"current_plan"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "current_plan",
            b"current_plan",
            "plans",
            b"plans",
            "recommended_plan_id",
            b"recommended_plan_id",
        ],
    ) -> None: ...

global___GetPricingPlansResponse = GetPricingPlansResponse

@typing.final
class ApplyPromoCodeRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROMO_CODE_FIELD_NUMBER: builtins.int
    promo_code: builtins.str
    def __init__(
        self,
        *,
        promo_code: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing.Literal["promo_code", b"promo_code"]
    ) -> None: ...

global___ApplyPromoCodeRequest = ApplyPromoCodeRequest

@typing.final
class ApplyPromoCodeResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VALID_FIELD_NUMBER: builtins.int
    DISCOUNT_FIELD_NUMBER: builtins.int
    MESSAGE_FIELD_NUMBER: builtins.int
    EXPIRES_AT_FIELD_NUMBER: builtins.int
    valid: builtins.bool
    message: builtins.str
    @property
    def discount(self) -> weaveapi.payment.v1.subscription_pb2.Discount: ...
    @property
    def expires_at(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    def __init__(
        self,
        *,
        valid: builtins.bool = ...,
        discount: weaveapi.payment.v1.subscription_pb2.Discount | None = ...,
        message: builtins.str = ...,
        expires_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing.Literal[
            "discount", b"discount", "expires_at", b"expires_at"
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "discount",
            b"discount",
            "expires_at",
            b"expires_at",
            "message",
            b"message",
            "valid",
            b"valid",
        ],
    ) -> None: ...

global___ApplyPromoCodeResponse = ApplyPromoCodeResponse

@typing.final
class HandleStripeWebhookRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAYLOAD_FIELD_NUMBER: builtins.int
    SIGNATURE_FIELD_NUMBER: builtins.int
    payload: builtins.bytes
    """Raw webhook payload"""
    signature: builtins.str
    """Stripe-Signature header"""
    def __init__(
        self,
        *,
        payload: builtins.bytes = ...,
        signature: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal["payload", b"payload", "signature", b"signature"],
    ) -> None: ...

global___HandleStripeWebhookRequest = HandleStripeWebhookRequest

@typing.final
class HandleStripeWebhookResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SUCCESS_FIELD_NUMBER: builtins.int
    EVENT_ID_FIELD_NUMBER: builtins.int
    EVENT_TYPE_FIELD_NUMBER: builtins.int
    MESSAGE_FIELD_NUMBER: builtins.int
    success: builtins.bool
    event_id: builtins.str
    event_type: builtins.str
    message: builtins.str
    def __init__(
        self,
        *,
        success: builtins.bool = ...,
        event_id: builtins.str = ...,
        event_type: builtins.str = ...,
        message: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "event_id",
            b"event_id",
            "event_type",
            b"event_type",
            "message",
            b"message",
            "success",
            b"success",
        ],
    ) -> None: ...

global___HandleStripeWebhookResponse = HandleStripeWebhookResponse

@typing.final
class GetUsageSummaryRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PERIOD_FIELD_NUMBER: builtins.int
    START_DATE_FIELD_NUMBER: builtins.int
    END_DATE_FIELD_NUMBER: builtins.int
    period: builtins.str
    """current, previous, custom"""
    @property
    def start_date(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """For custom period"""

    @property
    def end_date(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """For custom period"""

    def __init__(
        self,
        *,
        period: builtins.str = ...,
        start_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        end_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing.Literal[
            "end_date", b"end_date", "start_date", b"start_date"
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "end_date", b"end_date", "period", b"period", "start_date", b"start_date"
        ],
    ) -> None: ...

global___GetUsageSummaryRequest = GetUsageSummaryRequest

@typing.final
class GetUsageSummaryResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CURRENT_PERIOD_FIELD_NUMBER: builtins.int
    PREVIOUS_PERIODS_FIELD_NUMBER: builtins.int
    LIMITS_FIELD_NUMBER: builtins.int
    @property
    def current_period(self) -> global___UsagePeriod: ...
    @property
    def previous_periods(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___UsagePeriod
    ]: ...
    @property
    def limits(self) -> global___UsageLimits: ...
    def __init__(
        self,
        *,
        current_period: global___UsagePeriod | None = ...,
        previous_periods: collections.abc.Iterable[global___UsagePeriod] | None = ...,
        limits: global___UsageLimits | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing.Literal[
            "current_period", b"current_period", "limits", b"limits"
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "current_period",
            b"current_period",
            "limits",
            b"limits",
            "previous_periods",
            b"previous_periods",
        ],
    ) -> None: ...

global___GetUsageSummaryResponse = GetUsageSummaryResponse

@typing.final
class UsagePeriod(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class RequestsByEndpointEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.int
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.int = ...,
        ) -> None: ...
        def ClearField(
            self, field_name: typing.Literal["key", b"key", "value", b"value"]
        ) -> None: ...

    @typing.final
    class RequestsByApiKeyEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.int
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.int = ...,
        ) -> None: ...
        def ClearField(
            self, field_name: typing.Literal["key", b"key", "value", b"value"]
        ) -> None: ...

    START_DATE_FIELD_NUMBER: builtins.int
    END_DATE_FIELD_NUMBER: builtins.int
    API_REQUESTS_FIELD_NUMBER: builtins.int
    API_REQUESTS_LIMIT_FIELD_NUMBER: builtins.int
    USAGE_PERCENTAGE_FIELD_NUMBER: builtins.int
    REQUESTS_BY_ENDPOINT_FIELD_NUMBER: builtins.int
    REQUESTS_BY_API_KEY_FIELD_NUMBER: builtins.int
    BILLABLE_REQUESTS_FIELD_NUMBER: builtins.int
    OVERAGE_REQUESTS_FIELD_NUMBER: builtins.int
    OVERAGE_COST_CENTS_FIELD_NUMBER: builtins.int
    api_requests: builtins.int
    """API usage"""
    api_requests_limit: builtins.int
    usage_percentage: builtins.float
    billable_requests: builtins.int
    """Billing"""
    overage_requests: builtins.int
    overage_cost_cents: builtins.int
    @property
    def start_date(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    @property
    def end_date(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    @property
    def requests_by_endpoint(
        self,
    ) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.int]:
        """Breakdown"""

    @property
    def requests_by_api_key(
        self,
    ) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.int]: ...
    def __init__(
        self,
        *,
        start_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        end_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        api_requests: builtins.int = ...,
        api_requests_limit: builtins.int = ...,
        usage_percentage: builtins.float = ...,
        requests_by_endpoint: collections.abc.Mapping[builtins.str, builtins.int]
        | None = ...,
        requests_by_api_key: collections.abc.Mapping[builtins.str, builtins.int]
        | None = ...,
        billable_requests: builtins.int = ...,
        overage_requests: builtins.int = ...,
        overage_cost_cents: builtins.int = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing.Literal[
            "end_date", b"end_date", "start_date", b"start_date"
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "api_requests",
            b"api_requests",
            "api_requests_limit",
            b"api_requests_limit",
            "billable_requests",
            b"billable_requests",
            "end_date",
            b"end_date",
            "overage_cost_cents",
            b"overage_cost_cents",
            "overage_requests",
            b"overage_requests",
            "requests_by_api_key",
            b"requests_by_api_key",
            "requests_by_endpoint",
            b"requests_by_endpoint",
            "start_date",
            b"start_date",
            "usage_percentage",
            b"usage_percentage",
        ],
    ) -> None: ...

global___UsagePeriod = UsagePeriod

@typing.final
class UsageLimits(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TIER_FIELD_NUMBER: builtins.int
    REQUESTS_PER_HOUR_FIELD_NUMBER: builtins.int
    REQUESTS_PER_DAY_FIELD_NUMBER: builtins.int
    REQUESTS_PER_MONTH_FIELD_NUMBER: builtins.int
    UNLIMITED_FIELD_NUMBER: builtins.int
    OVERAGE_RATE_CENTS_FIELD_NUMBER: builtins.int
    tier: builtins.str
    requests_per_hour: builtins.int
    requests_per_day: builtins.int
    requests_per_month: builtins.int
    unlimited: builtins.bool
    overage_rate_cents: builtins.int
    """Cost per 1000 requests over limit"""
    def __init__(
        self,
        *,
        tier: builtins.str = ...,
        requests_per_hour: builtins.int = ...,
        requests_per_day: builtins.int = ...,
        requests_per_month: builtins.int = ...,
        unlimited: builtins.bool = ...,
        overage_rate_cents: builtins.int = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "overage_rate_cents",
            b"overage_rate_cents",
            "requests_per_day",
            b"requests_per_day",
            "requests_per_hour",
            b"requests_per_hour",
            "requests_per_month",
            b"requests_per_month",
            "tier",
            b"tier",
            "unlimited",
            b"unlimited",
        ],
    ) -> None: ...

global___UsageLimits = UsageLimits

@typing.final
class GetCreditBalanceRequest(google.protobuf.message.Message):
    """Get credit balance if using credit system"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___GetCreditBalanceRequest = GetCreditBalanceRequest

@typing.final
class GetCreditBalanceResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CREDITS_FIELD_NUMBER: builtins.int
    PENDING_CREDITS_FIELD_NUMBER: builtins.int
    EXPIRES_AT_FIELD_NUMBER: builtins.int
    RECENT_TRANSACTIONS_FIELD_NUMBER: builtins.int
    credits: builtins.int
    pending_credits: builtins.int
    @property
    def expires_at(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    @property
    def recent_transactions(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___CreditTransaction
    ]: ...
    def __init__(
        self,
        *,
        credits: builtins.int = ...,
        pending_credits: builtins.int = ...,
        expires_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        recent_transactions: collections.abc.Iterable[global___CreditTransaction]
        | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing.Literal["expires_at", b"expires_at"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "credits",
            b"credits",
            "expires_at",
            b"expires_at",
            "pending_credits",
            b"pending_credits",
            "recent_transactions",
            b"recent_transactions",
        ],
    ) -> None: ...

global___GetCreditBalanceResponse = GetCreditBalanceResponse

@typing.final
class CreditTransaction(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    AMOUNT_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    id: builtins.str
    type: builtins.str
    """purchase, usage, refund, bonus"""
    amount: builtins.int
    """Positive for credits, negative for usage"""
    description: builtins.str
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        type: builtins.str = ...,
        amount: builtins.int = ...,
        description: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing.Literal["created_at", b"created_at"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "amount",
            b"amount",
            "created_at",
            b"created_at",
            "description",
            b"description",
            "id",
            b"id",
            "type",
            b"type",
        ],
    ) -> None: ...

global___CreditTransaction = CreditTransaction

@typing.final
class UpdateTaxInfoRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TAX_ID_FIELD_NUMBER: builtins.int
    TAX_ID_TYPE_FIELD_NUMBER: builtins.int
    BILLING_ADDRESS_FIELD_NUMBER: builtins.int
    BUSINESS_NAME_FIELD_NUMBER: builtins.int
    TAX_EXEMPT_FIELD_NUMBER: builtins.int
    tax_id: builtins.str
    """VAT number, GST, etc"""
    tax_id_type: builtins.str
    """eu_vat, gb_vat, us_ein, etc"""
    business_name: builtins.str
    tax_exempt: builtins.bool
    @property
    def billing_address(self) -> weaveapi.payment.v1.subscription_pb2.Address: ...
    def __init__(
        self,
        *,
        tax_id: builtins.str = ...,
        tax_id_type: builtins.str = ...,
        billing_address: weaveapi.payment.v1.subscription_pb2.Address | None = ...,
        business_name: builtins.str = ...,
        tax_exempt: builtins.bool = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing.Literal["billing_address", b"billing_address"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "billing_address",
            b"billing_address",
            "business_name",
            b"business_name",
            "tax_exempt",
            b"tax_exempt",
            "tax_id",
            b"tax_id",
            "tax_id_type",
            b"tax_id_type",
        ],
    ) -> None: ...

global___UpdateTaxInfoRequest = UpdateTaxInfoRequest

@typing.final
class UpdateTaxInfoResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SUCCESS_FIELD_NUMBER: builtins.int
    MESSAGE_FIELD_NUMBER: builtins.int
    TAX_INFO_FIELD_NUMBER: builtins.int
    success: builtins.bool
    message: builtins.str
    @property
    def tax_info(self) -> global___TaxInfo: ...
    def __init__(
        self,
        *,
        success: builtins.bool = ...,
        message: builtins.str = ...,
        tax_info: global___TaxInfo | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing.Literal["tax_info", b"tax_info"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "message", b"message", "success", b"success", "tax_info", b"tax_info"
        ],
    ) -> None: ...

global___UpdateTaxInfoResponse = UpdateTaxInfoResponse

@typing.final
class TaxInfo(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TAX_ID_FIELD_NUMBER: builtins.int
    TAX_ID_TYPE_FIELD_NUMBER: builtins.int
    VERIFICATION_STATUS_FIELD_NUMBER: builtins.int
    BILLING_ADDRESS_FIELD_NUMBER: builtins.int
    BUSINESS_NAME_FIELD_NUMBER: builtins.int
    TAX_EXEMPT_FIELD_NUMBER: builtins.int
    APPLICABLE_RATES_FIELD_NUMBER: builtins.int
    tax_id: builtins.str
    tax_id_type: builtins.str
    verification_status: builtins.str
    """pending, verified, unverified"""
    business_name: builtins.str
    tax_exempt: builtins.bool
    @property
    def billing_address(self) -> weaveapi.payment.v1.subscription_pb2.Address: ...
    @property
    def applicable_rates(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        weaveapi.payment.v1.invoice_pb2.TaxRate
    ]: ...
    def __init__(
        self,
        *,
        tax_id: builtins.str = ...,
        tax_id_type: builtins.str = ...,
        verification_status: builtins.str = ...,
        billing_address: weaveapi.payment.v1.subscription_pb2.Address | None = ...,
        business_name: builtins.str = ...,
        tax_exempt: builtins.bool = ...,
        applicable_rates: collections.abc.Iterable[
            weaveapi.payment.v1.invoice_pb2.TaxRate
        ]
        | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing.Literal["billing_address", b"billing_address"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "applicable_rates",
            b"applicable_rates",
            "billing_address",
            b"billing_address",
            "business_name",
            b"business_name",
            "tax_exempt",
            b"tax_exempt",
            "tax_id",
            b"tax_id",
            "tax_id_type",
            b"tax_id_type",
            "verification_status",
            b"verification_status",
        ],
    ) -> None: ...

global___TaxInfo = TaxInfo

@typing.final
class DownloadInvoiceRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INVOICE_ID_FIELD_NUMBER: builtins.int
    invoice_id: builtins.str
    def __init__(
        self,
        *,
        invoice_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing.Literal["invoice_id", b"invoice_id"]
    ) -> None: ...

global___DownloadInvoiceRequest = DownloadInvoiceRequest

@typing.final
class DownloadInvoiceResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PDF_DATA_FIELD_NUMBER: builtins.int
    FILENAME_FIELD_NUMBER: builtins.int
    CONTENT_TYPE_FIELD_NUMBER: builtins.int
    pdf_data: builtins.bytes
    filename: builtins.str
    content_type: builtins.str
    def __init__(
        self,
        *,
        pdf_data: builtins.bytes = ...,
        filename: builtins.str = ...,
        content_type: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing.Literal[
            "content_type",
            b"content_type",
            "filename",
            b"filename",
            "pdf_data",
            b"pdf_data",
        ],
    ) -> None: ...

global___DownloadInvoiceResponse = DownloadInvoiceResponse
