# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError as core_api_error_ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.jsonable_encoder import jsonable_encoder
from ..core.pydantic_utilities import pydantic_v1
from ..core.request_options import RequestOptions
from ..errors.bad_request_error import BadRequestError
from ..errors.conflict_error import ConflictError
from ..errors.internal_server_error import InternalServerError
from ..errors.not_found_error import NotFoundError
from ..types.add_memory_response import AddMemoryResponse
from ..types.api_error import ApiError as types_api_error_ApiError
from ..types.classify_session_request import ClassifySessionRequest
from ..types.end_session_response import EndSessionResponse
from ..types.end_sessions_response import EndSessionsResponse
from ..types.fact_rating_instruction import FactRatingInstruction
from ..types.fact_response import FactResponse
from ..types.facts_response import FactsResponse
from ..types.memory import Memory
from ..types.memory_search_result import MemorySearchResult
from ..types.message import Message
from ..types.message_list_response import MessageListResponse
from ..types.new_fact import NewFact
from ..types.question import Question
from ..types.role_type import RoleType
from ..types.search_scope import SearchScope
from ..types.search_type import SearchType
from ..types.session import Session
from ..types.session_classification import SessionClassification
from ..types.session_list_response import SessionListResponse
from ..types.session_search_response import SessionSearchResponse
from ..types.success_response import SuccessResponse
from ..types.summary_list_response import SummaryListResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class MemoryClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def get_fact(self, fact_uuid: str, *, request_options: typing.Optional[RequestOptions] = None) -> FactResponse:
        """
        Deprecated API: get fact by uuid

        Parameters
        ----------
        fact_uuid : str
            Fact UUID

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FactResponse
            The fact with the specified UUID.

        Examples
        --------
        from zep_cloud.client import Zep

        client = Zep(
            api_key="YOUR_API_KEY",
        )
        client.memory.get_fact(
            fact_uuid="factUUID",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"facts/{jsonable_encoder(fact_uuid)}", method="GET", request_options=request_options
        )
        try:
            if 200 <= _response.status_code < 300:
                return pydantic_v1.parse_obj_as(FactResponse, _response.json())  # type: ignore
            if _response.status_code == 404:
                raise NotFoundError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)

    def delete_fact(
        self, fact_uuid: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> SuccessResponse:
        """
        Deprecated API: delete a fact

        Parameters
        ----------
        fact_uuid : str
            Fact UUID

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SuccessResponse
            Deleted

        Examples
        --------
        from zep_cloud.client import Zep

        client = Zep(
            api_key="YOUR_API_KEY",
        )
        client.memory.delete_fact(
            fact_uuid="factUUID",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"facts/{jsonable_encoder(fact_uuid)}", method="DELETE", request_options=request_options
        )
        try:
            if 200 <= _response.status_code < 300:
                return pydantic_v1.parse_obj_as(SuccessResponse, _response.json())  # type: ignore
            if _response.status_code == 404:
                raise NotFoundError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)

    def add_session(
        self,
        *,
        session_id: str,
        user_id: str,
        fact_rating_instruction: typing.Optional[FactRatingInstruction] = OMIT,
        metadata: typing.Optional[typing.Dict[str, typing.Any]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Session:
        """
        Creates a new session.

        Parameters
        ----------
        session_id : str
            The unique identifier of the session.

        user_id : str
            The unique identifier of the user associated with the session

        fact_rating_instruction : typing.Optional[FactRatingInstruction]
            Deprecated

        metadata : typing.Optional[typing.Dict[str, typing.Any]]
            Deprecated

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Session
            The added session.

        Examples
        --------
        from zep_cloud.client import Zep

        client = Zep(
            api_key="YOUR_API_KEY",
        )
        client.memory.add_session(
            session_id="session_id",
            user_id="user_id",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "sessions",
            method="POST",
            json={
                "fact_rating_instruction": fact_rating_instruction,
                "metadata": metadata,
                "session_id": session_id,
                "user_id": user_id,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return pydantic_v1.parse_obj_as(Session, _response.json())  # type: ignore
            if _response.status_code == 400:
                raise BadRequestError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)

    def list_sessions(
        self,
        *,
        page_number: typing.Optional[int] = None,
        page_size: typing.Optional[int] = None,
        order_by: typing.Optional[str] = None,
        asc: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SessionListResponse:
        """
        Returns all sessions.

        Parameters
        ----------
        page_number : typing.Optional[int]
            Page number for pagination, starting from 1

        page_size : typing.Optional[int]
            Number of sessions to retrieve per page.

        order_by : typing.Optional[str]
            Field to order the results by: created_at, updated_at, user_id, session_id.

        asc : typing.Optional[bool]
            Order direction: true for ascending, false for descending.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SessionListResponse
            List of sessions

        Examples
        --------
        from zep_cloud.client import Zep

        client = Zep(
            api_key="YOUR_API_KEY",
        )
        client.memory.list_sessions()
        """
        _response = self._client_wrapper.httpx_client.request(
            "sessions-ordered",
            method="GET",
            params={"page_number": page_number, "page_size": page_size, "order_by": order_by, "asc": asc},
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return pydantic_v1.parse_obj_as(SessionListResponse, _response.json())  # type: ignore
            if _response.status_code == 400:
                raise BadRequestError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)

    def end_sessions(
        self,
        *,
        session_ids: typing.Sequence[str],
        instruction: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EndSessionsResponse:
        """
        Deprecated API: End multiple sessions by their IDs.

        Parameters
        ----------
        session_ids : typing.Sequence[str]

        instruction : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EndSessionsResponse
            OK

        Examples
        --------
        from zep_cloud.client import Zep

        client = Zep(
            api_key="YOUR_API_KEY",
        )
        client.memory.end_sessions(
            session_ids=["session_ids"],
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "sessions/end",
            method="POST",
            json={"instruction": instruction, "session_ids": session_ids},
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return pydantic_v1.parse_obj_as(EndSessionsResponse, _response.json())  # type: ignore
            if _response.status_code == 400:
                raise BadRequestError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)

    def search_sessions(
        self,
        *,
        text: str,
        limit: typing.Optional[int] = None,
        min_fact_rating: typing.Optional[float] = OMIT,
        min_score: typing.Optional[float] = OMIT,
        mmr_lambda: typing.Optional[float] = OMIT,
        record_filter: typing.Optional[typing.Dict[str, typing.Any]] = OMIT,
        search_scope: typing.Optional[SearchScope] = OMIT,
        search_type: typing.Optional[SearchType] = OMIT,
        session_ids: typing.Optional[typing.Sequence[str]] = OMIT,
        user_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SessionSearchResponse:
        """
        Deprecated API: Search sessions for the specified query.

        Parameters
        ----------
        text : str
            The search text.

        limit : typing.Optional[int]
            The maximum number of search results to return. Defaults to None (no limit).

        min_fact_rating : typing.Optional[float]
            The minimum fact rating to filter on.

        min_score : typing.Optional[float]
            The minimum score for search results.

        mmr_lambda : typing.Optional[float]
            The lambda parameter for the MMR Reranking Algorithm.

        record_filter : typing.Optional[typing.Dict[str, typing.Any]]
            Record filter on the metadata.

        search_scope : typing.Optional[SearchScope]
            Search scope.

        search_type : typing.Optional[SearchType]
            Search type.

        session_ids : typing.Optional[typing.Sequence[str]]
            the session ids to search

        user_id : typing.Optional[str]
            User ID used to determine which sessions to search.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SessionSearchResponse
            A SessionSearchResponse object representing the search results.

        Examples
        --------
        from zep_cloud.client import Zep

        client = Zep(
            api_key="YOUR_API_KEY",
        )
        client.memory.search_sessions(
            text="text",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "sessions/search",
            method="POST",
            params={"limit": limit},
            json={
                "min_fact_rating": min_fact_rating,
                "min_score": min_score,
                "mmr_lambda": mmr_lambda,
                "record_filter": record_filter,
                "search_scope": search_scope,
                "search_type": search_type,
                "session_ids": session_ids,
                "text": text,
                "user_id": user_id,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return pydantic_v1.parse_obj_as(SessionSearchResponse, _response.json())  # type: ignore
            if _response.status_code == 500:
                raise InternalServerError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)

    def get_session(self, session_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> Session:
        """
        Returns a session.

        Parameters
        ----------
        session_id : str
            The unique identifier of the session.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Session
            The session with the specified ID.

        Examples
        --------
        from zep_cloud.client import Zep

        client = Zep(
            api_key="YOUR_API_KEY",
        )
        client.memory.get_session(
            session_id="sessionId",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"sessions/{jsonable_encoder(session_id)}", method="GET", request_options=request_options
        )
        try:
            if 200 <= _response.status_code < 300:
                return pydantic_v1.parse_obj_as(Session, _response.json())  # type: ignore
            if _response.status_code == 404:
                raise NotFoundError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)

    def update_session(
        self,
        session_id: str,
        *,
        metadata: typing.Dict[str, typing.Any],
        fact_rating_instruction: typing.Optional[FactRatingInstruction] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Session:
        """
        Update Session Metadata

        Parameters
        ----------
        session_id : str
            The unique identifier of the session.

        metadata : typing.Dict[str, typing.Any]
            Deprecated

        fact_rating_instruction : typing.Optional[FactRatingInstruction]
            Optional instruction to use for fact rating.
            Fact rating instructions can not be unset.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Session
            The updated session.

        Examples
        --------
        from zep_cloud.client import Zep

        client = Zep(
            api_key="YOUR_API_KEY",
        )
        client.memory.update_session(
            session_id="sessionId",
            metadata={"key": "value"},
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"sessions/{jsonable_encoder(session_id)}",
            method="PATCH",
            json={"fact_rating_instruction": fact_rating_instruction, "metadata": metadata},
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return pydantic_v1.parse_obj_as(Session, _response.json())  # type: ignore
            if _response.status_code == 400:
                raise BadRequestError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            if _response.status_code == 409:
                raise ConflictError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)

    def classify_session(
        self,
        session_id: str,
        *,
        classes: typing.Sequence[str],
        name: str,
        instruction: typing.Optional[str] = OMIT,
        last_n: typing.Optional[int] = OMIT,
        persist: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SessionClassification:
        """
        Classifies a session.

        Parameters
        ----------
        session_id : str
            Session ID

        classes : typing.Sequence[str]
            The classes to use for classification.

        name : str
            The name of the classifier.

        instruction : typing.Optional[str]
            Custom instruction to use for classification.

        last_n : typing.Optional[int]
            The number of session messages to consider for classification. Defaults to 4.

        persist : typing.Optional[bool]
            Deprecated

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SessionClassification
            A response object containing the name and classification result.

        Examples
        --------
        from zep_cloud.client import Zep

        client = Zep(
            api_key="YOUR_API_KEY",
        )
        client.memory.classify_session(
            session_id="sessionId",
            classes=["classes"],
            name="name",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"sessions/{jsonable_encoder(session_id)}/classify",
            method="POST",
            json={"classes": classes, "instruction": instruction, "last_n": last_n, "name": name, "persist": persist},
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return pydantic_v1.parse_obj_as(SessionClassification, _response.json())  # type: ignore
            if _response.status_code == 404:
                raise NotFoundError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)

    def end_session(
        self,
        session_id: str,
        *,
        classify: typing.Optional[ClassifySessionRequest] = OMIT,
        instruction: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EndSessionResponse:
        """
        Deprecated API: End a session by ID.

        Parameters
        ----------
        session_id : str
            Session ID

        classify : typing.Optional[ClassifySessionRequest]

        instruction : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EndSessionResponse
            OK

        Examples
        --------
        from zep_cloud.client import Zep

        client = Zep(
            api_key="YOUR_API_KEY",
        )
        client.memory.end_session(
            session_id="sessionId",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"sessions/{jsonable_encoder(session_id)}/end",
            method="POST",
            json={"classify": classify, "instruction": instruction},
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return pydantic_v1.parse_obj_as(EndSessionResponse, _response.json())  # type: ignore
            if _response.status_code == 400:
                raise BadRequestError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)

    def extract_data(
        self,
        session_id: str,
        *,
        last_n: int,
        model_schema: str,
        current_date_time: typing.Optional[str] = OMIT,
        validate: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Dict[str, str]:
        """
        extract data from a session by session id

        Parameters
        ----------
        session_id : str
            Session ID

        last_n : int
            The number of messages in the chat history from which to extract data

        model_schema : str
            The schema describing the data to be extracted. See Zep's SDKs for more details.

        current_date_time : typing.Optional[str]
            Your current date and time in ISO 8601 format including timezone. This is used for determining relative dates.

        validate : typing.Optional[bool]
            Validate that the extracted data is present in the dialog and correct per the field description.
            Mitigates hallucination, but is slower and may result in false negatives.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Dict[str, str]
            OK

        Examples
        --------
        from zep_cloud.client import Zep

        client = Zep(
            api_key="YOUR_API_KEY",
        )
        client.memory.extract_data(
            session_id="sessionId",
            last_n=1,
            model_schema="model_schema",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"sessions/{jsonable_encoder(session_id)}/extract",
            method="POST",
            json={
                "current_date_time": current_date_time,
                "last_n": last_n,
                "model_schema": model_schema,
                "validate": validate,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return pydantic_v1.parse_obj_as(typing.Dict[str, str], _response.json())  # type: ignore
            if _response.status_code == 400:
                raise BadRequestError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)

    def get_session_facts(
        self,
        session_id: str,
        *,
        min_rating: typing.Optional[float] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> FactsResponse:
        """
        Deprecated API: get facts for a session

        Parameters
        ----------
        session_id : str
            Session ID

        min_rating : typing.Optional[float]
            Minimum rating by which to filter facts

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FactsResponse
            The facts for the session.

        Examples
        --------
        from zep_cloud.client import Zep

        client = Zep(
            api_key="YOUR_API_KEY",
        )
        client.memory.get_session_facts(
            session_id="sessionId",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"sessions/{jsonable_encoder(session_id)}/facts",
            method="GET",
            params={"minRating": min_rating},
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return pydantic_v1.parse_obj_as(FactsResponse, _response.json())  # type: ignore
            if _response.status_code == 404:
                raise NotFoundError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)

    def add_session_facts(
        self,
        session_id: str,
        *,
        facts: typing.Optional[typing.Sequence[NewFact]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SuccessResponse:
        """
        Deprecated API: Adds facts to a session

        Parameters
        ----------
        session_id : str
            Session ID

        facts : typing.Optional[typing.Sequence[NewFact]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SuccessResponse
            OK

        Examples
        --------
        from zep_cloud.client import Zep

        client = Zep(
            api_key="YOUR_API_KEY",
        )
        client.memory.add_session_facts(
            session_id="sessionId",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"sessions/{jsonable_encoder(session_id)}/facts",
            method="POST",
            json={"facts": facts},
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return pydantic_v1.parse_obj_as(SuccessResponse, _response.json())  # type: ignore
            if _response.status_code == 404:
                raise NotFoundError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)

    def get(
        self,
        session_id: str,
        *,
        lastn: typing.Optional[int] = None,
        min_rating: typing.Optional[float] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Memory:
        """
        Returns a memory for a given session.

        Parameters
        ----------
        session_id : str
            The ID of the session for which to retrieve memory.

        lastn : typing.Optional[int]
            The number of most recent memory entries to retrieve.

        min_rating : typing.Optional[float]
            The minimum rating by which to filter relevant facts.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Memory
            OK

        Examples
        --------
        from zep_cloud.client import Zep

        client = Zep(
            api_key="YOUR_API_KEY",
        )
        client.memory.get(
            session_id="sessionId",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"sessions/{jsonable_encoder(session_id)}/memory",
            method="GET",
            params={"lastn": lastn, "minRating": min_rating},
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return pydantic_v1.parse_obj_as(Memory, _response.json())  # type: ignore
            if _response.status_code == 404:
                raise NotFoundError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)

    def add(
        self,
        session_id: str,
        *,
        messages: typing.Sequence[Message],
        fact_instruction: typing.Optional[str] = OMIT,
        ignore_roles: typing.Optional[typing.Sequence[RoleType]] = OMIT,
        return_context: typing.Optional[bool] = OMIT,
        summary_instruction: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AddMemoryResponse:
        """
        Add memory to the specified session.

        Parameters
        ----------
        session_id : str
            The ID of the session to which memory should be added.

        messages : typing.Sequence[Message]
            A list of message objects, where each message contains a role and content.

        fact_instruction : typing.Optional[str]
            Deprecated

        ignore_roles : typing.Optional[typing.Sequence[RoleType]]
            Optional list of role types to ignore when adding messages to graph memory.
            The message itself will still be added retained and used as context for messages
            that are added to a user's graph.

        return_context : typing.Optional[bool]
            Optionally return memory context relevant to the most recent messages.

        summary_instruction : typing.Optional[str]
            Deprecated

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AddMemoryResponse
            An object, optionally containing memory context retrieved for the last message

        Examples
        --------
        from zep_cloud import Message
        from zep_cloud.client import Zep

        client = Zep(
            api_key="YOUR_API_KEY",
        )
        client.memory.add(
            session_id="sessionId",
            messages=[
                Message(
                    content="content",
                    role_type="norole",
                )
            ],
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"sessions/{jsonable_encoder(session_id)}/memory",
            method="POST",
            json={
                "fact_instruction": fact_instruction,
                "ignore_roles": ignore_roles,
                "messages": messages,
                "return_context": return_context,
                "summary_instruction": summary_instruction,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return pydantic_v1.parse_obj_as(AddMemoryResponse, _response.json())  # type: ignore
            if _response.status_code == 500:
                raise InternalServerError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)

    def delete(self, session_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> SuccessResponse:
        """
        Deletes a session.

        Parameters
        ----------
        session_id : str
            The ID of the session for which memory should be deleted.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SuccessResponse
            OK

        Examples
        --------
        from zep_cloud.client import Zep

        client = Zep(
            api_key="YOUR_API_KEY",
        )
        client.memory.delete(
            session_id="sessionId",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"sessions/{jsonable_encoder(session_id)}/memory", method="DELETE", request_options=request_options
        )
        try:
            if 200 <= _response.status_code < 300:
                return pydantic_v1.parse_obj_as(SuccessResponse, _response.json())  # type: ignore
            if _response.status_code == 404:
                raise NotFoundError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)

    def get_session_messages(
        self,
        session_id: str,
        *,
        limit: typing.Optional[int] = None,
        cursor: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> MessageListResponse:
        """
        Returns messages for a session.

        Parameters
        ----------
        session_id : str
            Session ID

        limit : typing.Optional[int]
            Limit the number of results returned

        cursor : typing.Optional[int]
            Cursor for pagination

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MessageListResponse
            OK

        Examples
        --------
        from zep_cloud.client import Zep

        client = Zep(
            api_key="YOUR_API_KEY",
        )
        client.memory.get_session_messages(
            session_id="sessionId",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"sessions/{jsonable_encoder(session_id)}/messages",
            method="GET",
            params={"limit": limit, "cursor": cursor},
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return pydantic_v1.parse_obj_as(MessageListResponse, _response.json())  # type: ignore
            if _response.status_code == 404:
                raise NotFoundError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)

    def get_session_message(
        self, session_id: str, message_uuid: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> Message:
        """
        Returns a specific message from a session.

        Parameters
        ----------
        session_id : str
            Soon to be deprecated as this is not needed.

        message_uuid : str
            The UUID of the message.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Message
            The message.

        Examples
        --------
        from zep_cloud.client import Zep

        client = Zep(
            api_key="YOUR_API_KEY",
        )
        client.memory.get_session_message(
            session_id="sessionId",
            message_uuid="messageUUID",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"sessions/{jsonable_encoder(session_id)}/messages/{jsonable_encoder(message_uuid)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return pydantic_v1.parse_obj_as(Message, _response.json())  # type: ignore
            if _response.status_code == 404:
                raise NotFoundError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)

    def update_message_metadata(
        self,
        session_id: str,
        message_uuid: str,
        *,
        metadata: typing.Dict[str, typing.Any],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Message:
        """
        Updates the metadata of a message.

        Parameters
        ----------
        session_id : str
            The ID of the session.

        message_uuid : str
            The UUID of the message.

        metadata : typing.Dict[str, typing.Any]
            Deprecated

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Message
            The updated message.

        Examples
        --------
        from zep_cloud.client import Zep

        client = Zep(
            api_key="YOUR_API_KEY",
        )
        client.memory.update_message_metadata(
            session_id="sessionId",
            message_uuid="messageUUID",
            metadata={"key": "value"},
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"sessions/{jsonable_encoder(session_id)}/messages/{jsonable_encoder(message_uuid)}",
            method="PATCH",
            json={"metadata": metadata},
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return pydantic_v1.parse_obj_as(Message, _response.json())  # type: ignore
            if _response.status_code == 404:
                raise NotFoundError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)

    def search(
        self,
        session_id: str,
        *,
        limit: typing.Optional[int] = None,
        metadata: typing.Optional[typing.Dict[str, typing.Any]] = OMIT,
        min_fact_rating: typing.Optional[float] = OMIT,
        min_score: typing.Optional[float] = OMIT,
        mmr_lambda: typing.Optional[float] = OMIT,
        search_scope: typing.Optional[SearchScope] = OMIT,
        search_type: typing.Optional[SearchType] = OMIT,
        text: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[MemorySearchResult]:
        """
        Parameters
        ----------
        session_id : str
            The ID of the session for which memory should be searched.

        limit : typing.Optional[int]
            The maximum number of search results to return. Defaults to None (no limit).

        metadata : typing.Optional[typing.Dict[str, typing.Any]]
            Metadata Filter

        min_fact_rating : typing.Optional[float]

        min_score : typing.Optional[float]

        mmr_lambda : typing.Optional[float]

        search_scope : typing.Optional[SearchScope]

        search_type : typing.Optional[SearchType]

        text : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[MemorySearchResult]
            A list of SearchResult objects representing the search results.

        Examples
        --------
        from zep_cloud.client import Zep

        client = Zep(
            api_key="YOUR_API_KEY",
        )
        client.memory.search(
            session_id="sessionId",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"sessions/{jsonable_encoder(session_id)}/search",
            method="POST",
            params={"limit": limit},
            json={
                "metadata": metadata,
                "min_fact_rating": min_fact_rating,
                "min_score": min_score,
                "mmr_lambda": mmr_lambda,
                "search_scope": search_scope,
                "search_type": search_type,
                "text": text,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return pydantic_v1.parse_obj_as(typing.List[MemorySearchResult], _response.json())  # type: ignore
            if _response.status_code == 404:
                raise NotFoundError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)

    def get_summaries(
        self, session_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> SummaryListResponse:
        """
        Deprecated API: Get session summaries by ID

        Parameters
        ----------
        session_id : str
            Session ID

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SummaryListResponse
            OK

        Examples
        --------
        from zep_cloud.client import Zep

        client = Zep(
            api_key="YOUR_API_KEY",
        )
        client.memory.get_summaries(
            session_id="sessionId",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"sessions/{jsonable_encoder(session_id)}/summary", method="GET", request_options=request_options
        )
        try:
            if 200 <= _response.status_code < 300:
                return pydantic_v1.parse_obj_as(SummaryListResponse, _response.json())  # type: ignore
            if _response.status_code == 404:
                raise NotFoundError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)

    def synthesize_question(
        self,
        session_id: str,
        *,
        last_n_messages: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Question:
        """
        Deprecated API: Synthesize a question from the last N messages in the chat history.

        Parameters
        ----------
        session_id : str
            The ID of the session.

        last_n_messages : typing.Optional[int]
            The number of messages to use for question synthesis.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Question
            The synthesized question.

        Examples
        --------
        from zep_cloud.client import Zep

        client = Zep(
            api_key="YOUR_API_KEY",
        )
        client.memory.synthesize_question(
            session_id="sessionId",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"sessions/{jsonable_encoder(session_id)}/synthesize_question",
            method="GET",
            params={"lastNMessages": last_n_messages},
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return pydantic_v1.parse_obj_as(Question, _response.json())  # type: ignore
            if _response.status_code == 404:
                raise NotFoundError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)


class AsyncMemoryClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def get_fact(
        self, fact_uuid: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> FactResponse:
        """
        Deprecated API: get fact by uuid

        Parameters
        ----------
        fact_uuid : str
            Fact UUID

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FactResponse
            The fact with the specified UUID.

        Examples
        --------
        import asyncio

        from zep_cloud.client import AsyncZep

        client = AsyncZep(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.memory.get_fact(
                fact_uuid="factUUID",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"facts/{jsonable_encoder(fact_uuid)}", method="GET", request_options=request_options
        )
        try:
            if 200 <= _response.status_code < 300:
                return pydantic_v1.parse_obj_as(FactResponse, _response.json())  # type: ignore
            if _response.status_code == 404:
                raise NotFoundError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)

    async def delete_fact(
        self, fact_uuid: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> SuccessResponse:
        """
        Deprecated API: delete a fact

        Parameters
        ----------
        fact_uuid : str
            Fact UUID

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SuccessResponse
            Deleted

        Examples
        --------
        import asyncio

        from zep_cloud.client import AsyncZep

        client = AsyncZep(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.memory.delete_fact(
                fact_uuid="factUUID",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"facts/{jsonable_encoder(fact_uuid)}", method="DELETE", request_options=request_options
        )
        try:
            if 200 <= _response.status_code < 300:
                return pydantic_v1.parse_obj_as(SuccessResponse, _response.json())  # type: ignore
            if _response.status_code == 404:
                raise NotFoundError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)

    async def add_session(
        self,
        *,
        session_id: str,
        user_id: str,
        fact_rating_instruction: typing.Optional[FactRatingInstruction] = OMIT,
        metadata: typing.Optional[typing.Dict[str, typing.Any]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Session:
        """
        Creates a new session.

        Parameters
        ----------
        session_id : str
            The unique identifier of the session.

        user_id : str
            The unique identifier of the user associated with the session

        fact_rating_instruction : typing.Optional[FactRatingInstruction]
            Deprecated

        metadata : typing.Optional[typing.Dict[str, typing.Any]]
            Deprecated

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Session
            The added session.

        Examples
        --------
        import asyncio

        from zep_cloud.client import AsyncZep

        client = AsyncZep(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.memory.add_session(
                session_id="session_id",
                user_id="user_id",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "sessions",
            method="POST",
            json={
                "fact_rating_instruction": fact_rating_instruction,
                "metadata": metadata,
                "session_id": session_id,
                "user_id": user_id,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return pydantic_v1.parse_obj_as(Session, _response.json())  # type: ignore
            if _response.status_code == 400:
                raise BadRequestError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)

    async def list_sessions(
        self,
        *,
        page_number: typing.Optional[int] = None,
        page_size: typing.Optional[int] = None,
        order_by: typing.Optional[str] = None,
        asc: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SessionListResponse:
        """
        Returns all sessions.

        Parameters
        ----------
        page_number : typing.Optional[int]
            Page number for pagination, starting from 1

        page_size : typing.Optional[int]
            Number of sessions to retrieve per page.

        order_by : typing.Optional[str]
            Field to order the results by: created_at, updated_at, user_id, session_id.

        asc : typing.Optional[bool]
            Order direction: true for ascending, false for descending.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SessionListResponse
            List of sessions

        Examples
        --------
        import asyncio

        from zep_cloud.client import AsyncZep

        client = AsyncZep(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.memory.list_sessions()


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "sessions-ordered",
            method="GET",
            params={"page_number": page_number, "page_size": page_size, "order_by": order_by, "asc": asc},
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return pydantic_v1.parse_obj_as(SessionListResponse, _response.json())  # type: ignore
            if _response.status_code == 400:
                raise BadRequestError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)

    async def end_sessions(
        self,
        *,
        session_ids: typing.Sequence[str],
        instruction: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EndSessionsResponse:
        """
        Deprecated API: End multiple sessions by their IDs.

        Parameters
        ----------
        session_ids : typing.Sequence[str]

        instruction : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EndSessionsResponse
            OK

        Examples
        --------
        import asyncio

        from zep_cloud.client import AsyncZep

        client = AsyncZep(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.memory.end_sessions(
                session_ids=["session_ids"],
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "sessions/end",
            method="POST",
            json={"instruction": instruction, "session_ids": session_ids},
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return pydantic_v1.parse_obj_as(EndSessionsResponse, _response.json())  # type: ignore
            if _response.status_code == 400:
                raise BadRequestError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)

    async def search_sessions(
        self,
        *,
        text: str,
        limit: typing.Optional[int] = None,
        min_fact_rating: typing.Optional[float] = OMIT,
        min_score: typing.Optional[float] = OMIT,
        mmr_lambda: typing.Optional[float] = OMIT,
        record_filter: typing.Optional[typing.Dict[str, typing.Any]] = OMIT,
        search_scope: typing.Optional[SearchScope] = OMIT,
        search_type: typing.Optional[SearchType] = OMIT,
        session_ids: typing.Optional[typing.Sequence[str]] = OMIT,
        user_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SessionSearchResponse:
        """
        Deprecated API: Search sessions for the specified query.

        Parameters
        ----------
        text : str
            The search text.

        limit : typing.Optional[int]
            The maximum number of search results to return. Defaults to None (no limit).

        min_fact_rating : typing.Optional[float]
            The minimum fact rating to filter on.

        min_score : typing.Optional[float]
            The minimum score for search results.

        mmr_lambda : typing.Optional[float]
            The lambda parameter for the MMR Reranking Algorithm.

        record_filter : typing.Optional[typing.Dict[str, typing.Any]]
            Record filter on the metadata.

        search_scope : typing.Optional[SearchScope]
            Search scope.

        search_type : typing.Optional[SearchType]
            Search type.

        session_ids : typing.Optional[typing.Sequence[str]]
            the session ids to search

        user_id : typing.Optional[str]
            User ID used to determine which sessions to search.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SessionSearchResponse
            A SessionSearchResponse object representing the search results.

        Examples
        --------
        import asyncio

        from zep_cloud.client import AsyncZep

        client = AsyncZep(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.memory.search_sessions(
                text="text",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "sessions/search",
            method="POST",
            params={"limit": limit},
            json={
                "min_fact_rating": min_fact_rating,
                "min_score": min_score,
                "mmr_lambda": mmr_lambda,
                "record_filter": record_filter,
                "search_scope": search_scope,
                "search_type": search_type,
                "session_ids": session_ids,
                "text": text,
                "user_id": user_id,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return pydantic_v1.parse_obj_as(SessionSearchResponse, _response.json())  # type: ignore
            if _response.status_code == 500:
                raise InternalServerError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)

    async def get_session(self, session_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> Session:
        """
        Returns a session.

        Parameters
        ----------
        session_id : str
            The unique identifier of the session.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Session
            The session with the specified ID.

        Examples
        --------
        import asyncio

        from zep_cloud.client import AsyncZep

        client = AsyncZep(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.memory.get_session(
                session_id="sessionId",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"sessions/{jsonable_encoder(session_id)}", method="GET", request_options=request_options
        )
        try:
            if 200 <= _response.status_code < 300:
                return pydantic_v1.parse_obj_as(Session, _response.json())  # type: ignore
            if _response.status_code == 404:
                raise NotFoundError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)

    async def update_session(
        self,
        session_id: str,
        *,
        metadata: typing.Dict[str, typing.Any],
        fact_rating_instruction: typing.Optional[FactRatingInstruction] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Session:
        """
        Update Session Metadata

        Parameters
        ----------
        session_id : str
            The unique identifier of the session.

        metadata : typing.Dict[str, typing.Any]
            Deprecated

        fact_rating_instruction : typing.Optional[FactRatingInstruction]
            Optional instruction to use for fact rating.
            Fact rating instructions can not be unset.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Session
            The updated session.

        Examples
        --------
        import asyncio

        from zep_cloud.client import AsyncZep

        client = AsyncZep(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.memory.update_session(
                session_id="sessionId",
                metadata={"key": "value"},
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"sessions/{jsonable_encoder(session_id)}",
            method="PATCH",
            json={"fact_rating_instruction": fact_rating_instruction, "metadata": metadata},
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return pydantic_v1.parse_obj_as(Session, _response.json())  # type: ignore
            if _response.status_code == 400:
                raise BadRequestError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            if _response.status_code == 409:
                raise ConflictError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)

    async def classify_session(
        self,
        session_id: str,
        *,
        classes: typing.Sequence[str],
        name: str,
        instruction: typing.Optional[str] = OMIT,
        last_n: typing.Optional[int] = OMIT,
        persist: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SessionClassification:
        """
        Classifies a session.

        Parameters
        ----------
        session_id : str
            Session ID

        classes : typing.Sequence[str]
            The classes to use for classification.

        name : str
            The name of the classifier.

        instruction : typing.Optional[str]
            Custom instruction to use for classification.

        last_n : typing.Optional[int]
            The number of session messages to consider for classification. Defaults to 4.

        persist : typing.Optional[bool]
            Deprecated

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SessionClassification
            A response object containing the name and classification result.

        Examples
        --------
        import asyncio

        from zep_cloud.client import AsyncZep

        client = AsyncZep(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.memory.classify_session(
                session_id="sessionId",
                classes=["classes"],
                name="name",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"sessions/{jsonable_encoder(session_id)}/classify",
            method="POST",
            json={"classes": classes, "instruction": instruction, "last_n": last_n, "name": name, "persist": persist},
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return pydantic_v1.parse_obj_as(SessionClassification, _response.json())  # type: ignore
            if _response.status_code == 404:
                raise NotFoundError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)

    async def end_session(
        self,
        session_id: str,
        *,
        classify: typing.Optional[ClassifySessionRequest] = OMIT,
        instruction: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EndSessionResponse:
        """
        Deprecated API: End a session by ID.

        Parameters
        ----------
        session_id : str
            Session ID

        classify : typing.Optional[ClassifySessionRequest]

        instruction : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EndSessionResponse
            OK

        Examples
        --------
        import asyncio

        from zep_cloud.client import AsyncZep

        client = AsyncZep(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.memory.end_session(
                session_id="sessionId",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"sessions/{jsonable_encoder(session_id)}/end",
            method="POST",
            json={"classify": classify, "instruction": instruction},
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return pydantic_v1.parse_obj_as(EndSessionResponse, _response.json())  # type: ignore
            if _response.status_code == 400:
                raise BadRequestError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)

    async def extract_data(
        self,
        session_id: str,
        *,
        last_n: int,
        model_schema: str,
        current_date_time: typing.Optional[str] = OMIT,
        validate: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Dict[str, str]:
        """
        extract data from a session by session id

        Parameters
        ----------
        session_id : str
            Session ID

        last_n : int
            The number of messages in the chat history from which to extract data

        model_schema : str
            The schema describing the data to be extracted. See Zep's SDKs for more details.

        current_date_time : typing.Optional[str]
            Your current date and time in ISO 8601 format including timezone. This is used for determining relative dates.

        validate : typing.Optional[bool]
            Validate that the extracted data is present in the dialog and correct per the field description.
            Mitigates hallucination, but is slower and may result in false negatives.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Dict[str, str]
            OK

        Examples
        --------
        import asyncio

        from zep_cloud.client import AsyncZep

        client = AsyncZep(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.memory.extract_data(
                session_id="sessionId",
                last_n=1,
                model_schema="model_schema",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"sessions/{jsonable_encoder(session_id)}/extract",
            method="POST",
            json={
                "current_date_time": current_date_time,
                "last_n": last_n,
                "model_schema": model_schema,
                "validate": validate,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return pydantic_v1.parse_obj_as(typing.Dict[str, str], _response.json())  # type: ignore
            if _response.status_code == 400:
                raise BadRequestError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)

    async def get_session_facts(
        self,
        session_id: str,
        *,
        min_rating: typing.Optional[float] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> FactsResponse:
        """
        Deprecated API: get facts for a session

        Parameters
        ----------
        session_id : str
            Session ID

        min_rating : typing.Optional[float]
            Minimum rating by which to filter facts

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FactsResponse
            The facts for the session.

        Examples
        --------
        import asyncio

        from zep_cloud.client import AsyncZep

        client = AsyncZep(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.memory.get_session_facts(
                session_id="sessionId",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"sessions/{jsonable_encoder(session_id)}/facts",
            method="GET",
            params={"minRating": min_rating},
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return pydantic_v1.parse_obj_as(FactsResponse, _response.json())  # type: ignore
            if _response.status_code == 404:
                raise NotFoundError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)

    async def add_session_facts(
        self,
        session_id: str,
        *,
        facts: typing.Optional[typing.Sequence[NewFact]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SuccessResponse:
        """
        Deprecated API: Adds facts to a session

        Parameters
        ----------
        session_id : str
            Session ID

        facts : typing.Optional[typing.Sequence[NewFact]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SuccessResponse
            OK

        Examples
        --------
        import asyncio

        from zep_cloud.client import AsyncZep

        client = AsyncZep(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.memory.add_session_facts(
                session_id="sessionId",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"sessions/{jsonable_encoder(session_id)}/facts",
            method="POST",
            json={"facts": facts},
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return pydantic_v1.parse_obj_as(SuccessResponse, _response.json())  # type: ignore
            if _response.status_code == 404:
                raise NotFoundError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)

    async def get(
        self,
        session_id: str,
        *,
        lastn: typing.Optional[int] = None,
        min_rating: typing.Optional[float] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Memory:
        """
        Returns a memory for a given session.

        Parameters
        ----------
        session_id : str
            The ID of the session for which to retrieve memory.

        lastn : typing.Optional[int]
            The number of most recent memory entries to retrieve.

        min_rating : typing.Optional[float]
            The minimum rating by which to filter relevant facts.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Memory
            OK

        Examples
        --------
        import asyncio

        from zep_cloud.client import AsyncZep

        client = AsyncZep(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.memory.get(
                session_id="sessionId",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"sessions/{jsonable_encoder(session_id)}/memory",
            method="GET",
            params={"lastn": lastn, "minRating": min_rating},
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return pydantic_v1.parse_obj_as(Memory, _response.json())  # type: ignore
            if _response.status_code == 404:
                raise NotFoundError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)

    async def add(
        self,
        session_id: str,
        *,
        messages: typing.Sequence[Message],
        fact_instruction: typing.Optional[str] = OMIT,
        ignore_roles: typing.Optional[typing.Sequence[RoleType]] = OMIT,
        return_context: typing.Optional[bool] = OMIT,
        summary_instruction: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AddMemoryResponse:
        """
        Add memory to the specified session.

        Parameters
        ----------
        session_id : str
            The ID of the session to which memory should be added.

        messages : typing.Sequence[Message]
            A list of message objects, where each message contains a role and content.

        fact_instruction : typing.Optional[str]
            Deprecated

        ignore_roles : typing.Optional[typing.Sequence[RoleType]]
            Optional list of role types to ignore when adding messages to graph memory.
            The message itself will still be added retained and used as context for messages
            that are added to a user's graph.

        return_context : typing.Optional[bool]
            Optionally return memory context relevant to the most recent messages.

        summary_instruction : typing.Optional[str]
            Deprecated

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AddMemoryResponse
            An object, optionally containing memory context retrieved for the last message

        Examples
        --------
        import asyncio

        from zep_cloud import Message
        from zep_cloud.client import AsyncZep

        client = AsyncZep(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.memory.add(
                session_id="sessionId",
                messages=[
                    Message(
                        content="content",
                        role_type="norole",
                    )
                ],
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"sessions/{jsonable_encoder(session_id)}/memory",
            method="POST",
            json={
                "fact_instruction": fact_instruction,
                "ignore_roles": ignore_roles,
                "messages": messages,
                "return_context": return_context,
                "summary_instruction": summary_instruction,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return pydantic_v1.parse_obj_as(AddMemoryResponse, _response.json())  # type: ignore
            if _response.status_code == 500:
                raise InternalServerError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)

    async def delete(
        self, session_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> SuccessResponse:
        """
        Deletes a session.

        Parameters
        ----------
        session_id : str
            The ID of the session for which memory should be deleted.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SuccessResponse
            OK

        Examples
        --------
        import asyncio

        from zep_cloud.client import AsyncZep

        client = AsyncZep(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.memory.delete(
                session_id="sessionId",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"sessions/{jsonable_encoder(session_id)}/memory", method="DELETE", request_options=request_options
        )
        try:
            if 200 <= _response.status_code < 300:
                return pydantic_v1.parse_obj_as(SuccessResponse, _response.json())  # type: ignore
            if _response.status_code == 404:
                raise NotFoundError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)

    async def get_session_messages(
        self,
        session_id: str,
        *,
        limit: typing.Optional[int] = None,
        cursor: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> MessageListResponse:
        """
        Returns messages for a session.

        Parameters
        ----------
        session_id : str
            Session ID

        limit : typing.Optional[int]
            Limit the number of results returned

        cursor : typing.Optional[int]
            Cursor for pagination

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MessageListResponse
            OK

        Examples
        --------
        import asyncio

        from zep_cloud.client import AsyncZep

        client = AsyncZep(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.memory.get_session_messages(
                session_id="sessionId",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"sessions/{jsonable_encoder(session_id)}/messages",
            method="GET",
            params={"limit": limit, "cursor": cursor},
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return pydantic_v1.parse_obj_as(MessageListResponse, _response.json())  # type: ignore
            if _response.status_code == 404:
                raise NotFoundError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)

    async def get_session_message(
        self, session_id: str, message_uuid: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> Message:
        """
        Returns a specific message from a session.

        Parameters
        ----------
        session_id : str
            Soon to be deprecated as this is not needed.

        message_uuid : str
            The UUID of the message.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Message
            The message.

        Examples
        --------
        import asyncio

        from zep_cloud.client import AsyncZep

        client = AsyncZep(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.memory.get_session_message(
                session_id="sessionId",
                message_uuid="messageUUID",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"sessions/{jsonable_encoder(session_id)}/messages/{jsonable_encoder(message_uuid)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return pydantic_v1.parse_obj_as(Message, _response.json())  # type: ignore
            if _response.status_code == 404:
                raise NotFoundError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)

    async def update_message_metadata(
        self,
        session_id: str,
        message_uuid: str,
        *,
        metadata: typing.Dict[str, typing.Any],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Message:
        """
        Updates the metadata of a message.

        Parameters
        ----------
        session_id : str
            The ID of the session.

        message_uuid : str
            The UUID of the message.

        metadata : typing.Dict[str, typing.Any]
            Deprecated

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Message
            The updated message.

        Examples
        --------
        import asyncio

        from zep_cloud.client import AsyncZep

        client = AsyncZep(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.memory.update_message_metadata(
                session_id="sessionId",
                message_uuid="messageUUID",
                metadata={"key": "value"},
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"sessions/{jsonable_encoder(session_id)}/messages/{jsonable_encoder(message_uuid)}",
            method="PATCH",
            json={"metadata": metadata},
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return pydantic_v1.parse_obj_as(Message, _response.json())  # type: ignore
            if _response.status_code == 404:
                raise NotFoundError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)

    async def search(
        self,
        session_id: str,
        *,
        limit: typing.Optional[int] = None,
        metadata: typing.Optional[typing.Dict[str, typing.Any]] = OMIT,
        min_fact_rating: typing.Optional[float] = OMIT,
        min_score: typing.Optional[float] = OMIT,
        mmr_lambda: typing.Optional[float] = OMIT,
        search_scope: typing.Optional[SearchScope] = OMIT,
        search_type: typing.Optional[SearchType] = OMIT,
        text: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[MemorySearchResult]:
        """
        Parameters
        ----------
        session_id : str
            The ID of the session for which memory should be searched.

        limit : typing.Optional[int]
            The maximum number of search results to return. Defaults to None (no limit).

        metadata : typing.Optional[typing.Dict[str, typing.Any]]
            Metadata Filter

        min_fact_rating : typing.Optional[float]

        min_score : typing.Optional[float]

        mmr_lambda : typing.Optional[float]

        search_scope : typing.Optional[SearchScope]

        search_type : typing.Optional[SearchType]

        text : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[MemorySearchResult]
            A list of SearchResult objects representing the search results.

        Examples
        --------
        import asyncio

        from zep_cloud.client import AsyncZep

        client = AsyncZep(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.memory.search(
                session_id="sessionId",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"sessions/{jsonable_encoder(session_id)}/search",
            method="POST",
            params={"limit": limit},
            json={
                "metadata": metadata,
                "min_fact_rating": min_fact_rating,
                "min_score": min_score,
                "mmr_lambda": mmr_lambda,
                "search_scope": search_scope,
                "search_type": search_type,
                "text": text,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return pydantic_v1.parse_obj_as(typing.List[MemorySearchResult], _response.json())  # type: ignore
            if _response.status_code == 404:
                raise NotFoundError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)

    async def get_summaries(
        self, session_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> SummaryListResponse:
        """
        Deprecated API: Get session summaries by ID

        Parameters
        ----------
        session_id : str
            Session ID

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SummaryListResponse
            OK

        Examples
        --------
        import asyncio

        from zep_cloud.client import AsyncZep

        client = AsyncZep(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.memory.get_summaries(
                session_id="sessionId",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"sessions/{jsonable_encoder(session_id)}/summary", method="GET", request_options=request_options
        )
        try:
            if 200 <= _response.status_code < 300:
                return pydantic_v1.parse_obj_as(SummaryListResponse, _response.json())  # type: ignore
            if _response.status_code == 404:
                raise NotFoundError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)

    async def synthesize_question(
        self,
        session_id: str,
        *,
        last_n_messages: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Question:
        """
        Deprecated API: Synthesize a question from the last N messages in the chat history.

        Parameters
        ----------
        session_id : str
            The ID of the session.

        last_n_messages : typing.Optional[int]
            The number of messages to use for question synthesis.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Question
            The synthesized question.

        Examples
        --------
        import asyncio

        from zep_cloud.client import AsyncZep

        client = AsyncZep(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.memory.synthesize_question(
                session_id="sessionId",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"sessions/{jsonable_encoder(session_id)}/synthesize_question",
            method="GET",
            params={"lastNMessages": last_n_messages},
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return pydantic_v1.parse_obj_as(Question, _response.json())  # type: ignore
            if _response.status_code == 404:
                raise NotFoundError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    pydantic_v1.parse_obj_as(types_api_error_ApiError, _response.json())  # type: ignore
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(status_code=_response.status_code, body=_response.text)
        raise core_api_error_ApiError(status_code=_response.status_code, body=_response_json)
