from divinegift.cipher import decrypt_str, get_cipher, encrypt_str

cipher_key = b'rKKvXPL7OefUAfscsduYOWdtHHC1V0Mo0n5VgLR19tE='

console_template = b'gAAAAABcam2wh_sgULO7zXo1UJGH31CBTq0yad3izYyGWN3e4SUcrUqDLblddAa_E4R6alq7_lwhUHRy599ppkD7fj6qOpaMbfGC-ggu8UuP_4qziOBZ0jufcqqRSFtkUGJCwJpe-0DQNzCgJ0Vm_IMIgth_Sg5014HapXhCl-_0oP048x04LykqhUyjfOv-4cZk8kIJIxpFLdKlgqEUNnt5Xf_3bpSrSI4-UqdXNbWyHMI4SV_vlnYth3-ll75fRlwigq8u2w3BUPSgHgLWFsHSGE0WdTc1hxwfuOMUGQ_ZV8tik5iaAflYrqad3HkiACwkl2hAZBAHB6BcdsHdBs4m-Vfol-uX7o5CJRZXwh5_QyJgCCLdlPTBUjqH9csiSxmy1Cnsf2qFygaOmhFuLk7pM61mTOEAtz69Zz811O6c_H--EkW5b-M2wIgXYcCsXCMiSmWxZze5PZfggdP1jIjCVAApdpFUTWlyW2vDjf9neBdxmbrqCERRy398ohkDwfxBiLXkq1kJ96lpiaesY_yAJXc4aiP7Lb8QFI74-Q5YCEpOKvC6bvGBBwLYY8WmMBmP3SAh2NniT3GB6JFYZ-nEOJwLOzM0b3D5qF_bCNX3jk5FkEkc-JUekaVJzeQlOzh16mxhioHmDvgPRmYucFvJ-94qY0vTfvK8YqJ9M3060X4gOk-8BxjPgGNk2EjshDpOj7PcGmd89M7Co1mq8cEITY8Eukc5MycMEUj9oblPdoT8aK_kalmqWaOj6ceKjYCM8WHIfGJlnvQth7wGFpTE_ABVm_xfqk8b07kRcqLwoIWRV2fTCm4CpAgy3LCBONAn1K2JVV_VR9amGr8Ta8OjNte_ibReUucFn2qvf0eK_LNLWQKiYm_rZFdgAnxjQNE0JkRfuJ-hDVeOO-du5pkYXmW-kh30oIS-GutahUCW37032Hwg72w22YjE33cPynKw0dLRy-pseCF_6Ys8wpOkQPVEh_pqMOo0BZsDmwhrYNtiUOS1UZcy18RRa9u7zOTJhVw1qyoY2rq8JlIY-x12LmIDT-f6cYoHxBEF9hXEIj7FmWP68yC2Reb4diJVifnFxUQyBPmqK-YsevbQAad8FEQNAfY3F22gVb7tReoYqRpB4hkJiRyibssUVFgJnHH8j7pWK8-aG6ov-5glHhA43N7VOJqtlEmA2RK4rl-qlPDcPBoV8yx8zxCEDeHHw-P5WPrjroyhw6KAE1RLfXCceLeyIpRowQ-4Oj_8bMhi8ckegNNR9yB8GNw7u_kd2kU9IALb2qur0GtWQn_VkK8uV8JxNEmBGkhu0mDOzOVOVMAtVArZwXfnHFGJUxPzBH9Mig5i2GBauEAdlXamVbn1B9Eb5Rr88Hc65CQg9ept4t-FApsnbt2XMFGWFj2Cq5A5-ku9zTn_a0kKIYnVenuovbTYxC9GTakQaPny43ipN5boDvz3wqdRpJQega6b5AKI1V2Uv31fZmNlZA82zKimXg7of8n9Rg4Dqo7GEw-074s57_FIva9vRtQPdMkzSxekNHETzTWaa8Olk4KQxgOmiW51XgQ3P6TKzGQsEEB-dxFYPds1LZAb4WBY_k_-OdqEI3Rk3j8-FmxciGHiben0ruWrCcGzDCwBQwz4YN3w25mCZV24C7R4WOoZih_tcdNF4idMmfVXSRNZo3Lurfo2_HTQ9nlcjGaiYi8vPF-LPbbPqPB5whQ6_yLzqEl38tGuCr6iCm7dFwTenls70GiyJXVOATEogH1dmdd4rc7iM3fa-mA2Mos7rtz9FHbyGqulgzXG86perNQjYSZUi4L1U3cao_02aCVceIGrRI2mK0BarTePzr8ON9Ws19zvPc_U23l05gpXAkyvQwhUsmxqxdeW0XYMIvaTDhjcn1qAt3YQOdjRUiSSGawLWB39k2PSM8e6tTAgILyeEiqTC-0lSoGOmPRgCP-wWA8Zht7_8u84YRaE1Elwpq4074eUp9T8qvy9pSwu'
gui_template = b'gAAAAABcam3jCOeXKlovNWFJUdVNzFpbJxkf934F4ehEf8EDPRCSdhSDNMB6lIKuwQ8Xnq4vfQGsGtRyZA6X64NLmXhObUEES1tuXpU_U2wdd51YP5TIPOzQO3mCw_18Vwd_yO2VFe2w2kNCslaGw-NR7IPnRjFuckcCIOxsFPYf9vY5SyfCbuYJl2CHcbsdzAjE4U6D0O1Uk2JI4ZRSgBn5ratyKeC4v3tCBGjmY-NM4Suj8d8BB7uaTuRzcUhJco35zfCYVLqqyeJZjEFAuKW5iPll3EJDK__iXzZMQR_Tc530cCsSTVDIwX2dZ59x8BrhDaugEfb0Q-7B7NJE5U4BItCjSZ2AqEUPCsgB2S1SGmcDlSds_3zSYWwIydTqfLgt47QkC4qrzSHIcKVNKkNI3ClySDoOYIJKLRqm-_c-9eV5qVlpRIc_-_ezee3_WlK5HlJ5o1iRaO5NAEtbsXYfJhvrVPwXG9K03d7v_qaVoRzS19N9WFZcmYxZMBhmTep1APiOa7ggyAZimwfFF7SX6yZVTWXl6pj8c1xqBvm0XTgk7Um2Wqs6sPM8unYW0TntKEZYHPj6xOuJHPodAeoyQsXp7RnkbzZFcsSsdN_er60vQOQ4KpPm8PM9BxkC2tunApBMSC-jDfXOScMLEiWuJmgXN8iO1JyoxqaGZdLUtIVCVm9qUCargUi9A_Wp5aVfZRKKmyGNXpMVaiTRE97a0yAUcrRTWfRHj6bk6udztP1ndQaBXurj21seZryEmX5vd-swwsqcvHUsWP3L1pfMGRyTkv_ImpZUnLLnoMjiLjl76Gv9tYSsjpFdse5boi7WL9fajXw-b-zM3AfccDsxY1sftrjS4MSu6JqjhE7mgIvhMXpUAj15QnGGBozjstAoJ3jNyj_9GM6NBzIfHqUumC__gA7ZToH9TpLK_QuCV9knZBdf-73q3NkdX2DaSx0drM-obNOYx8s5jHg8Z1uplZFVWf_tOMo0BiuPiXuV7fFImSXSUczLiuM15LFmItN7a-42NeQh377kaq8X-93NVJrZz94xBbfZy6OCVLZ7XuyQyHSGllJ4O4_hafoNdec7CMQ6EVjWtZ82SIJKhMogusu5bitx52MHWXk4kyZ3DYZCwAsrLUOkUqgZL6adHhSlmJpEXFgPTqQrcTh77oeG8kE89MmYTDsNowI-ymb1DAAE8FQ-Gu7w75kNtqCyGNcWNX6XcHofy8lc0q1D-HrMf2xXN2JZx8wsyeO4kuIGA0A62gpYebQGWZsBEL-ngei5XbLjMYuh1njI-Ffg2YAIGIp8A--0rIyvs-G8WYluA1X6JPfQ3M8o56JHSUkgKwrRbFTt64Yq6PxuWvJxKunbqV6QbHDD62MXOtWzhekWrlPWrMjm_3onGycWnDxuN7HfvnEFSfz7LMKks4HOdqdaSaSLSyCTavBO-aruXeQCjPhtTfAlw56pPCOJZ6FXAk0L74r4L9MWYGCX2DCh8Uuz63kHtI3-HlCojL4Qr1IUPQdPGLwQJduYiSuyYXqJhpq1eeDHqRi1fP6htIPN1T1zA78lO3jmC_IrOa-kXQhIV1SGf0xO9JMA4_dwIPLOF2d1OXeT9Whl1Mr54HUAFN4nnDBgEriUFN2roqeZfY1RNFnb_p0tnnTIhLaxCDSFC3LUNzYEsyzMs41yKMpHYJRGpWxcNqx-T28PBzHYnrYMDSFtvkc441ux5mjU9BEcbLxXQqb2Hh2syp4Su9IS2xRo8vaBPspZflh_wVQxIqsyDG4zXqM0T_5gYWlKSgMwxMtR-sHSEoK9RPkThrpRz45b8z9Ivx8z_d9Ind99aY58PFR957wugvQktAaV9Kflgx4bu_yCjVNVjYezritfXIEqfvmwtU9i0aQ-nLMPED5BiLtlnP8aAPNN6tJC9UFjjgEuCONzajdxD47vuow9L_RcPUsDGXF8YkERUt78a-xlh3aYdA6Z4EIj-d9WZxeSoqPBXfUqL2NnF-9RCnd9u9Py9dcyIk9XLZAbFl_m_OmHF8kzH09DVocVqbtS72N31HjpMHEr0e8GD-ybrD0CBayil1WIaw9H3dArd5qgcmG5dD5Dc8BU02Sb2VS6vny4OU3UMC8C-Bd-hS_L33UztGn13i8G6VYvV-cmXo0vMskv9xI9GKDFqcbwOKZdFcRiiPlYUfkfkQLT7LyH06cOXD9f0mrhsoeSlgflV0AodOwDLPOlK_XAn33cT_J18eE6tiXncIZxi4dq-9o2QF1TeSo3EMSuHm6ENtybjWT_G_V_SHEc4EVLfX_ncsSmAf1-T6ETPpqEk2F0h9UPutZN--GRN_EKgAdcmFnmC3BwahFWQKR4eKW--zNTUATDHb00POZk1myaXVnridFcLDbJNKzC7LKN55JlZEN9e2n4WSyZYCtnOXQ7UK4S_bze292jxziS04tcDY7ji2bNnzp-GBhwSKou362Z2KXhkVQ-1T8FxO2fX_NDw5aPrFQ0rZrr3talowUnfV6n0sNISPN1RKpXgGJYrNOOym7jxAq9r6oeEd10JB7UvRR7aGVZcPXSdKa6XNsFsAdnVxwzzkyiMgjSCZWgeM5AFlMbSetNY8JtFKBXE-XLe6zTPClkjz2gRBHity-MT74kk9utp0Qfm3dEf-9pXxHY2N5DfKdJTdSZhImxsJ46lDEViUNzkfiq0C9NkI92r6Nw5ARAVzs0V12VM2IXW_NO_xHXqBSu4pVXWA6pK3uAYoQNsFr5QWxmXu930KHuU71gCpMvOVV50jOFIdyEGBD0JegspumYuQOKPFVr1lihCJBUrMvCHPW9iuv9fIRbf0bkrNlmYNWUKzK5clpZ7WlB9tLwkgnjxKqciMdSn3GeReJqexbkmEIR_JqKrdG6YWRItQMY5eIPwFW_nmSQL3KZiDTct6REwtXzSdOtUr28kblOWafhO_-RFmTM_h6CigmvUrHICZioM9oofb1nyEdQc4doF5Yx1Kf1fIJcwqG0n27GkfQ3giPtoU6Bop2XBIgRVG7ozkhKoZ1SrgqpQakn8GCPXWdaDsSf_am8ezhEKmCRLFej7EsxYfb-ui4q0tzGRZg8Ggb4sCG2AvFzaCguD0McsBvmZGIuY-ac81ippFQBmfr0qh2t-l7OplikSRtfzNDSGO2AYdYq5G-ySGb-BQEQLihqwO72EsJwcIDn3DzMeA6VGXv1Lh97p7F309R4FC4By1YALM7K5lsYt-0-QzwVIxoIW9p7wmY8ZtvZb3a3CO6GtzJJIgpIUfX678impQkfbWxynKpXwO-6goxjF-yFUQ4OD3wrfWcaD9m-uDtzGgHWR-IKWsZXy0-a4nzUIYGAzaT080GWQfKHaRQJhDGASUXZbh_PZhqu36xQtd9seGu7Tom57WOH9hrOXxsK3jOWYJKnx5C3Y88uoAfowXppnY9GH5hYECvQuFzZGxXZWlWEjCA07thJkDHQlOs6k6pN5axVHziE-y5KY_3xASTaOA3RtEi6K-cHZZ5tl5s6kvhrrzF_x977AUNay9NC45suAWHLTfkdlKKw3bric-HaWpdbx3Xz4to2WGKzhhqnNHsFKuKvfBIljYU2LMxVLhMVBSKuvmMV0f6y-JIYzDkk6h7Cp6aJapPKQ2P5bEwjO7Aw7GRf45GxkADp-4FmXE_WGs8W0PpZBGpUwWHE6B6o-CdmfnErC3fOC1PUAmXZ4HmcZo8VPGx6bSOWUOqXECrNL1dacwUbnBkJ41LBIg=='
config_template = b'gAAAAABcam4IXxB5tsuLAWqnXGH4PQT0tEg8aU_gusJvhR5xEh56Aim_jjtcXmTz2EBJSM8_RPp_nAJvxEf4baDMtzTsBY95VLY-a6MMTRGSUlVOE4nsD5cgp95iXC6MNRYEGNFxYswTI_O8JZyYfF1bEaVz8ISlLlwFCCSHWqnC3MURYWISTXQ8-GXJAR5FDzPHP0A3nvPcP3b3kY8EPPZIW639cUdHNmQv6tr9zPKE3du5Wfe1tV3aEKIgtSVhwfHmI55ZrQ-cQ7Yrkxh740Y3T17CjYWSARSr9R3iA-YK1L1bKq6MgD8bgIP1Lg6tl9BZ1yyjZk3OZtSJmsbuzup_7RxjYY3fY1wKBDydM3GOL3MrE8nwZ3dehRiZzdQNFaJb0S-eK8qPw25NItQYXA4RPLrBJepU6PyuRCQNx5MReKODp1vWs_Wze7l8LhARMnfrBeYFA5vbfLqCXrdYqcDmOuRNV8uIhuLB5jREBsL9lToTuAuCjia1j9UejZejm4v3YNoztffu'
email_config_template = b'gAAAAABcam4qHlH4MHm2hjQV_XOgRFBTluMpHfiFmdXqGHBEUejBqBzB76elHTgZ2X1NT9ZCQMbk9w9XAJ7ZQEMA6SiX1Px-NMezp7F4HMI31Bia2-sPV5WtlCNJBsUaM8e0q4jMLqklBRy1-_nAkUxE4DVYjWVUvOTPcU1szIWWxFVFzjrS1Wpb8KZXR_vsYXDylTxrv5uwlMscCc_RrFANL3K8L-swbfVramykFcvnYhQHbgsqN_n7_MtQ8mfBpwTz6iNoCIC9'


def create_file(filename, text):
    cipher = get_cipher(cipher_key)
    with open(filename, 'w') as f:
        f.write(decrypt_str(text, cipher))


def create_console(filename='main.py'):
    if not filename.endswith('.py'):
        filename += '.py'
    create_file(filename, console_template)


def create_gui(filename='main_gui.py'):
    if not filename.endswith('.py'):
        filename += '.py'
    create_file(filename, gui_template)


def create_config(filename='settings.conf'):
    create_file(filename, config_template)


def add_email_config(filename='settings.conf'):
    try:
        with open(filename, 'r') as f:
            text = f.read()
        text += ',\n'
    except:
        text = ''
    cipher = get_cipher(cipher_key)
    text += decrypt_str(email_config_template, cipher)
    config_with_email_template = encrypt_str(text, cipher, get_str=False)
    create_file(filename, config_with_email_template)
