# -*- coding:utf-8 -*-
ssq_d = {'河北': ['河北省', '河北'], '山西': ['山西省', '山西'], '辽宁': ['辽宁省', '辽宁'],
         '吉林': ['吉林省', '吉林'], '黑龙江': ['黑龙江省', '黑龙江'], '江苏': ['江苏省', '江苏'],
         '浙江': ['浙江省', '浙江'], '安徽': ['安徽省', '安徽'], '福建': ['福建省', '福建'],
         '江西': ['江西省', '江西'], '山东': ['山东省', '山东'], '河南': ['河南省', '河南'],
         '湖北': ['湖北省', '湖北'], '湖南': ['湖南省', '湖南'], '广东': ['广东省', '广东'],
         '海南': ['海南省', '海南'], '四川': ['四川省', '四川'], '贵州': ['贵州省', '贵州'],
         '云南': ['云南省', '云南'], '陕西': ['陕西省', '陕西'], '甘肃': ['甘肃省', '甘肃'],
         '青海': ['青海省', '青海'], '台湾': ['台湾省', '台湾'], '内蒙古': ['内蒙古自治区', '内蒙古', '内蒙'],
         '广西': ['广西壮族自治区', '广西自治区', '广西'],
         '西藏': ['西藏藏族自治区', '西藏自治区', '西藏'],
         '宁夏': ['宁夏回族自治区', '宁夏自治区', '宁夏'],
         '新疆': ['新疆维吾尔族自治区', '新疆维吾尔自治区', '新疆自治区', '新疆'],
         '北京': ['北京市', '北京'], '天津': ['天津市', '天津'], '上海': ['上海市', '上海'],
         '重庆': ['重庆市', '重庆'], '香港': ['香港特别行政区', '香港'],
         '澳门': ['澳门特别行政区', '澳门']}

#提取省市区
def get_ssq(text=None,Index=False):
    """
    :param text: 要提取字符串
    :param Index: 是否返回省市区所在字符串索引位置，默认为False
    :return:
    """
    if text:
        getssq= {}
        for k,vs in ssq_d.items():
            for v in vs:
                if v in text:
                    index=text.index(v)
                    getssq[k]=index
                    break
        if Index:
            return getssq
        ssq_list = list(zip(getssq.keys(), getssq.values()))
        return ([v[0] for v in sorted(ssq_list,key = lambda x:x[1])])
    return ssq_d

def is_ssq(string):
    if string in [v for vs in ssq_d.values() for v in vs]:
        return True
    return False