# swagger-client
JSON API for the Kimai 2 time-tracking software. Read more about its usage in the [API documentation](https://www.kimai.org/documentation/rest-api.html) and then download a [Swagger file](doc.json) for import e.g. in Postman. Be aware: it is not yet considered stable and BC breaks might happen. 

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 0.5
- Package version: 1.0.0
- Build package: io.swagger.codegen.languages.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import swagger_client 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import swagger_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import swagger_client
from swagger_client.rest import ApiException
from pprint import pprint

# Configure API key authorization: apiToken
configuration = swagger_client.Configuration()
configuration.api_key['X-AUTH-TOKEN'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-AUTH-TOKEN'] = 'Bearer'
# Configure API key authorization: apiUser
configuration = swagger_client.Configuration()
configuration.api_key['X-AUTH-USER'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-AUTH-USER'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.ActivityApi(swagger_client.ApiClient(configuration))
project = 'project_example' # str | Project ID to filter activities (optional)
projects = 'projects_example' # str | Comma separated list of project IDs to filter activities (optional)
visible = 'visible_example' # str | Visibility status to filter activities. Allowed values: 1=visible, 2=hidden, 3=all (default: 1) (optional)
globals = 'globals_example' # str | Use if you want to fetch only global activities. Allowed values: true (default: false) (optional)
globals_first = 'globals_first_example' # str | Deprecated parameter, value is not used any more (optional)
order_by = 'order_by_example' # str | The field by which results will be ordered. Allowed values: id, name, project (default: name) (optional)
order = 'order_example' # str | The result order. Allowed values: ASC, DESC (default: ASC) (optional)
term = 'term_example' # str | Free search term (optional)

try:
    # Returns a collection of activities
    api_response = api_instance.api_activities_get(project=project, projects=projects, visible=visible, globals=globals, globals_first=globals_first, order_by=order_by, order=order, term=term)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling ActivityApi->api_activities_get: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ActivityApi* | [**api_activities_get**](docs/ActivityApi.md#api_activities_get) | **GET** /api/activities | Returns a collection of activities
*ActivityApi* | [**api_activities_id_get**](docs/ActivityApi.md#api_activities_id_get) | **GET** /api/activities/{id} | Returns one activity
*ActivityApi* | [**api_activities_id_meta_patch**](docs/ActivityApi.md#api_activities_id_meta_patch) | **PATCH** /api/activities/{id}/meta | Sets the value of a meta-field for an existing activity
*ActivityApi* | [**api_activities_id_patch**](docs/ActivityApi.md#api_activities_id_patch) | **PATCH** /api/activities/{id} | Update an existing activity
*ActivityApi* | [**api_activities_id_rates_get**](docs/ActivityApi.md#api_activities_id_rates_get) | **GET** /api/activities/{id}/rates | Returns a collection of all rates for one activity
*ActivityApi* | [**api_activities_id_rates_post**](docs/ActivityApi.md#api_activities_id_rates_post) | **POST** /api/activities/{id}/rates | Adds a new rate to an activity
*ActivityApi* | [**api_activities_id_rates_rate_id_delete**](docs/ActivityApi.md#api_activities_id_rates_rate_id_delete) | **DELETE** /api/activities/{id}/rates/{rateId} | Deletes one rate for an activity
*ActivityApi* | [**api_activities_post**](docs/ActivityApi.md#api_activities_post) | **POST** /api/activities | Creates a new activity
*CustomerApi* | [**api_customers_get**](docs/CustomerApi.md#api_customers_get) | **GET** /api/customers | Returns a collection of customers
*CustomerApi* | [**api_customers_id_get**](docs/CustomerApi.md#api_customers_id_get) | **GET** /api/customers/{id} | Returns one customer
*CustomerApi* | [**api_customers_id_meta_patch**](docs/CustomerApi.md#api_customers_id_meta_patch) | **PATCH** /api/customers/{id}/meta | Sets the value of a meta-field for an existing customer
*CustomerApi* | [**api_customers_id_patch**](docs/CustomerApi.md#api_customers_id_patch) | **PATCH** /api/customers/{id} | Update an existing customer
*CustomerApi* | [**api_customers_id_rates_get**](docs/CustomerApi.md#api_customers_id_rates_get) | **GET** /api/customers/{id}/rates | Returns a collection of all rates for one customer
*CustomerApi* | [**api_customers_id_rates_post**](docs/CustomerApi.md#api_customers_id_rates_post) | **POST** /api/customers/{id}/rates | Adds a new rate to a customer
*CustomerApi* | [**api_customers_id_rates_rate_id_delete**](docs/CustomerApi.md#api_customers_id_rates_rate_id_delete) | **DELETE** /api/customers/{id}/rates/{rateId} | Deletes one rate for an customer
*CustomerApi* | [**api_customers_post**](docs/CustomerApi.md#api_customers_post) | **POST** /api/customers | Creates a new customer
*DefaultApi* | [**api_config_i18n_get**](docs/DefaultApi.md#api_config_i18n_get) | **GET** /api/config/i18n | Returns the user specific locale configuration
*DefaultApi* | [**api_config_timesheet_get**](docs/DefaultApi.md#api_config_timesheet_get) | **GET** /api/config/timesheet | Returns the instance specific timesheet configuration
*DefaultApi* | [**api_ping_get**](docs/DefaultApi.md#api_ping_get) | **GET** /api/ping | A testing route for the API
*DefaultApi* | [**api_version_get**](docs/DefaultApi.md#api_version_get) | **GET** /api/version | Returns information about the Kimai release
*ProjectApi* | [**api_projects_get**](docs/ProjectApi.md#api_projects_get) | **GET** /api/projects | Returns a collection of projects.
*ProjectApi* | [**api_projects_id_get**](docs/ProjectApi.md#api_projects_id_get) | **GET** /api/projects/{id} | Returns one project
*ProjectApi* | [**api_projects_id_meta_patch**](docs/ProjectApi.md#api_projects_id_meta_patch) | **PATCH** /api/projects/{id}/meta | Sets the value of a meta-field for an existing project
*ProjectApi* | [**api_projects_id_patch**](docs/ProjectApi.md#api_projects_id_patch) | **PATCH** /api/projects/{id} | Update an existing project
*ProjectApi* | [**api_projects_id_rates_get**](docs/ProjectApi.md#api_projects_id_rates_get) | **GET** /api/projects/{id}/rates | Returns a collection of all rates for one project
*ProjectApi* | [**api_projects_id_rates_post**](docs/ProjectApi.md#api_projects_id_rates_post) | **POST** /api/projects/{id}/rates | Adds a new rate to an project
*ProjectApi* | [**api_projects_id_rates_rate_id_delete**](docs/ProjectApi.md#api_projects_id_rates_rate_id_delete) | **DELETE** /api/projects/{id}/rates/{rateId} | Deletes one rate for an project
*ProjectApi* | [**api_projects_post**](docs/ProjectApi.md#api_projects_post) | **POST** /api/projects | Creates a new project
*TagApi* | [**api_tags_get**](docs/TagApi.md#api_tags_get) | **GET** /api/tags | Fetch all existing tags
*TagApi* | [**api_tags_id_delete**](docs/TagApi.md#api_tags_id_delete) | **DELETE** /api/tags/{id} | Delete a tag
*TagApi* | [**api_tags_post**](docs/TagApi.md#api_tags_post) | **POST** /api/tags | Creates a new tag
*TeamApi* | [**api_teams_get**](docs/TeamApi.md#api_teams_get) | **GET** /api/teams | Fetch all existing teams
*TeamApi* | [**api_teams_id_customers_customer_id_delete**](docs/TeamApi.md#api_teams_id_customers_customer_id_delete) | **DELETE** /api/teams/{id}/customers/{customerId} | Revokes access for a customer from a team
*TeamApi* | [**api_teams_id_customers_customer_id_post**](docs/TeamApi.md#api_teams_id_customers_customer_id_post) | **POST** /api/teams/{id}/customers/{customerId} | Grant the team access to a customer
*TeamApi* | [**api_teams_id_delete**](docs/TeamApi.md#api_teams_id_delete) | **DELETE** /api/teams/{id} | Delete a team
*TeamApi* | [**api_teams_id_get**](docs/TeamApi.md#api_teams_id_get) | **GET** /api/teams/{id} | Returns one team
*TeamApi* | [**api_teams_id_members_user_id_delete**](docs/TeamApi.md#api_teams_id_members_user_id_delete) | **DELETE** /api/teams/{id}/members/{userId} | Removes a member from the team
*TeamApi* | [**api_teams_id_members_user_id_post**](docs/TeamApi.md#api_teams_id_members_user_id_post) | **POST** /api/teams/{id}/members/{userId} | Add a new member to a team
*TeamApi* | [**api_teams_id_patch**](docs/TeamApi.md#api_teams_id_patch) | **PATCH** /api/teams/{id} | Update an existing team
*TeamApi* | [**api_teams_id_projects_project_id_delete**](docs/TeamApi.md#api_teams_id_projects_project_id_delete) | **DELETE** /api/teams/{id}/projects/{projectId} | Revokes access for a project from a team
*TeamApi* | [**api_teams_id_projects_project_id_post**](docs/TeamApi.md#api_teams_id_projects_project_id_post) | **POST** /api/teams/{id}/projects/{projectId} | Grant the team access to a project
*TeamApi* | [**api_teams_post**](docs/TeamApi.md#api_teams_post) | **POST** /api/teams | Creates a new team
*TimesheetApi* | [**api_timesheets_active_get**](docs/TimesheetApi.md#api_timesheets_active_get) | **GET** /api/timesheets/active | Returns the collection of active timesheet records
*TimesheetApi* | [**api_timesheets_get**](docs/TimesheetApi.md#api_timesheets_get) | **GET** /api/timesheets | Returns a collection of timesheet records
*TimesheetApi* | [**api_timesheets_id_delete**](docs/TimesheetApi.md#api_timesheets_id_delete) | **DELETE** /api/timesheets/{id} | Delete an existing timesheet record
*TimesheetApi* | [**api_timesheets_id_duplicate_patch**](docs/TimesheetApi.md#api_timesheets_id_duplicate_patch) | **PATCH** /api/timesheets/{id}/duplicate | Duplicates an existing timesheet record
*TimesheetApi* | [**api_timesheets_id_export_patch**](docs/TimesheetApi.md#api_timesheets_id_export_patch) | **PATCH** /api/timesheets/{id}/export | Switch the export state of a timesheet record to (un-)lock it
*TimesheetApi* | [**api_timesheets_id_get**](docs/TimesheetApi.md#api_timesheets_id_get) | **GET** /api/timesheets/{id} | Returns one timesheet record
*TimesheetApi* | [**api_timesheets_id_meta_patch**](docs/TimesheetApi.md#api_timesheets_id_meta_patch) | **PATCH** /api/timesheets/{id}/meta | Sets the value of a meta-field for an existing timesheet.
*TimesheetApi* | [**api_timesheets_id_patch**](docs/TimesheetApi.md#api_timesheets_id_patch) | **PATCH** /api/timesheets/{id} | Update an existing timesheet record
*TimesheetApi* | [**api_timesheets_id_restart_patch**](docs/TimesheetApi.md#api_timesheets_id_restart_patch) | **PATCH** /api/timesheets/{id}/restart | Restarts a previously stopped timesheet record for the current user
*TimesheetApi* | [**api_timesheets_id_stop_patch**](docs/TimesheetApi.md#api_timesheets_id_stop_patch) | **PATCH** /api/timesheets/{id}/stop | Stops an active timesheet record
*TimesheetApi* | [**api_timesheets_post**](docs/TimesheetApi.md#api_timesheets_post) | **POST** /api/timesheets | Creates a new timesheet record
*TimesheetApi* | [**api_timesheets_recent_get**](docs/TimesheetApi.md#api_timesheets_recent_get) | **GET** /api/timesheets/recent | Returns the collection of recent user activities
*UserApi* | [**api_users_get**](docs/UserApi.md#api_users_get) | **GET** /api/users | Returns the collection of all registered users
*UserApi* | [**api_users_id_get**](docs/UserApi.md#api_users_id_get) | **GET** /api/users/{id} | Return one user entity
*UserApi* | [**api_users_id_patch**](docs/UserApi.md#api_users_id_patch) | **PATCH** /api/users/{id} | Update an existing user
*UserApi* | [**api_users_me_get**](docs/UserApi.md#api_users_me_get) | **GET** /api/users/me | Return the current user entity
*UserApi* | [**api_users_post**](docs/UserApi.md#api_users_post) | **POST** /api/users | Creates a new user


## Documentation For Models

 - [Activity](docs/Activity.md)
 - [ActivityCollection](docs/ActivityCollection.md)
 - [ActivityEditForm](docs/ActivityEditForm.md)
 - [ActivityEntity](docs/ActivityEntity.md)
 - [ActivityMeta](docs/ActivityMeta.md)
 - [ActivityMetaField](docs/ActivityMetaField.md)
 - [ActivityRate](docs/ActivityRate.md)
 - [ActivityRateForm](docs/ActivityRateForm.md)
 - [Body](docs/Body.md)
 - [Body1](docs/Body1.md)
 - [Body2](docs/Body2.md)
 - [Body3](docs/Body3.md)
 - [Body4](docs/Body4.md)
 - [Customer](docs/Customer.md)
 - [Customer2](docs/Customer2.md)
 - [CustomerCollection](docs/CustomerCollection.md)
 - [CustomerEditForm](docs/CustomerEditForm.md)
 - [CustomerEntity](docs/CustomerEntity.md)
 - [CustomerMeta](docs/CustomerMeta.md)
 - [CustomerMetaField](docs/CustomerMetaField.md)
 - [CustomerRate](docs/CustomerRate.md)
 - [CustomerRateForm](docs/CustomerRateForm.md)
 - [I18nConfig](docs/I18nConfig.md)
 - [Project](docs/Project.md)
 - [Project2](docs/Project2.md)
 - [ProjectCollection](docs/ProjectCollection.md)
 - [ProjectEditForm](docs/ProjectEditForm.md)
 - [ProjectEntity](docs/ProjectEntity.md)
 - [ProjectMeta](docs/ProjectMeta.md)
 - [ProjectMetaField](docs/ProjectMetaField.md)
 - [ProjectRate](docs/ProjectRate.md)
 - [ProjectRateForm](docs/ProjectRateForm.md)
 - [TagEditForm](docs/TagEditForm.md)
 - [TagEntity](docs/TagEntity.md)
 - [Team](docs/Team.md)
 - [Team2](docs/Team2.md)
 - [Team3](docs/Team3.md)
 - [Team4](docs/Team4.md)
 - [Team5](docs/Team5.md)
 - [TeamCollection](docs/TeamCollection.md)
 - [TeamEditForm](docs/TeamEditForm.md)
 - [TeamEntity](docs/TeamEntity.md)
 - [Timesheet](docs/Timesheet.md)
 - [TimesheetCollection](docs/TimesheetCollection.md)
 - [TimesheetConfig](docs/TimesheetConfig.md)
 - [TimesheetEditForm](docs/TimesheetEditForm.md)
 - [TimesheetEntity](docs/TimesheetEntity.md)
 - [TimesheetMeta](docs/TimesheetMeta.md)
 - [TimesheetMeta2](docs/TimesheetMeta2.md)
 - [TimesheetSubCollection](docs/TimesheetSubCollection.md)
 - [User](docs/User.md)
 - [User2](docs/User2.md)
 - [UserCollection](docs/UserCollection.md)
 - [UserCreateForm](docs/UserCreateForm.md)
 - [UserEditForm](docs/UserEditForm.md)
 - [UserEntity](docs/UserEntity.md)
 - [Version](docs/Version.md)


## Documentation For Authorization


## apiToken

- **Type**: API key
- **API key parameter name**: X-AUTH-TOKEN
- **Location**: HTTP header

## apiUser

- **Type**: API key
- **API key parameter name**: X-AUTH-USER
- **Location**: HTTP header


## Author



