# coding: utf-8

"""
    Felix' Website mit Blog

    The api of my blog.  # noqa: E501

    OpenAPI spec version: 1.0.0
    Contact: felix@felix-scholz.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from website_python_client.api_client import ApiClient


class CategoryApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_category(self, body, **kwargs):  # noqa: E501
        """create a new category  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_category(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Object body: order for create a category (required)
        :return: Object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_category_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_category_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_category_with_http_info(self, body, **kwargs):  # noqa: E501
        """create a new category  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_category_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Object body: order for create a category (required)
        :return: Object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_category" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_category`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiSecurity', 'ApiWriteSecurity']  # noqa: E501

        return self.api_client.call_api(
            '/category', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_category(self, category, **kwargs):  # noqa: E501
        """delete a category  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_category(category, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int category: update a category by this id (required)
        :return: Object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_category_with_http_info(category, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_category_with_http_info(category, **kwargs)  # noqa: E501
            return data

    def delete_category_with_http_info(self, category, **kwargs):  # noqa: E501
        """delete a category  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_category_with_http_info(category, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int category: update a category by this id (required)
        :return: Object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['category']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_category" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'category' is set
        if ('category' not in params or
                params['category'] is None):
            raise ValueError("Missing the required parameter `category` when calling `delete_category`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'category' in params:
            path_params['category'] = params['category']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiSecurity', 'ApiWriteSecurity']  # noqa: E501

        return self.api_client.call_api(
            '/category/{category}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_category(self, category, **kwargs):  # noqa: E501
        """get a category  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_category(category, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int category: update a category by this id (required)
        :param int embedded_categories: Category ids resolve to category
        :return: Object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_category_with_http_info(category, **kwargs)  # noqa: E501
        else:
            (data) = self.get_category_with_http_info(category, **kwargs)  # noqa: E501
            return data

    def get_category_with_http_info(self, category, **kwargs):  # noqa: E501
        """get a category  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_category_with_http_info(category, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int category: update a category by this id (required)
        :param int embedded_categories: Category ids resolve to category
        :return: Object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['category', 'embedded_categories']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_category" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'category' is set
        if ('category' not in params or
                params['category'] is None):
            raise ValueError("Missing the required parameter `category` when calling `get_category`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'category' in params:
            path_params['category'] = params['category']  # noqa: E501

        query_params = []
        if 'embedded_categories' in params:
            query_params.append(('embeddedCategories', params['embedded_categories']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiSecurity', 'ApiWriteSecurity']  # noqa: E501

        return self.api_client.call_api(
            '/category/{category}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_categories(self, **kwargs):  # noqa: E501
        """Returned all categories  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_categories(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str identifier: get a category by identifier
        :return: list[Category]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_categories_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_categories_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_categories_with_http_info(self, **kwargs):  # noqa: E501
        """Returned all categories  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_categories_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str identifier: get a category by identifier
        :return: list[Category]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_categories" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'identifier' in params:
            query_params.append(('identifier', params['identifier']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiReadSecurity', 'ApiSecurity']  # noqa: E501

        return self.api_client.call_api(
            '/category', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Category]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_category(self, body, category, **kwargs):  # noqa: E501
        """update a category  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_category(body, category, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Object body: order for update a category (required)
        :param int category: update a category by this id (required)
        :return: Object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_category_with_http_info(body, category, **kwargs)  # noqa: E501
        else:
            (data) = self.update_category_with_http_info(body, category, **kwargs)  # noqa: E501
            return data

    def update_category_with_http_info(self, body, category, **kwargs):  # noqa: E501
        """update a category  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_category_with_http_info(body, category, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Object body: order for update a category (required)
        :param int category: update a category by this id (required)
        :return: Object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'category']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_category" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_category`")  # noqa: E501
        # verify the required parameter 'category' is set
        if ('category' not in params or
                params['category'] is None):
            raise ValueError("Missing the required parameter `category` when calling `update_category`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'category' in params:
            path_params['category'] = params['category']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiSecurity', 'ApiWriteSecurity']  # noqa: E501

        return self.api_client.call_api(
            '/category/{category}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
