# coding: utf-8

"""
    Felix' Website mit Blog

    The api of my blog.  # noqa: E501

    OpenAPI spec version: 1.0.0
    Contact: felix@felix-scholz.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from website_python_client.api_client import ApiClient


class PostApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_post(self, identifier, source, slug, title, description, tags, path, content, release, listing, authors, acl, preview, images, markdown, **kwargs):  # noqa: E501
        """create a new post  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_post(identifier, source, slug, title, description, tags, path, content, release, listing, authors, acl, preview, images, markdown, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str identifier: (required)
        :param str source: (required)
        :param str slug: (required)
        :param str title: (required)
        :param str description: (required)
        :param list[str] tags: (required)
        :param list[str] path: (required)
        :param str content: (required)
        :param str release: (required)
        :param bool listing: (required)
        :param Author authors: (required)
        :param Acl acl: (required)
        :param list[str] preview: (required)
        :param list[str] images: (required)
        :param str markdown: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_post_with_http_info(identifier, source, slug, title, description, tags, path, content, release, listing, authors, acl, preview, images, markdown, **kwargs)  # noqa: E501
        else:
            (data) = self.create_post_with_http_info(identifier, source, slug, title, description, tags, path, content, release, listing, authors, acl, preview, images, markdown, **kwargs)  # noqa: E501
            return data

    def create_post_with_http_info(self, identifier, source, slug, title, description, tags, path, content, release, listing, authors, acl, preview, images, markdown, **kwargs):  # noqa: E501
        """create a new post  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_post_with_http_info(identifier, source, slug, title, description, tags, path, content, release, listing, authors, acl, preview, images, markdown, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str identifier: (required)
        :param str source: (required)
        :param str slug: (required)
        :param str title: (required)
        :param str description: (required)
        :param list[str] tags: (required)
        :param list[str] path: (required)
        :param str content: (required)
        :param str release: (required)
        :param bool listing: (required)
        :param Author authors: (required)
        :param Acl acl: (required)
        :param list[str] preview: (required)
        :param list[str] images: (required)
        :param str markdown: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'source', 'slug', 'title', 'description', 'tags', 'path', 'content', 'release', 'listing', 'authors', 'acl', 'preview', 'images', 'markdown']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `create_post`")  # noqa: E501
        # verify the required parameter 'source' is set
        if ('source' not in params or
                params['source'] is None):
            raise ValueError("Missing the required parameter `source` when calling `create_post`")  # noqa: E501
        # verify the required parameter 'slug' is set
        if ('slug' not in params or
                params['slug'] is None):
            raise ValueError("Missing the required parameter `slug` when calling `create_post`")  # noqa: E501
        # verify the required parameter 'title' is set
        if ('title' not in params or
                params['title'] is None):
            raise ValueError("Missing the required parameter `title` when calling `create_post`")  # noqa: E501
        # verify the required parameter 'description' is set
        if ('description' not in params or
                params['description'] is None):
            raise ValueError("Missing the required parameter `description` when calling `create_post`")  # noqa: E501
        # verify the required parameter 'tags' is set
        if ('tags' not in params or
                params['tags'] is None):
            raise ValueError("Missing the required parameter `tags` when calling `create_post`")  # noqa: E501
        # verify the required parameter 'path' is set
        if ('path' not in params or
                params['path'] is None):
            raise ValueError("Missing the required parameter `path` when calling `create_post`")  # noqa: E501
        # verify the required parameter 'content' is set
        if ('content' not in params or
                params['content'] is None):
            raise ValueError("Missing the required parameter `content` when calling `create_post`")  # noqa: E501
        # verify the required parameter 'release' is set
        if ('release' not in params or
                params['release'] is None):
            raise ValueError("Missing the required parameter `release` when calling `create_post`")  # noqa: E501
        # verify the required parameter 'listing' is set
        if ('listing' not in params or
                params['listing'] is None):
            raise ValueError("Missing the required parameter `listing` when calling `create_post`")  # noqa: E501
        # verify the required parameter 'authors' is set
        if ('authors' not in params or
                params['authors'] is None):
            raise ValueError("Missing the required parameter `authors` when calling `create_post`")  # noqa: E501
        # verify the required parameter 'acl' is set
        if ('acl' not in params or
                params['acl'] is None):
            raise ValueError("Missing the required parameter `acl` when calling `create_post`")  # noqa: E501
        # verify the required parameter 'preview' is set
        if ('preview' not in params or
                params['preview'] is None):
            raise ValueError("Missing the required parameter `preview` when calling `create_post`")  # noqa: E501
        # verify the required parameter 'images' is set
        if ('images' not in params or
                params['images'] is None):
            raise ValueError("Missing the required parameter `images` when calling `create_post`")  # noqa: E501
        # verify the required parameter 'markdown' is set
        if ('markdown' not in params or
                params['markdown'] is None):
            raise ValueError("Missing the required parameter `markdown` when calling `create_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'identifier' in params:
            form_params.append(('identifier', params['identifier']))  # noqa: E501
        if 'source' in params:
            form_params.append(('source', params['source']))  # noqa: E501
        if 'slug' in params:
            form_params.append(('slug', params['slug']))  # noqa: E501
        if 'title' in params:
            form_params.append(('title', params['title']))  # noqa: E501
        if 'description' in params:
            form_params.append(('description', params['description']))  # noqa: E501
        if 'tags' in params:
            form_params.append(('tags', params['tags']))  # noqa: E501
            collection_formats['tags'] = 'multi'  # noqa: E501
        if 'path' in params:
            form_params.append(('path', params['path']))  # noqa: E501
            collection_formats['path'] = 'multi'  # noqa: E501
        if 'content' in params:
            form_params.append(('content', params['content']))  # noqa: E501
        if 'release' in params:
            form_params.append(('release', params['release']))  # noqa: E501
        if 'listing' in params:
            form_params.append(('listing', params['listing']))  # noqa: E501
        if 'authors' in params:
            form_params.append(('authors', params['authors']))  # noqa: E501
        if 'acl' in params:
            form_params.append(('acl', params['acl']))  # noqa: E501
        if 'preview' in params:
            form_params.append(('preview[]', params['preview']))  # noqa: E501
            collection_formats['preview[]'] = 'multi'  # noqa: E501
        if 'images' in params:
            form_params.append(('images[]', params['images']))  # noqa: E501
            collection_formats['images[]'] = 'multi'  # noqa: E501
        if 'markdown' in params:
            form_params.append(('markdown', params['markdown']))  # noqa: E501

        body_params = None
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiSecurity', 'ApiWriteSecurity']  # noqa: E501

        return self.api_client.call_api(
            '/post', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_post(self, post, **kwargs):  # noqa: E501
        """Delete the post by id  # noqa: E501

        Delete the post by id,  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_post(post, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int post: delete a post by this id (required)
        :param bool force: delete a post, force, by this id
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_post_with_http_info(post, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_post_with_http_info(post, **kwargs)  # noqa: E501
            return data

    def delete_post_with_http_info(self, post, **kwargs):  # noqa: E501
        """Delete the post by id  # noqa: E501

        Delete the post by id,  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_post_with_http_info(post, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int post: delete a post by this id (required)
        :param bool force: delete a post, force, by this id
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['post', 'force']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'post' is set
        if ('post' not in params or
                params['post'] is None):
            raise ValueError("Missing the required parameter `post` when calling `delete_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'post' in params:
            path_params['post'] = params['post']  # noqa: E501

        query_params = []
        if 'force' in params:
            query_params.append(('force', params['force']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['ApiSecurity', 'ApiWriteSecurity']  # noqa: E501

        return self.api_client.call_api(
            '/post/{post}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_post(self, **kwargs):  # noqa: E501
        """Returns all posts  # noqa: E501

        Returns a list of posts by any parameter  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_post(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str identifier: get a post by identifier
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_post_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_post_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_post_with_http_info(self, **kwargs):  # noqa: E501
        """Returns all posts  # noqa: E501

        Returns a list of posts by any parameter  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_post_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str identifier: get a post by identifier
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_post" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'identifier' in params:
            query_params.append(('identifier', params['identifier']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['ApiReadSecurity', 'ApiSecurity']  # noqa: E501

        return self.api_client.call_api(
            '/post', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def show_post(self, post, **kwargs):  # noqa: E501
        """Returns a posts  # noqa: E501

        Returns a spezific post with all content of the post  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.show_post(post, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int post: get a post by this id (required)
        :param int with_tags: Show all Tags to this post?
        :param int with_images: Show all Images to this post?
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.show_post_with_http_info(post, **kwargs)  # noqa: E501
        else:
            (data) = self.show_post_with_http_info(post, **kwargs)  # noqa: E501
            return data

    def show_post_with_http_info(self, post, **kwargs):  # noqa: E501
        """Returns a posts  # noqa: E501

        Returns a spezific post with all content of the post  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.show_post_with_http_info(post, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int post: get a post by this id (required)
        :param int with_tags: Show all Tags to this post?
        :param int with_images: Show all Images to this post?
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['post', 'with_tags', 'with_images']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method show_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'post' is set
        if ('post' not in params or
                params['post'] is None):
            raise ValueError("Missing the required parameter `post` when calling `show_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'post' in params:
            path_params['post'] = params['post']  # noqa: E501

        query_params = []
        if 'with_tags' in params:
            query_params.append(('withTags', params['with_tags']))  # noqa: E501
        if 'with_images' in params:
            query_params.append(('withImages', params['with_images']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['ApiReadSecurity', 'ApiSecurity']  # noqa: E501

        return self.api_client.call_api(
            '/post/{post}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_post(self, identifier, source, slug, title, description, tags, path, content, release, listing, authors, acl, preview, images, markdown, post, **kwargs):  # noqa: E501
        """Update the post by id  # noqa: E501

        Udate the post by id,  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_post(identifier, source, slug, title, description, tags, path, content, release, listing, authors, acl, preview, images, markdown, post, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str identifier: (required)
        :param str source: (required)
        :param str slug: (required)
        :param str title: (required)
        :param str description: (required)
        :param list[str] tags: (required)
        :param list[str] path: (required)
        :param str content: (required)
        :param str release: (required)
        :param bool listing: (required)
        :param Author authors: (required)
        :param Acl acl: (required)
        :param list[str] preview: (required)
        :param list[str] images: (required)
        :param str markdown: (required)
        :param int post: update a post by this id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_post_with_http_info(identifier, source, slug, title, description, tags, path, content, release, listing, authors, acl, preview, images, markdown, post, **kwargs)  # noqa: E501
        else:
            (data) = self.update_post_with_http_info(identifier, source, slug, title, description, tags, path, content, release, listing, authors, acl, preview, images, markdown, post, **kwargs)  # noqa: E501
            return data

    def update_post_with_http_info(self, identifier, source, slug, title, description, tags, path, content, release, listing, authors, acl, preview, images, markdown, post, **kwargs):  # noqa: E501
        """Update the post by id  # noqa: E501

        Udate the post by id,  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_post_with_http_info(identifier, source, slug, title, description, tags, path, content, release, listing, authors, acl, preview, images, markdown, post, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str identifier: (required)
        :param str source: (required)
        :param str slug: (required)
        :param str title: (required)
        :param str description: (required)
        :param list[str] tags: (required)
        :param list[str] path: (required)
        :param str content: (required)
        :param str release: (required)
        :param bool listing: (required)
        :param Author authors: (required)
        :param Acl acl: (required)
        :param list[str] preview: (required)
        :param list[str] images: (required)
        :param str markdown: (required)
        :param int post: update a post by this id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'source', 'slug', 'title', 'description', 'tags', 'path', 'content', 'release', 'listing', 'authors', 'acl', 'preview', 'images', 'markdown', 'post']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `update_post`")  # noqa: E501
        # verify the required parameter 'source' is set
        if ('source' not in params or
                params['source'] is None):
            raise ValueError("Missing the required parameter `source` when calling `update_post`")  # noqa: E501
        # verify the required parameter 'slug' is set
        if ('slug' not in params or
                params['slug'] is None):
            raise ValueError("Missing the required parameter `slug` when calling `update_post`")  # noqa: E501
        # verify the required parameter 'title' is set
        if ('title' not in params or
                params['title'] is None):
            raise ValueError("Missing the required parameter `title` when calling `update_post`")  # noqa: E501
        # verify the required parameter 'description' is set
        if ('description' not in params or
                params['description'] is None):
            raise ValueError("Missing the required parameter `description` when calling `update_post`")  # noqa: E501
        # verify the required parameter 'tags' is set
        if ('tags' not in params or
                params['tags'] is None):
            raise ValueError("Missing the required parameter `tags` when calling `update_post`")  # noqa: E501
        # verify the required parameter 'path' is set
        if ('path' not in params or
                params['path'] is None):
            raise ValueError("Missing the required parameter `path` when calling `update_post`")  # noqa: E501
        # verify the required parameter 'content' is set
        if ('content' not in params or
                params['content'] is None):
            raise ValueError("Missing the required parameter `content` when calling `update_post`")  # noqa: E501
        # verify the required parameter 'release' is set
        if ('release' not in params or
                params['release'] is None):
            raise ValueError("Missing the required parameter `release` when calling `update_post`")  # noqa: E501
        # verify the required parameter 'listing' is set
        if ('listing' not in params or
                params['listing'] is None):
            raise ValueError("Missing the required parameter `listing` when calling `update_post`")  # noqa: E501
        # verify the required parameter 'authors' is set
        if ('authors' not in params or
                params['authors'] is None):
            raise ValueError("Missing the required parameter `authors` when calling `update_post`")  # noqa: E501
        # verify the required parameter 'acl' is set
        if ('acl' not in params or
                params['acl'] is None):
            raise ValueError("Missing the required parameter `acl` when calling `update_post`")  # noqa: E501
        # verify the required parameter 'preview' is set
        if ('preview' not in params or
                params['preview'] is None):
            raise ValueError("Missing the required parameter `preview` when calling `update_post`")  # noqa: E501
        # verify the required parameter 'images' is set
        if ('images' not in params or
                params['images'] is None):
            raise ValueError("Missing the required parameter `images` when calling `update_post`")  # noqa: E501
        # verify the required parameter 'markdown' is set
        if ('markdown' not in params or
                params['markdown'] is None):
            raise ValueError("Missing the required parameter `markdown` when calling `update_post`")  # noqa: E501
        # verify the required parameter 'post' is set
        if ('post' not in params or
                params['post'] is None):
            raise ValueError("Missing the required parameter `post` when calling `update_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'post' in params:
            path_params['post'] = params['post']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'identifier' in params:
            form_params.append(('identifier', params['identifier']))  # noqa: E501
        if 'source' in params:
            form_params.append(('source', params['source']))  # noqa: E501
        if 'slug' in params:
            form_params.append(('slug', params['slug']))  # noqa: E501
        if 'title' in params:
            form_params.append(('title', params['title']))  # noqa: E501
        if 'description' in params:
            form_params.append(('description', params['description']))  # noqa: E501
        if 'tags' in params:
            form_params.append(('tags', params['tags']))  # noqa: E501
            collection_formats['tags'] = 'multi'  # noqa: E501
        if 'path' in params:
            form_params.append(('path', params['path']))  # noqa: E501
            collection_formats['path'] = 'multi'  # noqa: E501
        if 'content' in params:
            form_params.append(('content', params['content']))  # noqa: E501
        if 'release' in params:
            form_params.append(('release', params['release']))  # noqa: E501
        if 'listing' in params:
            form_params.append(('listing', params['listing']))  # noqa: E501
        if 'authors' in params:
            form_params.append(('authors', params['authors']))  # noqa: E501
        if 'acl' in params:
            form_params.append(('acl', params['acl']))  # noqa: E501
        if 'preview' in params:
            form_params.append(('preview[]', params['preview']))  # noqa: E501
            collection_formats['preview[]'] = 'multi'  # noqa: E501
        if 'images' in params:
            form_params.append(('images[]', params['images']))  # noqa: E501
            collection_formats['images[]'] = 'multi'  # noqa: E501
        if 'markdown' in params:
            form_params.append(('markdown', params['markdown']))  # noqa: E501

        body_params = None
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiSecurity', 'ApiWriteSecurity']  # noqa: E501

        return self.api_client.call_api(
            '/post/{post}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
