"""
 SMARTS definitions for the publicly available MACCS keys
and a MACCS fingerprinter

I compared the MACCS fingerprints generated here with those from two
other packages (not MDL, unfortunately). Of course there are
disagreements between the various fingerprints still, but I think
these definitions work pretty well. Some notes:

1) most of the differences have to do with aromaticity
2) there's a discrepancy sometimes because the current RDKit
definitions do not require multiple matches to be distinct. e.g. the
SMILES C(=O)CC(=O) can match the (hypothetical) key O=CC twice in my
definition. It's not clear to me what the correct behavior is.
3) Some keys are not fully defined in the MDL documentation
4) Two keys, 125 and 166, have to be done outside of SMARTS.
5) Key 1 (ISOTOPE) isn't defined

Rev history:
2006 (gl): Original open-source release
May 2011 (gl): Update some definitions based on feedback from Andrew Dalke

"""
from __future__ import annotations
from rdkit import Chem
from rdkit.Chem import rdMolDescriptors
from rdkit import DataStructs
__all__: list[str] = ['Chem', 'DataStructs', 'maccsKeys', 'rdMolDescriptors', 'smartsPatts']
def _InitKeys(keyList, keyDict):
    """
     *Internal Use Only*
    
       generates SMARTS patterns for the keys, run once
    
      
    """
def _pyGenMACCSKeys(mol, **kwargs):
    """
     generates the MACCS fingerprint for a molecules
    
       **Arguments**
    
         - mol: the molecule to be fingerprinted
    
         - any extra keyword arguments are ignored
         
       **Returns**
    
          a _DataStructs.SparseBitVect_ containing the fingerprint.
    
      >>> m = Chem.MolFromSmiles('CNO')
      >>> bv = GenMACCSKeys(m)
      >>> tuple(bv.GetOnBits())
      (24, 68, 69, 71, 93, 94, 102, 124, 131, 139, 151, 158, 160, 161, 164)
      >>> bv = GenMACCSKeys(Chem.MolFromSmiles('CCC'))
      >>> tuple(bv.GetOnBits())
      (74, 114, 149, 155, 160)
    
      
    """
def _test():
    ...
maccsKeys = None
smartsPatts: dict = {1: ('?', 0), 2: ('[#104]', 0), 3: ('[#32,#33,#34,#50,#51,#52,#82,#83,#84]', 0), 4: ('[Ac,Th,Pa,U,Np,Pu,Am,Cm,Bk,Cf,Es,Fm,Md,No,Lr]', 0), 5: ('[Sc,Ti,Y,Zr,Hf]', 0), 6: ('[La,Ce,Pr,Nd,Pm,Sm,Eu,Gd,Tb,Dy,Ho,Er,Tm,Yb,Lu]', 0), 7: ('[V,Cr,Mn,Nb,Mo,Tc,Ta,W,Re]', 0), 8: ('[!#6;!#1]1~*~*~*~1', 0), 9: ('[Fe,Co,Ni,Ru,Rh,Pd,Os,Ir,Pt]', 0), 10: ('[Be,Mg,Ca,Sr,Ba,Ra]', 0), 11: ('*1~*~*~*~1', 0), 12: ('[Cu,Zn,Ag,Cd,Au,Hg]', 0), 13: ('[#8]~[#7](~[#6])~[#6]', 0), 14: ('[#16]-[#16]', 0), 15: ('[#8]~[#6](~[#8])~[#8]', 0), 16: ('[!#6;!#1]1~*~*~1', 0), 17: ('[#6]#[#6]', 0), 18: ('[#5,#13,#31,#49,#81]', 0), 19: ('*1~*~*~*~*~*~*~1', 0), 20: ('[#14]', 0), 21: ('[#6]=[#6](~[!#6;!#1])~[!#6;!#1]', 0), 22: ('*1~*~*~1', 0), 23: ('[#7]~[#6](~[#8])~[#8]', 0), 24: ('[#7]-[#8]', 0), 25: ('[#7]~[#6](~[#7])~[#7]', 0), 26: ('[#6]=;@[#6](@*)@*', 0), 27: ('[I]', 0), 28: ('[!#6;!#1]~[CH2]~[!#6;!#1]', 0), 29: ('[#15]', 0), 30: ('[#6]~[!#6;!#1](~[#6])(~[#6])~*', 0), 31: ('[!#6;!#1]~[F,Cl,Br,I]', 0), 32: ('[#6]~[#16]~[#7]', 0), 33: ('[#7]~[#16]', 0), 34: ('[CH2]=*', 0), 35: ('[Li,Na,K,Rb,Cs,Fr]', 0), 36: ('[#16R]', 0), 37: ('[#7]~[#6](~[#8])~[#7]', 0), 38: ('[#7]~[#6](~[#6])~[#7]', 0), 39: ('[#8]~[#16](~[#8])~[#8]', 0), 40: ('[#16]-[#8]', 0), 41: ('[#6]#[#7]', 0), 42: ('F', 0), 43: ('[!#6;!#1;!H0]~*~[!#6;!#1;!H0]', 0), 44: ('[!#1;!#6;!#7;!#8;!#9;!#14;!#15;!#16;!#17;!#35;!#53]', 0), 45: ('[#6]=[#6]~[#7]', 0), 46: ('Br', 0), 47: ('[#16]~*~[#7]', 0), 48: ('[#8]~[!#6;!#1](~[#8])(~[#8])', 0), 49: ('[!+0]', 0), 50: ('[#6]=[#6](~[#6])~[#6]', 0), 51: ('[#6]~[#16]~[#8]', 0), 52: ('[#7]~[#7]', 0), 53: ('[!#6;!#1;!H0]~*~*~*~[!#6;!#1;!H0]', 0), 54: ('[!#6;!#1;!H0]~*~*~[!#6;!#1;!H0]', 0), 55: ('[#8]~[#16]~[#8]', 0), 56: ('[#8]~[#7](~[#8])~[#6]', 0), 57: ('[#8R]', 0), 58: ('[!#6;!#1]~[#16]~[!#6;!#1]', 0), 59: ('[#16]!:*:*', 0), 60: ('[#16]=[#8]', 0), 61: ('*~[#16](~*)~*', 0), 62: ('*@*!@*@*', 0), 63: ('[#7]=[#8]', 0), 64: ('*@*!@[#16]', 0), 65: ('c:n', 0), 66: ('[#6]~[#6](~[#6])(~[#6])~*', 0), 67: ('[!#6;!#1]~[#16]', 0), 68: ('[!#6;!#1;!H0]~[!#6;!#1;!H0]', 0), 69: ('[!#6;!#1]~[!#6;!#1;!H0]', 0), 70: ('[!#6;!#1]~[#7]~[!#6;!#1]', 0), 71: ('[#7]~[#8]', 0), 72: ('[#8]~*~*~[#8]', 0), 73: ('[#16]=*', 0), 74: ('[CH3]~*~[CH3]', 0), 75: ('*!@[#7]@*', 0), 76: ('[#6]=[#6](~*)~*', 0), 77: ('[#7]~*~[#7]', 0), 78: ('[#6]=[#7]', 0), 79: ('[#7]~*~*~[#7]', 0), 80: ('[#7]~*~*~*~[#7]', 0), 81: ('[#16]~*(~*)~*', 0), 82: ('*~[CH2]~[!#6;!#1;!H0]', 0), 83: ('[!#6;!#1]1~*~*~*~*~1', 0), 84: ('[NH2]', 0), 85: ('[#6]~[#7](~[#6])~[#6]', 0), 86: ('[C;H2,H3][!#6;!#1][C;H2,H3]', 0), 87: ('[F,Cl,Br,I]!@*@*', 0), 88: ('[#16]', 0), 89: ('[#8]~*~*~*~[#8]', 0), 90: ('[$([!#6;!#1;!H0]~*~*~[CH2]~*),$([!#6;!#1;!H0;R]1@[R]@[R]@[CH2;R]1),$([!#6;!#1;!H0]~[R]1@[R]@[CH2;R]1)]', 0), 91: ('[$([!#6;!#1;!H0]~*~*~*~[CH2]~*),$([!#6;!#1;!H0;R]1@[R]@[R]@[R]@[CH2;R]1),$([!#6;!#1;!H0]~[R]1@[R]@[R]@[CH2;R]1),$([!#6;!#1;!H0]~*~[R]1@[R]@[CH2;R]1)]', 0), 92: ('[#8]~[#6](~[#7])~[#6]', 0), 93: ('[!#6;!#1]~[CH3]', 0), 94: ('[!#6;!#1]~[#7]', 0), 95: ('[#7]~*~*~[#8]', 0), 96: ('*1~*~*~*~*~1', 0), 97: ('[#7]~*~*~*~[#8]', 0), 98: ('[!#6;!#1]1~*~*~*~*~*~1', 0), 99: ('[#6]=[#6]', 0), 100: ('*~[CH2]~[#7]', 0), 101: ('[$([R]@1@[R]@[R]@[R]@[R]@[R]@[R]@[R]1),$([R]@1@[R]@[R]@[R]@[R]@[R]@[R]@[R]@[R]1),$([R]@1@[R]@[R]@[R]@[R]@[R]@[R]@[R]@[R]@[R]1),$([R]@1@[R]@[R]@[R]@[R]@[R]@[R]@[R]@[R]@[R]@[R]1),$([R]@1@[R]@[R]@[R]@[R]@[R]@[R]@[R]@[R]@[R]@[R]@[R]1),$([R]@1@[R]@[R]@[R]@[R]@[R]@[R]@[R]@[R]@[R]@[R]@[R]@[R]1),$([R]@1@[R]@[R]@[R]@[R]@[R]@[R]@[R]@[R]@[R]@[R]@[R]@[R]@[R]1)]', 0), 102: ('[!#6;!#1]~[#8]', 0), 103: ('Cl', 0), 104: ('[!#6;!#1;!H0]~*~[CH2]~*', 0), 105: ('*@*(@*)@*', 0), 106: ('[!#6;!#1]~*(~[!#6;!#1])~[!#6;!#1]', 0), 107: ('[F,Cl,Br,I]~*(~*)~*', 0), 108: ('[CH3]~*~*~*~[CH2]~*', 0), 109: ('*~[CH2]~[#8]', 0), 110: ('[#7]~[#6]~[#8]', 0), 111: ('[#7]~*~[CH2]~*', 0), 112: ('*~*(~*)(~*)~*', 0), 113: ('[#8]!:*:*', 0), 114: ('[CH3]~[CH2]~*', 0), 115: ('[CH3]~*~[CH2]~*', 0), 116: ('[$([CH3]~*~*~[CH2]~*),$([CH3]~*1~*~[CH2]1)]', 0), 117: ('[#7]~*~[#8]', 0), 118: ('[$(*~[CH2]~[CH2]~*),$(*1~[CH2]~[CH2]1)]', 1), 119: ('[#7]=*', 0), 120: ('[!#6;R]', 1), 121: ('[#7;R]', 0), 122: ('*~[#7](~*)~*', 0), 123: ('[#8]~[#6]~[#8]', 0), 124: ('[!#6;!#1]~[!#6;!#1]', 0), 125: ('?', 0), 126: ('*!@[#8]!@*', 0), 127: ('*@*!@[#8]', 1), 128: ('[$(*~[CH2]~*~*~*~[CH2]~*),$([R]1@[CH2;R]@[R]@[R]@[R]@[CH2;R]1),$(*~[CH2]~[R]1@[R]@[R]@[CH2;R]1),$(*~[CH2]~*~[R]1@[R]@[CH2;R]1)]', 0), 129: ('[$(*~[CH2]~*~*~[CH2]~*),$([R]1@[CH2]@[R]@[R]@[CH2;R]1),$(*~[CH2]~[R]1@[R]@[CH2;R]1)]', 0), 130: ('[!#6;!#1]~[!#6;!#1]', 1), 131: ('[!#6;!#1;!H0]', 1), 132: ('[#8]~*~[CH2]~*', 0), 133: ('*@*!@[#7]', 0), 134: ('[F,Cl,Br,I]', 0), 135: ('[#7]!:*:*', 0), 136: ('[#8]=*', 1), 137: ('[!C;!c;R]', 0), 138: ('[!#6;!#1]~[CH2]~*', 1), 139: ('[O;!H0]', 0), 140: ('[#8]', 3), 141: ('[CH3]', 2), 142: ('[#7]', 1), 143: ('*@*!@[#8]', 0), 144: ('*!:*:*!:*', 0), 145: ('*1~*~*~*~*~*~1', 1), 146: ('[#8]', 2), 147: ('[$(*~[CH2]~[CH2]~*),$([R]1@[CH2;R]@[CH2;R]1)]', 0), 148: ('*~[!#6;!#1](~*)~*', 0), 149: ('[C;H3,H4]', 1), 150: ('*!@*@*!@*', 0), 151: ('[#7;!H0]', 0), 152: ('[#8]~[#6](~[#6])~[#6]', 0), 153: ('[!#6;!#1]~[CH2]~*', 0), 154: ('[#6]=[#8]', 0), 155: ('*!@[CH2]!@*', 0), 156: ('[#7]~*(~*)~*', 0), 157: ('[#6]-[#8]', 0), 158: ('[#6]-[#7]', 0), 159: ('[#8]', 1), 160: ('[C;H3,H4]', 0), 161: ('[#7]', 0), 162: ('a', 0), 163: ('*1~*~*~*~*~*~1', 0), 164: ('[#8]', 0), 165: ('[R]', 0), 166: ('?', 0)}
