/*
 * Decompiled with CFR 0.152.
 */
package org.ray.api.options;

import java.util.HashMap;
import java.util.Map;
import org.ray.api.options.BaseTaskOptions;

public class ActorCreationOptions
extends BaseTaskOptions {
    public static final int NO_RECONSTRUCTION = 0;
    public static final int INFINITE_RECONSTRUCTION = (int)Math.pow(2.0, 30.0);
    public final int maxReconstructions;
    public final String jvmOptions;
    public final int maxConcurrency;

    private ActorCreationOptions(Map<String, Double> resources, int maxReconstructions, boolean useDirectCall, String jvmOptions, int maxConcurrency) {
        super(resources, useDirectCall);
        this.maxReconstructions = maxReconstructions;
        this.jvmOptions = jvmOptions;
        this.maxConcurrency = maxConcurrency;
    }

    public static class Builder {
        private Map<String, Double> resources = new HashMap<String, Double>();
        private int maxReconstructions = 0;
        private boolean useDirectCall = BaseTaskOptions.DEFAULT_USE_DIRECT_CALL;
        private String jvmOptions = null;
        private int maxConcurrency = 1;

        public Builder setResources(Map<String, Double> resources) {
            this.resources = resources;
            return this;
        }

        public Builder setMaxReconstructions(int maxReconstructions) {
            this.maxReconstructions = maxReconstructions;
            return this;
        }

        public Builder setJvmOptions(String jvmOptions) {
            this.jvmOptions = jvmOptions;
            return this;
        }

        public Builder setMaxConcurrency(int maxConcurrency) {
            if (maxConcurrency <= 0) {
                throw new IllegalArgumentException("maxConcurrency must be greater than 0.");
            }
            this.maxConcurrency = maxConcurrency;
            return this;
        }

        public ActorCreationOptions createActorCreationOptions() {
            return new ActorCreationOptions(this.resources, this.maxReconstructions, this.useDirectCall, this.jvmOptions, this.maxConcurrency);
        }
    }
}

