/*
 * Decompiled with CFR 0.152.
 */
package org.ray.api.options;

import java.util.HashMap;
import java.util.Map;

public abstract class BaseTaskOptions {
    public static final boolean DEFAULT_USE_DIRECT_CALL = "1".equals(System.getenv("DEFAULT_USE_DIRECT_CALL"));
    public final Map<String, Double> resources;
    public final boolean useDirectCall;

    public BaseTaskOptions() {
        this.resources = new HashMap<String, Double>();
        this.useDirectCall = DEFAULT_USE_DIRECT_CALL;
    }

    public BaseTaskOptions(Map<String, Double> resources, boolean useDirectCall) {
        for (Map.Entry<String, Double> entry : resources.entrySet()) {
            if (entry.getValue().compareTo(0.0) > 0) continue;
            throw new IllegalArgumentException(String.format("Resource capacity should be positive, but got resource %s = %f.", entry.getKey(), entry.getValue()));
        }
        this.resources = resources;
        this.useDirectCall = useDirectCall;
    }
}

