/*
 * Decompiled with CFR 0.152.
 */
package org.ray.runtime.actor;

import com.google.common.base.Preconditions;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import org.ray.api.Ray;
import org.ray.api.RayActor;
import org.ray.api.id.ActorId;
import org.ray.api.runtime.RayRuntime;
import org.ray.runtime.RayMultiWorkerNativeRuntime;
import org.ray.runtime.RayNativeRuntime;
import org.ray.runtime.actor.NativeRayJavaActor;
import org.ray.runtime.actor.NativeRayPyActor;
import org.ray.runtime.generated.Common;

public abstract class NativeRayActor
implements RayActor,
Externalizable {
    long nativeCoreWorkerPointer;
    byte[] actorId;

    NativeRayActor(long nativeCoreWorkerPointer, byte[] actorId) {
        Preconditions.checkState(nativeCoreWorkerPointer != 0L);
        Preconditions.checkState(!ActorId.fromBytes(actorId).isNil());
        this.nativeCoreWorkerPointer = nativeCoreWorkerPointer;
        this.actorId = actorId;
    }

    NativeRayActor() {
    }

    public static NativeRayActor create(long nativeCoreWorkerPointer, byte[] actorId, Common.Language language) {
        Preconditions.checkState(nativeCoreWorkerPointer != 0L);
        switch (language) {
            case JAVA: {
                return new NativeRayJavaActor(nativeCoreWorkerPointer, actorId);
            }
            case PYTHON: {
                return new NativeRayPyActor(nativeCoreWorkerPointer, actorId);
            }
        }
        throw new IllegalStateException("Unknown actor handle language: " + language);
    }

    @Override
    public ActorId getId() {
        return ActorId.fromBytes(this.actorId);
    }

    public Common.Language getLanguage() {
        return Common.Language.forNumber(NativeRayActor.nativeGetLanguage(this.nativeCoreWorkerPointer, this.actorId));
    }

    public boolean isDirectCallActor() {
        return NativeRayActor.nativeIsDirectCallActor(this.nativeCoreWorkerPointer, this.actorId);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.toBytes());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.nativeCoreWorkerPointer = NativeRayActor.getNativeCoreWorkerPointer();
        this.actorId = NativeRayActor.nativeDeserialize(this.nativeCoreWorkerPointer, (byte[])in.readObject());
    }

    public byte[] toBytes() {
        return NativeRayActor.nativeSerialize(this.nativeCoreWorkerPointer, this.actorId);
    }

    public static NativeRayActor fromBytes(byte[] bytes) {
        long nativeCoreWorkerPointer = NativeRayActor.getNativeCoreWorkerPointer();
        byte[] actorId = NativeRayActor.nativeDeserialize(nativeCoreWorkerPointer, bytes);
        Common.Language language = Common.Language.forNumber(NativeRayActor.nativeGetLanguage(nativeCoreWorkerPointer, actorId));
        Preconditions.checkNotNull(language);
        return NativeRayActor.create(nativeCoreWorkerPointer, actorId, language);
    }

    private static long getNativeCoreWorkerPointer() {
        RayRuntime runtime = Ray.internal();
        if (runtime instanceof RayMultiWorkerNativeRuntime) {
            runtime = ((RayMultiWorkerNativeRuntime)runtime).getCurrentRuntime();
        }
        Preconditions.checkState(runtime instanceof RayNativeRuntime);
        return ((RayNativeRuntime)runtime).getNativeCoreWorkerPointer();
    }

    protected void finalize() {
    }

    private static native int nativeGetLanguage(long var0, byte[] var2);

    private static native boolean nativeIsDirectCallActor(long var0, byte[] var2);

    static native List<String> nativeGetActorCreationTaskFunctionDescriptor(long var0, byte[] var2);

    private static native byte[] nativeSerialize(long var0, byte[] var2);

    private static native byte[] nativeDeserialize(long var0, byte[] var2);
}

