/*
 * Decompiled with CFR 0.152.
 */
package org.ray.streaming.api.stream;

import org.ray.streaming.api.context.StreamingContext;
import org.ray.streaming.api.function.impl.FilterFunction;
import org.ray.streaming.api.function.impl.FlatMapFunction;
import org.ray.streaming.api.function.impl.KeyFunction;
import org.ray.streaming.api.function.impl.MapFunction;
import org.ray.streaming.api.function.impl.SinkFunction;
import org.ray.streaming.api.partition.Partition;
import org.ray.streaming.api.partition.impl.BroadcastPartition;
import org.ray.streaming.api.stream.DataStreamSink;
import org.ray.streaming.api.stream.JoinStream;
import org.ray.streaming.api.stream.KeyDataStream;
import org.ray.streaming.api.stream.Stream;
import org.ray.streaming.api.stream.UnionStream;
import org.ray.streaming.operator.StreamOperator;
import org.ray.streaming.operator.impl.FilterOperator;
import org.ray.streaming.operator.impl.FlatMapOperator;
import org.ray.streaming.operator.impl.KeyByOperator;
import org.ray.streaming.operator.impl.MapOperator;
import org.ray.streaming.operator.impl.SinkOperator;

public class DataStream<T>
extends Stream<T> {
    public DataStream(StreamingContext streamingContext, StreamOperator streamOperator) {
        super(streamingContext, streamOperator);
    }

    public DataStream(DataStream input, StreamOperator streamOperator) {
        super(input, streamOperator);
    }

    public <R> DataStream<R> map(MapFunction<T, R> mapFunction) {
        return new DataStream<T>(this, (StreamOperator)new MapOperator<T, R>(mapFunction));
    }

    public <R> DataStream<R> flatMap(FlatMapFunction<T, R> flatMapFunction) {
        return new DataStream<T>(this, (StreamOperator)new FlatMapOperator<T, R>(flatMapFunction));
    }

    public DataStream<T> filter(FilterFunction<T> filterFunction) {
        return new DataStream<T>(this, (StreamOperator)new FilterOperator<T>(filterFunction));
    }

    public UnionStream<T> union(DataStream<T> other) {
        return new UnionStream<T>(this, null, other);
    }

    public <O, R> JoinStream<T, O, R> join(DataStream<O> other) {
        return new JoinStream(this, other);
    }

    public <R> DataStream<R> process() {
        return new DataStream<T>(this, null);
    }

    public DataStreamSink<T> sink(SinkFunction<T> sinkFunction) {
        return new DataStreamSink(this, new SinkOperator<T>(sinkFunction));
    }

    public <K> KeyDataStream<K, T> keyBy(KeyFunction<T, K> keyFunction) {
        return new KeyDataStream(this, (StreamOperator)new KeyByOperator<T, K>(keyFunction));
    }

    public DataStream<T> broadcast() {
        this.partition = new BroadcastPartition();
        return this;
    }

    public DataStream<T> partitionBy(Partition<T> partition) {
        this.partition = partition;
        return this;
    }

    @Override
    public DataStream<T> setParallelism(int parallelism) {
        this.parallelism = parallelism;
        return this;
    }
}

