/*
 * Decompiled with CFR 0.152.
 */
package org.ray.streaming.runtime.core.graph;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.ray.api.RayActor;
import org.ray.streaming.runtime.core.graph.ExecutionNode;
import org.ray.streaming.runtime.core.graph.ExecutionTask;
import org.ray.streaming.runtime.worker.JobWorker;

public class ExecutionGraph
implements Serializable {
    private long buildTime;
    private List<ExecutionNode> executionNodeList;
    private List<RayActor<JobWorker>> sourceWorkers = new ArrayList<RayActor<JobWorker>>();
    private List<RayActor<JobWorker>> sinkWorkers = new ArrayList<RayActor<JobWorker>>();

    public ExecutionGraph(List<ExecutionNode> executionNodes) {
        this.executionNodeList = executionNodes;
        for (ExecutionNode executionNode : this.executionNodeList) {
            List actors;
            if (executionNode.getNodeType() == ExecutionNode.NodeType.SOURCE) {
                actors = executionNode.getExecutionTasks().stream().map(ExecutionTask::getWorker).collect(Collectors.toList());
                this.sourceWorkers.addAll(actors);
            }
            if (executionNode.getNodeType() != ExecutionNode.NodeType.SINK) continue;
            actors = executionNode.getExecutionTasks().stream().map(ExecutionTask::getWorker).collect(Collectors.toList());
            this.sinkWorkers.addAll(actors);
        }
        this.buildTime = System.currentTimeMillis();
    }

    public List<RayActor<JobWorker>> getSourceWorkers() {
        return this.sourceWorkers;
    }

    public List<RayActor<JobWorker>> getSinkWorkers() {
        return this.sinkWorkers;
    }

    public List<ExecutionNode> getExecutionNodeList() {
        return this.executionNodeList;
    }

    public ExecutionTask getExecutionTaskByTaskId(int taskId) {
        for (ExecutionNode executionNode : this.executionNodeList) {
            for (ExecutionTask executionTask : executionNode.getExecutionTasks()) {
                if (executionTask.getTaskId() != taskId) continue;
                return executionTask;
            }
        }
        throw new RuntimeException("Task " + taskId + " does not exist!");
    }

    public ExecutionNode getExecutionNodeByNodeId(int nodeId) {
        for (ExecutionNode executionNode : this.executionNodeList) {
            if (executionNode.getNodeId() != nodeId) continue;
            return executionNode;
        }
        throw new RuntimeException("Node " + nodeId + " does not exist!");
    }

    public ExecutionNode getExecutionNodeByTaskId(int taskId) {
        for (ExecutionNode executionNode : this.executionNodeList) {
            for (ExecutionTask executionTask : executionNode.getExecutionTasks()) {
                if (executionTask.getTaskId() != taskId) continue;
                return executionNode;
            }
        }
        throw new RuntimeException("Task " + taskId + " does not exist!");
    }

    public Map<Integer, RayActor<JobWorker>> getTaskId2WorkerByNodeId(int nodeId) {
        for (ExecutionNode executionNode : this.executionNodeList) {
            if (executionNode.getNodeId() != nodeId) continue;
            HashMap<Integer, RayActor<JobWorker>> taskId2Worker = new HashMap<Integer, RayActor<JobWorker>>();
            for (ExecutionTask executionTask : executionNode.getExecutionTasks()) {
                taskId2Worker.put(executionTask.getTaskId(), executionTask.getWorker());
            }
            return taskId2Worker;
        }
        throw new RuntimeException("Node " + nodeId + " does not exist!");
    }

    public long getBuildTime() {
        return this.buildTime;
    }
}

