/*
 * Decompiled with CFR 0.152.
 */
package org.ray.streaming.runtime.core.graph.executiongraph;

import com.google.common.base.MoreObjects;
import java.io.Serializable;
import org.ray.streaming.runtime.core.graph.executiongraph.ExecutionJobEdge;
import org.ray.streaming.runtime.core.graph.executiongraph.ExecutionVertex;

public class ExecutionEdge
implements Serializable {
    private final ExecutionVertex sourceVertex;
    private final ExecutionVertex targetVertex;
    private final String executionEdgeIndex;

    public ExecutionEdge(ExecutionVertex sourceVertex, ExecutionVertex targetVertex, ExecutionJobEdge executionJobEdge) {
        this.sourceVertex = sourceVertex;
        this.targetVertex = targetVertex;
        this.executionEdgeIndex = this.generateExecutionEdgeIndex();
    }

    private String generateExecutionEdgeIndex() {
        return this.sourceVertex.getVertexId() + "\u2014" + this.targetVertex.getVertexId();
    }

    public ExecutionVertex getSourceVertex() {
        return this.sourceVertex;
    }

    public ExecutionVertex getTargetVertex() {
        return this.targetVertex;
    }

    public int getSourceVertexId() {
        return this.sourceVertex.getVertexId();
    }

    public int getTargetVertexId() {
        return this.targetVertex.getVertexId();
    }

    public String getExecutionEdgeIndex() {
        return this.executionEdgeIndex;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("srcVertex", this.sourceVertex).add("targetVertex", this.targetVertex).add("executionEdgeIndex", this.executionEdgeIndex).toString();
    }
}

