/*
 * Decompiled with CFR 0.152.
 */
package org.ray.streaming.runtime.core.graph.executiongraph;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ray.api.RayActor;
import org.ray.streaming.jobgraph.JobVertex;
import org.ray.streaming.jobgraph.VertexType;
import org.ray.streaming.operator.StreamOperator;
import org.ray.streaming.runtime.core.graph.executiongraph.ExecutionJobEdge;
import org.ray.streaming.runtime.core.graph.executiongraph.ExecutionVertex;
import org.ray.streaming.runtime.worker.JobWorker;

public class ExecutionJobVertex {
    private final int jobVertexId;
    private final String jobVertexName;
    private final StreamOperator streamOperator;
    private final VertexType vertexType;
    private int parallelism;
    private List<ExecutionVertex> executionVertices;
    private List<ExecutionJobEdge> inputEdges = new ArrayList<ExecutionJobEdge>();
    private List<ExecutionJobEdge> outputEdges = new ArrayList<ExecutionJobEdge>();

    public ExecutionJobVertex(JobVertex jobVertex) {
        this.jobVertexId = jobVertex.getVertexId();
        this.jobVertexName = this.generateVertexName(this.jobVertexId, jobVertex.getStreamOperator());
        this.streamOperator = jobVertex.getStreamOperator();
        this.vertexType = jobVertex.getVertexType();
        this.parallelism = jobVertex.getParallelism();
        this.executionVertices = this.createExecutionVertics();
    }

    private String generateVertexName(int vertexId, StreamOperator streamOperator) {
        return vertexId + "-" + streamOperator.getName();
    }

    private List<ExecutionVertex> createExecutionVertics() {
        ArrayList<ExecutionVertex> executionVertices = new ArrayList<ExecutionVertex>();
        for (int index = 1; index <= this.parallelism; ++index) {
            executionVertices.add(new ExecutionVertex(this.jobVertexId, index, this));
        }
        return executionVertices;
    }

    public Map<Integer, RayActor<JobWorker>> getExecutionVertexWorkers() {
        HashMap<Integer, RayActor<JobWorker>> executionVertexWorkersMap = new HashMap<Integer, RayActor<JobWorker>>();
        Preconditions.checkArgument(this.executionVertices != null && !this.executionVertices.isEmpty(), "Empty execution vertex.");
        this.executionVertices.stream().forEach(vertex -> {
            Preconditions.checkArgument(vertex.getWorkerActor() != null, "Empty execution vertex worker actor.");
            executionVertexWorkersMap.put(vertex.getVertexId(), vertex.getWorkerActor());
        });
        return executionVertexWorkersMap;
    }

    public int getJobVertexId() {
        return this.jobVertexId;
    }

    public String getJobVertexName() {
        return this.jobVertexName;
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public List<ExecutionVertex> getExecutionVertices() {
        return this.executionVertices;
    }

    public void setExecutionVertices(List<ExecutionVertex> executionVertex) {
        this.executionVertices = executionVertex;
    }

    public List<ExecutionJobEdge> getOutputEdges() {
        return this.outputEdges;
    }

    public void setOutputEdges(List<ExecutionJobEdge> outputEdges) {
        this.outputEdges = outputEdges;
    }

    public List<ExecutionJobEdge> getInputEdges() {
        return this.inputEdges;
    }

    public void setInputEdges(List<ExecutionJobEdge> inputEdges) {
        this.inputEdges = inputEdges;
    }

    public StreamOperator getStreamOperator() {
        return this.streamOperator;
    }

    public VertexType getVertexType() {
        return this.vertexType;
    }

    public boolean isSourceVertex() {
        return this.getVertexType() == VertexType.SOURCE;
    }

    public boolean isTransformationVertex() {
        return this.getVertexType() == VertexType.TRANSFORMATION;
    }

    public boolean isSinkVertex() {
        return this.getVertexType() == VertexType.SINK;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("jobVertexId", this.jobVertexId).add("jobVertexName", this.jobVertexName).add("streamOperator", this.streamOperator).add("vertexType", (Object)this.vertexType).add("parallelism", this.parallelism).add("executionVertices", this.executionVertices).add("inputEdges", this.inputEdges).add("outputEdges", this.outputEdges).toString();
    }
}

