/*
 * Decompiled with CFR 0.152.
 */
package org.ray.streaming.runtime.transfer;

import com.google.common.base.FinalizablePhantomReference;
import com.google.common.base.FinalizableReferenceQueue;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.common.io.BaseEncoding;
import java.lang.ref.Reference;
import java.nio.ByteBuffer;
import java.util.Random;
import java.util.Set;
import sun.nio.ch.DirectBuffer;

public class ChannelID {
    public static final int ID_LENGTH = 20;
    private static final FinalizableReferenceQueue REFERENCE_QUEUE = new FinalizableReferenceQueue();
    private static final Set<Reference<?>> references = Sets.newConcurrentHashSet();
    private final byte[] bytes;
    private final String strId;
    private final ByteBuffer buffer;
    private final long address;
    private final long nativeIdPtr;

    private ChannelID(String strId, byte[] idBytes) {
        this.strId = strId;
        this.bytes = idBytes;
        ByteBuffer directBuffer = ByteBuffer.allocateDirect(20);
        directBuffer.put(this.bytes);
        directBuffer.rewind();
        this.buffer = directBuffer;
        this.address = ((DirectBuffer)((Object)this.buffer)).address();
        long nativeIdPtr = 0L;
        this.nativeIdPtr = nativeIdPtr = ChannelID.createNativeID(this.address);
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public long getAddress() {
        return this.address;
    }

    public long getNativeIdPtr() {
        if (this.nativeIdPtr == 0L) {
            throw new IllegalStateException("native ID not available");
        }
        return this.nativeIdPtr;
    }

    public String toString() {
        return this.strId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChannelID that = (ChannelID)o;
        return this.strId.equals(that.strId);
    }

    public int hashCode() {
        return this.strId.hashCode();
    }

    private static native long createNativeID(long var0);

    private static native void destroyNativeID(long var0);

    public static ChannelID from(String id) {
        return ChannelID.from(id, ChannelID.idStrToBytes(id));
    }

    public static ChannelID from(byte[] idBytes) {
        return ChannelID.from(ChannelID.idBytesToStr(idBytes), idBytes);
    }

    private static ChannelID from(String strID, byte[] idBytes) {
        ChannelID id = new ChannelID(strID, idBytes);
        final long nativeIdPtr = id.nativeIdPtr;
        if (nativeIdPtr != 0L) {
            FinalizablePhantomReference<ChannelID> reference = new FinalizablePhantomReference<ChannelID>(id, REFERENCE_QUEUE){

                @Override
                public void finalizeReferent() {
                    ChannelID.destroyNativeID(nativeIdPtr);
                    references.remove(this);
                }
            };
            references.add(reference);
        }
        return id;
    }

    public static String genRandomIdStr() {
        StringBuilder sb = new StringBuilder();
        Random random = new Random();
        for (int i = 0; i < 40; ++i) {
            sb.append((char)(random.nextInt(6) + 65));
        }
        return sb.toString();
    }

    public static String genIdStr(int fromTaskId, int toTaskId, long ts) {
        Preconditions.checkArgument(fromTaskId < Short.MAX_VALUE, "fromTaskId %d is larger than %d", fromTaskId, Short.MAX_VALUE);
        Preconditions.checkArgument(toTaskId < Short.MAX_VALUE, "toTaskId %d is larger than %d", fromTaskId, Short.MAX_VALUE);
        byte[] channelName = new byte[20];
        for (int i = 11; i >= 8; --i) {
            channelName[i] = (byte)(ts & 0xFFL);
            ts >>= 8;
        }
        channelName[16] = (byte)((fromTaskId & 0xFFFF) >> 8);
        channelName[17] = (byte)(fromTaskId & 0xFF);
        channelName[18] = (byte)((toTaskId & 0xFFFF) >> 8);
        channelName[19] = (byte)(toTaskId & 0xFF);
        return ChannelID.idBytesToStr(channelName);
    }

    static byte[] idStrToBytes(String id) {
        byte[] idBytes = BaseEncoding.base16().decode(id.toUpperCase());
        assert (idBytes.length == 20);
        return idBytes;
    }

    static String idBytesToStr(byte[] id) {
        assert (id.length == 20);
        return BaseEncoding.base16().encode(id).toLowerCase();
    }
}

