# Copyright 2024 The KServe Authors.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# generated by datamodel-codegen:
#   filename:  openapi-2.0.0.yaml
#   timestamp: 2024-04-22T00:56:49+00:00

from __future__ import annotations

from typing import Any, Dict, List, Optional, Union

from pydantic import (
    AnyUrl,
    BaseModel,
    ConfigDict,
    Field,
    PositiveFloat,
    RootModel,
    confloat,
    conint,
    constr,
)
from typing_extensions import Literal


class Error(BaseModel):
    code: Optional[str] = Field(...)
    message: str
    param: Optional[str] = Field(...)
    type: str


class ErrorResponse(BaseModel):
    error: Error


class DeleteModelResponse(BaseModel):
    id: str
    deleted: bool
    object: str


class CreateCompletionRequest(BaseModel):
    model: Union[
        str, Literal["gpt-3.5-turbo-instruct", "davinci-002", "babbage-002"]
    ] = Field(
        ...,
        description="ID of the model to use. You can use the [List models](/docs/api-reference/models/list) API to see all of your available models, or see our [Model overview](/docs/models/overview) for descriptions of them.\n",
    )
    prompt: Optional[Union[Optional[str], List[str], List[int], List[List[Any]]]] = (
        Field(
            ...,
            description="The prompt(s) to generate completions for, encoded as a string, array of strings, array of tokens, or array of token arrays.\n\nNote that <|endoftext|> is the document separator that the model sees during training, so if a prompt is not specified the model will generate as if from the beginning of a new document.\n",
        )
    )
    best_of: Optional[conint(ge=0, le=20)] = Field(
        1,
        description='Generates `best_of` completions server-side and returns the "best" (the one with the highest log probability per token). Results cannot be streamed.\n\nWhen used with `n`, `best_of` controls the number of candidate completions and `n` specifies how many to return – `best_of` must be greater than `n`.\n\n**Note:** Because this parameter generates many completions, it can quickly consume your token quota. Use carefully and ensure that you have reasonable settings for `max_tokens` and `stop`.\n',
    )
    echo: Optional[bool] = Field(
        False, description="Echo back the prompt in addition to the completion\n"
    )
    frequency_penalty: Optional[confloat(ge=-2.0, le=2.0)] = Field(
        0,
        description="Number between -2.0 and 2.0. Positive values penalize new tokens based on their existing frequency in the text so far, decreasing the model's likelihood to repeat the same line verbatim.\n\n[See more information about frequency and presence penalties.](/docs/guides/text-generation/parameter-details)\n",
    )
    logit_bias: Optional[Dict[str, int]] = Field(
        None,
        description='Modify the likelihood of specified tokens appearing in the completion.\n\nAccepts a JSON object that maps tokens (specified by their token ID in the GPT tokenizer) to an associated bias value from -100 to 100. You can use this [tokenizer tool](/tokenizer?view=bpe) to convert text to token IDs. Mathematically, the bias is added to the logits generated by the model prior to sampling. The exact effect will vary per model, but values between -1 and 1 should decrease or increase likelihood of selection; values like -100 or 100 should result in a ban or exclusive selection of the relevant token.\n\nAs an example, you can pass `{"50256": -100}` to prevent the <|endoftext|> token from being generated.\n',
    )
    logprobs: Optional[conint(ge=0, le=5)] = Field(
        None,
        description="Include the log probabilities on the `logprobs` most likely output tokens, as well the chosen tokens. For example, if `logprobs` is 5, the API will return a list of the 5 most likely tokens. The API will always return the `logprob` of the sampled token, so there may be up to `logprobs+1` elements in the response.\n\nThe maximum value for `logprobs` is 5.\n",
    )
    max_tokens: Optional[conint(ge=0)] = Field(
        16,
        description="The maximum number of [tokens](/tokenizer) that can be generated in the completion.\n\nThe token count of your prompt plus `max_tokens` cannot exceed the model's context length. [Example Python code](https://cookbook.openai.com/examples/how_to_count_tokens_with_tiktoken) for counting tokens.\n",
        examples=[16],
    )
    n: Optional[conint(ge=1, le=128)] = Field(
        1,
        description="How many completions to generate for each prompt.\n\n**Note:** Because this parameter generates many completions, it can quickly consume your token quota. Use carefully and ensure that you have reasonable settings for `max_tokens` and `stop`.\n",
        examples=[1],
    )
    presence_penalty: Optional[confloat(ge=-2.0, le=2.0)] = Field(
        0,
        description="Number between -2.0 and 2.0. Positive values penalize new tokens based on whether they appear in the text so far, increasing the model's likelihood to talk about new topics.\n\n[See more information about frequency and presence penalties.](/docs/guides/text-generation/parameter-details)\n",
    )
    seed: Optional[conint(ge=-9223372036854775808, le=9223372036854775807)] = Field(
        None,
        description="If specified, our system will make a best effort to sample deterministically, such that repeated requests with the same `seed` and parameters should return the same result.\n\nDeterminism is not guaranteed, and you should refer to the `system_fingerprint` response parameter to monitor changes in the backend.\n",
    )
    stop: Optional[Union[Optional[str], List[str]]] = Field(
        None,
        description="Up to 4 sequences where the API will stop generating further tokens. The returned text will not contain the stop sequence.\n",
    )
    stream: Optional[bool] = Field(
        False,
        description="Whether to stream back partial progress. If set, tokens will be sent as data-only [server-sent events](https://developer.mozilla.org/en-US/docs/Web/API/Server-sent_events/Using_server-sent_events#Event_stream_format) as they become available, with the stream terminated by a `data: [DONE]` message. [Example Python code](https://cookbook.openai.com/examples/how_to_stream_completions).\n",
    )
    suffix: Optional[str] = Field(
        None,
        description="The suffix that comes after a completion of inserted text.\n\nThis parameter is only supported for `gpt-3.5-turbo-instruct`.\n",
        examples=["test."],
    )
    temperature: Optional[confloat(ge=0.0, le=2.0)] = Field(
        1,
        description="What sampling temperature to use, between 0 and 2. Higher values like 0.8 will make the output more random, while lower values like 0.2 will make it more focused and deterministic.\n\nWe generally recommend altering this or `top_p` but not both.\n",
        examples=[1],
    )
    top_p: Optional[confloat(ge=0.0, le=1.0)] = Field(
        1,
        description="An alternative to sampling with temperature, called nucleus sampling, where the model considers the results of the tokens with top_p probability mass. So 0.1 means only the tokens comprising the top 10% probability mass are considered.\n\nWe generally recommend altering this or `temperature` but not both.\n",
        examples=[1],
    )
    user: Optional[str] = Field(
        None,
        description="A unique identifier representing your end-user, which can help OpenAI to monitor and detect abuse. [Learn more](/docs/guides/safety-best-practices/end-user-ids).\n",
        examples=["user-1234"],
    )


class Logprobs(BaseModel):
    text_offset: Optional[List[int]] = None
    token_logprobs: Optional[List[float]] = None
    tokens: Optional[List[str]] = None
    top_logprobs: Optional[List[Dict[str, float]]] = None


class Choice(BaseModel):
    finish_reason: Optional[Literal["stop", "length", "content_filter"]] = Field(
        ...,
        description="The reason the model stopped generating tokens. This will be `stop` if the model hit a natural stop point or a provided stop sequence,\n`length` if the maximum number of tokens specified in the request was reached,\nor `content_filter` if content was omitted due to a flag from our content filters.\n",
    )
    index: int
    logprobs: Optional[Logprobs] = Field(...)
    text: str


class ImageUrl(BaseModel):
    url: AnyUrl = Field(
        ..., description="Either a URL of the image or the base64 encoded image data."
    )
    detail: Literal["auto", "low", "high"] = Field(
        "auto",
        description="Specifies the detail level of the image. Learn more in the [Vision guide](/docs/guides/vision/low-or-high-fidelity-image-understanding).",
    )


class ChatCompletionRequestMessageContentPartImage(BaseModel):
    type: Literal["image_url"] = Field(..., description="The type of the content part.")
    image_url: ImageUrl


class ChatCompletionRequestMessageContentPartText(BaseModel):
    type: Literal["text"] = Field(..., description="The type of the content part.")
    text: str = Field(..., description="The text content.")


class ChatCompletionRequestSystemMessage(BaseModel):
    content: str = Field(..., description="The contents of the system message.")
    role: Literal["system"] = Field(
        ..., description="The role of the messages author, in this case `system`."
    )
    name: Optional[str] = Field(
        None,
        description="An optional name for the participant. Provides the model information to differentiate between participants of the same role.",
    )


class FunctionCall(BaseModel):
    arguments: str = Field(
        ...,
        description="The arguments to call the function with, as generated by the model in JSON format. Note that the model does not always generate valid JSON, and may hallucinate parameters not defined by your function schema. Validate the arguments in your code before calling your function.",
    )
    name: str = Field(..., description="The name of the function to call.")


class ChatCompletionRequestToolMessage(BaseModel):
    role: Literal["tool"] = Field(
        ..., description="The role of the messages author, in this case `tool`."
    )
    content: str = Field(..., description="The contents of the tool message.")
    tool_call_id: str = Field(
        ..., description="Tool call that this message is responding to."
    )


class ChatCompletionRequestFunctionMessage(BaseModel):
    role: Literal["function"] = Field(
        ..., description="The role of the messages author, in this case `function`."
    )
    content: Optional[str] = Field(
        ..., description="The contents of the function message."
    )
    name: str = Field(..., description="The name of the function to call.")


class FunctionParameters(BaseModel):
    pass
    model_config = ConfigDict(
        extra="allow",
    )


class ChatCompletionFunctions(BaseModel):
    description: Optional[str] = Field(
        None,
        description="A description of what the function does, used by the model to choose when and how to call the function.",
    )
    name: str = Field(
        ...,
        description="The name of the function to be called. Must be a-z, A-Z, 0-9, or contain underscores and dashes, with a maximum length of 64.",
    )
    parameters: Optional[FunctionParameters] = None


class ChatCompletionFunctionCallOption(BaseModel):
    name: str = Field(..., description="The name of the function to call.")


class FunctionObject(BaseModel):
    description: Optional[str] = Field(
        None,
        description="A description of what the function does, used by the model to choose when and how to call the function.",
    )
    name: str = Field(
        ...,
        description="The name of the function to be called. Must be a-z, A-Z, 0-9, or contain underscores and dashes, with a maximum length of 64.",
    )
    parameters: Optional[FunctionParameters] = None


class Function(BaseModel):
    name: str = Field(..., description="The name of the function to call.")


class ChatCompletionNamedToolChoice(BaseModel):
    type: Literal["function"] = Field(
        ...,
        description="The type of the tool. Currently, only `function` is supported.",
    )
    function: Function


class Function1(BaseModel):
    name: str = Field(..., description="The name of the function to call.")
    arguments: str = Field(
        ...,
        description="The arguments to call the function with, as generated by the model in JSON format. Note that the model does not always generate valid JSON, and may hallucinate parameters not defined by your function schema. Validate the arguments in your code before calling your function.",
    )


class ChatCompletionMessageToolCall(BaseModel):
    id: str = Field(..., description="The ID of the tool call.")
    type: Literal["function"] = Field(
        ...,
        description="The type of the tool. Currently, only `function` is supported.",
    )
    function: Function1 = Field(..., description="The function that the model called.")


class Function2(BaseModel):
    name: Optional[str] = Field(None, description="The name of the function to call.")
    arguments: Optional[str] = Field(
        None,
        description="The arguments to call the function with, as generated by the model in JSON format. Note that the model does not always generate valid JSON, and may hallucinate parameters not defined by your function schema. Validate the arguments in your code before calling your function.",
    )


class ChatCompletionMessageToolCallChunk(BaseModel):
    index: int
    id: Optional[str] = Field(None, description="The ID of the tool call.")
    type: Optional[Literal["function"]] = Field(
        None,
        description="The type of the tool. Currently, only `function` is supported.",
    )
    function: Optional[Function2] = None


class ChatCompletionRole(
    RootModel[Literal["system", "user", "assistant", "tool", "function"]]
):
    root: Literal["system", "user", "assistant", "tool", "function"] = Field(
        ..., description="The role of the author of a message"
    )


class FunctionCall2(BaseModel):
    arguments: Optional[str] = Field(
        None,
        description="The arguments to call the function with, as generated by the model in JSON format. Note that the model does not always generate valid JSON, and may hallucinate parameters not defined by your function schema. Validate the arguments in your code before calling your function.",
    )
    name: Optional[str] = Field(None, description="The name of the function to call.")


class ChatCompletionStreamResponseDelta(BaseModel):
    content: Optional[str] = Field(
        None, description="The contents of the chunk message."
    )
    function_call: Optional[FunctionCall2] = Field(
        None,
        description="Deprecated and replaced by `tool_calls`. The name and arguments of a function that should be called, as generated by the model.",
    )
    tool_calls: Optional[List[ChatCompletionMessageToolCallChunk]] = None
    role: Optional[Literal["system", "user", "assistant", "tool"]] = Field(
        None, description="The role of the author of this message."
    )


class ResponseFormat(BaseModel):
    type: Literal["text", "json_object"] = Field(
        "text",
        description="Must be one of `text` or `json_object`.",
        examples=["json_object"],
    )


class TopLogprob(BaseModel):
    token: str = Field(..., description="The token.")
    logprob: float = Field(
        ...,
        description="The log probability of this token, if it is within the top 20 most likely tokens. Otherwise, the value `-9999.0` is used to signify that the token is very unlikely.",
    )
    bytes: Optional[List[int]] = Field(
        ...,
        description="A list of integers representing the UTF-8 bytes representation of the token. Useful in instances where characters are represented by multiple tokens and their byte representations must be combined to generate the correct text representation. Can be `null` if there is no bytes representation for the token.",
    )


class ChatCompletionTokenLogprob(BaseModel):
    token: str = Field(..., description="The token.")
    logprob: float = Field(
        ...,
        description="The log probability of this token, if it is within the top 20 most likely tokens. Otherwise, the value `-9999.0` is used to signify that the token is very unlikely.",
    )
    bytes: Optional[List[int]] = Field(
        ...,
        description="A list of integers representing the UTF-8 bytes representation of the token. Useful in instances where characters are represented by multiple tokens and their byte representations must be combined to generate the correct text representation. Can be `null` if there is no bytes representation for the token.",
    )
    top_logprobs: List[TopLogprob] = Field(
        ...,
        description="List of the most likely tokens and their log probability, at this token position. In rare cases, there may be fewer than the number of requested `top_logprobs` returned.",
    )


class Logprobs2(BaseModel):
    content: Optional[List[ChatCompletionTokenLogprob]] = Field(
        ...,
        description="A list of message content tokens with log probability information.",
    )


class Choice3(BaseModel):
    delta: ChatCompletionStreamResponseDelta
    logprobs: Optional[Logprobs2] = Field(
        None, description="Log probability information for the choice."
    )
    finish_reason: Optional[
        Literal["stop", "length", "tool_calls", "content_filter", "function_call"]
    ] = Field(
        ...,
        description="The reason the model stopped generating tokens. This will be `stop` if the model hit a natural stop point or a provided stop sequence,\n`length` if the maximum number of tokens specified in the request was reached,\n`content_filter` if content was omitted due to a flag from our content filters,\n`tool_calls` if the model called a tool, or `function_call` (deprecated) if the model called a function.\n",
    )
    index: int = Field(
        ..., description="The index of the choice in the list of choices."
    )


class CreateChatCompletionStreamResponse(BaseModel):
    id: str = Field(
        ...,
        description="A unique identifier for the chat completion. Each chunk has the same ID.",
    )
    choices: List[Choice3] = Field(
        ...,
        description="A list of chat completion choices. Can be more than one if `n` is greater than 1.",
    )
    created: int = Field(
        ...,
        description="The Unix timestamp (in seconds) of when the chat completion was created. Each chunk has the same timestamp.",
    )
    model: str = Field(..., description="The model to generate the completion.")
    system_fingerprint: Optional[str] = Field(
        None,
        description="This fingerprint represents the backend configuration that the model runs with.\nCan be used in conjunction with the `seed` request parameter to understand when backend changes have been made that might impact determinism.\n",
    )
    object: Literal["chat.completion.chunk"] = Field(
        ..., description="The object type, which is always `chat.completion.chunk`."
    )


class CreateChatCompletionImageResponse(BaseModel):
    pass


class CreateImageRequest(BaseModel):
    prompt: str = Field(
        ...,
        description="A text description of the desired image(s). The maximum length is 1000 characters for `dall-e-2` and 4000 characters for `dall-e-3`.",
        examples=["A cute baby sea otter"],
    )
    model: Optional[Union[Optional[str], Literal["dall-e-2", "dall-e-3"]]] = Field(
        "dall-e-2",
        description="The model to use for image generation.",
        examples=["dall-e-3"],
    )
    n: Optional[conint(ge=1, le=10)] = Field(
        1,
        description="The number of images to generate. Must be between 1 and 10. For `dall-e-3`, only `n=1` is supported.",
        examples=[1],
    )
    quality: Literal["standard", "hd"] = Field(
        "standard",
        description="The quality of the image that will be generated. `hd` creates images with finer details and greater consistency across the image. This param is only supported for `dall-e-3`.",
        examples=["standard"],
    )
    response_format: Optional[Literal["url", "b64_json"]] = Field(
        "url",
        description="The format in which the generated images are returned. Must be one of `url` or `b64_json`. URLs are only valid for 60 minutes after the image has been generated.",
        examples=["url"],
    )
    size: Optional[
        Literal["256x256", "512x512", "1024x1024", "1792x1024", "1024x1792"]
    ] = Field(
        "1024x1024",
        description="The size of the generated images. Must be one of `256x256`, `512x512`, or `1024x1024` for `dall-e-2`. Must be one of `1024x1024`, `1792x1024`, or `1024x1792` for `dall-e-3` models.",
        examples=["1024x1024"],
    )
    style: Optional[Literal["vivid", "natural"]] = Field(
        "vivid",
        description="The style of the generated images. Must be one of `vivid` or `natural`. Vivid causes the model to lean towards generating hyper-real and dramatic images. Natural causes the model to produce more natural, less hyper-real looking images. This param is only supported for `dall-e-3`.",
        examples=["vivid"],
    )
    user: Optional[str] = Field(
        None,
        description="A unique identifier representing your end-user, which can help OpenAI to monitor and detect abuse. [Learn more](/docs/guides/safety-best-practices/end-user-ids).\n",
        examples=["user-1234"],
    )


class Image(BaseModel):
    b64_json: Optional[str] = Field(
        None,
        description="The base64-encoded JSON of the generated image, if `response_format` is `b64_json`.",
    )
    url: Optional[str] = Field(
        None,
        description="The URL of the generated image, if `response_format` is `url` (default).",
    )
    revised_prompt: Optional[str] = Field(
        None,
        description="The prompt that was used to generate the image, if there was any revision to the prompt.",
    )


class CreateImageEditRequest(BaseModel):
    image: bytes = Field(
        ...,
        description="The image to edit. Must be a valid PNG file, less than 4MB, and square. If mask is not provided, image must have transparency, which will be used as the mask.",
    )
    prompt: str = Field(
        ...,
        description="A text description of the desired image(s). The maximum length is 1000 characters.",
        examples=["A cute baby sea otter wearing a beret"],
    )
    mask: Optional[bytes] = Field(
        None,
        description="An additional image whose fully transparent areas (e.g. where alpha is zero) indicate where `image` should be edited. Must be a valid PNG file, less than 4MB, and have the same dimensions as `image`.",
    )
    model: Optional[Union[Optional[str], Literal["dall-e-2"]]] = Field(
        "dall-e-2",
        description="The model to use for image generation. Only `dall-e-2` is supported at this time.",
        examples=["dall-e-2"],
    )
    n: Optional[conint(ge=1, le=10)] = Field(
        1,
        description="The number of images to generate. Must be between 1 and 10.",
        examples=[1],
    )
    size: Optional[Literal["256x256", "512x512", "1024x1024"]] = Field(
        "1024x1024",
        description="The size of the generated images. Must be one of `256x256`, `512x512`, or `1024x1024`.",
        examples=["1024x1024"],
    )
    response_format: Optional[Literal["url", "b64_json"]] = Field(
        "url",
        description="The format in which the generated images are returned. Must be one of `url` or `b64_json`. URLs are only valid for 60 minutes after the image has been generated.",
        examples=["url"],
    )
    user: Optional[str] = Field(
        None,
        description="A unique identifier representing your end-user, which can help OpenAI to monitor and detect abuse. [Learn more](/docs/guides/safety-best-practices/end-user-ids).\n",
        examples=["user-1234"],
    )


class CreateImageVariationRequest(BaseModel):
    image: bytes = Field(
        ...,
        description="The image to use as the basis for the variation(s). Must be a valid PNG file, less than 4MB, and square.",
    )
    model: Optional[Union[Optional[str], Literal["dall-e-2"]]] = Field(
        "dall-e-2",
        description="The model to use for image generation. Only `dall-e-2` is supported at this time.",
        examples=["dall-e-2"],
    )
    n: Optional[conint(ge=1, le=10)] = Field(
        1,
        description="The number of images to generate. Must be between 1 and 10. For `dall-e-3`, only `n=1` is supported.",
        examples=[1],
    )
    response_format: Optional[Literal["url", "b64_json"]] = Field(
        "url",
        description="The format in which the generated images are returned. Must be one of `url` or `b64_json`. URLs are only valid for 60 minutes after the image has been generated.",
        examples=["url"],
    )
    size: Optional[Literal["256x256", "512x512", "1024x1024"]] = Field(
        "1024x1024",
        description="The size of the generated images. Must be one of `256x256`, `512x512`, or `1024x1024`.",
        examples=["1024x1024"],
    )
    user: Optional[str] = Field(
        None,
        description="A unique identifier representing your end-user, which can help OpenAI to monitor and detect abuse. [Learn more](/docs/guides/safety-best-practices/end-user-ids).\n",
        examples=["user-1234"],
    )


class CreateModerationRequest(BaseModel):
    input: Union[str, List[str]] = Field(..., description="The input text to classify")
    model: Union[str, Literal["text-moderation-latest", "text-moderation-stable"]] = (
        Field(
            "text-moderation-latest",
            description="Two content moderations models are available: `text-moderation-stable` and `text-moderation-latest`.\n\nThe default is `text-moderation-latest` which will be automatically upgraded over time. This ensures you are always using our most accurate model. If you use `text-moderation-stable`, we will provide advanced notice before updating the model. Accuracy of `text-moderation-stable` may be slightly lower than for `text-moderation-latest`.\n",
            examples=["text-moderation-stable"],
        )
    )


class Categories(BaseModel):
    hate: bool = Field(
        ...,
        description="Content that expresses, incites, or promotes hate based on race, gender, ethnicity, religion, nationality, sexual orientation, disability status, or caste. Hateful content aimed at non-protected groups (e.g., chess players) is harassment.",
    )
    hate_threatening: bool = Field(
        ...,
        alias="hate/threatening",
        description="Hateful content that also includes violence or serious harm towards the targeted group based on race, gender, ethnicity, religion, nationality, sexual orientation, disability status, or caste.",
    )
    harassment: bool = Field(
        ...,
        description="Content that expresses, incites, or promotes harassing language towards any target.",
    )
    harassment_threatening: bool = Field(
        ...,
        alias="harassment/threatening",
        description="Harassment content that also includes violence or serious harm towards any target.",
    )
    self_harm: bool = Field(
        ...,
        alias="self-harm",
        description="Content that promotes, encourages, or depicts acts of self-harm, such as suicide, cutting, and eating disorders.",
    )
    self_harm_intent: bool = Field(
        ...,
        alias="self-harm/intent",
        description="Content where the speaker expresses that they are engaging or intend to engage in acts of self-harm, such as suicide, cutting, and eating disorders.",
    )
    self_harm_instructions: bool = Field(
        ...,
        alias="self-harm/instructions",
        description="Content that encourages performing acts of self-harm, such as suicide, cutting, and eating disorders, or that gives instructions or advice on how to commit such acts.",
    )
    sexual: bool = Field(
        ...,
        description="Content meant to arouse sexual excitement, such as the description of sexual activity, or that promotes sexual services (excluding sex education and wellness).",
    )
    sexual_minors: bool = Field(
        ...,
        alias="sexual/minors",
        description="Sexual content that includes an individual who is under 18 years old.",
    )
    violence: bool = Field(
        ..., description="Content that depicts death, violence, or physical injury."
    )
    violence_graphic: bool = Field(
        ...,
        alias="violence/graphic",
        description="Content that depicts death, violence, or physical injury in graphic detail.",
    )


class CategoryScores(BaseModel):
    hate: float = Field(..., description="The score for the category 'hate'.")
    hate_threatening: float = Field(
        ...,
        alias="hate/threatening",
        description="The score for the category 'hate/threatening'.",
    )
    harassment: float = Field(
        ..., description="The score for the category 'harassment'."
    )
    harassment_threatening: float = Field(
        ...,
        alias="harassment/threatening",
        description="The score for the category 'harassment/threatening'.",
    )
    self_harm: float = Field(
        ..., alias="self-harm", description="The score for the category 'self-harm'."
    )
    self_harm_intent: float = Field(
        ...,
        alias="self-harm/intent",
        description="The score for the category 'self-harm/intent'.",
    )
    self_harm_instructions: float = Field(
        ...,
        alias="self-harm/instructions",
        description="The score for the category 'self-harm/instructions'.",
    )
    sexual: float = Field(..., description="The score for the category 'sexual'.")
    sexual_minors: float = Field(
        ...,
        alias="sexual/minors",
        description="The score for the category 'sexual/minors'.",
    )
    violence: float = Field(..., description="The score for the category 'violence'.")
    violence_graphic: float = Field(
        ...,
        alias="violence/graphic",
        description="The score for the category 'violence/graphic'.",
    )


class Result(BaseModel):
    flagged: bool = Field(
        ..., description="Whether any of the below categories are flagged."
    )
    categories: Categories = Field(
        ...,
        description="A list of the categories, and whether they are flagged or not.",
    )
    category_scores: CategoryScores = Field(
        ...,
        description="A list of the categories along with their scores as predicted by model.",
    )


class CreateModerationResponse(BaseModel):
    id: str = Field(
        ..., description="The unique identifier for the moderation request."
    )
    model: str = Field(
        ..., description="The model used to generate the moderation results."
    )
    results: List[Result] = Field(..., description="A list of moderation objects.")


class CreateFileRequest(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    file: bytes = Field(
        ..., description="The File object (not file name) to be uploaded.\n"
    )
    purpose: Literal["fine-tune", "assistants"] = Field(
        ...,
        description='The intended purpose of the uploaded file.\n\nUse "fine-tune" for [Fine-tuning](/docs/api-reference/fine-tuning) and "assistants" for [Assistants](/docs/api-reference/assistants) and [Messages](/docs/api-reference/messages). This allows us to validate the format of the uploaded file is correct for fine-tuning.\n',
    )


class DeleteFileResponse(BaseModel):
    id: str
    object: Literal["file"]
    deleted: bool


class Hyperparameters(BaseModel):
    batch_size: Union[Literal["auto"], conint(ge=1, le=256)] = Field(
        "auto",
        description="Number of examples in each batch. A larger batch size means that model parameters\nare updated less frequently, but with lower variance.\n",
    )
    learning_rate_multiplier: Union[Literal["auto"], PositiveFloat] = Field(
        "auto",
        description="Scaling factor for the learning rate. A smaller learning rate may be useful to avoid\noverfitting.\n",
    )
    n_epochs: Union[Literal["auto"], conint(ge=1, le=50)] = Field(
        "auto",
        description="The number of epochs to train the model for. An epoch refers to one full cycle\nthrough the training dataset.\n",
    )


class Wandb(BaseModel):
    project: str = Field(
        ...,
        description="The name of the project that the new run will be created under.\n",
        examples=["my-wandb-project"],
    )
    name: Optional[str] = Field(
        None,
        description="A display name to set for the run. If not set, we will use the Job ID as the name.\n",
    )
    entity: Optional[str] = Field(
        None,
        description="The entity to use for the run. This allows you to set the team or username of the WandB user that you would\nlike associated with the run. If not set, the default entity for the registered WandB API key is used.\n",
    )
    tags: Optional[List[str]] = Field(
        None,
        description='A list of tags to be attached to the newly created run. These tags are passed through directly to WandB. Some\ndefault tags are generated by OpenAI: "openai/finetune", "openai/{base-model}", "openai/{ftjob-abcdef}".\n',
    )


class Integration(BaseModel):
    type: Literal["wandb"] = Field(
        ...,
        description='The type of integration to enable. Currently, only "wandb" (Weights and Biases) is supported.\n',
    )
    wandb: Wandb = Field(
        ...,
        description="The settings for your integration with Weights and Biases. This payload specifies the project that\nmetrics will be sent to. Optionally, you can set an explicit display name for your run, add tags\nto your run, and set a default entity (team, username, etc) to be associated with your run.\n",
    )


class CreateFineTuningJobRequest(BaseModel):
    model: Union[str, Literal["babbage-002", "davinci-002", "gpt-3.5-turbo"]] = Field(
        ...,
        description="The name of the model to fine-tune. You can select one of the\n[supported models](/docs/guides/fine-tuning/what-models-can-be-fine-tuned).\n",
        examples=["gpt-3.5-turbo"],
    )
    training_file: str = Field(
        ...,
        description="The ID of an uploaded file that contains training data.\n\nSee [upload file](/docs/api-reference/files/upload) for how to upload a file.\n\nYour dataset must be formatted as a JSONL file. Additionally, you must upload your file with the purpose `fine-tune`.\n\nSee the [fine-tuning guide](/docs/guides/fine-tuning) for more details.\n",
        examples=["file-abc123"],
    )
    hyperparameters: Optional[Hyperparameters] = Field(
        None, description="The hyperparameters used for the fine-tuning job."
    )
    suffix: Optional[constr(min_length=1, max_length=40)] = Field(
        None,
        description='A string of up to 18 characters that will be added to your fine-tuned model name.\n\nFor example, a `suffix` of "custom-model-name" would produce a model name like `ft:gpt-3.5-turbo:openai:custom-model-name:7p4lURel`.\n',
    )
    validation_file: Optional[str] = Field(
        None,
        description="The ID of an uploaded file that contains validation data.\n\nIf you provide this file, the data is used to generate validation\nmetrics periodically during fine-tuning. These metrics can be viewed in\nthe fine-tuning results file.\nThe same data should not be present in both train and validation files.\n\nYour dataset must be formatted as a JSONL file. You must upload your file with the purpose `fine-tune`.\n\nSee the [fine-tuning guide](/docs/guides/fine-tuning) for more details.\n",
        examples=["file-abc123"],
    )
    integrations: Optional[List[Integration]] = Field(
        None, description="A list of integrations to enable for your fine-tuning job."
    )
    seed: Optional[conint(ge=0, le=2147483647)] = Field(
        None,
        description="The seed controls the reproducibility of the job. Passing in the same seed and job parameters should produce the same results, but may differ in rare cases.\nIf a seed is not specified, one will be generated for you.\n",
        examples=[42],
    )


class CreateEmbeddingRequest(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    input: Union[str, List[str], List[int], List[List[Any]]] = Field(
        ...,
        description="Input text to embed, encoded as a string or array of tokens. To embed multiple inputs in a single request, pass an array of strings or array of token arrays. The input must not exceed the max input tokens for the model (8192 tokens for `text-embedding-ada-002`), cannot be an empty string, and any array must be 2048 dimensions or less. [Example Python code](https://cookbook.openai.com/examples/how_to_count_tokens_with_tiktoken) for counting tokens.\n",
        examples=["The quick brown fox jumped over the lazy dog"],
    )
    model: Union[
        str,
        Literal[
            "text-embedding-ada-002", "text-embedding-3-small", "text-embedding-3-large"
        ],
    ] = Field(
        ...,
        description="ID of the model to use. You can use the [List models](/docs/api-reference/models/list) API to see all of your available models, or see our [Model overview](/docs/models/overview) for descriptions of them.\n",
        examples=["text-embedding-3-small"],
    )
    encoding_format: Literal["float", "base64"] = Field(
        "float",
        description="The format to return the embeddings in. Can be either `float` or [`base64`](https://pypi.org/project/pybase64/).",
        examples=["float"],
    )
    dimensions: Optional[conint(ge=1)] = Field(
        None,
        description="The number of dimensions the resulting output embeddings should have. Only supported in `text-embedding-3` and later models.\n",
    )
    user: Optional[str] = Field(
        None,
        description="A unique identifier representing your end-user, which can help OpenAI to monitor and detect abuse. [Learn more](/docs/guides/safety-best-practices/end-user-ids).\n",
        examples=["user-1234"],
    )


class Usage(BaseModel):
    prompt_tokens: int = Field(
        ..., description="The number of tokens used by the prompt."
    )
    total_tokens: int = Field(
        ..., description="The total number of tokens used by the request."
    )


class CreateTranscriptionRequest(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    file: bytes = Field(
        ...,
        description="The audio file object (not file name) to transcribe, in one of these formats: flac, mp3, mp4, mpeg, mpga, m4a, ogg, wav, or webm.\n",
    )
    model: Union[str, Literal["whisper-1"]] = Field(
        ...,
        description="ID of the model to use. Only `whisper-1` (which is powered by our open source Whisper V2 model) is currently available.\n",
        examples=["whisper-1"],
    )
    language: Optional[str] = Field(
        None,
        description="The language of the input audio. Supplying the input language in [ISO-639-1](https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes) format will improve accuracy and latency.\n",
    )
    prompt: Optional[str] = Field(
        None,
        description="An optional text to guide the model's style or continue a previous audio segment. The [prompt](/docs/guides/speech-to-text/prompting) should match the audio language.\n",
    )
    response_format: Literal["json", "text", "srt", "verbose_json", "vtt"] = Field(
        "json",
        description="The format of the transcript output, in one of these options: `json`, `text`, `srt`, `verbose_json`, or `vtt`.\n",
    )
    temperature: float = Field(
        0,
        description="The sampling temperature, between 0 and 1. Higher values like 0.8 will make the output more random, while lower values like 0.2 will make it more focused and deterministic. If set to 0, the model will use [log probability](https://en.wikipedia.org/wiki/Log_probability) to automatically increase the temperature until certain thresholds are hit.\n",
    )
    timestamp_granularities__: List[Literal["word", "segment"]] = Field(
        ["segment"],
        alias="timestamp_granularities[]",
        description="The timestamp granularities to populate for this transcription. `response_format` must be set `verbose_json` to use timestamp granularities. Either or both of these options are supported: `word`, or `segment`. Note: There is no additional latency for segment timestamps, but generating word timestamps incurs additional latency.\n",
    )


class CreateTranscriptionResponseJson(BaseModel):
    text: str = Field(..., description="The transcribed text.")


class TranscriptionSegment(BaseModel):
    id: int = Field(..., description="Unique identifier of the segment.")
    seek: int = Field(..., description="Seek offset of the segment.")
    start: float = Field(..., description="Start time of the segment in seconds.")
    end: float = Field(..., description="End time of the segment in seconds.")
    text: str = Field(..., description="Text content of the segment.")
    tokens: List[int] = Field(
        ..., description="Array of token IDs for the text content."
    )
    temperature: float = Field(
        ..., description="Temperature parameter used for generating the segment."
    )
    avg_logprob: float = Field(
        ...,
        description="Average logprob of the segment. If the value is lower than -1, consider the logprobs failed.",
    )
    compression_ratio: float = Field(
        ...,
        description="Compression ratio of the segment. If the value is greater than 2.4, consider the compression failed.",
    )
    no_speech_prob: float = Field(
        ...,
        description="Probability of no speech in the segment. If the value is higher than 1.0 and the `avg_logprob` is below -1, consider this segment silent.",
    )


class TranscriptionWord(BaseModel):
    word: str = Field(..., description="The text content of the word.")
    start: float = Field(..., description="Start time of the word in seconds.")
    end: float = Field(..., description="End time of the word in seconds.")


class CreateTranscriptionResponseVerboseJson(BaseModel):
    language: str = Field(..., description="The language of the input audio.")
    duration: str = Field(..., description="The duration of the input audio.")
    text: str = Field(..., description="The transcribed text.")
    words: Optional[List[TranscriptionWord]] = Field(
        None, description="Extracted words and their corresponding timestamps."
    )
    segments: Optional[List[TranscriptionSegment]] = Field(
        None,
        description="Segments of the transcribed text and their corresponding details.",
    )


class CreateTranslationRequest(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    file: bytes = Field(
        ...,
        description="The audio file object (not file name) translate, in one of these formats: flac, mp3, mp4, mpeg, mpga, m4a, ogg, wav, or webm.\n",
    )
    model: Union[str, Literal["whisper-1"]] = Field(
        ...,
        description="ID of the model to use. Only `whisper-1` (which is powered by our open source Whisper V2 model) is currently available.\n",
        examples=["whisper-1"],
    )
    prompt: Optional[str] = Field(
        None,
        description="An optional text to guide the model's style or continue a previous audio segment. The [prompt](/docs/guides/speech-to-text/prompting) should be in English.\n",
    )
    response_format: str = Field(
        "json",
        description="The format of the transcript output, in one of these options: `json`, `text`, `srt`, `verbose_json`, or `vtt`.\n",
    )
    temperature: float = Field(
        0,
        description="The sampling temperature, between 0 and 1. Higher values like 0.8 will make the output more random, while lower values like 0.2 will make it more focused and deterministic. If set to 0, the model will use [log probability](https://en.wikipedia.org/wiki/Log_probability) to automatically increase the temperature until certain thresholds are hit.\n",
    )


class CreateTranslationResponseJson(BaseModel):
    text: str


class CreateTranslationResponseVerboseJson(BaseModel):
    language: str = Field(
        ..., description="The language of the output translation (always `english`)."
    )
    duration: str = Field(..., description="The duration of the input audio.")
    text: str = Field(..., description="The translated text.")
    segments: Optional[List[TranscriptionSegment]] = Field(
        None,
        description="Segments of the translated text and their corresponding details.",
    )


class CreateSpeechRequest(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    model: Union[str, Literal["tts-1", "tts-1-hd"]] = Field(
        ...,
        description="One of the available [TTS models](/docs/models/tts): `tts-1` or `tts-1-hd`\n",
    )
    input: constr(max_length=4096) = Field(
        ...,
        description="The text to generate audio for. The maximum length is 4096 characters.",
    )
    voice: Literal["alloy", "echo", "fable", "onyx", "nova", "shimmer"] = Field(
        ...,
        description="The voice to use when generating the audio. Supported voices are `alloy`, `echo`, `fable`, `onyx`, `nova`, and `shimmer`. Previews of the voices are available in the [Text to speech guide](/docs/guides/text-to-speech/voice-options).",
    )
    response_format: Literal["mp3", "opus", "aac", "flac", "wav", "pcm"] = Field(
        "mp3",
        description="The format to audio in. Supported formats are `mp3`, `opus`, `aac`, `flac`, `wav`, and `pcm`.",
    )
    speed: confloat(ge=0.25, le=4.0) = Field(
        1.0,
        description="The speed of the generated audio. Select a value from `0.25` to `4.0`. `1.0` is the default.",
    )


class Model(BaseModel):
    id: str = Field(
        ...,
        description="The model identifier, which can be referenced in the API endpoints.",
    )
    created: int = Field(
        ..., description="The Unix timestamp (in seconds) when the model was created."
    )
    object: Literal["model"] = Field(
        ..., description='The object type, which is always "model".'
    )
    owned_by: str = Field(..., description="The organization that owns the model.")


class OpenAIFile(BaseModel):
    id: str = Field(
        ...,
        description="The file identifier, which can be referenced in the API endpoints.",
    )
    bytes: int = Field(..., description="The size of the file, in bytes.")
    created_at: int = Field(
        ...,
        description="The Unix timestamp (in seconds) for when the file was created.",
    )
    filename: str = Field(..., description="The name of the file.")
    object: Literal["file"] = Field(
        ..., description="The object type, which is always `file`."
    )
    purpose: Literal[
        "fine-tune", "fine-tune-results", "assistants", "assistants_output"
    ] = Field(
        ...,
        description="The intended purpose of the file. Supported values are `fine-tune`, `fine-tune-results`, `assistants`, and `assistants_output`.",
    )
    status: Literal["uploaded", "processed", "error"] = Field(
        ...,
        description="Deprecated. The current status of the file, which can be either `uploaded`, `processed`, or `error`.",
    )
    status_details: Optional[str] = Field(
        None,
        description="Deprecated. For details on why a fine-tuning training file failed validation, see the `error` field on `fine_tuning.job`.",
    )


class Embedding(BaseModel):
    index: int = Field(
        ..., description="The index of the embedding in the list of embeddings."
    )
    embedding: List[float] = Field(
        ...,
        description="The embedding vector, which is a list of floats. The length of vector depends on the model as listed in the [embedding guide](/docs/guides/embeddings).\n",
    )
    object: Literal["embedding"] = Field(
        ..., description='The object type, which is always "embedding".'
    )


class Error1(BaseModel):
    code: str = Field(..., description="A machine-readable error code.")
    message: str = Field(..., description="A human-readable error message.")
    param: Optional[str] = Field(
        ...,
        description="The parameter that was invalid, usually `training_file` or `validation_file`. This field will be null if the failure was not parameter-specific.",
    )


class Hyperparameters1(BaseModel):
    n_epochs: Union[Literal["auto"], conint(ge=1, le=50)] = Field(
        ...,
        description='The number of epochs to train the model for. An epoch refers to one full cycle through the training dataset.\n"auto" decides the optimal number of epochs based on the size of the dataset. If setting the number manually, we support any number between 1 and 50 epochs.',
    )


class FineTuningIntegration(BaseModel):
    type: Literal["wandb"] = Field(
        ...,
        description="The type of the integration being enabled for the fine-tuning job",
    )
    wandb: Wandb = Field(
        ...,
        description="The settings for your integration with Weights and Biases. This payload specifies the project that\nmetrics will be sent to. Optionally, you can set an explicit display name for your run, add tags\nto your run, and set a default entity (team, username, etc) to be associated with your run.\n",
    )


class FineTuningJobEvent(BaseModel):
    id: str
    created_at: int
    level: Literal["info", "warn", "error"]
    message: str
    object: Literal["fine_tuning.job.event"]


class Metrics(BaseModel):
    step: Optional[float] = None
    train_loss: Optional[float] = None
    train_mean_token_accuracy: Optional[float] = None
    valid_loss: Optional[float] = None
    valid_mean_token_accuracy: Optional[float] = None
    full_valid_loss: Optional[float] = None
    full_valid_mean_token_accuracy: Optional[float] = None


class FineTuningJobCheckpoint(BaseModel):
    id: str = Field(
        ...,
        description="The checkpoint identifier, which can be referenced in the API endpoints.",
    )
    created_at: int = Field(
        ...,
        description="The Unix timestamp (in seconds) for when the checkpoint was created.",
    )
    fine_tuned_model_checkpoint: str = Field(
        ..., description="The name of the fine-tuned checkpoint model that is created."
    )
    step_number: int = Field(
        ..., description="The step number that the checkpoint was created at."
    )
    metrics: Metrics = Field(
        ..., description="Metrics at the step number during the fine-tuning job."
    )
    fine_tuning_job_id: str = Field(
        ...,
        description="The name of the fine-tuning job that this checkpoint was created from.",
    )
    object: Literal["fine_tuning.job.checkpoint"] = Field(
        ...,
        description='The object type, which is always "fine_tuning.job.checkpoint".',
    )


class CompletionUsage(BaseModel):
    completion_tokens: int = Field(
        ..., description="Number of tokens in the generated completion."
    )
    prompt_tokens: int = Field(..., description="Number of tokens in the prompt.")
    total_tokens: int = Field(
        ...,
        description="Total number of tokens used in the request (prompt + completion).",
    )


class RunCompletionUsage(BaseModel):
    completion_tokens: int = Field(
        ..., description="Number of completion tokens used over the course of the run."
    )
    prompt_tokens: int = Field(
        ..., description="Number of prompt tokens used over the course of the run."
    )
    total_tokens: int = Field(
        ..., description="Total number of tokens used (prompt + completion)."
    )


class RunStepCompletionUsage(BaseModel):
    completion_tokens: int = Field(
        ...,
        description="Number of completion tokens used over the course of the run step.",
    )
    prompt_tokens: int = Field(
        ..., description="Number of prompt tokens used over the course of the run step."
    )
    total_tokens: int = Field(
        ..., description="Total number of tokens used (prompt + completion)."
    )


class DeleteAssistantResponse(BaseModel):
    id: str
    deleted: bool
    object: Literal["assistant.deleted"]


class AssistantToolsCode(BaseModel):
    type: Literal["code_interpreter"] = Field(
        ..., description="The type of tool being defined: `code_interpreter`"
    )


class AssistantToolsRetrieval(BaseModel):
    type: Literal["retrieval"] = Field(
        ..., description="The type of tool being defined: `retrieval`"
    )


class AssistantToolsFunction(BaseModel):
    type: Literal["function"] = Field(
        ..., description="The type of tool being defined: `function`"
    )
    function: FunctionObject


class LastError(BaseModel):
    code: Literal["server_error", "rate_limit_exceeded", "invalid_prompt"] = Field(
        ...,
        description="One of `server_error`, `rate_limit_exceeded`, or `invalid_prompt`.",
    )
    message: str = Field(..., description="A human-readable description of the error.")


class ModifyRunRequest(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    metadata: Optional[Dict[str, Any]] = Field(
        None,
        description="Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.\n",
    )


class ToolOutput(BaseModel):
    tool_call_id: Optional[str] = Field(
        None,
        description="The ID of the tool call in the `required_action` object within the run object the output is being submitted for.",
    )
    output: Optional[str] = Field(
        None,
        description="The output of the tool call to be submitted to continue the run.",
    )


class SubmitToolOutputsRunRequest(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    tool_outputs: List[ToolOutput] = Field(
        ..., description="A list of tools for which the outputs are being submitted."
    )
    stream: Optional[bool] = Field(
        None,
        description="If `true`, returns a stream of events that happen during the Run as server-sent events, terminating when the Run enters a terminal state with a `data: [DONE]` message.\n",
    )


class Function3(BaseModel):
    name: str = Field(..., description="The name of the function.")
    arguments: str = Field(
        ...,
        description="The arguments that the model expects you to pass to the function.",
    )


class RunToolCallObject(BaseModel):
    id: str = Field(
        ...,
        description="The ID of the tool call. This ID must be referenced when you submit the tool outputs in using the [Submit tool outputs to run](/docs/api-reference/runs/submitToolOutputs) endpoint.",
    )
    type: Literal["function"] = Field(
        ...,
        description="The type of tool call the output is required for. For now, this is always `function`.",
    )
    function: Function3 = Field(..., description="The function definition.")


class ThreadObject(BaseModel):
    id: str = Field(
        ..., description="The identifier, which can be referenced in API endpoints."
    )
    object: Literal["thread"] = Field(
        ..., description="The object type, which is always `thread`."
    )
    created_at: int = Field(
        ...,
        description="The Unix timestamp (in seconds) for when the thread was created.",
    )
    metadata: Optional[Dict[str, Any]] = Field(
        ...,
        description="Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.\n",
    )


class ModifyThreadRequest(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    metadata: Optional[Dict[str, Any]] = Field(
        None,
        description="Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.\n",
    )


class DeleteThreadResponse(BaseModel):
    id: str
    deleted: bool
    object: Literal["thread.deleted"]


class ListThreadsResponse(BaseModel):
    object: str = Field(..., examples=["list"])
    data: List[ThreadObject]
    first_id: str = Field(..., examples=["asst_abc123"])
    last_id: str = Field(..., examples=["asst_abc456"])
    has_more: bool = Field(..., examples=[False])


class IncompleteDetails(BaseModel):
    reason: Literal[
        "content_filter", "max_tokens", "run_cancelled", "run_expired", "run_failed"
    ] = Field(..., description="The reason the message is incomplete.")


class CreateMessageRequest(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    role: Literal["user", "assistant"] = Field(
        ...,
        description="The role of the entity that is creating the message. Allowed values include:\n- `user`: Indicates the message is sent by an actual user and should be used in most cases to represent user-generated messages.\n- `assistant`: Indicates the message is generated by the assistant. Use this value to insert messages from the assistant into the conversation.\n",
    )
    content: constr(min_length=1, max_length=256000) = Field(
        ..., description="The content of the message."
    )
    file_ids: List[str] = Field(
        [],
        description="A list of [File](/docs/api-reference/files) IDs that the message should use. There can be a maximum of 10 files attached to a message. Useful for tools like `retrieval` and `code_interpreter` that can access and use files.",
        max_length=10,
        min_length=1,
    )
    metadata: Optional[Dict[str, Any]] = Field(
        None,
        description="Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.\n",
    )


class ModifyMessageRequest(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    metadata: Optional[Dict[str, Any]] = Field(
        None,
        description="Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.\n",
    )


class DeleteMessageResponse(BaseModel):
    id: str
    deleted: bool
    object: Literal["thread.message.deleted"]


class ImageFile(BaseModel):
    file_id: str = Field(
        ...,
        description="The [File](/docs/api-reference/files) ID of the image in the message content.",
    )


class MessageContentImageFileObject(BaseModel):
    type: Literal["image_file"] = Field(..., description="Always `image_file`.")
    image_file: ImageFile


class ImageFile1(BaseModel):
    file_id: Optional[str] = Field(
        None,
        description="The [File](/docs/api-reference/files) ID of the image in the message content.",
    )


class MessageDeltaContentImageFileObject(BaseModel):
    index: int = Field(..., description="The index of the content part in the message.")
    type: Literal["image_file"] = Field(..., description="Always `image_file`.")
    image_file: Optional[ImageFile1] = None


class FileCitation(BaseModel):
    file_id: str = Field(
        ..., description="The ID of the specific File the citation is from."
    )
    quote: str = Field(..., description="The specific quote in the file.")


class MessageContentTextAnnotationsFileCitationObject(BaseModel):
    type: Literal["file_citation"] = Field(..., description="Always `file_citation`.")
    text: str = Field(
        ..., description="The text in the message content that needs to be replaced."
    )
    file_citation: FileCitation
    start_index: conint(ge=0)
    end_index: conint(ge=0)


class FilePath(BaseModel):
    file_id: str = Field(..., description="The ID of the file that was generated.")


class MessageContentTextAnnotationsFilePathObject(BaseModel):
    type: Literal["file_path"] = Field(..., description="Always `file_path`.")
    text: str = Field(
        ..., description="The text in the message content that needs to be replaced."
    )
    file_path: FilePath
    start_index: conint(ge=0)
    end_index: conint(ge=0)


class FileCitation1(BaseModel):
    file_id: Optional[str] = Field(
        None, description="The ID of the specific File the citation is from."
    )
    quote: Optional[str] = Field(None, description="The specific quote in the file.")


class MessageDeltaContentTextAnnotationsFileCitationObject(BaseModel):
    index: int = Field(
        ..., description="The index of the annotation in the text content part."
    )
    type: Literal["file_citation"] = Field(..., description="Always `file_citation`.")
    text: Optional[str] = Field(
        None, description="The text in the message content that needs to be replaced."
    )
    file_citation: Optional[FileCitation1] = None
    start_index: Optional[conint(ge=0)] = None
    end_index: Optional[conint(ge=0)] = None


class FilePath1(BaseModel):
    file_id: Optional[str] = Field(
        None, description="The ID of the file that was generated."
    )


class MessageDeltaContentTextAnnotationsFilePathObject(BaseModel):
    index: int = Field(
        ..., description="The index of the annotation in the text content part."
    )
    type: Literal["file_path"] = Field(..., description="Always `file_path`.")
    text: Optional[str] = Field(
        None, description="The text in the message content that needs to be replaced."
    )
    file_path: Optional[FilePath1] = None
    start_index: Optional[conint(ge=0)] = None
    end_index: Optional[conint(ge=0)] = None


class LastError1(BaseModel):
    code: Literal["server_error", "rate_limit_exceeded"] = Field(
        ..., description="One of `server_error` or `rate_limit_exceeded`."
    )
    message: str = Field(..., description="A human-readable description of the error.")


class MessageCreation(BaseModel):
    message_id: str = Field(
        ..., description="The ID of the message that was created by this run step."
    )


class RunStepDetailsMessageCreationObject(BaseModel):
    type: Literal["message_creation"] = Field(
        ..., description="Always `message_creation`."
    )
    message_creation: MessageCreation


class MessageCreation1(BaseModel):
    message_id: Optional[str] = Field(
        None, description="The ID of the message that was created by this run step."
    )


class RunStepDeltaStepDetailsMessageCreationObject(BaseModel):
    type: Literal["message_creation"] = Field(
        ..., description="Always `message_creation`."
    )
    message_creation: Optional[MessageCreation1] = None


class RunStepDetailsToolCallsCodeOutputLogsObject(BaseModel):
    type: Literal["logs"] = Field(..., description="Always `logs`.")
    logs: str = Field(
        ..., description="The text output from the Code Interpreter tool call."
    )


class RunStepDeltaStepDetailsToolCallsCodeOutputLogsObject(BaseModel):
    index: int = Field(..., description="The index of the output in the outputs array.")
    type: Literal["logs"] = Field(..., description="Always `logs`.")
    logs: Optional[str] = Field(
        None, description="The text output from the Code Interpreter tool call."
    )


class Image1(BaseModel):
    file_id: str = Field(
        ..., description="The [file](/docs/api-reference/files) ID of the image."
    )


class RunStepDetailsToolCallsCodeOutputImageObject(BaseModel):
    type: Literal["image"] = Field(..., description="Always `image`.")
    image: Image1


class Image2(BaseModel):
    file_id: Optional[str] = Field(
        None, description="The [file](/docs/api-reference/files) ID of the image."
    )


class RunStepDeltaStepDetailsToolCallsCodeOutputImageObject(BaseModel):
    index: int = Field(..., description="The index of the output in the outputs array.")
    type: Literal["image"] = Field(..., description="Always `image`.")
    image: Optional[Image2] = None


class RunStepDetailsToolCallsRetrievalObject(BaseModel):
    id: str = Field(..., description="The ID of the tool call object.")
    type: Literal["retrieval"] = Field(
        ...,
        description="The type of tool call. This is always going to be `retrieval` for this type of tool call.",
    )
    retrieval: Dict[str, Any] = Field(
        ..., description="For now, this is always going to be an empty object."
    )


class RunStepDeltaStepDetailsToolCallsRetrievalObject(BaseModel):
    index: int = Field(
        ..., description="The index of the tool call in the tool calls array."
    )
    id: Optional[str] = Field(None, description="The ID of the tool call object.")
    type: Literal["retrieval"] = Field(
        ...,
        description="The type of tool call. This is always going to be `retrieval` for this type of tool call.",
    )
    retrieval: Optional[Dict[str, Any]] = Field(
        None, description="For now, this is always going to be an empty object."
    )


class Function4(BaseModel):
    name: str = Field(..., description="The name of the function.")
    arguments: str = Field(..., description="The arguments passed to the function.")
    output: Optional[str] = Field(
        ...,
        description="The output of the function. This will be `null` if the outputs have not been [submitted](/docs/api-reference/runs/submitToolOutputs) yet.",
    )


class RunStepDetailsToolCallsFunctionObject(BaseModel):
    id: str = Field(..., description="The ID of the tool call object.")
    type: Literal["function"] = Field(
        ...,
        description="The type of tool call. This is always going to be `function` for this type of tool call.",
    )
    function: Function4 = Field(
        ..., description="The definition of the function that was called."
    )


class Function5(BaseModel):
    name: Optional[str] = Field(None, description="The name of the function.")
    arguments: Optional[str] = Field(
        None, description="The arguments passed to the function."
    )
    output: Optional[str] = Field(
        None,
        description="The output of the function. This will be `null` if the outputs have not been [submitted](/docs/api-reference/runs/submitToolOutputs) yet.",
    )


class RunStepDeltaStepDetailsToolCallsFunctionObject(BaseModel):
    index: int = Field(
        ..., description="The index of the tool call in the tool calls array."
    )
    id: Optional[str] = Field(None, description="The ID of the tool call object.")
    type: Literal["function"] = Field(
        ...,
        description="The type of tool call. This is always going to be `function` for this type of tool call.",
    )
    function: Optional[Function5] = Field(
        None, description="The definition of the function that was called."
    )


class AssistantFileObject(BaseModel):
    id: str = Field(
        ..., description="The identifier, which can be referenced in API endpoints."
    )
    object: Literal["assistant.file"] = Field(
        ..., description="The object type, which is always `assistant.file`."
    )
    created_at: int = Field(
        ...,
        description="The Unix timestamp (in seconds) for when the assistant file was created.",
    )
    assistant_id: str = Field(
        ..., description="The assistant ID that the file is attached to."
    )


class CreateAssistantFileRequest(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    file_id: str = Field(
        ...,
        description='A [File](/docs/api-reference/files) ID (with `purpose="assistants"`) that the assistant should use. Useful for tools like `retrieval` and `code_interpreter` that can access files.',
    )


class DeleteAssistantFileResponse(BaseModel):
    id: str
    deleted: bool
    object: Literal["assistant.file.deleted"]


class ListAssistantFilesResponse(BaseModel):
    object: str = Field(..., examples=["list"])
    data: List[AssistantFileObject]
    first_id: str = Field(..., examples=["file-abc123"])
    last_id: str = Field(..., examples=["file-abc456"])
    has_more: bool = Field(..., examples=[False])


class MessageFileObject(BaseModel):
    id: str = Field(
        ..., description="The identifier, which can be referenced in API endpoints."
    )
    object: Literal["thread.message.file"] = Field(
        ..., description="The object type, which is always `thread.message.file`."
    )
    created_at: int = Field(
        ...,
        description="The Unix timestamp (in seconds) for when the message file was created.",
    )
    message_id: str = Field(
        ...,
        description="The ID of the [message](/docs/api-reference/messages) that the [File](/docs/api-reference/files) is attached to.",
    )


class ListMessageFilesResponse(BaseModel):
    object: str = Field(..., examples=["list"])
    data: List[MessageFileObject]
    first_id: str = Field(..., examples=["file-abc123"])
    last_id: str = Field(..., examples=["file-abc456"])
    has_more: bool = Field(..., examples=[False])


class ThreadStreamEvent1(BaseModel):
    event: Literal["thread.created"]
    data: ThreadObject


class ErrorEvent(BaseModel):
    event: Literal["error"]
    data: Error


class DoneEvent(BaseModel):
    event: Literal["done"]
    data: Literal["[DONE]"]


class ListModelsResponse(BaseModel):
    object: Literal["list"]
    data: List[Model]


class CreateCompletionResponse(BaseModel):
    id: str = Field(..., description="A unique identifier for the completion.")
    choices: List[Choice] = Field(
        ...,
        description="The list of completion choices the model generated for the input prompt.",
    )
    created: int = Field(
        ...,
        description="The Unix timestamp (in seconds) of when the completion was created.",
    )
    model: str = Field(..., description="The model used for completion.")
    system_fingerprint: Optional[str] = Field(
        None,
        description="This fingerprint represents the backend configuration that the model runs with.\n\nCan be used in conjunction with the `seed` request parameter to understand when backend changes have been made that might impact determinism.\n",
    )
    object: Literal["text_completion"] = Field(
        ..., description='The object type, which is always "text_completion"'
    )
    usage: Optional[CompletionUsage] = None


class ChatCompletionRequestUserMessage(BaseModel):
    content: Union[
        str,
        List[
            Union[
                ChatCompletionRequestMessageContentPartText,
                ChatCompletionRequestMessageContentPartImage,
            ]
        ],
    ] = Field(..., description="The contents of the user message.\n")
    role: Literal["user"] = Field(
        ..., description="The role of the messages author, in this case `user`."
    )
    name: Optional[str] = Field(
        None,
        description="An optional name for the participant. Provides the model information to differentiate between participants of the same role.",
    )


class ChatCompletionTool(BaseModel):
    type: Literal["function"] = Field(
        ...,
        description="The type of the tool. Currently, only `function` is supported.",
    )
    function: FunctionObject


class ChatCompletionResponseMessage(BaseModel):
    content: Optional[str] = Field(..., description="The contents of the message.")
    tool_calls: Optional[List[ChatCompletionMessageToolCall]] = Field(
        None,
        description="The tool calls generated by the model, such as function calls.",
    )
    role: Literal["assistant"] = Field(
        ..., description="The role of the author of this message."
    )
    function_call: Optional[FunctionCall] = Field(
        None,
        description="Deprecated and replaced by `tool_calls`. The name and arguments of a function that should be called, as generated by the model.",
    )


class Choice1(BaseModel):
    finish_reason: Literal[
        "stop", "length", "tool_calls", "content_filter", "function_call"
    ] = Field(
        ...,
        description="The reason the model stopped generating tokens. This will be `stop` if the model hit a natural stop point or a provided stop sequence,\n`length` if the maximum number of tokens specified in the request was reached,\n`content_filter` if content was omitted due to a flag from our content filters,\n`tool_calls` if the model called a tool, or `function_call` (deprecated) if the model called a function.\n",
    )
    index: int = Field(
        ..., description="The index of the choice in the list of choices."
    )
    message: ChatCompletionResponseMessage
    logprobs: Optional[Logprobs2] = Field(
        ..., description="Log probability information for the choice."
    )


class CreateChatCompletionResponse(BaseModel):
    id: str = Field(..., description="A unique identifier for the chat completion.")
    choices: List[Choice1] = Field(
        ...,
        description="A list of chat completion choices. Can be more than one if `n` is greater than 1.",
    )
    created: int = Field(
        ...,
        description="The Unix timestamp (in seconds) of when the chat completion was created.",
    )
    model: str = Field(..., description="The model used for the chat completion.")
    system_fingerprint: Optional[str] = Field(
        None,
        description="This fingerprint represents the backend configuration that the model runs with.\n\nCan be used in conjunction with the `seed` request parameter to understand when backend changes have been made that might impact determinism.\n",
    )
    object: Literal["chat.completion"] = Field(
        ..., description="The object type, which is always `chat.completion`."
    )
    usage: Optional[CompletionUsage] = None


class Choice2(BaseModel):
    finish_reason: Literal["stop", "length", "function_call", "content_filter"] = Field(
        ...,
        description="The reason the model stopped generating tokens. This will be `stop` if the model hit a natural stop point or a provided stop sequence, `length` if the maximum number of tokens specified in the request was reached, `content_filter` if content was omitted due to a flag from our content filters, or `function_call` if the model called a function.\n",
    )
    index: int = Field(
        ..., description="The index of the choice in the list of choices."
    )
    message: ChatCompletionResponseMessage


class CreateChatCompletionFunctionResponse(BaseModel):
    id: str = Field(..., description="A unique identifier for the chat completion.")
    choices: List[Choice2] = Field(
        ...,
        description="A list of chat completion choices. Can be more than one if `n` is greater than 1.",
    )
    created: int = Field(
        ...,
        description="The Unix timestamp (in seconds) of when the chat completion was created.",
    )
    model: str = Field(..., description="The model used for the chat completion.")
    system_fingerprint: Optional[str] = Field(
        None,
        description="This fingerprint represents the backend configuration that the model runs with.\n\nCan be used in conjunction with the `seed` request parameter to understand when backend changes have been made that might impact determinism.\n",
    )
    object: Literal["chat.completion"] = Field(
        ..., description="The object type, which is always `chat.completion`."
    )
    usage: Optional[CompletionUsage] = None


class ImagesResponse(BaseModel):
    created: int
    data: List[Image]


class ListFilesResponse(BaseModel):
    data: List[OpenAIFile]
    object: Literal["list"]


class ListFineTuningJobEventsResponse(BaseModel):
    data: List[FineTuningJobEvent]
    object: Literal["list"]


class ListFineTuningJobCheckpointsResponse(BaseModel):
    data: List[FineTuningJobCheckpoint]
    object: Literal["list"]
    first_id: Optional[str] = None
    last_id: Optional[str] = None
    has_more: bool


class CreateEmbeddingResponse(BaseModel):
    data: List[Embedding] = Field(
        ..., description="The list of embeddings generated by the model."
    )
    model: str = Field(
        ..., description="The name of the model used to generate the embedding."
    )
    object: Literal["list"] = Field(
        ..., description='The object type, which is always "list".'
    )
    usage: Usage = Field(..., description="The usage information for the request.")


class FineTuningJob(BaseModel):
    id: str = Field(
        ...,
        description="The object identifier, which can be referenced in the API endpoints.",
    )
    created_at: int = Field(
        ...,
        description="The Unix timestamp (in seconds) for when the fine-tuning job was created.",
    )
    error: Optional[Error1] = Field(
        ...,
        description="For fine-tuning jobs that have `failed`, this will contain more information on the cause of the failure.",
    )
    fine_tuned_model: Optional[str] = Field(
        ...,
        description="The name of the fine-tuned model that is being created. The value will be null if the fine-tuning job is still running.",
    )
    finished_at: Optional[int] = Field(
        ...,
        description="The Unix timestamp (in seconds) for when the fine-tuning job was finished. The value will be null if the fine-tuning job is still running.",
    )
    hyperparameters: Hyperparameters1 = Field(
        ...,
        description="The hyperparameters used for the fine-tuning job. See the [fine-tuning guide](/docs/guides/fine-tuning) for more details.",
    )
    model: str = Field(..., description="The base model that is being fine-tuned.")
    object: Literal["fine_tuning.job"] = Field(
        ..., description='The object type, which is always "fine_tuning.job".'
    )
    organization_id: str = Field(
        ..., description="The organization that owns the fine-tuning job."
    )
    result_files: List[str] = Field(
        ...,
        description="The compiled results file ID(s) for the fine-tuning job. You can retrieve the results with the [Files API](/docs/api-reference/files/retrieve-contents).",
    )
    status: Literal[
        "validating_files", "queued", "running", "succeeded", "failed", "cancelled"
    ] = Field(
        ...,
        description="The current status of the fine-tuning job, which can be either `validating_files`, `queued`, `running`, `succeeded`, `failed`, or `cancelled`.",
    )
    trained_tokens: Optional[int] = Field(
        ...,
        description="The total number of billable tokens processed by this fine-tuning job. The value will be null if the fine-tuning job is still running.",
    )
    training_file: str = Field(
        ...,
        description="The file ID used for training. You can retrieve the training data with the [Files API](/docs/api-reference/files/retrieve-contents).",
    )
    validation_file: Optional[str] = Field(
        ...,
        description="The file ID used for validation. You can retrieve the validation results with the [Files API](/docs/api-reference/files/retrieve-contents).",
    )
    integrations: Optional[List[FineTuningIntegration]] = Field(
        None,
        description="A list of integrations to enable for this fine-tuning job.",
        max_length=5,
    )
    seed: int = Field(..., description="The seed used for the fine-tuning job.")


class AssistantObject(BaseModel):
    id: str = Field(
        ..., description="The identifier, which can be referenced in API endpoints."
    )
    object: Literal["assistant"] = Field(
        ..., description="The object type, which is always `assistant`."
    )
    created_at: int = Field(
        ...,
        description="The Unix timestamp (in seconds) for when the assistant was created.",
    )
    name: Optional[constr(max_length=256)] = Field(
        ...,
        description="The name of the assistant. The maximum length is 256 characters.\n",
    )
    description: Optional[constr(max_length=512)] = Field(
        ...,
        description="The description of the assistant. The maximum length is 512 characters.\n",
    )
    model: str = Field(
        ...,
        description="ID of the model to use. You can use the [List models](/docs/api-reference/models/list) API to see all of your available models, or see our [Model overview](/docs/models/overview) for descriptions of them.\n",
    )
    instructions: Optional[constr(max_length=256000)] = Field(
        ...,
        description="The system instructions that the assistant uses. The maximum length is 256,000 characters.\n",
    )
    tools: List[
        Union[AssistantToolsCode, AssistantToolsRetrieval, AssistantToolsFunction]
    ] = Field(
        ...,
        description="A list of tool enabled on the assistant. There can be a maximum of 128 tools per assistant. Tools can be of types `code_interpreter`, `retrieval`, or `function`.\n",
        max_length=128,
    )
    file_ids: List[str] = Field(
        ...,
        description="A list of [file](/docs/api-reference/files) IDs attached to this assistant. There can be a maximum of 20 files attached to the assistant. Files are ordered by their creation date in ascending order.\n",
        max_length=20,
    )
    metadata: Optional[Dict[str, Any]] = Field(
        ...,
        description="Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.\n",
    )


class CreateAssistantRequest(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    model: Union[
        str,
        Literal[
            "gpt-4-turbo",
            "gpt-4-turbo-2024-04-09",
            "gpt-4-0125-preview",
            "gpt-4-turbo-preview",
            "gpt-4-1106-preview",
            "gpt-4-vision-preview",
            "gpt-4",
            "gpt-4-0314",
            "gpt-4-0613",
            "gpt-4-32k",
            "gpt-4-32k-0314",
            "gpt-4-32k-0613",
            "gpt-3.5-turbo",
            "gpt-3.5-turbo-16k",
            "gpt-3.5-turbo-0613",
            "gpt-3.5-turbo-1106",
            "gpt-3.5-turbo-0125",
            "gpt-3.5-turbo-16k-0613",
        ],
    ] = Field(
        ...,
        description="ID of the model to use. You can use the [List models](/docs/api-reference/models/list) API to see all of your available models, or see our [Model overview](/docs/models/overview) for descriptions of them.\n",
        examples=["gpt-4-turbo"],
    )
    name: Optional[constr(max_length=256)] = Field(
        None,
        description="The name of the assistant. The maximum length is 256 characters.\n",
    )
    description: Optional[constr(max_length=512)] = Field(
        None,
        description="The description of the assistant. The maximum length is 512 characters.\n",
    )
    instructions: Optional[constr(max_length=256000)] = Field(
        None,
        description="The system instructions that the assistant uses. The maximum length is 256,000 characters.\n",
    )
    tools: List[
        Union[AssistantToolsCode, AssistantToolsRetrieval, AssistantToolsFunction]
    ] = Field(
        [],
        description="A list of tool enabled on the assistant. There can be a maximum of 128 tools per assistant. Tools can be of types `code_interpreter`, `retrieval`, or `function`.\n",
        max_length=128,
    )
    file_ids: List[str] = Field(
        [],
        description="A list of [file](/docs/api-reference/files) IDs attached to this assistant. There can be a maximum of 20 files attached to the assistant. Files are ordered by their creation date in ascending order.\n",
        max_length=20,
    )
    metadata: Optional[Dict[str, Any]] = Field(
        None,
        description="Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.\n",
    )


class ModifyAssistantRequest(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    model: Optional[str] = Field(
        None,
        description="ID of the model to use. You can use the [List models](/docs/api-reference/models/list) API to see all of your available models, or see our [Model overview](/docs/models/overview) for descriptions of them.\n",
    )
    name: Optional[constr(max_length=256)] = Field(
        None,
        description="The name of the assistant. The maximum length is 256 characters.\n",
    )
    description: Optional[constr(max_length=512)] = Field(
        None,
        description="The description of the assistant. The maximum length is 512 characters.\n",
    )
    instructions: Optional[constr(max_length=256000)] = Field(
        None,
        description="The system instructions that the assistant uses. The maximum length is 256,000 characters.\n",
    )
    tools: List[
        Union[AssistantToolsCode, AssistantToolsRetrieval, AssistantToolsFunction]
    ] = Field(
        [],
        description="A list of tool enabled on the assistant. There can be a maximum of 128 tools per assistant. Tools can be of types `code_interpreter`, `retrieval`, or `function`.\n",
        max_length=128,
    )
    file_ids: List[str] = Field(
        [],
        description="A list of [File](/docs/api-reference/files) IDs attached to this assistant. There can be a maximum of 20 files attached to the assistant. Files are ordered by their creation date in ascending order. If a file was previously attached to the list but does not show up in the list, it will be deleted from the assistant.\n",
        max_length=20,
    )
    metadata: Optional[Dict[str, Any]] = Field(
        None,
        description="Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.\n",
    )


class ListAssistantsResponse(BaseModel):
    object: str = Field(..., examples=["list"])
    data: List[AssistantObject]
    first_id: str = Field(..., examples=["asst_abc123"])
    last_id: str = Field(..., examples=["asst_abc456"])
    has_more: bool = Field(..., examples=[False])


class SubmitToolOutputs(BaseModel):
    tool_calls: List[RunToolCallObject] = Field(
        ..., description="A list of the relevant tool calls."
    )


class RequiredAction(BaseModel):
    type: Literal["submit_tool_outputs"] = Field(
        ..., description="For now, this is always `submit_tool_outputs`."
    )
    submit_tool_outputs: SubmitToolOutputs = Field(
        ..., description="Details on the tool outputs needed for this run to continue."
    )


class RunObject(BaseModel):
    id: str = Field(
        ..., description="The identifier, which can be referenced in API endpoints."
    )
    object: Literal["thread.run"] = Field(
        ..., description="The object type, which is always `thread.run`."
    )
    created_at: int = Field(
        ..., description="The Unix timestamp (in seconds) for when the run was created."
    )
    thread_id: str = Field(
        ...,
        description="The ID of the [thread](/docs/api-reference/threads) that was executed on as a part of this run.",
    )
    assistant_id: str = Field(
        ...,
        description="The ID of the [assistant](/docs/api-reference/assistants) used for execution of this run.",
    )
    status: Literal[
        "queued",
        "in_progress",
        "requires_action",
        "cancelling",
        "cancelled",
        "failed",
        "completed",
        "expired",
    ] = Field(
        ...,
        description="The status of the run, which can be either `queued`, `in_progress`, `requires_action`, `cancelling`, `cancelled`, `failed`, `completed`, or `expired`.",
    )
    required_action: Optional[RequiredAction] = Field(
        ...,
        description="Details on the action required to continue the run. Will be `null` if no action is required.",
    )
    last_error: Optional[LastError] = Field(
        ...,
        description="The last error associated with this run. Will be `null` if there are no errors.",
    )
    expires_at: Optional[int] = Field(
        ..., description="The Unix timestamp (in seconds) for when the run will expire."
    )
    started_at: Optional[int] = Field(
        ..., description="The Unix timestamp (in seconds) for when the run was started."
    )
    cancelled_at: Optional[int] = Field(
        ...,
        description="The Unix timestamp (in seconds) for when the run was cancelled.",
    )
    failed_at: Optional[int] = Field(
        ..., description="The Unix timestamp (in seconds) for when the run failed."
    )
    completed_at: Optional[int] = Field(
        ...,
        description="The Unix timestamp (in seconds) for when the run was completed.",
    )
    model: str = Field(
        ...,
        description="The model that the [assistant](/docs/api-reference/assistants) used for this run.",
    )
    instructions: str = Field(
        ...,
        description="The instructions that the [assistant](/docs/api-reference/assistants) used for this run.",
    )
    tools: List[
        Union[AssistantToolsCode, AssistantToolsRetrieval, AssistantToolsFunction]
    ] = Field(
        ...,
        description="The list of tools that the [assistant](/docs/api-reference/assistants) used for this run.",
        max_length=20,
    )
    file_ids: List[str] = Field(
        ...,
        description="The list of [File](/docs/api-reference/files) IDs the [assistant](/docs/api-reference/assistants) used for this run.",
    )
    metadata: Optional[Dict[str, Any]] = Field(
        ...,
        description="Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.\n",
    )
    usage: RunCompletionUsage
    temperature: Optional[float] = Field(
        None,
        description="The sampling temperature used for this run. If not set, defaults to 1.",
    )


class CreateRunRequest(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    assistant_id: str = Field(
        ...,
        description="The ID of the [assistant](/docs/api-reference/assistants) to use to execute this run.",
    )
    model: Optional[
        Union[
            Optional[str],
            Literal[
                "gpt-4-turbo",
                "gpt-4-turbo-2024-04-09",
                "gpt-4-0125-preview",
                "gpt-4-turbo-preview",
                "gpt-4-1106-preview",
                "gpt-4-vision-preview",
                "gpt-4",
                "gpt-4-0314",
                "gpt-4-0613",
                "gpt-4-32k",
                "gpt-4-32k-0314",
                "gpt-4-32k-0613",
                "gpt-3.5-turbo",
                "gpt-3.5-turbo-16k",
                "gpt-3.5-turbo-0613",
                "gpt-3.5-turbo-1106",
                "gpt-3.5-turbo-0125",
                "gpt-3.5-turbo-16k-0613",
            ],
        ]
    ] = Field(
        None,
        description="The ID of the [Model](/docs/api-reference/models) to be used to execute this run. If a value is provided here, it will override the model associated with the assistant. If not, the model associated with the assistant will be used.",
        examples=["gpt-4-turbo"],
    )
    instructions: Optional[str] = Field(
        None,
        description="Overrides the [instructions](/docs/api-reference/assistants/createAssistant) of the assistant. This is useful for modifying the behavior on a per-run basis.",
    )
    additional_instructions: Optional[str] = Field(
        None,
        description="Appends additional instructions at the end of the instructions for the run. This is useful for modifying the behavior on a per-run basis without overriding other instructions.",
    )
    additional_messages: Optional[List[CreateMessageRequest]] = Field(
        None,
        description="Adds additional messages to the thread before creating the run.",
    )
    tools: Optional[
        List[Union[AssistantToolsCode, AssistantToolsRetrieval, AssistantToolsFunction]]
    ] = Field(
        None,
        description="Override the tools the assistant can use for this run. This is useful for modifying the behavior on a per-run basis.",
        max_length=20,
    )
    metadata: Optional[Dict[str, Any]] = Field(
        None,
        description="Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.\n",
    )
    temperature: Optional[confloat(ge=0.0, le=2.0)] = Field(
        1,
        description="What sampling temperature to use, between 0 and 2. Higher values like 0.8 will make the output more random, while lower values like 0.2 will make it more focused and deterministic.\n",
        examples=[1],
    )
    stream: Optional[bool] = Field(
        None,
        description="If `true`, returns a stream of events that happen during the Run as server-sent events, terminating when the Run enters a terminal state with a `data: [DONE]` message.\n",
    )


class ListRunsResponse(BaseModel):
    object: str = Field(..., examples=["list"])
    data: List[RunObject]
    first_id: str = Field(..., examples=["run_abc123"])
    last_id: str = Field(..., examples=["run_abc456"])
    has_more: bool = Field(..., examples=[False])


class CreateThreadRequest(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    messages: Optional[List[CreateMessageRequest]] = Field(
        None,
        description="A list of [messages](/docs/api-reference/messages) to start the thread with.",
    )
    metadata: Optional[Dict[str, Any]] = Field(
        None,
        description="Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.\n",
    )


class Text(BaseModel):
    value: str = Field(..., description="The data that makes up the text.")
    annotations: List[
        Union[
            MessageContentTextAnnotationsFileCitationObject,
            MessageContentTextAnnotationsFilePathObject,
        ]
    ]


class MessageContentTextObject(BaseModel):
    type: Literal["text"] = Field(..., description="Always `text`.")
    text: Text


class Text1(BaseModel):
    value: Optional[str] = Field(None, description="The data that makes up the text.")
    annotations: Optional[
        List[
            Union[
                MessageDeltaContentTextAnnotationsFileCitationObject,
                MessageDeltaContentTextAnnotationsFilePathObject,
            ]
        ]
    ] = None


class MessageDeltaContentTextObject(BaseModel):
    index: int = Field(..., description="The index of the content part in the message.")
    type: Literal["text"] = Field(..., description="Always `text`.")
    text: Optional[Text1] = None


class CodeInterpreter(BaseModel):
    input: str = Field(..., description="The input to the Code Interpreter tool call.")
    outputs: List[
        Union[
            RunStepDetailsToolCallsCodeOutputLogsObject,
            RunStepDetailsToolCallsCodeOutputImageObject,
        ]
    ] = Field(
        ...,
        description="The outputs from the Code Interpreter tool call. Code Interpreter can output one or more items, including text (`logs`) or images (`image`). Each of these are represented by a different object type.",
    )


class RunStepDetailsToolCallsCodeObject(BaseModel):
    id: str = Field(..., description="The ID of the tool call.")
    type: Literal["code_interpreter"] = Field(
        ...,
        description="The type of tool call. This is always going to be `code_interpreter` for this type of tool call.",
    )
    code_interpreter: CodeInterpreter = Field(
        ..., description="The Code Interpreter tool call definition."
    )


class CodeInterpreter1(BaseModel):
    input: Optional[str] = Field(
        None, description="The input to the Code Interpreter tool call."
    )
    outputs: Optional[
        List[
            Union[
                RunStepDeltaStepDetailsToolCallsCodeOutputLogsObject,
                RunStepDeltaStepDetailsToolCallsCodeOutputImageObject,
            ]
        ]
    ] = Field(
        None,
        description="The outputs from the Code Interpreter tool call. Code Interpreter can output one or more items, including text (`logs`) or images (`image`). Each of these are represented by a different object type.",
    )


class RunStepDeltaStepDetailsToolCallsCodeObject(BaseModel):
    index: int = Field(
        ..., description="The index of the tool call in the tool calls array."
    )
    id: Optional[str] = Field(None, description="The ID of the tool call.")
    type: Literal["code_interpreter"] = Field(
        ...,
        description="The type of tool call. This is always going to be `code_interpreter` for this type of tool call.",
    )
    code_interpreter: Optional[CodeInterpreter1] = Field(
        None, description="The Code Interpreter tool call definition."
    )


class RunStreamEvent1(BaseModel):
    event: Literal["thread.run.created"]
    data: RunObject


class RunStreamEvent2(BaseModel):
    event: Literal["thread.run.queued"]
    data: RunObject


class RunStreamEvent3(BaseModel):
    event: Literal["thread.run.in_progress"]
    data: RunObject


class RunStreamEvent4(BaseModel):
    event: Literal["thread.run.requires_action"]
    data: RunObject


class RunStreamEvent5(BaseModel):
    event: Literal["thread.run.completed"]
    data: RunObject


class RunStreamEvent6(BaseModel):
    event: Literal["thread.run.failed"]
    data: RunObject


class RunStreamEvent7(BaseModel):
    event: Literal["thread.run.cancelling"]
    data: RunObject


class RunStreamEvent8(BaseModel):
    event: Literal["thread.run.cancelled"]
    data: RunObject


class RunStreamEvent9(BaseModel):
    event: Literal["thread.run.expired"]
    data: RunObject


class ChatCompletionRequestAssistantMessage(BaseModel):
    content: Optional[str] = Field(
        None,
        description="The contents of the assistant message. Required unless `tool_calls` or `function_call` is specified.\n",
    )
    role: Literal["assistant"] = Field(
        ..., description="The role of the messages author, in this case `assistant`."
    )
    name: Optional[str] = Field(
        None,
        description="An optional name for the participant. Provides the model information to differentiate between participants of the same role.",
    )
    tool_calls: Optional[List[ChatCompletionMessageToolCall]] = Field(
        None,
        description="The tool calls generated by the model, such as function calls.",
    )
    function_call: Optional[FunctionCall] = Field(
        None,
        description="Deprecated and replaced by `tool_calls`. The name and arguments of a function that should be called, as generated by the model.",
    )


class ListPaginatedFineTuningJobsResponse(BaseModel):
    data: List[FineTuningJob]
    has_more: bool
    object: Literal["list"]


class CreateThreadAndRunRequest(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
    )
    assistant_id: str = Field(
        ...,
        description="The ID of the [assistant](/docs/api-reference/assistants) to use to execute this run.",
    )
    thread: Optional[CreateThreadRequest] = Field(
        None, description="If no thread is provided, an empty thread will be created."
    )
    model: Optional[
        Union[
            Optional[str],
            Literal[
                "gpt-4-turbo",
                "gpt-4-turbo-2024-04-09",
                "gpt-4-0125-preview",
                "gpt-4-turbo-preview",
                "gpt-4-1106-preview",
                "gpt-4-vision-preview",
                "gpt-4",
                "gpt-4-0314",
                "gpt-4-0613",
                "gpt-4-32k",
                "gpt-4-32k-0314",
                "gpt-4-32k-0613",
                "gpt-3.5-turbo",
                "gpt-3.5-turbo-16k",
                "gpt-3.5-turbo-0613",
                "gpt-3.5-turbo-1106",
                "gpt-3.5-turbo-0125",
                "gpt-3.5-turbo-16k-0613",
            ],
        ]
    ] = Field(
        None,
        description="The ID of the [Model](/docs/api-reference/models) to be used to execute this run. If a value is provided here, it will override the model associated with the assistant. If not, the model associated with the assistant will be used.",
        examples=["gpt-4-turbo"],
    )
    instructions: Optional[str] = Field(
        None,
        description="Override the default system message of the assistant. This is useful for modifying the behavior on a per-run basis.",
    )
    tools: Optional[
        List[Union[AssistantToolsCode, AssistantToolsRetrieval, AssistantToolsFunction]]
    ] = Field(
        None,
        description="Override the tools the assistant can use for this run. This is useful for modifying the behavior on a per-run basis.",
        max_length=20,
    )
    metadata: Optional[Dict[str, Any]] = Field(
        None,
        description="Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.\n",
    )
    temperature: Optional[confloat(ge=0.0, le=2.0)] = Field(
        1,
        description="What sampling temperature to use, between 0 and 2. Higher values like 0.8 will make the output more random, while lower values like 0.2 will make it more focused and deterministic.\n",
        examples=[1],
    )
    stream: Optional[bool] = Field(
        None,
        description="If `true`, returns a stream of events that happen during the Run as server-sent events, terminating when the Run enters a terminal state with a `data: [DONE]` message.\n",
    )


class MessageObject(BaseModel):
    id: str = Field(
        ..., description="The identifier, which can be referenced in API endpoints."
    )
    object: Literal["thread.message"] = Field(
        ..., description="The object type, which is always `thread.message`."
    )
    created_at: int = Field(
        ...,
        description="The Unix timestamp (in seconds) for when the message was created.",
    )
    thread_id: str = Field(
        ...,
        description="The [thread](/docs/api-reference/threads) ID that this message belongs to.",
    )
    status: Literal["in_progress", "incomplete", "completed"] = Field(
        ...,
        description="The status of the message, which can be either `in_progress`, `incomplete`, or `completed`.",
    )
    incomplete_details: Optional[IncompleteDetails] = Field(
        ...,
        description="On an incomplete message, details about why the message is incomplete.",
    )
    completed_at: Optional[int] = Field(
        ...,
        description="The Unix timestamp (in seconds) for when the message was completed.",
    )
    incomplete_at: Optional[int] = Field(
        ...,
        description="The Unix timestamp (in seconds) for when the message was marked as incomplete.",
    )
    role: Literal["user", "assistant"] = Field(
        ...,
        description="The entity that produced the message. One of `user` or `assistant`.",
    )
    content: List[Union[MessageContentImageFileObject, MessageContentTextObject]] = (
        Field(
            ...,
            description="The content of the message in array of text and/or images.",
        )
    )
    assistant_id: Optional[str] = Field(
        ...,
        description="If applicable, the ID of the [assistant](/docs/api-reference/assistants) that authored this message.",
    )
    run_id: Optional[str] = Field(
        ...,
        description="The ID of the [run](/docs/api-reference/runs) associated with the creation of this message. Value is `null` when messages are created manually using the create message or create thread endpoints.",
    )
    file_ids: List[str] = Field(
        ...,
        description="A list of [file](/docs/api-reference/files) IDs that the assistant should use. Useful for tools like retrieval and code_interpreter that can access files. A maximum of 10 files can be attached to a message.",
        max_length=10,
    )
    metadata: Optional[Dict[str, Any]] = Field(
        ...,
        description="Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.\n",
    )


class Delta(BaseModel):
    role: Optional[Literal["user", "assistant"]] = Field(
        None,
        description="The entity that produced the message. One of `user` or `assistant`.",
    )
    content: Optional[
        List[Union[MessageDeltaContentImageFileObject, MessageDeltaContentTextObject]]
    ] = Field(
        None, description="The content of the message in array of text and/or images."
    )
    file_ids: List[str] = Field(
        [],
        description="A list of [file](/docs/api-reference/files) IDs that the assistant should use. Useful for tools like retrieval and code_interpreter that can access files. A maximum of 10 files can be attached to a message.",
        max_length=10,
    )


class MessageDeltaObject(BaseModel):
    id: str = Field(
        ...,
        description="The identifier of the message, which can be referenced in API endpoints.",
    )
    object: Literal["thread.message.delta"] = Field(
        ..., description="The object type, which is always `thread.message.delta`."
    )
    delta: Delta = Field(
        ...,
        description="The delta containing the fields that have changed on the Message.",
    )


class ListMessagesResponse(BaseModel):
    object: str = Field(..., examples=["list"])
    data: List[MessageObject]
    first_id: str = Field(..., examples=["msg_abc123"])
    last_id: str = Field(..., examples=["msg_abc123"])
    has_more: bool = Field(..., examples=[False])


class RunStepDetailsToolCallsObject(BaseModel):
    type: Literal["tool_calls"] = Field(..., description="Always `tool_calls`.")
    tool_calls: List[
        Union[
            RunStepDetailsToolCallsCodeObject,
            RunStepDetailsToolCallsRetrievalObject,
            RunStepDetailsToolCallsFunctionObject,
        ]
    ] = Field(
        ...,
        description="An array of tool calls the run step was involved in. These can be associated with one of three types of tools: `code_interpreter`, `retrieval`, or `function`.\n",
    )


class RunStepDeltaStepDetailsToolCallsObject(BaseModel):
    type: Literal["tool_calls"] = Field(..., description="Always `tool_calls`.")
    tool_calls: Optional[
        List[
            Union[
                RunStepDeltaStepDetailsToolCallsCodeObject,
                RunStepDeltaStepDetailsToolCallsRetrievalObject,
                RunStepDeltaStepDetailsToolCallsFunctionObject,
            ]
        ]
    ] = Field(
        None,
        description="An array of tool calls the run step was involved in. These can be associated with one of three types of tools: `code_interpreter`, `retrieval`, or `function`.\n",
    )


class MessageStreamEvent1(BaseModel):
    event: Literal["thread.message.created"]
    data: MessageObject


class MessageStreamEvent2(BaseModel):
    event: Literal["thread.message.in_progress"]
    data: MessageObject


class MessageStreamEvent3(BaseModel):
    event: Literal["thread.message.delta"]
    data: MessageDeltaObject


class MessageStreamEvent4(BaseModel):
    event: Literal["thread.message.completed"]
    data: MessageObject


class MessageStreamEvent5(BaseModel):
    event: Literal["thread.message.incomplete"]
    data: MessageObject


class CreateChatCompletionRequest(BaseModel):
    messages: List[
        Union[
            ChatCompletionRequestSystemMessage,
            ChatCompletionRequestUserMessage,
            ChatCompletionRequestAssistantMessage,
            ChatCompletionRequestToolMessage,
            ChatCompletionRequestFunctionMessage,
        ]
    ] = Field(
        ...,
        description="A list of messages comprising the conversation so far. [Example Python code](https://cookbook.openai.com/examples/how_to_format_inputs_to_chatgpt_models).",
        min_length=1,
    )
    model: Union[
        str,
        Literal[
            "gpt-4-turbo",
            "gpt-4-turbo-2024-04-09",
            "gpt-4-0125-preview",
            "gpt-4-turbo-preview",
            "gpt-4-1106-preview",
            "gpt-4-vision-preview",
            "gpt-4",
            "gpt-4-0314",
            "gpt-4-0613",
            "gpt-4-32k",
            "gpt-4-32k-0314",
            "gpt-4-32k-0613",
            "gpt-3.5-turbo",
            "gpt-3.5-turbo-16k",
            "gpt-3.5-turbo-0301",
            "gpt-3.5-turbo-0613",
            "gpt-3.5-turbo-1106",
            "gpt-3.5-turbo-0125",
            "gpt-3.5-turbo-16k-0613",
        ],
    ] = Field(
        ...,
        description="ID of the model to use. See the [model endpoint compatibility](/docs/models/model-endpoint-compatibility) table for details on which models work with the Chat API.",
        examples=["gpt-4-turbo"],
    )
    frequency_penalty: Optional[confloat(ge=-2.0, le=2.0)] = Field(
        0,
        description="Number between -2.0 and 2.0. Positive values penalize new tokens based on their existing frequency in the text so far, decreasing the model's likelihood to repeat the same line verbatim.\n\n[See more information about frequency and presence penalties.](/docs/guides/text-generation/parameter-details)\n",
    )
    logit_bias: Optional[Dict[str, int]] = Field(
        None,
        description="Modify the likelihood of specified tokens appearing in the completion.\n\nAccepts a JSON object that maps tokens (specified by their token ID in the tokenizer) to an associated bias value from -100 to 100. Mathematically, the bias is added to the logits generated by the model prior to sampling. The exact effect will vary per model, but values between -1 and 1 should decrease or increase likelihood of selection; values like -100 or 100 should result in a ban or exclusive selection of the relevant token.\n",
    )
    logprobs: Optional[bool] = Field(
        False,
        description="Whether to return log probabilities of the output tokens or not. If true, returns the log probabilities of each output token returned in the `content` of `message`.",
    )
    top_logprobs: Optional[conint(ge=0, le=20)] = Field(
        None,
        description="An integer between 0 and 20 specifying the number of most likely tokens to return at each token position, each with an associated log probability. `logprobs` must be set to `true` if this parameter is used.",
    )
    max_tokens: Optional[int] = Field(
        None,
        description="The maximum number of [tokens](/tokenizer) that can be generated in the chat completion.\n\nThe total length of input tokens and generated tokens is limited by the model's context length. [Example Python code](https://cookbook.openai.com/examples/how_to_count_tokens_with_tiktoken) for counting tokens.\n",
    )
    n: Optional[conint(ge=1, le=128)] = Field(
        1,
        description="How many chat completion choices to generate for each input message. Note that you will be charged based on the number of generated tokens across all of the choices. Keep `n` as `1` to minimize costs.",
        examples=[1],
    )
    presence_penalty: Optional[confloat(ge=-2.0, le=2.0)] = Field(
        0,
        description="Number between -2.0 and 2.0. Positive values penalize new tokens based on whether they appear in the text so far, increasing the model's likelihood to talk about new topics.\n\n[See more information about frequency and presence penalties.](/docs/guides/text-generation/parameter-details)\n",
    )
    response_format: Optional[ResponseFormat] = Field(
        None,
        description='An object specifying the format that the model must output. Compatible with [GPT-4 Turbo](/docs/models/gpt-4-and-gpt-4-turbo) and all GPT-3.5 Turbo models newer than `gpt-3.5-turbo-1106`.\n\nSetting to `{ "type": "json_object" }` enables JSON mode, which guarantees the message the model generates is valid JSON.\n\n**Important:** when using JSON mode, you **must** also instruct the model to produce JSON yourself via a system or user message. Without this, the model may generate an unending stream of whitespace until the generation reaches the token limit, resulting in a long-running and seemingly "stuck" request. Also note that the message content may be partially cut off if `finish_reason="length"`, which indicates the generation exceeded `max_tokens` or the conversation exceeded the max context length.\n',
    )
    seed: Optional[conint(ge=-9223372036854775808, le=9223372036854775807)] = Field(
        None,
        description="This feature is in Beta.\nIf specified, our system will make a best effort to sample deterministically, such that repeated requests with the same `seed` and parameters should return the same result.\nDeterminism is not guaranteed, and you should refer to the `system_fingerprint` response parameter to monitor changes in the backend.\n",
    )
    stop: Union[Optional[str], List[str]] = Field(
        None,
        description="Up to 4 sequences where the API will stop generating further tokens.\n",
    )
    stream: Optional[bool] = Field(
        False,
        description="If set, partial message deltas will be sent, like in ChatGPT. Tokens will be sent as data-only [server-sent events](https://developer.mozilla.org/en-US/docs/Web/API/Server-sent_events/Using_server-sent_events#Event_stream_format) as they become available, with the stream terminated by a `data: [DONE]` message. [Example Python code](https://cookbook.openai.com/examples/how_to_stream_completions).\n",
    )
    temperature: Optional[confloat(ge=0.0, le=2.0)] = Field(
        1,
        description="What sampling temperature to use, between 0 and 2. Higher values like 0.8 will make the output more random, while lower values like 0.2 will make it more focused and deterministic.\n\nWe generally recommend altering this or `top_p` but not both.\n",
        examples=[1],
    )
    top_p: Optional[confloat(ge=0.0, le=1.0)] = Field(
        1,
        description="An alternative to sampling with temperature, called nucleus sampling, where the model considers the results of the tokens with top_p probability mass. So 0.1 means only the tokens comprising the top 10% probability mass are considered.\n\nWe generally recommend altering this or `temperature` but not both.\n",
        examples=[1],
    )
    tools: Optional[List[ChatCompletionTool]] = Field(
        None,
        description="A list of tools the model may call. Currently, only functions are supported as a tool. Use this to provide a list of functions the model may generate JSON inputs for. A max of 128 functions are supported.\n",
    )
    tool_choice: Optional[
        Union[Literal["none", "auto"], ChatCompletionNamedToolChoice]
    ] = Field(
        None,
        description='Controls which (if any) function is called by the model.\n`none` means the model will not call a function and instead generates a message.\n`auto` means the model can pick between generating a message or calling a function.\nSpecifying a particular function via `{"type": "function", "function": {"name": "my_function"}}` forces the model to call that function.\n\n`none` is the default when no functions are present. `auto` is the default if functions are present.\n',
    )
    user: Optional[str] = Field(
        None,
        description="A unique identifier representing your end-user, which can help OpenAI to monitor and detect abuse. [Learn more](/docs/guides/safety-best-practices/end-user-ids).\n",
        examples=["user-1234"],
    )
    function_call: Optional[
        Union[Literal["none", "auto"], ChatCompletionFunctionCallOption]
    ] = Field(
        None,
        description='Deprecated in favor of `tool_choice`.\n\nControls which (if any) function is called by the model.\n`none` means the model will not call a function and instead generates a message.\n`auto` means the model can pick between generating a message or calling a function.\nSpecifying a particular function via `{"name": "my_function"}` forces the model to call that function.\n\n`none` is the default when no functions are present. `auto` is the default if functions are present.\n',
    )
    functions: Optional[List[ChatCompletionFunctions]] = Field(
        None,
        description="Deprecated in favor of `tools`.\n\nA list of functions the model may generate JSON inputs for.\n",
        max_length=128,
        min_length=1,
    )


class RunStepObject(BaseModel):
    id: str = Field(
        ...,
        description="The identifier of the run step, which can be referenced in API endpoints.",
    )
    object: Literal["thread.run.step"] = Field(
        ..., description="The object type, which is always `thread.run.step`."
    )
    created_at: int = Field(
        ...,
        description="The Unix timestamp (in seconds) for when the run step was created.",
    )
    assistant_id: str = Field(
        ...,
        description="The ID of the [assistant](/docs/api-reference/assistants) associated with the run step.",
    )
    thread_id: str = Field(
        ...,
        description="The ID of the [thread](/docs/api-reference/threads) that was run.",
    )
    run_id: str = Field(
        ...,
        description="The ID of the [run](/docs/api-reference/runs) that this run step is a part of.",
    )
    type: Literal["message_creation", "tool_calls"] = Field(
        ...,
        description="The type of run step, which can be either `message_creation` or `tool_calls`.",
    )
    status: Literal["in_progress", "cancelled", "failed", "completed", "expired"] = (
        Field(
            ...,
            description="The status of the run step, which can be either `in_progress`, `cancelled`, `failed`, `completed`, or `expired`.",
        )
    )
    step_details: Union[
        RunStepDetailsMessageCreationObject, RunStepDetailsToolCallsObject
    ] = Field(..., description="The details of the run step.")
    last_error: Optional[LastError1] = Field(
        ...,
        description="The last error associated with this run step. Will be `null` if there are no errors.",
    )
    expired_at: Optional[int] = Field(
        ...,
        description="The Unix timestamp (in seconds) for when the run step expired. A step is considered expired if the parent run is expired.",
    )
    cancelled_at: Optional[int] = Field(
        ...,
        description="The Unix timestamp (in seconds) for when the run step was cancelled.",
    )
    failed_at: Optional[int] = Field(
        ..., description="The Unix timestamp (in seconds) for when the run step failed."
    )
    completed_at: Optional[int] = Field(
        ...,
        description="The Unix timestamp (in seconds) for when the run step completed.",
    )
    metadata: Optional[Dict[str, Any]] = Field(
        ...,
        description="Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.\n",
    )
    usage: RunStepCompletionUsage


class Delta1(BaseModel):
    step_details: Optional[
        Union[
            RunStepDeltaStepDetailsMessageCreationObject,
            RunStepDeltaStepDetailsToolCallsObject,
        ]
    ] = Field(None, description="The details of the run step.")


class RunStepDeltaObject(BaseModel):
    id: str = Field(
        ...,
        description="The identifier of the run step, which can be referenced in API endpoints.",
    )
    object: Literal["thread.run.step.delta"] = Field(
        ..., description="The object type, which is always `thread.run.step.delta`."
    )
    delta: Delta1 = Field(
        ...,
        description="The delta containing the fields that have changed on the run step.",
    )


class ListRunStepsResponse(BaseModel):
    object: str = Field(..., examples=["list"])
    data: List[RunStepObject]
    first_id: str = Field(..., examples=["step_abc123"])
    last_id: str = Field(..., examples=["step_abc456"])
    has_more: bool = Field(..., examples=[False])


class RunStepStreamEvent1(BaseModel):
    event: Literal["thread.run.step.created"]
    data: RunStepObject


class RunStepStreamEvent2(BaseModel):
    event: Literal["thread.run.step.in_progress"]
    data: RunStepObject


class RunStepStreamEvent3(BaseModel):
    event: Literal["thread.run.step.delta"]
    data: RunStepDeltaObject


class RunStepStreamEvent4(BaseModel):
    event: Literal["thread.run.step.completed"]
    data: RunStepObject


class RunStepStreamEvent5(BaseModel):
    event: Literal["thread.run.step.failed"]
    data: RunStepObject


class RunStepStreamEvent6(BaseModel):
    event: Literal["thread.run.step.cancelled"]
    data: RunStepObject


class RunStepStreamEvent7(BaseModel):
    event: Literal["thread.run.step.expired"]
    data: RunStepObject


class AssistantStreamEvent(
    RootModel[
        Union[
            ErrorEvent,
            DoneEvent,
            ThreadStreamEvent1,
            Union[
                RunStreamEvent1,
                RunStreamEvent2,
                RunStreamEvent3,
                RunStreamEvent4,
                RunStreamEvent5,
                RunStreamEvent6,
                RunStreamEvent7,
                RunStreamEvent8,
                RunStreamEvent9,
            ],
            Union[
                RunStepStreamEvent1,
                RunStepStreamEvent2,
                RunStepStreamEvent3,
                RunStepStreamEvent4,
                RunStepStreamEvent5,
                RunStepStreamEvent6,
                RunStepStreamEvent7,
            ],
            Union[
                MessageStreamEvent1,
                MessageStreamEvent2,
                MessageStreamEvent3,
                MessageStreamEvent4,
                MessageStreamEvent5,
            ],
        ]
    ]
):
    root: Union[
        ErrorEvent,
        DoneEvent,
        ThreadStreamEvent1,
        Union[
            RunStreamEvent1,
            RunStreamEvent2,
            RunStreamEvent3,
            RunStreamEvent4,
            RunStreamEvent5,
            RunStreamEvent6,
            RunStreamEvent7,
            RunStreamEvent8,
            RunStreamEvent9,
        ],
        Union[
            RunStepStreamEvent1,
            RunStepStreamEvent2,
            RunStepStreamEvent3,
            RunStepStreamEvent4,
            RunStepStreamEvent5,
            RunStepStreamEvent6,
            RunStepStreamEvent7,
        ],
        Union[
            MessageStreamEvent1,
            MessageStreamEvent2,
            MessageStreamEvent3,
            MessageStreamEvent4,
            MessageStreamEvent5,
        ],
    ] = Field(
        ...,
        description='Represents an event emitted when streaming a Run.\n\nEach event in a server-sent events stream has an `event` and `data` property:\n\n```\nevent: thread.created\ndata: {"id": "thread_123", "object": "thread", ...}\n```\n\nWe emit events whenever a new object is created, transitions to a new state, or is being\nstreamed in parts (deltas). For example, we emit `thread.run.created` when a new run\nis created, `thread.run.completed` when a run completes, and so on. When an Assistant chooses\nto create a message during a run, we emit a `thread.message.created event`, a\n`thread.message.in_progress` event, many `thread.message.delta` events, and finally a\n`thread.message.completed` event.\n\nWe may add additional events over time, so we recommend handling unknown events gracefully\nin your code. See the [Assistants API quickstart](/docs/assistants/overview) to learn how to\nintegrate the Assistants API with streaming.\n',
    )
