---
timestamp: 2025-08-26T01:42:58.729008
type: agent_engineer
metadata: {"agent_type": "engineer", "agent_id": "engineer_b34a6307-9304-4961-b5a8-0d659444aa07", "session_id": "b34a6307-9304-4961-b5a8-0d659444aa07", "delegation_context": {"description": "Fix agent-manager template", "timestamp": "2025-08-26T01:42:58.728080"}}
---


AGENT MEMORY - PROJECT-SPECIFIC KNOWLEDGE:
# Agent Memory: engineer
<!-- Last Updated: 2025-08-26T01:42:58.720337Z -->



INSTRUCTIONS: Review your memory above before proceeding. Apply learned patterns and avoid known mistakes.


Fix the agent-manager template with proper schema and metadata based on the research findings.

The research identified these critical missing components:
1. Schema version fields (schema_version, agent_version, template_version, template_changelog)
2. Expanded metadata (created_at, updated_at, color)
3. Complete capabilities configuration (resource_tier, temperature, max_tokens, timeout, limits, tools array)
4. Embedded instructions instead of just reference
5. Knowledge configuration (domain_expertise, best_practices, constraints, examples)
6. Dependencies specification (python, system packages)
7. Memory routing configuration for the memory system
8. Interactions protocol (input/output format, handoff_agents, triggers)
9. Testing configuration with test cases and benchmarks

Please:
1. Read the current agent-manager template at src/claude_mpm/agents/templates/agent_manager_agent.json
2. Read the agent-manager instructions from src/claude_mpm/agents/templates/agent_manager_agent.md
3. Look at well-structured templates like engineer_agent.json and research_agent.json as references
4. Update the agent-manager template with ALL missing components identified
5. Ensure the template follows the same comprehensive structure as other production agents
6. Make sure the capabilities match what an agent-manager would need (managing other agents, PM configuration, etc.)
7. Include appropriate memory routing rules for storing agent management knowledge

The agent-manager is a critical system agent that manages agent creation, customization, deployment, and PM instruction configuration, so it needs a complete and robust template structure.