"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AlbToLambda = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constructs_1 = require("constructs");
const defaults = require("@aws-solutions-constructs/core");
const core_1 = require("@aws-solutions-constructs/core");
class AlbToLambda extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        defaults.CheckAlbProps(props);
        defaults.CheckVpcProps(props);
        defaults.CheckLambdaProps(props);
        // Obtain VPC for construct (existing or created)
        this.vpc = defaults.buildVpc(scope, {
            existingVpc: props.existingVpc,
            defaultVpcProps: props.publicApi ? defaults.DefaultPublicPrivateVpcProps() : defaults.DefaultIsolatedVpcProps(),
            userVpcProps: props.vpcProps,
            constructVpcProps: props.publicApi ? {} : { enableDnsHostnames: true, enableDnsSupport: true }
        });
        this.loadBalancer = defaults.ObtainAlb(this, id, {
            vpc: this.vpc,
            publicApi: props.publicApi,
            existingLoadBalancerObj: props.existingLoadBalancerObj,
            loadBalancerProps: props.loadBalancerProps,
            logAccessLogs: props.logAlbAccessLogs,
            loggingBucketProps: props.albLoggingBucketProps
        });
        // Obtain Lambda function for construct (existing or created)
        this.lambdaFunction = defaults.buildLambdaFunction(this, {
            existingLambdaObj: props.existingLambdaObj,
            lambdaFunctionProps: props.lambdaFunctionProps,
            vpc: this.vpc
        });
        let newListener;
        if (this.loadBalancer.listeners.length === 0) {
            newListener = true;
        }
        else {
            newListener = false;
        }
        // If there's no listener, then we add one here
        if (newListener) {
            this.listener = defaults.AddListener(this, id, this.loadBalancer, props.listenerProps);
        }
        else {
            this.listener = core_1.GetActiveListener(this.loadBalancer.listeners);
        }
        const newTargetGroup = defaults.AddLambdaTarget(this, `tg${this.loadBalancer.listeners.length + 1}`, this.listener, this.lambdaFunction, props.ruleProps, props.targetProps);
        // this.listener needs to be set on the construct.
        // could be above: else { defaults.GetActiveListener }
        // do we then move that functionality back into the construct (not the function). If so do
        // we leave it in AddNewTarget or just do it here and pass the listener?
        if (newListener && this.listener) {
            const levelOneListener = this.listener.node.defaultChild;
            const cfnTargetGroup = newTargetGroup.node.defaultChild;
            levelOneListener.addDependency(cfnTargetGroup);
        }
    }
}
exports.AlbToLambda = AlbToLambda;
_a = JSII_RTTI_SYMBOL_1;
AlbToLambda[_a] = { fqn: "@aws-solutions-constructs/aws-alb-lambda.AlbToLambda", version: "2.53.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJpbmRleC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQWlCQSwyQ0FBdUM7QUFDdkMsMkRBQTJEO0FBRTNELHlEQUFtRTtBQStGbkUsTUFBYSxXQUFZLFNBQVEsc0JBQVM7SUFNeEMsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxLQUF1QjtRQUMvRCxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBQ2pCLFFBQVEsQ0FBQyxhQUFhLENBQUMsS0FBSyxDQUFDLENBQUM7UUFDOUIsUUFBUSxDQUFDLGFBQWEsQ0FBQyxLQUFLLENBQUMsQ0FBQztRQUM5QixRQUFRLENBQUMsZ0JBQWdCLENBQUMsS0FBSyxDQUFDLENBQUM7UUFFakMsaURBQWlEO1FBQ2pELElBQUksQ0FBQyxHQUFHLEdBQUcsUUFBUSxDQUFDLFFBQVEsQ0FBQyxLQUFLLEVBQUU7WUFDbEMsV0FBVyxFQUFFLEtBQUssQ0FBQyxXQUFXO1lBQzlCLGVBQWUsRUFBRSxLQUFLLENBQUMsU0FBUyxDQUFDLENBQUMsQ0FBQyxRQUFRLENBQUMsNEJBQTRCLEVBQUUsQ0FBQyxDQUFDLENBQUMsUUFBUSxDQUFDLHVCQUF1QixFQUFFO1lBQy9HLFlBQVksRUFBRSxLQUFLLENBQUMsUUFBUTtZQUM1QixpQkFBaUIsRUFBRSxLQUFLLENBQUMsU0FBUyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLEVBQUUsa0JBQWtCLEVBQUUsSUFBSSxFQUFFLGdCQUFnQixFQUFFLElBQUksRUFBRTtTQUMvRixDQUFDLENBQUM7UUFFSCxJQUFJLENBQUMsWUFBWSxHQUFHLFFBQVEsQ0FBQyxTQUFTLENBQUMsSUFBSSxFQUFFLEVBQUUsRUFBRTtZQUMvQyxHQUFHLEVBQUUsSUFBSSxDQUFDLEdBQUc7WUFDYixTQUFTLEVBQUUsS0FBSyxDQUFDLFNBQVM7WUFDMUIsdUJBQXVCLEVBQUUsS0FBSyxDQUFDLHVCQUF1QjtZQUN0RCxpQkFBaUIsRUFBRSxLQUFLLENBQUMsaUJBQWlCO1lBQzFDLGFBQWEsRUFBRSxLQUFLLENBQUMsZ0JBQWdCO1lBQ3JDLGtCQUFrQixFQUFFLEtBQUssQ0FBQyxxQkFBcUI7U0FDaEQsQ0FBQyxDQUFDO1FBRUgsNkRBQTZEO1FBQzdELElBQUksQ0FBQyxjQUFjLEdBQUcsUUFBUSxDQUFDLG1CQUFtQixDQUFDLElBQUksRUFBRTtZQUN2RCxpQkFBaUIsRUFBRSxLQUFLLENBQUMsaUJBQWlCO1lBQzFDLG1CQUFtQixFQUFFLEtBQUssQ0FBQyxtQkFBbUI7WUFDOUMsR0FBRyxFQUFFLElBQUksQ0FBQyxHQUFHO1NBQ2QsQ0FBQyxDQUFDO1FBRUgsSUFBSSxXQUFvQixDQUFDO1FBQ3pCLElBQUksSUFBSSxDQUFDLFlBQVksQ0FBQyxTQUFTLENBQUMsTUFBTSxLQUFLLENBQUMsRUFBRTtZQUM1QyxXQUFXLEdBQUcsSUFBSSxDQUFDO1NBQ3BCO2FBQU07WUFDTCxXQUFXLEdBQUcsS0FBSyxDQUFDO1NBQ3JCO1FBRUQsK0NBQStDO1FBQy9DLElBQUksV0FBVyxFQUFFO1lBQ2YsSUFBSSxDQUFDLFFBQVEsR0FBRyxRQUFRLENBQUMsV0FBVyxDQUFDLElBQUksRUFBRSxFQUFFLEVBQUUsSUFBSSxDQUFDLFlBQVksRUFBRSxLQUFLLENBQUMsYUFBYSxDQUFDLENBQUM7U0FDeEY7YUFBTTtZQUNMLElBQUksQ0FBQyxRQUFRLEdBQUcsd0JBQWlCLENBQUMsSUFBSSxDQUFDLFlBQVksQ0FBQyxTQUFTLENBQUMsQ0FBQztTQUNoRTtRQUVELE1BQU0sY0FBYyxHQUFHLFFBQVEsQ0FBQyxlQUFlLENBQzdDLElBQUksRUFDSixLQUFLLElBQUksQ0FBQyxZQUFZLENBQUMsU0FBUyxDQUFDLE1BQU0sR0FBRyxDQUFDLEVBQUUsRUFDN0MsSUFBSSxDQUFDLFFBQVEsRUFDYixJQUFJLENBQUMsY0FBYyxFQUNuQixLQUFLLENBQUMsU0FBUyxFQUNmLEtBQUssQ0FBQyxXQUFXLENBQUMsQ0FBQztRQUVyQixrREFBa0Q7UUFDbEQsc0RBQXNEO1FBQ3RELDBGQUEwRjtRQUMxRix3RUFBd0U7UUFDeEUsSUFBSSxXQUFXLElBQUksSUFBSSxDQUFDLFFBQVEsRUFBRTtZQUNoQyxNQUFNLGdCQUFnQixHQUFHLElBQUksQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLFlBQTJCLENBQUM7WUFDeEUsTUFBTSxjQUFjLEdBQUcsY0FBYyxDQUFDLElBQUksQ0FBQyxZQUE4QixDQUFDO1lBQzFFLGdCQUFnQixDQUFDLGFBQWEsQ0FBQyxjQUFjLENBQUMsQ0FBQztTQUNoRDtJQUNILENBQUM7O0FBbkVILGtDQW9FQyIsInNvdXJjZXNDb250ZW50IjpbIi8qKlxuICogIENvcHlyaWdodCBBbWF6b24uY29tLCBJbmMuIG9yIGl0cyBhZmZpbGlhdGVzLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuICpcbiAqICBMaWNlbnNlZCB1bmRlciB0aGUgQXBhY2hlIExpY2Vuc2UsIFZlcnNpb24gMi4wICh0aGUgXCJMaWNlbnNlXCIpLiBZb3UgbWF5IG5vdCB1c2UgdGhpcyBmaWxlIGV4Y2VwdCBpbiBjb21wbGlhbmNlXG4gKiAgd2l0aCB0aGUgTGljZW5zZS4gQSBjb3B5IG9mIHRoZSBMaWNlbnNlIGlzIGxvY2F0ZWQgYXRcbiAqXG4gKiAgICAgIGh0dHA6Ly93d3cuYXBhY2hlLm9yZy9saWNlbnNlcy9MSUNFTlNFLTIuMFxuICpcbiAqICBvciBpbiB0aGUgJ2xpY2Vuc2UnIGZpbGUgYWNjb21wYW55aW5nIHRoaXMgZmlsZS4gVGhpcyBmaWxlIGlzIGRpc3RyaWJ1dGVkIG9uIGFuICdBUyBJUycgQkFTSVMsIFdJVEhPVVQgV0FSUkFOVElFU1xuICogIE9SIENPTkRJVElPTlMgT0YgQU5ZIEtJTkQsIGV4cHJlc3Mgb3IgaW1wbGllZC4gU2VlIHRoZSBMaWNlbnNlIGZvciB0aGUgc3BlY2lmaWMgbGFuZ3VhZ2UgZ292ZXJuaW5nIHBlcm1pc3Npb25zXG4gKiAgYW5kIGxpbWl0YXRpb25zIHVuZGVyIHRoZSBMaWNlbnNlLlxuICovXG5cbmltcG9ydCAqIGFzIGVsYiBmcm9tIFwiYXdzLWNkay1saWIvYXdzLWVsYXN0aWNsb2FkYmFsYW5jaW5ndjJcIjtcbmltcG9ydCAqIGFzIGVjMiBmcm9tIFwiYXdzLWNkay1saWIvYXdzLWVjMlwiO1xuaW1wb3J0ICogYXMgczMgZnJvbSBcImF3cy1jZGstbGliL2F3cy1zM1wiO1xuaW1wb3J0ICogYXMgbGFtYmRhIGZyb20gXCJhd3MtY2RrLWxpYi9hd3MtbGFtYmRhXCI7XG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tIFwiY29uc3RydWN0c1wiO1xuaW1wb3J0ICogYXMgZGVmYXVsdHMgZnJvbSBcIkBhd3Mtc29sdXRpb25zLWNvbnN0cnVjdHMvY29yZVwiO1xuaW1wb3J0IHsgQ2ZuTGlzdGVuZXIsIENmblRhcmdldEdyb3VwIH0gZnJvbSBcImF3cy1jZGstbGliL2F3cy1lbGFzdGljbG9hZGJhbGFuY2luZ3YyXCI7XG5pbXBvcnQgeyBHZXRBY3RpdmVMaXN0ZW5lciB9IGZyb20gXCJAYXdzLXNvbHV0aW9ucy1jb25zdHJ1Y3RzL2NvcmVcIjtcblxuZXhwb3J0IGludGVyZmFjZSBBbGJUb0xhbWJkYVByb3BzIHtcbiAgLyoqXG4gICAqIE9wdGlvbmFsIGN1c3RvbSBwcm9wZXJ0aWVzIGZvciBhIG5ldyBsb2FkQmFsYW5jZXIuIFByb3ZpZGluZyBib3RoIHRoaXMgYW5kXG4gICAqIGV4aXN0aW5nTG9hZEJhbGFuY2VyIGlzIGFuIGVycm9yLiBUaGlzIGNhbm5vdCBzcGVjaWZ5IGEgVlBDLCBpdCB3aWxsIHVzZSB0aGUgVlBDXG4gICAqIGluIGV4aXN0aW5nVnBjIG9yIHRoZSBWUEMgY3JlYXRlZCBieSB0aGUgY29uc3RydWN0LlxuICAgKlxuICAgKiBAZGVmYXVsdCAtIG5vbmVcbiAgICovXG4gIHJlYWRvbmx5IGxvYWRCYWxhbmNlclByb3BzPzogZWxiLkFwcGxpY2F0aW9uTG9hZEJhbGFuY2VyUHJvcHMgfCBhbnk7XG4gIC8qKlxuICAgKiBFeGlzdGluZyBBcHBsaWNhdGlvbiBMb2FkIEJhbGFuY2VyIHRvIGluY29ycG9yYXRlIGludG8gdGhlXG4gICAqIGNvbnN0cnVjdCBhcmNoaXRlY3R1cmUuIFByb3ZpZGluZyBib3RoIHRoaXMgYW5kIGxvYWRCYWxhbmNlclByb3BzIGlzIGFuXG4gICAqIGVycm9yLiBUaGUgVlBDIGNvbnRhaW5pbmcgdGhpcyBsb2FkQmFsYW5jZXIgbXVzdCBtYXRjaCB0aGUgVlBDIHByb3ZpZGVkIGluIGV4aXN0aW5nVnBjLlxuICAgKlxuICAgKiBAZGVmYXVsdCAtIG5vbmVcbiAgICovXG4gIHJlYWRvbmx5IGV4aXN0aW5nTG9hZEJhbGFuY2VyT2JqPzogZWxiLkFwcGxpY2F0aW9uTG9hZEJhbGFuY2VyO1xuICAvKipcbiAgICogRXhpc3RpbmcgaW5zdGFuY2Ugb2YgTGFtYmRhIEZ1bmN0aW9uIG9iamVjdCwgcHJvdmlkaW5nIGJvdGggdGhpcyBhbmRcbiAgICogYGxhbWJkYUZ1bmN0aW9uUHJvcHNgIHdpbGwgY2F1c2UgYW4gZXJyb3IuXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gTm9uZVxuICAgKi9cbiAgcmVhZG9ubHkgZXhpc3RpbmdMYW1iZGFPYmo/OiBsYW1iZGEuRnVuY3Rpb247XG4gIC8qKlxuICAgKiBVc2VyIHByb3ZpZGVkIHByb3BzIHRvIG92ZXJyaWRlIHRoZSBkZWZhdWx0IHByb3BzIGZvciB0aGUgTGFtYmRhIGZ1bmN0aW9uLlxuICAgKlxuICAgKiBAZGVmYXVsdCAtIERlZmF1bHQgcHJvcHMgYXJlIHVzZWRcbiAgICovXG4gIHJlYWRvbmx5IGxhbWJkYUZ1bmN0aW9uUHJvcHM/OiBsYW1iZGEuRnVuY3Rpb25Qcm9wcztcbiAgLyoqXG4gICAqIFByb3BzIHRvIGRlZmluZSB0aGUgbGlzdGVuZXIuIE11c3QgYmUgcHJvdmlkZWQgd2hlbiBhZGRpbmcgdGhlIGxpc3RlbmVyXG4gICAqIHRvIGFuIEFMQiAoZWcgLSB3aGVuIGNyZWF0aW5nIHRoZSBhbGIpLCBtYXkgbm90IGJlIHByb3ZpZGVkIHdoZW4gYWRkaW5nXG4gICAqIGEgc2Vjb25kIHRhcmdldCB0byBhbiBhbHJlYWR5IGVzdGFibGlzaGVkIGxpc3RlbmVyLiBXaGVuIHByb3ZpZGVkLCBtdXN0IGluY2x1ZGVcbiAgICogZWl0aGVyIGEgY2VydGlmaWNhdGUgb3IgcHJvdG9jb2w6IEhUVFBcbiAgICpcbiAgICogQGRlZmF1bHQgLSBub25lXG4gICAqL1xuICByZWFkb25seSBsaXN0ZW5lclByb3BzPzogZWxiLkFwcGxpY2F0aW9uTGlzdGVuZXJQcm9wcyB8IGFueTtcbiAgLyoqXG4gICAqIE9wdGlvbmFsIGN1c3RvbSBwcm9wZXJ0aWVzIGZvciBhIG5ldyB0YXJnZXQgZ3JvdXAuIFdoaWxlIHRoaXMgaXMgYSBzdGFuZGFyZFxuICAgKiBhdHRyaWJ1dGUgb2YgcHJvcHMgZm9yIEFMQiBjb25zdHJ1Y3RzLCB0aGVyZSBhcmUgZmV3IHBlcnRpbmVudCBwcm9wZXJ0aWVzIGZvciBhIExhbWJkYSB0YXJnZXQuXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gbm9uZVxuICAgKlxuICAgKi9cbiAgcmVhZG9ubHkgdGFyZ2V0UHJvcHM/OiBlbGIuQXBwbGljYXRpb25UYXJnZXRHcm91cFByb3BzO1xuICAvKipcbiAgICogUnVsZXMgZm9yIGRpcmVjdGluZyB0cmFmZmljIHRvIHRoZSB0YXJnZXQgYmVpbmcgY3JlYXRlZC4gTWF5IG5vdCBiZSBzcGVjaWZpZWRcbiAgICogZm9yIHRoZSBmaXJzdCBsaXN0ZW5lciBhZGRlZCB0byBhbiBBTEIsIGFuZCBtdXN0IGJlIHNwZWNpZmllZCBmb3IgdGhlIHNlY29uZFxuICAgKiB0YXJnZXQgYWRkZWQgdG8gYSBsaXN0ZW5lci4gQWRkIGEgc2Vjb25kIHRhcmdldCBieSBpbnN0YW50aWF0aW5nIHRoaXMgY29uc3RydWN0IGFcbiAgICogc2Vjb25kIHRpbWUgYW5kIHByb3ZpZGluZyB0aGUgZXhpc3RpbmdBbGIgZnJvbSB0aGUgZmlyc3QgaW5zdGFudGlhdGlvbi5cbiAgICpcbiAgICogQGRlZmF1bHQgLSBub25lXG4gICAqL1xuICByZWFkb25seSBydWxlUHJvcHM/OiBlbGIuQWRkUnVsZVByb3BzO1xuICAvKipcbiAgICogT3B0aW9uYWwgY3VzdG9tIHByb3BlcnRpZXMgZm9yIGEgVlBDIHRoZSBjb25zdHJ1Y3Qgd2lsbCBjcmVhdGUuIFRoaXMgVlBDIHdpbGxcbiAgICogYmUgdXNlZCBieSB0aGUgbmV3IEFMQiBhbmQgYW55IFByaXZhdGUgSG9zdGVkIFpvbmUgdGhlIGNvbnN0cnVjdCBjcmVhdGVzICh0aGF0J3NcbiAgICogd2h5IGxvYWRCYWxhbmNlclByb3BzIGFuZCBwcml2YXRlSG9zdGVkWm9uZVByb3BzIGNhbid0IGluY2x1ZGUgYSBWUEMpLiBQcm92aWRpbmdcbiAgICogYm90aCB0aGlzIGFuZCBleGlzdGluZ1ZwYyBpcyBhbiBlcnJvci5cbiAgICpcbiAgICogQGRlZmF1bHQgLSBub25lXG4gICAqL1xuICByZWFkb25seSB2cGNQcm9wcz86IGVjMi5WcGNQcm9wcztcbiAgLyoqXG4gICAqIEFuIGV4aXN0aW5nIFZQQyBpbiB3aGljaCB0byBkZXBsb3kgdGhlIGNvbnN0cnVjdC4gUHJvdmlkaW5nIGJvdGggdGhpcyBhbmRcbiAgICogdnBjUHJvcHMgaXMgYW4gZXJyb3IuIElmIHRoZSBjbGllbnQgcHJvdmlkZXMgYW4gZXhpc3RpbmcgbG9hZCBiYWxhbmNlciBhbmQvb3JcbiAgICogZXhpc3RpbmcgUHJpdmF0ZSBIb3N0ZWQgWm9uZSwgdGhvc2UgY29uc3RydWN0cyBtdXN0IGV4aXN0IGluIHRoaXMgVlBDLlxuICAgKlxuICAgKiBAZGVmYXVsdCAtIG5vbmVcbiAgICovXG4gIHJlYWRvbmx5IGV4aXN0aW5nVnBjPzogZWMyLklWcGM7XG4gIC8qKlxuICAgKiBXaGV0aGVyIHRvIHR1cm4gb24gQWNjZXNzIExvZ3MgZm9yIHRoZSBBcHBsaWNhdGlvbiBMb2FkIEJhbGFuY2VyLiBVc2VzIGFuIFMzIGJ1Y2tldFxuICAgKiB3aXRoIGFzc29jaWF0ZWQgc3RvcmFnZSBjb3N0cy4gRW5hYmxpbmcgQWNjZXNzIExvZ2dpbmcgaXMgYSBiZXN0IHByYWN0aWNlLlxuICAgKlxuICAgKiBAZGVmYXVsdCAtIHRydWVcbiAgICovXG4gIHJlYWRvbmx5IGxvZ0FsYkFjY2Vzc0xvZ3M/OiBib29sZWFuLFxuICAvKipcbiAgICogT3B0aW9uYWwgcHJvcGVydGllcyB0byBjdXN0b21pemUgdGhlIGJ1Y2tldCB1c2VkIHRvIHN0b3JlIHRoZSBBTEIgQWNjZXNzXG4gICAqIExvZ3MuIFN1cHBseWluZyB0aGlzIGFuZCBzZXR0aW5nIGxvZ0FjY2Vzc0xvZ3MgdG8gZmFsc2UgaXMgYW4gZXJyb3IuXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gbm9uZVxuICAgKi9cbiAgcmVhZG9ubHkgYWxiTG9nZ2luZ0J1Y2tldFByb3BzPzogczMuQnVja2V0UHJvcHMsXG4gIC8qKlxuICAgKiBXaGV0aGVyIHRoZSBjb25zdHJ1Y3QgaXMgZGVwbG95aW5nIGEgcHJpdmF0ZSBvciBwdWJsaWMgQVBJLiBUaGlzIGhhcyBpbXBsaWNhdGlvbnMgZm9yIHRoZSBWUEMgYW5kIEFMQi5cbiAgICovXG4gIHJlYWRvbmx5IHB1YmxpY0FwaTogYm9vbGVhbjtcbn1cblxuZXhwb3J0IGNsYXNzIEFsYlRvTGFtYmRhIGV4dGVuZHMgQ29uc3RydWN0IHtcbiAgcHVibGljIHJlYWRvbmx5IGxvYWRCYWxhbmNlcjogZWxiLkFwcGxpY2F0aW9uTG9hZEJhbGFuY2VyO1xuICBwdWJsaWMgcmVhZG9ubHkgdnBjOiBlYzIuSVZwYztcbiAgcHVibGljIHJlYWRvbmx5IGxhbWJkYUZ1bmN0aW9uOiBsYW1iZGEuRnVuY3Rpb247XG4gIHB1YmxpYyByZWFkb25seSBsaXN0ZW5lcjogZWxiLkFwcGxpY2F0aW9uTGlzdGVuZXI7XG5cbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IEFsYlRvTGFtYmRhUHJvcHMpIHtcbiAgICBzdXBlcihzY29wZSwgaWQpO1xuICAgIGRlZmF1bHRzLkNoZWNrQWxiUHJvcHMocHJvcHMpO1xuICAgIGRlZmF1bHRzLkNoZWNrVnBjUHJvcHMocHJvcHMpO1xuICAgIGRlZmF1bHRzLkNoZWNrTGFtYmRhUHJvcHMocHJvcHMpO1xuXG4gICAgLy8gT2J0YWluIFZQQyBmb3IgY29uc3RydWN0IChleGlzdGluZyBvciBjcmVhdGVkKVxuICAgIHRoaXMudnBjID0gZGVmYXVsdHMuYnVpbGRWcGMoc2NvcGUsIHtcbiAgICAgIGV4aXN0aW5nVnBjOiBwcm9wcy5leGlzdGluZ1ZwYyxcbiAgICAgIGRlZmF1bHRWcGNQcm9wczogcHJvcHMucHVibGljQXBpID8gZGVmYXVsdHMuRGVmYXVsdFB1YmxpY1ByaXZhdGVWcGNQcm9wcygpIDogZGVmYXVsdHMuRGVmYXVsdElzb2xhdGVkVnBjUHJvcHMoKSxcbiAgICAgIHVzZXJWcGNQcm9wczogcHJvcHMudnBjUHJvcHMsXG4gICAgICBjb25zdHJ1Y3RWcGNQcm9wczogcHJvcHMucHVibGljQXBpID8ge30gOiB7IGVuYWJsZURuc0hvc3RuYW1lczogdHJ1ZSwgZW5hYmxlRG5zU3VwcG9ydDogdHJ1ZSB9XG4gICAgfSk7XG5cbiAgICB0aGlzLmxvYWRCYWxhbmNlciA9IGRlZmF1bHRzLk9idGFpbkFsYih0aGlzLCBpZCwge1xuICAgICAgdnBjOiB0aGlzLnZwYyxcbiAgICAgIHB1YmxpY0FwaTogcHJvcHMucHVibGljQXBpLFxuICAgICAgZXhpc3RpbmdMb2FkQmFsYW5jZXJPYmo6IHByb3BzLmV4aXN0aW5nTG9hZEJhbGFuY2VyT2JqLFxuICAgICAgbG9hZEJhbGFuY2VyUHJvcHM6IHByb3BzLmxvYWRCYWxhbmNlclByb3BzLFxuICAgICAgbG9nQWNjZXNzTG9nczogcHJvcHMubG9nQWxiQWNjZXNzTG9ncyxcbiAgICAgIGxvZ2dpbmdCdWNrZXRQcm9wczogcHJvcHMuYWxiTG9nZ2luZ0J1Y2tldFByb3BzXG4gICAgfSk7XG5cbiAgICAvLyBPYnRhaW4gTGFtYmRhIGZ1bmN0aW9uIGZvciBjb25zdHJ1Y3QgKGV4aXN0aW5nIG9yIGNyZWF0ZWQpXG4gICAgdGhpcy5sYW1iZGFGdW5jdGlvbiA9IGRlZmF1bHRzLmJ1aWxkTGFtYmRhRnVuY3Rpb24odGhpcywge1xuICAgICAgZXhpc3RpbmdMYW1iZGFPYmo6IHByb3BzLmV4aXN0aW5nTGFtYmRhT2JqLFxuICAgICAgbGFtYmRhRnVuY3Rpb25Qcm9wczogcHJvcHMubGFtYmRhRnVuY3Rpb25Qcm9wcyxcbiAgICAgIHZwYzogdGhpcy52cGNcbiAgICB9KTtcblxuICAgIGxldCBuZXdMaXN0ZW5lcjogYm9vbGVhbjtcbiAgICBpZiAodGhpcy5sb2FkQmFsYW5jZXIubGlzdGVuZXJzLmxlbmd0aCA9PT0gMCkge1xuICAgICAgbmV3TGlzdGVuZXIgPSB0cnVlO1xuICAgIH0gZWxzZSB7XG4gICAgICBuZXdMaXN0ZW5lciA9IGZhbHNlO1xuICAgIH1cblxuICAgIC8vIElmIHRoZXJlJ3Mgbm8gbGlzdGVuZXIsIHRoZW4gd2UgYWRkIG9uZSBoZXJlXG4gICAgaWYgKG5ld0xpc3RlbmVyKSB7XG4gICAgICB0aGlzLmxpc3RlbmVyID0gZGVmYXVsdHMuQWRkTGlzdGVuZXIodGhpcywgaWQsIHRoaXMubG9hZEJhbGFuY2VyLCBwcm9wcy5saXN0ZW5lclByb3BzKTtcbiAgICB9IGVsc2Uge1xuICAgICAgdGhpcy5saXN0ZW5lciA9IEdldEFjdGl2ZUxpc3RlbmVyKHRoaXMubG9hZEJhbGFuY2VyLmxpc3RlbmVycyk7XG4gICAgfVxuXG4gICAgY29uc3QgbmV3VGFyZ2V0R3JvdXAgPSBkZWZhdWx0cy5BZGRMYW1iZGFUYXJnZXQoXG4gICAgICB0aGlzLFxuICAgICAgYHRnJHt0aGlzLmxvYWRCYWxhbmNlci5saXN0ZW5lcnMubGVuZ3RoICsgMX1gLFxuICAgICAgdGhpcy5saXN0ZW5lcixcbiAgICAgIHRoaXMubGFtYmRhRnVuY3Rpb24sXG4gICAgICBwcm9wcy5ydWxlUHJvcHMsXG4gICAgICBwcm9wcy50YXJnZXRQcm9wcyk7XG5cbiAgICAvLyB0aGlzLmxpc3RlbmVyIG5lZWRzIHRvIGJlIHNldCBvbiB0aGUgY29uc3RydWN0LlxuICAgIC8vIGNvdWxkIGJlIGFib3ZlOiBlbHNlIHsgZGVmYXVsdHMuR2V0QWN0aXZlTGlzdGVuZXIgfVxuICAgIC8vIGRvIHdlIHRoZW4gbW92ZSB0aGF0IGZ1bmN0aW9uYWxpdHkgYmFjayBpbnRvIHRoZSBjb25zdHJ1Y3QgKG5vdCB0aGUgZnVuY3Rpb24pLiBJZiBzbyBkb1xuICAgIC8vIHdlIGxlYXZlIGl0IGluIEFkZE5ld1RhcmdldCBvciBqdXN0IGRvIGl0IGhlcmUgYW5kIHBhc3MgdGhlIGxpc3RlbmVyP1xuICAgIGlmIChuZXdMaXN0ZW5lciAmJiB0aGlzLmxpc3RlbmVyKSB7XG4gICAgICBjb25zdCBsZXZlbE9uZUxpc3RlbmVyID0gdGhpcy5saXN0ZW5lci5ub2RlLmRlZmF1bHRDaGlsZCBhcyBDZm5MaXN0ZW5lcjtcbiAgICAgIGNvbnN0IGNmblRhcmdldEdyb3VwID0gbmV3VGFyZ2V0R3JvdXAubm9kZS5kZWZhdWx0Q2hpbGQgYXMgQ2ZuVGFyZ2V0R3JvdXA7XG4gICAgICBsZXZlbE9uZUxpc3RlbmVyLmFkZERlcGVuZGVuY3koY2ZuVGFyZ2V0R3JvdXApO1xuICAgIH1cbiAgfVxufVxuIl19