from typing import List, Optional, Protocol

class SphinxConfig(Protocol):
    @property
    def extensions(self) -> Optional[List[str]]: ...
    @property
    def myst_enable_extensions(self) -> Optional[List[str]]: ...

class SphinxOptions(Protocol):
    @property
    def srcdir(self) -> str: ...
    @property
    def outdir(self) -> str: ...
    @property
    def conf(self) -> SphinxConfig: ...

class SourceMapper:
    def open(self, path: str) -> Doctree: ...
    def seal(self, doctree: Doctree) -> None: ...

class Bundler:
    def __new__(cls, options: SphinxOptions): ...
    def sourcemap(self) -> SourceMapper: ...
    def build(self, mapper: SourceMapper) -> None: ...

class Doctree:
    def element(
        self,
        tag: str,
        attrs: str,
        *,
        file: Optional[str] = None,
        line: Optional[int] = None,
        source: Optional[str] = None,
    ): ...
    def enter(self): ...
    def text(self, text: str): ...
    def exit(self): ...
