"""Code generated by Speakeasy (https://speakeasyapi.dev). DO NOT EDIT."""

from __future__ import annotations
import dataclasses
from dataclasses_json import Undefined, dataclass_json
from enum import Enum
from shippo import utils
from typing import Optional


class PaymentMethod(str, Enum):
    r"""Secured funds include money orders, certified cheques and others (see
    <a href=\"https://www.ups.com/content/us/en/shipping/time/service/value_added/cod.html\">UPS</a> for details). 
    If no payment_method inputted the value defaults to \"ANY\".)
    """
    SECURED_FUNDS = 'SECURED_FUNDS'
    CASH = 'CASH'
    ANY = 'ANY'


@dataclass_json(undefined=Undefined.EXCLUDE)
@dataclasses.dataclass
class Cod:
    r"""Specify collection on delivery details (UPS only)."""
    amount: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('amount'), 'exclude': lambda f: f is None }})
    r"""Amount to be collected."""
    currency: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('currency'), 'exclude': lambda f: f is None }})
    r"""Currency for the amount to be collected. Currently only USD is supported for UPS."""
    payment_method: Optional[PaymentMethod] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('payment_method'), 'exclude': lambda f: f is None }})
    r"""Secured funds include money orders, certified cheques and others (see
    <a href=\"https://www.ups.com/content/us/en/shipping/time/service/value_added/cod.html\">UPS</a> for details). 
    If no payment_method inputted the value defaults to \"ANY\".)
    """
    

