"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwesomeList = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const projen_1 = require("projen");
/**
 * Awesome List project.
 *
 * @stability stable
 * @pjid awesome-list
 */
class AwesomeList extends projen_1.JsiiProject {
    /**
     * @stability stable
     */
    constructor(options) {
        var _b, _c;
        super({
            ...options,
            readme: {
                filename: 'readme.md',
                contents: readmeContents(),
            },
            defaultReleaseBranch: 'main',
            releaseBranches: ['main'],
            gitpod: true,
            releaseToNpm: false,
        });
        new projen_1.SampleFile(this, 'code-of-conduct.md', {
            contents: this.codeOfConduct().replace('CONTACTEMAIL', (_b = options.contactEmail) !== null && _b !== void 0 ? _b : 'noreply@example.com'),
        });
        new projen_1.SampleFile(this, 'contributing.md', {
            contents: this.contributing(),
        });
        this._awesomeLint();
        (_c = this.gitpod) === null || _c === void 0 ? void 0 : _c.addCustomTask({
            name: 'Setup',
            command: 'npx projen Setup',
        });
    }
    _awesomeLint() {
        this.addDevDeps('awesome-lint');
        const awesomeLintTask = this.addTask('awesome-lint');
        awesomeLintTask.exec('npx awesome-lint');
        this.buildTask.reset(awesomeLintTask.toShellCommand());
    }
    codeOfConduct() {
        const contents = `# Contributor Covenant Code of Conduct

## Our Pledge

In the interest of fostering an open and welcoming environment, we as
contributors and maintainers pledge to making participation in our project and
our community a harassment-free experience for everyone, regardless of age, body
size, disability, ethnicity, gender identity and expression, level of experience,
nationality, personal appearance, race, religion, or sexual identity and
orientation.

## Our Standards

Examples of behavior that contributes to creating a positive environment
include:

* Using welcoming and inclusive language
* Being respectful of differing viewpoints and experiences
* Gracefully accepting constructive criticism
* Focusing on what is best for the community
* Showing empathy towards other community members

Examples of unacceptable behavior by participants include:

* The use of sexualized language or imagery and unwelcome sexual attention or
advances
* Trolling, insulting/derogatory comments, and personal or political attacks
* Public or private harassment
* Publishing others' private information, such as a physical or electronic
  address, without explicit permission
* Other conduct which could reasonably be considered inappropriate in a
  professional setting

## Our Responsibilities

Project maintainers are responsible for clarifying the standards of acceptable
behavior and are expected to take appropriate and fair corrective action in
response to any instances of unacceptable behavior.

Project maintainers have the right and responsibility to remove, edit, or
reject comments, commits, code, wiki edits, issues, and other contributions
that are not aligned to this Code of Conduct, or to ban temporarily or
permanently any contributor for other behaviors that they deem inappropriate,
threatening, offensive, or harmful.

## Scope

This Code of Conduct applies both within project spaces and in public spaces
when an individual is representing the project or its community. Examples of
representing a project or community include using an official project e-mail
address, posting via an official social media account, or acting as an appointed
representative at an online or offline event. Representation of a project may be
further defined and clarified by project maintainers.

## Enforcement

Instances of abusive, harassing, or otherwise unacceptable behavior may be
reported by contacting the project team at CONTACTEMAIL. All
complaints will be reviewed and investigated and will result in a response that
is deemed necessary and appropriate to the circumstances. The project team is
obligated to maintain confidentiality with regard to the reporter of an incident.
Further details of specific enforcement policies may be posted separately.

Project maintainers who do not follow or enforce the Code of Conduct in good
faith may face temporary or permanent repercussions as determined by other
members of the project's leadership.

## Attribution

This Code of Conduct is adapted from the [Contributor Covenant][homepage], version 1.4,
available at [http://contributor-covenant.org/version/1/4][version]

[homepage]: http://contributor-covenant.org
[version]: http://contributor-covenant.org/version/1/4/
    `;
        return contents;
    }
    contributing() {
        const contents = `# Contribution Guidelines

Please note that this project is released with a
[Contributor Code of Conduct](code-of-conduct.md). By participating in this
project you agree to abide by its terms.

## Adding an awesome list

Please ensure your pull request adheres to the [list guidelines](pull_request_template.md).

## Updating your PR

A lot of times, making a PR adhere to the standards above can be difficult.
If the maintainers notice anything that we'd like changed, we'll ask you to
edit your PR before we merge it. There's no need to open a new PR, just edit
the existing one. If you're not sure how to do that,
[here is a guide](https://github.com/RichardLitt/knowledge/blob/master/github/amending-a-commit-guide.md)
on the different ways you can update your PR so that we can merge it.
    `;
        return contents;
    }
}
exports.AwesomeList = AwesomeList;
_a = JSII_RTTI_SYMBOL_1;
AwesomeList[_a] = { fqn: "p6-projen-project-awesome-list.AwesomeList", version: "0.1.85" };
function readmeContents() {
    const contents = `# Awesome Projen [![Awesome](https://awesome.re/badge.svg)](https://awesome.re)

  > Curated list of awesome [PROJECT](REPOSITORY) SHORTDESC.

  LONGDESC

  ## Contents

  ## Contributing

  Contributions welcome! Read the [contribution guidelines](contributing.md) first.`;
    return contents;
}
//# sourceMappingURL=data:application/json;base64,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