# Pyrogram - Telegram MTProto API Client Library for Python
# Copyright (C) 2017-2019 Dan Tès <https://github.com/delivrance>
#
# This file is part of Pyrogram.
#
# Pyrogram is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License as published
# by the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Pyrogram is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with Pyrogram.  If not, see <http://www.gnu.org/licenses/>.

layer = 105

objects = {
    0x05162463: "pyrogram.api.types.ResPQ",
    0x83c95aec: "pyrogram.api.types.PQInnerData",
    0xa9f55f95: "pyrogram.api.types.PQInnerDataDc",
    0x3c6a84d4: "pyrogram.api.types.PQInnerDataTemp",
    0x56fddf88: "pyrogram.api.types.PQInnerDataTempDc",
    0x75a3f765: "pyrogram.api.types.BindAuthKeyInner",
    0x79cb045d: "pyrogram.api.types.ServerDHParamsFail",
    0xd0e8075c: "pyrogram.api.types.ServerDHParamsOk",
    0xb5890dba: "pyrogram.api.types.ServerDHInnerData",
    0x6643b654: "pyrogram.api.types.ClientDHInnerData",
    0x3bcbf734: "pyrogram.api.types.DhGenOk",
    0x46dc1fb9: "pyrogram.api.types.DhGenRetry",
    0xa69dae02: "pyrogram.api.types.DhGenFail",
    0xf660e1d4: "pyrogram.api.types.DestroyAuthKeyOk",
    0x0a9f2259: "pyrogram.api.types.DestroyAuthKeyNone",
    0xea109b13: "pyrogram.api.types.DestroyAuthKeyFail",
    0x60469778: "pyrogram.api.functions.ReqPq",
    0xbe7e8ef1: "pyrogram.api.functions.ReqPqMulti",
    0xd712e4be: "pyrogram.api.functions.ReqDHParams",
    0xf5045f1f: "pyrogram.api.functions.SetClientDHParams",
    0xd1435160: "pyrogram.api.functions.DestroyAuthKey",
    0x62d6b459: "pyrogram.api.types.MsgsAck",
    0xa7eff811: "pyrogram.api.types.BadMsgNotification",
    0xedab447b: "pyrogram.api.types.BadServerSalt",
    0xda69fb52: "pyrogram.api.types.MsgsStateReq",
    0x04deb57d: "pyrogram.api.types.MsgsStateInfo",
    0x8cc0d131: "pyrogram.api.types.MsgsAllInfo",
    0x276d3ec6: "pyrogram.api.types.MsgDetailedInfo",
    0x809db6df: "pyrogram.api.types.MsgNewDetailedInfo",
    0x7d861a08: "pyrogram.api.types.MsgResendReq",
    0x8610baeb: "pyrogram.api.types.MsgResendAnsReq",
    0xf35c6d01: "pyrogram.api.types.RpcResult",
    0x2144ca19: "pyrogram.api.types.RpcError",
    0x5e2ad36e: "pyrogram.api.types.RpcAnswerUnknown",
    0xcd78e586: "pyrogram.api.types.RpcAnswerDroppedRunning",
    0xa43ad8b7: "pyrogram.api.types.RpcAnswerDropped",
    0x347773c5: "pyrogram.api.types.Pong",
    0xe22045fc: "pyrogram.api.types.DestroySessionOk",
    0x62d350c9: "pyrogram.api.types.DestroySessionNone",
    0x9ec20908: "pyrogram.api.types.NewSessionCreated",
    0x9299359f: "pyrogram.api.types.HttpWait",
    0xd433ad73: "pyrogram.api.types.IpPort",
    0x37982646: "pyrogram.api.types.IpPortSecret",
    0x4679b65f: "pyrogram.api.types.AccessPointRule",
    0x5a592a6c: "pyrogram.api.types.help.ConfigSimple",
    0x58e4a740: "pyrogram.api.functions.RpcDropAnswer",
    0xb921bd04: "pyrogram.api.functions.GetFutureSalts",
    0x7abe77ec: "pyrogram.api.functions.Ping",
    0xf3427b8c: "pyrogram.api.functions.PingDelayDisconnect",
    0xe7512126: "pyrogram.api.functions.DestroySession",
    0x9a5f6e95: "pyrogram.api.functions.contest.SaveDeveloperInfo",
    0x7f3b18ea: "pyrogram.api.types.InputPeerEmpty",
    0x7da07ec9: "pyrogram.api.types.InputPeerSelf",
    0x179be863: "pyrogram.api.types.InputPeerChat",
    0x7b8e7de6: "pyrogram.api.types.InputPeerUser",
    0x20adaef8: "pyrogram.api.types.InputPeerChannel",
    0x17bae2e6: "pyrogram.api.types.InputPeerUserFromMessage",
    0x9c95f7bb: "pyrogram.api.types.InputPeerChannelFromMessage",
    0xb98886cf: "pyrogram.api.types.InputUserEmpty",
    0xf7c1b13f: "pyrogram.api.types.InputUserSelf",
    0xd8292816: "pyrogram.api.types.InputUser",
    0x2d117597: "pyrogram.api.types.InputUserFromMessage",
    0xf392b7f4: "pyrogram.api.types.InputPhoneContact",
    0xf52ff27f: "pyrogram.api.types.InputFile",
    0xfa4f0bb5: "pyrogram.api.types.InputFileBig",
    0x9664f57f: "pyrogram.api.types.InputMediaEmpty",
    0x1e287d04: "pyrogram.api.types.InputMediaUploadedPhoto",
    0xb3ba0635: "pyrogram.api.types.InputMediaPhoto",
    0xf9c44144: "pyrogram.api.types.InputMediaGeoPoint",
    0xf8ab7dfb: "pyrogram.api.types.InputMediaContact",
    0x5b38c6c1: "pyrogram.api.types.InputMediaUploadedDocument",
    0x23ab23d2: "pyrogram.api.types.InputMediaDocument",
    0xc13d1c11: "pyrogram.api.types.InputMediaVenue",
    0x4843b0fd: "pyrogram.api.types.InputMediaGifExternal",
    0xe5bbfe1a: "pyrogram.api.types.InputMediaPhotoExternal",
    0xfb52dc99: "pyrogram.api.types.InputMediaDocumentExternal",
    0xd33f43f3: "pyrogram.api.types.InputMediaGame",
    0xf4e096c3: "pyrogram.api.types.InputMediaInvoice",
    0xce4e82fd: "pyrogram.api.types.InputMediaGeoLive",
    0x06b3765b: "pyrogram.api.types.InputMediaPoll",
    0x1ca48f57: "pyrogram.api.types.InputChatPhotoEmpty",
    0x927c55b4: "pyrogram.api.types.InputChatUploadedPhoto",
    0x8953ad37: "pyrogram.api.types.InputChatPhoto",
    0xe4c123d6: "pyrogram.api.types.InputGeoPointEmpty",
    0xf3b7acc9: "pyrogram.api.types.InputGeoPoint",
    0x1cd7bf0d: "pyrogram.api.types.InputPhotoEmpty",
    0x3bb3b94a: "pyrogram.api.types.InputPhoto",
    0xdfdaabe1: "pyrogram.api.types.InputFileLocation",
    0xf5235d55: "pyrogram.api.types.InputEncryptedFileLocation",
    0xbad07584: "pyrogram.api.types.InputDocumentFileLocation",
    0xcbc7ee28: "pyrogram.api.types.InputSecureFileLocation",
    0x29be5899: "pyrogram.api.types.InputTakeoutFileLocation",
    0x40181ffe: "pyrogram.api.types.InputPhotoFileLocation",
    0x27d69997: "pyrogram.api.types.InputPeerPhotoFileLocation",
    0x0dbaeae9: "pyrogram.api.types.InputStickerSetThumb",
    0x9db1bc6d: "pyrogram.api.types.PeerUser",
    0xbad0e5bb: "pyrogram.api.types.PeerChat",
    0xbddde532: "pyrogram.api.types.PeerChannel",
    0xaa963b05: "pyrogram.api.types.storage.FileUnknown",
    0x40bc6f52: "pyrogram.api.types.storage.FilePartial",
    0x007efe0e: "pyrogram.api.types.storage.FileJpeg",
    0xcae1aadf: "pyrogram.api.types.storage.FileGif",
    0x0a4f63c0: "pyrogram.api.types.storage.FilePng",
    0xae1e508d: "pyrogram.api.types.storage.FilePdf",
    0x528a0677: "pyrogram.api.types.storage.FileMp3",
    0x4b09ebbc: "pyrogram.api.types.storage.FileMov",
    0xb3cea0e4: "pyrogram.api.types.storage.FileMp4",
    0x1081464c: "pyrogram.api.types.storage.FileWebp",
    0x200250ba: "pyrogram.api.types.UserEmpty",
    0x938458c1: "pyrogram.api.types.User",
    0x4f11bae1: "pyrogram.api.types.UserProfilePhotoEmpty",
    0xecd75d8c: "pyrogram.api.types.UserProfilePhoto",
    0x09d05049: "pyrogram.api.types.UserStatusEmpty",
    0xedb93949: "pyrogram.api.types.UserStatusOnline",
    0x008c703f: "pyrogram.api.types.UserStatusOffline",
    0xe26f42f1: "pyrogram.api.types.UserStatusRecently",
    0x07bf09fc: "pyrogram.api.types.UserStatusLastWeek",
    0x77ebc742: "pyrogram.api.types.UserStatusLastMonth",
    0x9ba2d800: "pyrogram.api.types.ChatEmpty",
    0x3bda1bde: "pyrogram.api.types.Chat",
    0x07328bdb: "pyrogram.api.types.ChatForbidden",
    0xd31a961e: "pyrogram.api.types.Channel",
    0x289da732: "pyrogram.api.types.ChannelForbidden",
    0x1b7c9db3: "pyrogram.api.types.ChatFull",
    0x2d895c74: "pyrogram.api.types.ChannelFull",
    0xc8d7493e: "pyrogram.api.types.ChatParticipant",
    0xda13538a: "pyrogram.api.types.ChatParticipantCreator",
    0xe2d6e436: "pyrogram.api.types.ChatParticipantAdmin",
    0xfc900c2b: "pyrogram.api.types.ChatParticipantsForbidden",
    0x3f460fed: "pyrogram.api.types.ChatParticipants",
    0x37c1011c: "pyrogram.api.types.ChatPhotoEmpty",
    0x475cdbd5: "pyrogram.api.types.ChatPhoto",
    0x83e5de54: "pyrogram.api.types.MessageEmpty",
    0x452c0e65: "pyrogram.api.types.Message",
    0x9e19a1f6: "pyrogram.api.types.MessageService",
    0x3ded6320: "pyrogram.api.types.MessageMediaEmpty",
    0x695150d7: "pyrogram.api.types.MessageMediaPhoto",
    0x56e0d474: "pyrogram.api.types.MessageMediaGeo",
    0xcbf24940: "pyrogram.api.types.MessageMediaContact",
    0x9f84f49e: "pyrogram.api.types.MessageMediaUnsupported",
    0x9cb070d7: "pyrogram.api.types.MessageMediaDocument",
    0xa32dd600: "pyrogram.api.types.MessageMediaWebPage",
    0x2ec0533f: "pyrogram.api.types.MessageMediaVenue",
    0xfdb19008: "pyrogram.api.types.MessageMediaGame",
    0x84551347: "pyrogram.api.types.MessageMediaInvoice",
    0x7c3c2609: "pyrogram.api.types.MessageMediaGeoLive",
    0x4bd6e798: "pyrogram.api.types.MessageMediaPoll",
    0xb6aef7b0: "pyrogram.api.types.MessageActionEmpty",
    0xa6638b9a: "pyrogram.api.types.MessageActionChatCreate",
    0xb5a1ce5a: "pyrogram.api.types.MessageActionChatEditTitle",
    0x7fcb13a8: "pyrogram.api.types.MessageActionChatEditPhoto",
    0x95e3fbef: "pyrogram.api.types.MessageActionChatDeletePhoto",
    0x488a7337: "pyrogram.api.types.MessageActionChatAddUser",
    0xb2ae9b0c: "pyrogram.api.types.MessageActionChatDeleteUser",
    0xf89cf5e8: "pyrogram.api.types.MessageActionChatJoinedByLink",
    0x95d2ac92: "pyrogram.api.types.MessageActionChannelCreate",
    0x51bdb021: "pyrogram.api.types.MessageActionChatMigrateTo",
    0xb055eaee: "pyrogram.api.types.MessageActionChannelMigrateFrom",
    0x94bd38ed: "pyrogram.api.types.MessageActionPinMessage",
    0x9fbab604: "pyrogram.api.types.MessageActionHistoryClear",
    0x92a72876: "pyrogram.api.types.MessageActionGameScore",
    0x8f31b327: "pyrogram.api.types.MessageActionPaymentSentMe",
    0x40699cd0: "pyrogram.api.types.MessageActionPaymentSent",
    0x80e11a7f: "pyrogram.api.types.MessageActionPhoneCall",
    0x4792929b: "pyrogram.api.types.MessageActionScreenshotTaken",
    0xfae69f56: "pyrogram.api.types.MessageActionCustomAction",
    0xabe9affe: "pyrogram.api.types.MessageActionBotAllowed",
    0x1b287353: "pyrogram.api.types.MessageActionSecureValuesSentMe",
    0xd95c6154: "pyrogram.api.types.MessageActionSecureValuesSent",
    0xf3f25f76: "pyrogram.api.types.MessageActionContactSignUp",
    0x2c171f72: "pyrogram.api.types.Dialog",
    0x71bd134c: "pyrogram.api.types.DialogFolder",
    0x2331b22d: "pyrogram.api.types.PhotoEmpty",
    0xd07504a5: "pyrogram.api.types.Photo",
    0x0e17e23c: "pyrogram.api.types.PhotoSizeEmpty",
    0x77bfb61b: "pyrogram.api.types.PhotoSize",
    0xe9a734fa: "pyrogram.api.types.PhotoCachedSize",
    0xe0b0bc2e: "pyrogram.api.types.PhotoStrippedSize",
    0x1117dd5f: "pyrogram.api.types.GeoPointEmpty",
    0x0296f104: "pyrogram.api.types.GeoPoint",
    0x5e002502: "pyrogram.api.types.auth.SentCode",
    0xcd050916: "pyrogram.api.types.auth.Authorization",
    0x44747e9a: "pyrogram.api.types.auth.AuthorizationSignUpRequired",
    0xdf969c2d: "pyrogram.api.types.auth.ExportedAuthorization",
    0xb8bc5b0c: "pyrogram.api.types.InputNotifyPeer",
    0x193b4417: "pyrogram.api.types.InputNotifyUsers",
    0x4a95e84e: "pyrogram.api.types.InputNotifyChats",
    0xb1db7c7e: "pyrogram.api.types.InputNotifyBroadcasts",
    0x9c3d198e: "pyrogram.api.types.InputPeerNotifySettings",
    0xaf509d20: "pyrogram.api.types.PeerNotifySettings",
    0x818426cd: "pyrogram.api.types.PeerSettings",
    0xa437c3ed: "pyrogram.api.types.WallPaper",
    0x58dbcab8: "pyrogram.api.types.InputReportReasonSpam",
    0x1e22c78d: "pyrogram.api.types.InputReportReasonViolence",
    0x2e59d922: "pyrogram.api.types.InputReportReasonPornography",
    0xadf44ee3: "pyrogram.api.types.InputReportReasonChildAbuse",
    0xe1746d0a: "pyrogram.api.types.InputReportReasonOther",
    0x9b89f93a: "pyrogram.api.types.InputReportReasonCopyright",
    0xdbd4feed: "pyrogram.api.types.InputReportReasonGeoIrrelevant",
    0xedf17c12: "pyrogram.api.types.UserFull",
    0xf911c994: "pyrogram.api.types.Contact",
    0xd0028438: "pyrogram.api.types.ImportedContact",
    0x561bc879: "pyrogram.api.types.ContactBlocked",
    0xd3680c61: "pyrogram.api.types.ContactStatus",
    0xb74ba9d2: "pyrogram.api.types.contacts.ContactsNotModified",
    0xeae87e42: "pyrogram.api.types.contacts.Contacts",
    0x77d01c3b: "pyrogram.api.types.contacts.ImportedContacts",
    0x1c138d15: "pyrogram.api.types.contacts.Blocked",
    0x900802a1: "pyrogram.api.types.contacts.BlockedSlice",
    0x15ba6c40: "pyrogram.api.types.messages.Dialogs",
    0x71e094f3: "pyrogram.api.types.messages.DialogsSlice",
    0xf0e3e596: "pyrogram.api.types.messages.DialogsNotModified",
    0x8c718e87: "pyrogram.api.types.messages.Messages",
    0xc8edce1e: "pyrogram.api.types.messages.MessagesSlice",
    0x99262e37: "pyrogram.api.types.messages.ChannelMessages",
    0x74535f21: "pyrogram.api.types.messages.MessagesNotModified",
    0x64ff9fd5: "pyrogram.api.types.messages.Chats",
    0x9cd81144: "pyrogram.api.types.messages.ChatsSlice",
    0xe5d7d19c: "pyrogram.api.types.messages.ChatFull",
    0xb45c69d1: "pyrogram.api.types.messages.AffectedHistory",
    0x57e2f66c: "pyrogram.api.types.InputMessagesFilterEmpty",
    0x9609a51c: "pyrogram.api.types.InputMessagesFilterPhotos",
    0x9fc00e65: "pyrogram.api.types.InputMessagesFilterVideo",
    0x56e9f0e4: "pyrogram.api.types.InputMessagesFilterPhotoVideo",
    0x9eddf188: "pyrogram.api.types.InputMessagesFilterDocument",
    0x7ef0dd87: "pyrogram.api.types.InputMessagesFilterUrl",
    0xffc86587: "pyrogram.api.types.InputMessagesFilterGif",
    0x50f5c392: "pyrogram.api.types.InputMessagesFilterVoice",
    0x3751b49e: "pyrogram.api.types.InputMessagesFilterMusic",
    0x3a20ecb8: "pyrogram.api.types.InputMessagesFilterChatPhotos",
    0x80c99768: "pyrogram.api.types.InputMessagesFilterPhoneCalls",
    0x7a7c17a4: "pyrogram.api.types.InputMessagesFilterRoundVoice",
    0xb549da53: "pyrogram.api.types.InputMessagesFilterRoundVideo",
    0xc1f8e69a: "pyrogram.api.types.InputMessagesFilterMyMentions",
    0xe7026d0d: "pyrogram.api.types.InputMessagesFilterGeo",
    0xe062db83: "pyrogram.api.types.InputMessagesFilterContacts",
    0x1f2b0afd: "pyrogram.api.types.UpdateNewMessage",
    0x4e90bfd6: "pyrogram.api.types.UpdateMessageID",
    0xa20db0e5: "pyrogram.api.types.UpdateDeleteMessages",
    0x5c486927: "pyrogram.api.types.UpdateUserTyping",
    0x9a65ea1f: "pyrogram.api.types.UpdateChatUserTyping",
    0x07761198: "pyrogram.api.types.UpdateChatParticipants",
    0x1bfbd823: "pyrogram.api.types.UpdateUserStatus",
    0xa7332b73: "pyrogram.api.types.UpdateUserName",
    0x95313b0c: "pyrogram.api.types.UpdateUserPhoto",
    0x12bcbd9a: "pyrogram.api.types.UpdateNewEncryptedMessage",
    0x1710f156: "pyrogram.api.types.UpdateEncryptedChatTyping",
    0xb4a2e88d: "pyrogram.api.types.UpdateEncryption",
    0x38fe25b7: "pyrogram.api.types.UpdateEncryptedMessagesRead",
    0xea4b0e5c: "pyrogram.api.types.UpdateChatParticipantAdd",
    0x6e5f8c22: "pyrogram.api.types.UpdateChatParticipantDelete",
    0x8e5e9873: "pyrogram.api.types.UpdateDcOptions",
    0x80ece81a: "pyrogram.api.types.UpdateUserBlocked",
    0xbec268ef: "pyrogram.api.types.UpdateNotifySettings",
    0xebe46819: "pyrogram.api.types.UpdateServiceNotification",
    0xee3b272a: "pyrogram.api.types.UpdatePrivacy",
    0x12b9417b: "pyrogram.api.types.UpdateUserPhone",
    0x9c974fdf: "pyrogram.api.types.UpdateReadHistoryInbox",
    0x2f2f21bf: "pyrogram.api.types.UpdateReadHistoryOutbox",
    0x7f891213: "pyrogram.api.types.UpdateWebPage",
    0x68c13933: "pyrogram.api.types.UpdateReadMessagesContents",
    0xeb0467fb: "pyrogram.api.types.UpdateChannelTooLong",
    0xb6d45656: "pyrogram.api.types.UpdateChannel",
    0x62ba04d9: "pyrogram.api.types.UpdateNewChannelMessage",
    0x330b5424: "pyrogram.api.types.UpdateReadChannelInbox",
    0xc37521c9: "pyrogram.api.types.UpdateDeleteChannelMessages",
    0x98a12b4b: "pyrogram.api.types.UpdateChannelMessageViews",
    0xb6901959: "pyrogram.api.types.UpdateChatParticipantAdmin",
    0x688a30aa: "pyrogram.api.types.UpdateNewStickerSet",
    0x0bb2d201: "pyrogram.api.types.UpdateStickerSetsOrder",
    0x43ae3dec: "pyrogram.api.types.UpdateStickerSets",
    0x9375341e: "pyrogram.api.types.UpdateSavedGifs",
    0x54826690: "pyrogram.api.types.UpdateBotInlineQuery",
    0x0e48f964: "pyrogram.api.types.UpdateBotInlineSend",
    0x1b3f4df7: "pyrogram.api.types.UpdateEditChannelMessage",
    0x98592475: "pyrogram.api.types.UpdateChannelPinnedMessage",
    0xe73547e1: "pyrogram.api.types.UpdateBotCallbackQuery",
    0xe40370a3: "pyrogram.api.types.UpdateEditMessage",
    0xf9d27a5a: "pyrogram.api.types.UpdateInlineBotCallbackQuery",
    0x25d6c9c7: "pyrogram.api.types.UpdateReadChannelOutbox",
    0xee2bb969: "pyrogram.api.types.UpdateDraftMessage",
    0x571d2742: "pyrogram.api.types.UpdateReadFeaturedStickers",
    0x9a422c20: "pyrogram.api.types.UpdateRecentStickers",
    0xa229dd06: "pyrogram.api.types.UpdateConfig",
    0x3354678f: "pyrogram.api.types.UpdatePtsChanged",
    0x40771900: "pyrogram.api.types.UpdateChannelWebPage",
    0x6e6fe51c: "pyrogram.api.types.UpdateDialogPinned",
    0xfa0f3ca2: "pyrogram.api.types.UpdatePinnedDialogs",
    0x8317c0c3: "pyrogram.api.types.UpdateBotWebhookJSON",
    0x9b9240a6: "pyrogram.api.types.UpdateBotWebhookJSONQuery",
    0xe0cdc940: "pyrogram.api.types.UpdateBotShippingQuery",
    0x5d2f3aa9: "pyrogram.api.types.UpdateBotPrecheckoutQuery",
    0xab0f6b1e: "pyrogram.api.types.UpdatePhoneCall",
    0x46560264: "pyrogram.api.types.UpdateLangPackTooLong",
    0x56022f4d: "pyrogram.api.types.UpdateLangPack",
    0xe511996d: "pyrogram.api.types.UpdateFavedStickers",
    0x89893b45: "pyrogram.api.types.UpdateChannelReadMessagesContents",
    0x7084a7be: "pyrogram.api.types.UpdateContactsReset",
    0x70db6837: "pyrogram.api.types.UpdateChannelAvailableMessages",
    0xe16459c3: "pyrogram.api.types.UpdateDialogUnreadMark",
    0x4c43da18: "pyrogram.api.types.UpdateUserPinnedMessage",
    0xe10db349: "pyrogram.api.types.UpdateChatPinnedMessage",
    0xaca1657b: "pyrogram.api.types.UpdateMessagePoll",
    0x54c01850: "pyrogram.api.types.UpdateChatDefaultBannedRights",
    0x19360dc0: "pyrogram.api.types.UpdateFolderPeers",
    0x6a7e7366: "pyrogram.api.types.UpdatePeerSettings",
    0xb4afcfb0: "pyrogram.api.types.UpdatePeerLocated",
    0x39a51dfb: "pyrogram.api.types.UpdateNewScheduledMessage",
    0x90866cee: "pyrogram.api.types.UpdateDeleteScheduledMessages",
    0x8216fba3: "pyrogram.api.types.UpdateTheme",
    0xa56c2a3e: "pyrogram.api.types.updates.State",
    0x5d75a138: "pyrogram.api.types.updates.DifferenceEmpty",
    0x00f49ca0: "pyrogram.api.types.updates.Difference",
    0xa8fb1981: "pyrogram.api.types.updates.DifferenceSlice",
    0x4afe8f6d: "pyrogram.api.types.updates.DifferenceTooLong",
    0xe317af7e: "pyrogram.api.types.UpdatesTooLong",
    0x914fbf11: "pyrogram.api.types.UpdateShortMessage",
    0x16812688: "pyrogram.api.types.UpdateShortChatMessage",
    0x78d4dec1: "pyrogram.api.types.UpdateShort",
    0x725b04c3: "pyrogram.api.types.UpdatesCombined",
    0x74ae4240: "pyrogram.api.types.Update",
    0x11f1331c: "pyrogram.api.types.UpdateShortSentMessage",
    0x8dca6aa5: "pyrogram.api.types.photos.Photos",
    0x15051f54: "pyrogram.api.types.photos.PhotosSlice",
    0x20212ca8: "pyrogram.api.types.photos.Photo",
    0x096a18d5: "pyrogram.api.types.upload.File",
    0xf18cda44: "pyrogram.api.types.upload.FileCdnRedirect",
    0x18b7a10d: "pyrogram.api.types.DcOption",
    0x330b4067: "pyrogram.api.types.Config",
    0x8e1a1775: "pyrogram.api.types.NearestDc",
    0x1da7158f: "pyrogram.api.types.help.AppUpdate",
    0xc45a6536: "pyrogram.api.types.help.NoAppUpdate",
    0x18cb9f78: "pyrogram.api.types.help.InviteText",
    0xab7ec0a0: "pyrogram.api.types.EncryptedChatEmpty",
    0x3bf703dc: "pyrogram.api.types.EncryptedChatWaiting",
    0xc878527e: "pyrogram.api.types.EncryptedChatRequested",
    0xfa56ce36: "pyrogram.api.types.EncryptedChat",
    0x13d6dd27: "pyrogram.api.types.EncryptedChatDiscarded",
    0xf141b5e1: "pyrogram.api.types.InputEncryptedChat",
    0xc21f497e: "pyrogram.api.types.EncryptedFileEmpty",
    0x4a70994c: "pyrogram.api.types.EncryptedFile",
    0x1837c364: "pyrogram.api.types.InputEncryptedFileEmpty",
    0x64bd0306: "pyrogram.api.types.InputEncryptedFileUploaded",
    0x5a17b5e5: "pyrogram.api.types.InputEncryptedFile",
    0x2dc173c8: "pyrogram.api.types.InputEncryptedFileBigUploaded",
    0xed18c118: "pyrogram.api.types.EncryptedMessage",
    0x23734b06: "pyrogram.api.types.EncryptedMessageService",
    0xc0e24635: "pyrogram.api.types.messages.DhConfigNotModified",
    0x2c221edd: "pyrogram.api.types.messages.DhConfig",
    0x560f8935: "pyrogram.api.types.messages.SentEncryptedMessage",
    0x9493ff32: "pyrogram.api.types.messages.SentEncryptedFile",
    0x72f0eaae: "pyrogram.api.types.InputDocumentEmpty",
    0x1abfb575: "pyrogram.api.types.InputDocument",
    0x36f8c871: "pyrogram.api.types.DocumentEmpty",
    0x9ba29cc1: "pyrogram.api.types.Document",
    0x17c6b5f6: "pyrogram.api.types.help.Support",
    0x9fd40bd8: "pyrogram.api.types.NotifyPeer",
    0xb4c83b4c: "pyrogram.api.types.NotifyUsers",
    0xc007cec3: "pyrogram.api.types.NotifyChats",
    0xd612e8ef: "pyrogram.api.types.NotifyBroadcasts",
    0x16bf744e: "pyrogram.api.types.SendMessageTypingAction",
    0xfd5ec8f5: "pyrogram.api.types.SendMessageCancelAction",
    0xa187d66f: "pyrogram.api.types.SendMessageRecordVideoAction",
    0xe9763aec: "pyrogram.api.types.SendMessageUploadVideoAction",
    0xd52f73f7: "pyrogram.api.types.SendMessageRecordAudioAction",
    0xf351d7ab: "pyrogram.api.types.SendMessageUploadAudioAction",
    0xd1d34a26: "pyrogram.api.types.SendMessageUploadPhotoAction",
    0xaa0cd9e4: "pyrogram.api.types.SendMessageUploadDocumentAction",
    0x176f8ba1: "pyrogram.api.types.SendMessageGeoLocationAction",
    0x628cbc6f: "pyrogram.api.types.SendMessageChooseContactAction",
    0xdd6a8f48: "pyrogram.api.types.SendMessageGamePlayAction",
    0x88f27fbc: "pyrogram.api.types.SendMessageRecordRoundAction",
    0x243e1c66: "pyrogram.api.types.SendMessageUploadRoundAction",
    0xb3134d9d: "pyrogram.api.types.contacts.Found",
    0x4f96cb18: "pyrogram.api.types.InputPrivacyKeyStatusTimestamp",
    0xbdfb0426: "pyrogram.api.types.InputPrivacyKeyChatInvite",
    0xfabadc5f: "pyrogram.api.types.InputPrivacyKeyPhoneCall",
    0xdb9e70d2: "pyrogram.api.types.InputPrivacyKeyPhoneP2P",
    0xa4dd4c08: "pyrogram.api.types.InputPrivacyKeyForwards",
    0x5719bacc: "pyrogram.api.types.InputPrivacyKeyProfilePhoto",
    0x0352dafa: "pyrogram.api.types.InputPrivacyKeyPhoneNumber",
    0xd1219bdd: "pyrogram.api.types.InputPrivacyKeyAddedByPhone",
    0xbc2eab30: "pyrogram.api.types.PrivacyKeyStatusTimestamp",
    0x500e6dfa: "pyrogram.api.types.PrivacyKeyChatInvite",
    0x3d662b7b: "pyrogram.api.types.PrivacyKeyPhoneCall",
    0x39491cc8: "pyrogram.api.types.PrivacyKeyPhoneP2P",
    0x69ec56a3: "pyrogram.api.types.PrivacyKeyForwards",
    0x96151fed: "pyrogram.api.types.PrivacyKeyProfilePhoto",
    0xd19ae46d: "pyrogram.api.types.PrivacyKeyPhoneNumber",
    0x42ffd42b: "pyrogram.api.types.PrivacyKeyAddedByPhone",
    0x0d09e07b: "pyrogram.api.types.InputPrivacyValueAllowContacts",
    0x184b35ce: "pyrogram.api.types.InputPrivacyValueAllowAll",
    0x131cc67f: "pyrogram.api.types.InputPrivacyValueAllowUsers",
    0x0ba52007: "pyrogram.api.types.InputPrivacyValueDisallowContacts",
    0xd66b66c9: "pyrogram.api.types.InputPrivacyValueDisallowAll",
    0x90110467: "pyrogram.api.types.InputPrivacyValueDisallowUsers",
    0x4c81c1ba: "pyrogram.api.types.InputPrivacyValueAllowChatParticipants",
    0xd82363af: "pyrogram.api.types.InputPrivacyValueDisallowChatParticipants",
    0xfffe1bac: "pyrogram.api.types.PrivacyValueAllowContacts",
    0x65427b82: "pyrogram.api.types.PrivacyValueAllowAll",
    0x4d5bbe0c: "pyrogram.api.types.PrivacyValueAllowUsers",
    0xf888fa1a: "pyrogram.api.types.PrivacyValueDisallowContacts",
    0x8b73e763: "pyrogram.api.types.PrivacyValueDisallowAll",
    0x0c7f49b7: "pyrogram.api.types.PrivacyValueDisallowUsers",
    0x18be796b: "pyrogram.api.types.PrivacyValueAllowChatParticipants",
    0xacae0690: "pyrogram.api.types.PrivacyValueDisallowChatParticipants",
    0x50a04e45: "pyrogram.api.types.account.PrivacyRules",
    0xb8d0afdf: "pyrogram.api.types.AccountDaysTTL",
    0x6c37c15c: "pyrogram.api.types.DocumentAttributeImageSize",
    0x11b58939: "pyrogram.api.types.DocumentAttributeAnimated",
    0x6319d612: "pyrogram.api.types.DocumentAttributeSticker",
    0x0ef02ce6: "pyrogram.api.types.DocumentAttributeVideo",
    0x9852f9c6: "pyrogram.api.types.DocumentAttributeAudio",
    0x15590068: "pyrogram.api.types.DocumentAttributeFilename",
    0x9801d2f7: "pyrogram.api.types.DocumentAttributeHasStickers",
    0xf1749a22: "pyrogram.api.types.messages.StickersNotModified",
    0xe4599bbd: "pyrogram.api.types.messages.Stickers",
    0x12b299d4: "pyrogram.api.types.StickerPack",
    0xe86602c3: "pyrogram.api.types.messages.AllStickersNotModified",
    0xedfd405f: "pyrogram.api.types.messages.AllStickers",
    0x84d19185: "pyrogram.api.types.messages.AffectedMessages",
    0xeb1477e8: "pyrogram.api.types.WebPageEmpty",
    0xc586da1c: "pyrogram.api.types.WebPagePending",
    0xfa64e172: "pyrogram.api.types.WebPage",
    0x85849473: "pyrogram.api.types.WebPageNotModified",
    0xad01d61d: "pyrogram.api.types.Authorization",
    0x1250abde: "pyrogram.api.types.account.Authorizations",
    0xad2641f8: "pyrogram.api.types.account.Password",
    0x9a5c33e5: "pyrogram.api.types.account.PasswordSettings",
    0xc23727c9: "pyrogram.api.types.account.PasswordInputSettings",
    0x137948a5: "pyrogram.api.types.auth.PasswordRecovery",
    0xa384b779: "pyrogram.api.types.ReceivedNotifyMessage",
    0x69df3769: "pyrogram.api.types.ChatInviteEmpty",
    0xfc2e05bc: "pyrogram.api.types.ChatInviteExported",
    0x5a686d7c: "pyrogram.api.types.ChatInviteAlready",
    0xdfc2f58e: "pyrogram.api.types.ChatInvite",
    0xffb62b95: "pyrogram.api.types.InputStickerSetEmpty",
    0x9de7a269: "pyrogram.api.types.InputStickerSetID",
    0x861cc8a0: "pyrogram.api.types.InputStickerSetShortName",
    0x028703c8: "pyrogram.api.types.InputStickerSetAnimatedEmoji",
    0xeeb46f27: "pyrogram.api.types.StickerSet",
    0xb60a24a6: "pyrogram.api.types.messages.StickerSet",
    0xc27ac8c7: "pyrogram.api.types.BotCommand",
    0x98e81d3a: "pyrogram.api.types.BotInfo",
    0xa2fa4880: "pyrogram.api.types.KeyboardButton",
    0x258aff05: "pyrogram.api.types.KeyboardButtonUrl",
    0x683a5e46: "pyrogram.api.types.KeyboardButtonCallback",
    0xb16a6c29: "pyrogram.api.types.KeyboardButtonRequestPhone",
    0xfc796b3f: "pyrogram.api.types.KeyboardButtonRequestGeoLocation",
    0x0568a748: "pyrogram.api.types.KeyboardButtonSwitchInline",
    0x50f41ccf: "pyrogram.api.types.KeyboardButtonGame",
    0xafd93fbb: "pyrogram.api.types.KeyboardButtonBuy",
    0x10b78d29: "pyrogram.api.types.KeyboardButtonUrlAuth",
    0xd02e7fd4: "pyrogram.api.types.InputKeyboardButtonUrlAuth",
    0x77608b83: "pyrogram.api.types.KeyboardButtonRow",
    0xa03e5b85: "pyrogram.api.types.ReplyKeyboardHide",
    0xf4108aa0: "pyrogram.api.types.ReplyKeyboardForceReply",
    0x3502758c: "pyrogram.api.types.ReplyKeyboardMarkup",
    0x48a30254: "pyrogram.api.types.ReplyInlineMarkup",
    0xbb92ba95: "pyrogram.api.types.MessageEntityUnknown",
    0xfa04579d: "pyrogram.api.types.MessageEntityMention",
    0x6f635b0d: "pyrogram.api.types.MessageEntityHashtag",
    0x6cef8ac7: "pyrogram.api.types.MessageEntityBotCommand",
    0x6ed02538: "pyrogram.api.types.MessageEntityUrl",
    0x64e475c2: "pyrogram.api.types.MessageEntityEmail",
    0xbd610bc9: "pyrogram.api.types.MessageEntityBold",
    0x826f8b60: "pyrogram.api.types.MessageEntityItalic",
    0x28a20571: "pyrogram.api.types.MessageEntityCode",
    0x73924be0: "pyrogram.api.types.MessageEntityPre",
    0x76a6d327: "pyrogram.api.types.MessageEntityTextUrl",
    0x352dca58: "pyrogram.api.types.MessageEntityMentionName",
    0x208e68c9: "pyrogram.api.types.InputMessageEntityMentionName",
    0x9b69e34b: "pyrogram.api.types.MessageEntityPhone",
    0x4c4e743f: "pyrogram.api.types.MessageEntityCashtag",
    0x9c4e7e8b: "pyrogram.api.types.MessageEntityUnderline",
    0xbf0693d4: "pyrogram.api.types.MessageEntityStrike",
    0x020df5d0: "pyrogram.api.types.MessageEntityBlockquote",
    0xee8c1e86: "pyrogram.api.types.InputChannelEmpty",
    0xafeb712e: "pyrogram.api.types.InputChannel",
    0x2a286531: "pyrogram.api.types.InputChannelFromMessage",
    0x7f077ad9: "pyrogram.api.types.contacts.ResolvedPeer",
    0x0ae30253: "pyrogram.api.types.MessageRange",
    0x3e11affb: "pyrogram.api.types.updates.ChannelDifferenceEmpty",
    0xa4bcc6fe: "pyrogram.api.types.updates.ChannelDifferenceTooLong",
    0x2064674e: "pyrogram.api.types.updates.ChannelDifference",
    0x94d42ee7: "pyrogram.api.types.ChannelMessagesFilterEmpty",
    0xcd77d957: "pyrogram.api.types.ChannelMessagesFilter",
    0x15ebac1d: "pyrogram.api.types.ChannelParticipant",
    0xa3289a6d: "pyrogram.api.types.ChannelParticipantSelf",
    0x808d15a4: "pyrogram.api.types.ChannelParticipantCreator",
    0xccbebbaf: "pyrogram.api.types.ChannelParticipantAdmin",
    0x1c0facaf: "pyrogram.api.types.ChannelParticipantBanned",
    0xde3f3c79: "pyrogram.api.types.ChannelParticipantsRecent",
    0xb4608969: "pyrogram.api.types.ChannelParticipantsAdmins",
    0xa3b54985: "pyrogram.api.types.ChannelParticipantsKicked",
    0xb0d1865b: "pyrogram.api.types.ChannelParticipantsBots",
    0x1427a5e1: "pyrogram.api.types.ChannelParticipantsBanned",
    0x0656ac4b: "pyrogram.api.types.ChannelParticipantsSearch",
    0xbb6ae88d: "pyrogram.api.types.ChannelParticipantsContacts",
    0xf56ee2a8: "pyrogram.api.types.channels.ChannelParticipants",
    0xf0173fe9: "pyrogram.api.types.channels.ChannelParticipantsNotModified",
    0xd0d9b163: "pyrogram.api.types.channels.ChannelParticipant",
    0x780a0310: "pyrogram.api.types.help.TermsOfService",
    0x162ecc1f: "pyrogram.api.types.FoundGif",
    0x9c750409: "pyrogram.api.types.FoundGifCached",
    0x450a1c0a: "pyrogram.api.types.messages.FoundGifs",
    0xe8025ca2: "pyrogram.api.types.messages.SavedGifsNotModified",
    0x2e0709a5: "pyrogram.api.types.messages.SavedGifs",
    0x3380c786: "pyrogram.api.types.InputBotInlineMessageMediaAuto",
    0x3dcd7a87: "pyrogram.api.types.InputBotInlineMessageText",
    0xc1b15d65: "pyrogram.api.types.InputBotInlineMessageMediaGeo",
    0x417bbf11: "pyrogram.api.types.InputBotInlineMessageMediaVenue",
    0xa6edbffd: "pyrogram.api.types.InputBotInlineMessageMediaContact",
    0x4b425864: "pyrogram.api.types.InputBotInlineMessageGame",
    0x88bf9319: "pyrogram.api.types.InputBotInlineResult",
    0xa8d864a7: "pyrogram.api.types.InputBotInlineResultPhoto",
    0xfff8fdc4: "pyrogram.api.types.InputBotInlineResultDocument",
    0x4fa417f2: "pyrogram.api.types.InputBotInlineResultGame",
    0x764cf810: "pyrogram.api.types.BotInlineMessageMediaAuto",
    0x8c7f65e2: "pyrogram.api.types.BotInlineMessageText",
    0xb722de65: "pyrogram.api.types.BotInlineMessageMediaGeo",
    0x8a86659c: "pyrogram.api.types.BotInlineMessageMediaVenue",
    0x18d1cdc2: "pyrogram.api.types.BotInlineMessageMediaContact",
    0x11965f3a: "pyrogram.api.types.BotInlineResult",
    0x17db940b: "pyrogram.api.types.BotInlineMediaResult",
    0x947ca848: "pyrogram.api.types.messages.BotResults",
    0x5dab1af4: "pyrogram.api.types.ExportedMessageLink",
    0xec338270: "pyrogram.api.types.MessageFwdHeader",
    0x72a3158c: "pyrogram.api.types.auth.CodeTypeSms",
    0x741cd3e3: "pyrogram.api.types.auth.CodeTypeCall",
    0x226ccefb: "pyrogram.api.types.auth.CodeTypeFlashCall",
    0x3dbb5986: "pyrogram.api.types.auth.SentCodeTypeApp",
    0xc000bba2: "pyrogram.api.types.auth.SentCodeTypeSms",
    0x5353e5a7: "pyrogram.api.types.auth.SentCodeTypeCall",
    0xab03c6d9: "pyrogram.api.types.auth.SentCodeTypeFlashCall",
    0x36585ea4: "pyrogram.api.types.messages.BotCallbackAnswer",
    0x26b5dde6: "pyrogram.api.types.messages.MessageEditData",
    0x890c3d89: "pyrogram.api.types.InputBotInlineMessageID",
    0x3c20629f: "pyrogram.api.types.InlineBotSwitchPM",
    0x3371c354: "pyrogram.api.types.messages.PeerDialogs",
    0xedcdc05b: "pyrogram.api.types.TopPeer",
    0xab661b5b: "pyrogram.api.types.TopPeerCategoryBotsPM",
    0x148677e2: "pyrogram.api.types.TopPeerCategoryBotsInline",
    0x0637b7ed: "pyrogram.api.types.TopPeerCategoryCorrespondents",
    0xbd17a14a: "pyrogram.api.types.TopPeerCategoryGroups",
    0x161d9628: "pyrogram.api.types.TopPeerCategoryChannels",
    0x1e76a78c: "pyrogram.api.types.TopPeerCategoryPhoneCalls",
    0xa8406ca9: "pyrogram.api.types.TopPeerCategoryForwardUsers",
    0xfbeec0f0: "pyrogram.api.types.TopPeerCategoryForwardChats",
    0xfb834291: "pyrogram.api.types.TopPeerCategoryPeers",
    0xde266ef5: "pyrogram.api.types.contacts.TopPeersNotModified",
    0x70b772a8: "pyrogram.api.types.contacts.TopPeers",
    0xb52c939d: "pyrogram.api.types.contacts.TopPeersDisabled",
    0x1b0c841a: "pyrogram.api.types.DraftMessageEmpty",
    0xfd8e711f: "pyrogram.api.types.DraftMessage",
    0x04ede3cf: "pyrogram.api.types.messages.FeaturedStickersNotModified",
    0xf89d88e5: "pyrogram.api.types.messages.FeaturedStickers",
    0x0b17f890: "pyrogram.api.types.messages.RecentStickersNotModified",
    0x22f3afb3: "pyrogram.api.types.messages.RecentStickers",
    0x4fcba9c8: "pyrogram.api.types.messages.ArchivedStickers",
    0x38641628: "pyrogram.api.types.messages.StickerSetInstallResultSuccess",
    0x35e410a8: "pyrogram.api.types.messages.StickerSetInstallResultArchive",
    0x6410a5d2: "pyrogram.api.types.StickerSetCovered",
    0x3407e51b: "pyrogram.api.types.StickerSetMultiCovered",
    0xaed6dbb2: "pyrogram.api.types.MaskCoords",
    0x4a992157: "pyrogram.api.types.InputStickeredMediaPhoto",
    0x0438865b: "pyrogram.api.types.InputStickeredMediaDocument",
    0xbdf9653b: "pyrogram.api.types.Game",
    0x032c3e77: "pyrogram.api.types.InputGameID",
    0xc331e80a: "pyrogram.api.types.InputGameShortName",
    0x58fffcd0: "pyrogram.api.types.HighScore",
    0x9a3bfd99: "pyrogram.api.types.messages.HighScores",
    0xdc3d824f: "pyrogram.api.types.TextEmpty",
    0x744694e0: "pyrogram.api.types.TextPlain",
    0x6724abc4: "pyrogram.api.types.TextBold",
    0xd912a59c: "pyrogram.api.types.TextItalic",
    0xc12622c4: "pyrogram.api.types.TextUnderline",
    0x9bf8bb95: "pyrogram.api.types.TextStrike",
    0x6c3f19b9: "pyrogram.api.types.TextFixed",
    0x3c2884c1: "pyrogram.api.types.TextUrl",
    0xde5a0dd6: "pyrogram.api.types.TextEmail",
    0x7e6260d7: "pyrogram.api.types.TextConcat",
    0xed6a8504: "pyrogram.api.types.TextSubscript",
    0xc7fb5e01: "pyrogram.api.types.TextSuperscript",
    0x034b8621: "pyrogram.api.types.TextMarked",
    0x1ccb966a: "pyrogram.api.types.TextPhone",
    0x081ccf4f: "pyrogram.api.types.TextImage",
    0x35553762: "pyrogram.api.types.TextAnchor",
    0x13567e8a: "pyrogram.api.types.PageBlockUnsupported",
    0x70abc3fd: "pyrogram.api.types.PageBlockTitle",
    0x8ffa9a1f: "pyrogram.api.types.PageBlockSubtitle",
    0xbaafe5e0: "pyrogram.api.types.PageBlockAuthorDate",
    0xbfd064ec: "pyrogram.api.types.PageBlockHeader",
    0xf12bb6e1: "pyrogram.api.types.PageBlockSubheader",
    0x467a0766: "pyrogram.api.types.PageBlockParagraph",
    0xc070d93e: "pyrogram.api.types.PageBlockPreformatted",
    0x48870999: "pyrogram.api.types.PageBlockFooter",
    0xdb20b188: "pyrogram.api.types.PageBlockDivider",
    0xce0d37b0: "pyrogram.api.types.PageBlockAnchor",
    0xe4e88011: "pyrogram.api.types.PageBlockList",
    0x263d7c26: "pyrogram.api.types.PageBlockBlockquote",
    0x4f4456d3: "pyrogram.api.types.PageBlockPullquote",
    0x1759c560: "pyrogram.api.types.PageBlockPhoto",
    0x7c8fe7b6: "pyrogram.api.types.PageBlockVideo",
    0x39f23300: "pyrogram.api.types.PageBlockCover",
    0xa8718dc5: "pyrogram.api.types.PageBlockEmbed",
    0xf259a80b: "pyrogram.api.types.PageBlockEmbedPost",
    0x65a0fa4d: "pyrogram.api.types.PageBlockCollage",
    0x031f9590: "pyrogram.api.types.PageBlockSlideshow",
    0xef1751b5: "pyrogram.api.types.PageBlockChannel",
    0x804361ea: "pyrogram.api.types.PageBlockAudio",
    0x1e148390: "pyrogram.api.types.PageBlockKicker",
    0xbf4dea82: "pyrogram.api.types.PageBlockTable",
    0x9a8ae1e1: "pyrogram.api.types.PageBlockOrderedList",
    0x76768bed: "pyrogram.api.types.PageBlockDetails",
    0x16115a96: "pyrogram.api.types.PageBlockRelatedArticles",
    0xa44f3ef6: "pyrogram.api.types.PageBlockMap",
    0x85e42301: "pyrogram.api.types.PhoneCallDiscardReasonMissed",
    0xe095c1a0: "pyrogram.api.types.PhoneCallDiscardReasonDisconnect",
    0x57adc690: "pyrogram.api.types.PhoneCallDiscardReasonHangup",
    0xfaf7e8c9: "pyrogram.api.types.PhoneCallDiscardReasonBusy",
    0x7d748d04: "pyrogram.api.types.DataJSON",
    0xcb296bf8: "pyrogram.api.types.LabeledPrice",
    0xc30aa358: "pyrogram.api.types.Invoice",
    0xea02c27e: "pyrogram.api.types.PaymentCharge",
    0x1e8caaeb: "pyrogram.api.types.PostAddress",
    0x909c3f94: "pyrogram.api.types.PaymentRequestedInfo",
    0xcdc27a1f: "pyrogram.api.types.PaymentSavedCredentialsCard",
    0x1c570ed1: "pyrogram.api.types.WebDocument",
    0xf9c8bcc6: "pyrogram.api.types.WebDocumentNoProxy",
    0x9bed434d: "pyrogram.api.types.InputWebDocument",
    0xc239d686: "pyrogram.api.types.InputWebFileLocation",
    0x9f2221c9: "pyrogram.api.types.InputWebFileGeoPointLocation",
    0x21e753bc: "pyrogram.api.types.upload.WebFile",
    0x3f56aea3: "pyrogram.api.types.payments.PaymentForm",
    0xd1451883: "pyrogram.api.types.payments.ValidatedRequestedInfo",
    0x4e5f810d: "pyrogram.api.types.payments.PaymentResult",
    0xd8411139: "pyrogram.api.types.payments.PaymentVerificationNeeded",
    0x500911e1: "pyrogram.api.types.payments.PaymentReceipt",
    0xfb8fe43c: "pyrogram.api.types.payments.SavedInfo",
    0xc10eb2cf: "pyrogram.api.types.InputPaymentCredentialsSaved",
    0x3417d728: "pyrogram.api.types.InputPaymentCredentials",
    0x0aa1c39f: "pyrogram.api.types.InputPaymentCredentialsApplePay",
    0xca05d50e: "pyrogram.api.types.InputPaymentCredentialsAndroidPay",
    0xdb64fd34: "pyrogram.api.types.account.TmpPassword",
    0xb6213cdf: "pyrogram.api.types.ShippingOption",
    0xffa0a496: "pyrogram.api.types.InputStickerSetItem",
    0x1e36fded: "pyrogram.api.types.InputPhoneCall",
    0x5366c915: "pyrogram.api.types.PhoneCallEmpty",
    0x1b8f4ad1: "pyrogram.api.types.PhoneCallWaiting",
    0x87eabb53: "pyrogram.api.types.PhoneCallRequested",
    0x997c454a: "pyrogram.api.types.PhoneCallAccepted",
    0x8742ae7f: "pyrogram.api.types.PhoneCall",
    0x50ca4de1: "pyrogram.api.types.PhoneCallDiscarded",
    0x9d4c17c0: "pyrogram.api.types.PhoneConnection",
    0xa2bb35cb: "pyrogram.api.types.PhoneCallProtocol",
    0xec82e140: "pyrogram.api.types.phone.PhoneCall",
    0xeea8e46e: "pyrogram.api.types.upload.CdnFileReuploadNeeded",
    0xa99fca4f: "pyrogram.api.types.upload.CdnFile",
    0xc982eaba: "pyrogram.api.types.CdnPublicKey",
    0x5725e40a: "pyrogram.api.types.CdnConfig",
    0xcad181f6: "pyrogram.api.types.LangPackString",
    0x6c47ac9f: "pyrogram.api.types.LangPackStringPluralized",
    0x2979eeb2: "pyrogram.api.types.LangPackStringDeleted",
    0xf385c1f6: "pyrogram.api.types.LangPackDifference",
    0xeeca5ce3: "pyrogram.api.types.LangPackLanguage",
    0xe6dfb825: "pyrogram.api.types.ChannelAdminLogEventActionChangeTitle",
    0x55188a2e: "pyrogram.api.types.ChannelAdminLogEventActionChangeAbout",
    0x6a4afc38: "pyrogram.api.types.ChannelAdminLogEventActionChangeUsername",
    0x434bd2af: "pyrogram.api.types.ChannelAdminLogEventActionChangePhoto",
    0x1b7907ae: "pyrogram.api.types.ChannelAdminLogEventActionToggleInvites",
    0x26ae0971: "pyrogram.api.types.ChannelAdminLogEventActionToggleSignatures",
    0xe9e82c18: "pyrogram.api.types.ChannelAdminLogEventActionUpdatePinned",
    0x709b2405: "pyrogram.api.types.ChannelAdminLogEventActionEditMessage",
    0x42e047bb: "pyrogram.api.types.ChannelAdminLogEventActionDeleteMessage",
    0x183040d3: "pyrogram.api.types.ChannelAdminLogEventActionParticipantJoin",
    0xf89777f2: "pyrogram.api.types.ChannelAdminLogEventActionParticipantLeave",
    0xe31c34d8: "pyrogram.api.types.ChannelAdminLogEventActionParticipantInvite",
    0xe6d83d7e: "pyrogram.api.types.ChannelAdminLogEventActionParticipantToggleBan",
    0xd5676710: "pyrogram.api.types.ChannelAdminLogEventActionParticipantToggleAdmin",
    0xb1c3caa7: "pyrogram.api.types.ChannelAdminLogEventActionChangeStickerSet",
    0x5f5c95f1: "pyrogram.api.types.ChannelAdminLogEventActionTogglePreHistoryHidden",
    0x2df5fc0a: "pyrogram.api.types.ChannelAdminLogEventActionDefaultBannedRights",
    0x8f079643: "pyrogram.api.types.ChannelAdminLogEventActionStopPoll",
    0xa26f881b: "pyrogram.api.types.ChannelAdminLogEventActionChangeLinkedChat",
    0x0e6b76ae: "pyrogram.api.types.ChannelAdminLogEventActionChangeLocation",
    0x53909779: "pyrogram.api.types.ChannelAdminLogEventActionToggleSlowMode",
    0x3b5a3e40: "pyrogram.api.types.ChannelAdminLogEvent",
    0xed8af74d: "pyrogram.api.types.channels.AdminLogResults",
    0xea107ae4: "pyrogram.api.types.ChannelAdminLogEventsFilter",
    0x5ce14175: "pyrogram.api.types.PopularContact",
    0x9e8fa6d3: "pyrogram.api.types.messages.FavedStickersNotModified",
    0xf37f2f16: "pyrogram.api.types.messages.FavedStickers",
    0x46e1d13d: "pyrogram.api.types.RecentMeUrlUnknown",
    0x8dbc3336: "pyrogram.api.types.RecentMeUrlUser",
    0xa01b22f9: "pyrogram.api.types.RecentMeUrlChat",
    0xeb49081d: "pyrogram.api.types.RecentMeUrlChatInvite",
    0xbc0a57dc: "pyrogram.api.types.RecentMeUrlStickerSet",
    0x0e0310d7: "pyrogram.api.types.help.RecentMeUrls",
    0x1cc6e91f: "pyrogram.api.types.InputSingleMedia",
    0xcac943f2: "pyrogram.api.types.WebAuthorization",
    0xed56c9fc: "pyrogram.api.types.account.WebAuthorizations",
    0xa676a322: "pyrogram.api.types.InputMessageID",
    0xbad88395: "pyrogram.api.types.InputMessageReplyTo",
    0x86872538: "pyrogram.api.types.InputMessagePinned",
    0xfcaafeb7: "pyrogram.api.types.InputDialogPeer",
    0x64600527: "pyrogram.api.types.InputDialogPeerFolder",
    0xe56dbf05: "pyrogram.api.types.DialogPeer",
    0x514519e2: "pyrogram.api.types.DialogPeerFolder",
    0x0d54b65d: "pyrogram.api.types.messages.FoundStickerSetsNotModified",
    0x5108d648: "pyrogram.api.types.messages.FoundStickerSets",
    0x6242c773: "pyrogram.api.types.FileHash",
    0x75588b3f: "pyrogram.api.types.InputClientProxy",
    0xe09e1fb8: "pyrogram.api.types.help.ProxyDataEmpty",
    0x2bf7ee23: "pyrogram.api.types.help.ProxyDataPromo",
    0xe3309f7f: "pyrogram.api.types.help.TermsOfServiceUpdateEmpty",
    0x28ecf961: "pyrogram.api.types.help.TermsOfServiceUpdate",
    0x3334b0f0: "pyrogram.api.types.InputSecureFileUploaded",
    0x5367e5be: "pyrogram.api.types.InputSecureFile",
    0x64199744: "pyrogram.api.types.SecureFileEmpty",
    0xe0277a62: "pyrogram.api.types.SecureFile",
    0x8aeabec3: "pyrogram.api.types.SecureData",
    0x7d6099dd: "pyrogram.api.types.SecurePlainPhone",
    0x21ec5a5f: "pyrogram.api.types.SecurePlainEmail",
    0x9d2a81e3: "pyrogram.api.types.SecureValueTypePersonalDetails",
    0x3dac6a00: "pyrogram.api.types.SecureValueTypePassport",
    0x06e425c4: "pyrogram.api.types.SecureValueTypeDriverLicense",
    0xa0d0744b: "pyrogram.api.types.SecureValueTypeIdentityCard",
    0x99a48f23: "pyrogram.api.types.SecureValueTypeInternalPassport",
    0xcbe31e26: "pyrogram.api.types.SecureValueTypeAddress",
    0xfc36954e: "pyrogram.api.types.SecureValueTypeUtilityBill",
    0x89137c0d: "pyrogram.api.types.SecureValueTypeBankStatement",
    0x8b883488: "pyrogram.api.types.SecureValueTypeRentalAgreement",
    0x99e3806a: "pyrogram.api.types.SecureValueTypePassportRegistration",
    0xea02ec33: "pyrogram.api.types.SecureValueTypeTemporaryRegistration",
    0xb320aadb: "pyrogram.api.types.SecureValueTypePhone",
    0x8e3ca7ee: "pyrogram.api.types.SecureValueTypeEmail",
    0x187fa0ca: "pyrogram.api.types.SecureValue",
    0xdb21d0a7: "pyrogram.api.types.InputSecureValue",
    0xed1ecdb0: "pyrogram.api.types.SecureValueHash",
    0xe8a40bd9: "pyrogram.api.types.SecureValueErrorData",
    0x00be3dfa: "pyrogram.api.types.SecureValueErrorFrontSide",
    0x868a2aa5: "pyrogram.api.types.SecureValueErrorReverseSide",
    0xe537ced6: "pyrogram.api.types.SecureValueErrorSelfie",
    0x7a700873: "pyrogram.api.types.SecureValueErrorFile",
    0x666220e9: "pyrogram.api.types.SecureValueErrorFiles",
    0x869d758f: "pyrogram.api.types.SecureValueError",
    0xa1144770: "pyrogram.api.types.SecureValueErrorTranslationFile",
    0x34636dd8: "pyrogram.api.types.SecureValueErrorTranslationFiles",
    0x33f0ea47: "pyrogram.api.types.SecureCredentialsEncrypted",
    0xad2e1cd8: "pyrogram.api.types.account.AuthorizationForm",
    0x811f854f: "pyrogram.api.types.account.SentEmailCode",
    0x66afa166: "pyrogram.api.types.help.DeepLinkInfoEmpty",
    0x6a4ee832: "pyrogram.api.types.help.DeepLinkInfo",
    0x1142bd56: "pyrogram.api.types.SavedPhoneContact",
    0x4dba4501: "pyrogram.api.types.account.Takeout",
    0xd45ab096: "pyrogram.api.types.PasswordKdfAlgoUnknown",
    0x3a912d4a: "pyrogram.api.types.PasswordKdfAlgoSHA256SHA256PBKDF2HMACSHA512iter100000SHA256ModPow",
    0x004a8537: "pyrogram.api.types.SecurePasswordKdfAlgoUnknown",
    0xbbf2dda0: "pyrogram.api.types.SecurePasswordKdfAlgoPBKDF2HMACSHA512iter100000",
    0x86471d92: "pyrogram.api.types.SecurePasswordKdfAlgoSHA512",
    0x1527bcac: "pyrogram.api.types.SecureSecretSettings",
    0x9880f658: "pyrogram.api.types.InputCheckPasswordEmpty",
    0xd27ff082: "pyrogram.api.types.InputCheckPasswordSRP",
    0x829d99da: "pyrogram.api.types.SecureRequiredType",
    0x027477b4: "pyrogram.api.types.SecureRequiredTypeOneOf",
    0xbfb9f457: "pyrogram.api.types.help.PassportConfigNotModified",
    0xa098d6af: "pyrogram.api.types.help.PassportConfig",
    0x1d1b1245: "pyrogram.api.types.InputAppEvent",
    0xc0de1bd9: "pyrogram.api.types.JsonObjectValue",
    0x3f6d7b68: "pyrogram.api.types.JsonNull",
    0xc7345e6a: "pyrogram.api.types.JsonBool",
    0x2be0dfa4: "pyrogram.api.types.JsonNumber",
    0xb71e767a: "pyrogram.api.types.JsonString",
    0xf7444763: "pyrogram.api.types.JsonArray",
    0x99c1d49d: "pyrogram.api.types.JsonObject",
    0x34566b6a: "pyrogram.api.types.PageTableCell",
    0xe0c0c5e5: "pyrogram.api.types.PageTableRow",
    0x6f747657: "pyrogram.api.types.PageCaption",
    0xb92fb6cd: "pyrogram.api.types.PageListItemText",
    0x25e073fc: "pyrogram.api.types.PageListItemBlocks",
    0x5e068047: "pyrogram.api.types.PageListOrderedItemText",
    0x98dd8936: "pyrogram.api.types.PageListOrderedItemBlocks",
    0xb390dc08: "pyrogram.api.types.PageRelatedArticle",
    0xae891bec: "pyrogram.api.types.Page",
    0x8c05f1c9: "pyrogram.api.types.help.SupportName",
    0xf3ae2eed: "pyrogram.api.types.help.UserInfoEmpty",
    0x01eb3758: "pyrogram.api.types.help.UserInfo",
    0x6ca9c2e9: "pyrogram.api.types.PollAnswer",
    0xd5529d06: "pyrogram.api.types.Poll",
    0x3b6ddad2: "pyrogram.api.types.PollAnswerVoters",
    0x5755785a: "pyrogram.api.types.PollResults",
    0xf041e250: "pyrogram.api.types.ChatOnlines",
    0x47a971e0: "pyrogram.api.types.StatsURL",
    0x5fb224d5: "pyrogram.api.types.ChatAdminRights",
    0x9f120418: "pyrogram.api.types.ChatBannedRights",
    0xe630b979: "pyrogram.api.types.InputWallPaper",
    0x72091c80: "pyrogram.api.types.InputWallPaperSlug",
    0x1c199183: "pyrogram.api.types.account.WallPapersNotModified",
    0x702b65a9: "pyrogram.api.types.account.WallPapers",
    0xdebebe83: "pyrogram.api.types.CodeSettings",
    0xa12f40b8: "pyrogram.api.types.WallPaperSettings",
    0xd246fd47: "pyrogram.api.types.AutoDownloadSettings",
    0x63cacf26: "pyrogram.api.types.account.AutoDownloadSettings",
    0xd5b3b9f9: "pyrogram.api.types.EmojiKeyword",
    0x236df622: "pyrogram.api.types.EmojiKeywordDeleted",
    0x5cc761bd: "pyrogram.api.types.EmojiKeywordsDifference",
    0xa575739d: "pyrogram.api.types.EmojiURL",
    0xb3fb5361: "pyrogram.api.types.EmojiLanguage",
    0xbc7fc6cd: "pyrogram.api.types.FileLocationToBeDeprecated",
    0xff544e65: "pyrogram.api.types.Folder",
    0xfbd2c296: "pyrogram.api.types.InputFolderPeer",
    0xe9baa668: "pyrogram.api.types.FolderPeer",
    0xe844ebff: "pyrogram.api.types.messages.SearchCounter",
    0x92d33a0e: "pyrogram.api.types.UrlAuthResultRequest",
    0x8f8c0e4e: "pyrogram.api.types.UrlAuthResultAccepted",
    0xa9d6db1f: "pyrogram.api.types.UrlAuthResultDefault",
    0xbfb5ad8b: "pyrogram.api.types.ChannelLocationEmpty",
    0x209b82db: "pyrogram.api.types.ChannelLocation",
    0xca461b5d: "pyrogram.api.types.PeerLocated",
    0xd072acb4: "pyrogram.api.types.RestrictionReason",
    0x3c5693e9: "pyrogram.api.types.InputTheme",
    0xf5890df1: "pyrogram.api.types.InputThemeSlug",
    0x483d270c: "pyrogram.api.types.ThemeDocumentNotModified",
    0xf7d90ce0: "pyrogram.api.types.Theme",
    0xf41eb622: "pyrogram.api.types.account.ThemesNotModified",
    0x7f676421: "pyrogram.api.types.account.Themes",
    0xcb9f372d: "pyrogram.api.functions.InvokeAfterMsg",
    0x3dc4b4f0: "pyrogram.api.functions.InvokeAfterMsgs",
    0x785188b8: "pyrogram.api.functions.InitConnection",
    0xda9b0d0d: "pyrogram.api.functions.InvokeWithLayer",
    0xbf9459b7: "pyrogram.api.functions.InvokeWithoutUpdates",
    0x365275f2: "pyrogram.api.functions.InvokeWithMessagesRange",
    0xaca9fd2e: "pyrogram.api.functions.InvokeWithTakeout",
    0xa677244f: "pyrogram.api.functions.auth.SendCode",
    0x80eee427: "pyrogram.api.functions.auth.SignUp",
    0xbcd51581: "pyrogram.api.functions.auth.SignIn",
    0x5717da40: "pyrogram.api.functions.auth.LogOut",
    0x9fab0d1a: "pyrogram.api.functions.auth.ResetAuthorizations",
    0xe5bfffcd: "pyrogram.api.functions.auth.ExportAuthorization",
    0xe3ef9613: "pyrogram.api.functions.auth.ImportAuthorization",
    0xcdd42a05: "pyrogram.api.functions.auth.BindTempAuthKey",
    0x67a3ff2c: "pyrogram.api.functions.auth.ImportBotAuthorization",
    0xd18b4d16: "pyrogram.api.functions.auth.CheckPassword",
    0xd897bc66: "pyrogram.api.functions.auth.RequestPasswordRecovery",
    0x4ea56e92: "pyrogram.api.functions.auth.RecoverPassword",
    0x3ef1a9bf: "pyrogram.api.functions.auth.ResendCode",
    0x1f040578: "pyrogram.api.functions.auth.CancelCode",
    0x8e48a188: "pyrogram.api.functions.auth.DropTempAuthKeys",
    0x68976c6f: "pyrogram.api.functions.account.RegisterDevice",
    0x3076c4bf: "pyrogram.api.functions.account.UnregisterDevice",
    0x84be5b93: "pyrogram.api.functions.account.UpdateNotifySettings",
    0x12b3ad31: "pyrogram.api.functions.account.GetNotifySettings",
    0xdb7e1747: "pyrogram.api.functions.account.ResetNotifySettings",
    0x78515775: "pyrogram.api.functions.account.UpdateProfile",
    0x6628562c: "pyrogram.api.functions.account.UpdateStatus",
    0xaabb1763: "pyrogram.api.functions.account.GetWallPapers",
    0xae189d5f: "pyrogram.api.functions.account.ReportPeer",
    0x2714d86c: "pyrogram.api.functions.account.CheckUsername",
    0x3e0bdd7c: "pyrogram.api.functions.account.UpdateUsername",
    0xdadbc950: "pyrogram.api.functions.account.GetPrivacy",
    0xc9f81ce8: "pyrogram.api.functions.account.SetPrivacy",
    0x418d4e0b: "pyrogram.api.functions.account.DeleteAccount",
    0x08fc711d: "pyrogram.api.functions.account.GetAccountTTL",
    0x2442485e: "pyrogram.api.functions.account.SetAccountTTL",
    0x82574ae5: "pyrogram.api.functions.account.SendChangePhoneCode",
    0x70c32edb: "pyrogram.api.functions.account.ChangePhone",
    0x38df3532: "pyrogram.api.functions.account.UpdateDeviceLocked",
    0xe320c158: "pyrogram.api.functions.account.GetAuthorizations",
    0xdf77f3bc: "pyrogram.api.functions.account.ResetAuthorization",
    0x548a30f5: "pyrogram.api.functions.account.GetPassword",
    0x9cd4eaf9: "pyrogram.api.functions.account.GetPasswordSettings",
    0xa59b102f: "pyrogram.api.functions.account.UpdatePasswordSettings",
    0x1b3faa88: "pyrogram.api.functions.account.SendConfirmPhoneCode",
    0x5f2178c3: "pyrogram.api.functions.account.ConfirmPhone",
    0x449e0b51: "pyrogram.api.functions.account.GetTmpPassword",
    0x182e6d6f: "pyrogram.api.functions.account.GetWebAuthorizations",
    0x2d01b9ef: "pyrogram.api.functions.account.ResetWebAuthorization",
    0x682d2594: "pyrogram.api.functions.account.ResetWebAuthorizations",
    0xb288bc7d: "pyrogram.api.functions.account.GetAllSecureValues",
    0x73665bc2: "pyrogram.api.functions.account.GetSecureValue",
    0x899fe31d: "pyrogram.api.functions.account.SaveSecureValue",
    0xb880bc4b: "pyrogram.api.functions.account.DeleteSecureValue",
    0xb86ba8e1: "pyrogram.api.functions.account.GetAuthorizationForm",
    0xe7027c94: "pyrogram.api.functions.account.AcceptAuthorization",
    0xa5a356f9: "pyrogram.api.functions.account.SendVerifyPhoneCode",
    0x4dd3a7f6: "pyrogram.api.functions.account.VerifyPhone",
    0x7011509f: "pyrogram.api.functions.account.SendVerifyEmailCode",
    0xecba39db: "pyrogram.api.functions.account.VerifyEmail",
    0xf05b4804: "pyrogram.api.functions.account.InitTakeoutSession",
    0x1d2652ee: "pyrogram.api.functions.account.FinishTakeoutSession",
    0x8fdf1920: "pyrogram.api.functions.account.ConfirmPasswordEmail",
    0x7a7f2a15: "pyrogram.api.functions.account.ResendPasswordEmail",
    0xc1cbd5b6: "pyrogram.api.functions.account.CancelPasswordEmail",
    0x9f07c728: "pyrogram.api.functions.account.GetContactSignUpNotification",
    0xcff43f61: "pyrogram.api.functions.account.SetContactSignUpNotification",
    0x53577479: "pyrogram.api.functions.account.GetNotifyExceptions",
    0xfc8ddbea: "pyrogram.api.functions.account.GetWallPaper",
    0xdd853661: "pyrogram.api.functions.account.UploadWallPaper",
    0x6c5a5b37: "pyrogram.api.functions.account.SaveWallPaper",
    0xfeed5769: "pyrogram.api.functions.account.InstallWallPaper",
    0xbb3b9804: "pyrogram.api.functions.account.ResetWallPapers",
    0x56da0b3f: "pyrogram.api.functions.account.GetAutoDownloadSettings",
    0x76f36233: "pyrogram.api.functions.account.SaveAutoDownloadSettings",
    0x1c3db333: "pyrogram.api.functions.account.UploadTheme",
    0x2b7ffd7f: "pyrogram.api.functions.account.CreateTheme",
    0x3b8ea202: "pyrogram.api.functions.account.UpdateTheme",
    0xf257106c: "pyrogram.api.functions.account.SaveTheme",
    0x7ae43737: "pyrogram.api.functions.account.InstallTheme",
    0x8d9d742b: "pyrogram.api.functions.account.GetTheme",
    0x285946f8: "pyrogram.api.functions.account.GetThemes",
    0x0d91a548: "pyrogram.api.functions.users.GetUsers",
    0xca30a5b1: "pyrogram.api.functions.users.GetFullUser",
    0x90c894b5: "pyrogram.api.functions.users.SetSecureValueErrors",
    0x2caa4a42: "pyrogram.api.functions.contacts.GetContactIDs",
    0xc4a353ee: "pyrogram.api.functions.contacts.GetStatuses",
    0xc023849f: "pyrogram.api.functions.contacts.GetContacts",
    0x2c800be5: "pyrogram.api.functions.contacts.ImportContacts",
    0x096a0e00: "pyrogram.api.functions.contacts.DeleteContacts",
    0x1013fd9e: "pyrogram.api.functions.contacts.DeleteByPhones",
    0x332b49fc: "pyrogram.api.functions.contacts.Block",
    0xe54100bd: "pyrogram.api.functions.contacts.Unblock",
    0xf57c350f: "pyrogram.api.functions.contacts.GetBlocked",
    0x11f812d8: "pyrogram.api.functions.contacts.Search",
    0xf93ccba3: "pyrogram.api.functions.contacts.ResolveUsername",
    0xd4982db5: "pyrogram.api.functions.contacts.GetTopPeers",
    0x1ae373ac: "pyrogram.api.functions.contacts.ResetTopPeerRating",
    0x879537f1: "pyrogram.api.functions.contacts.ResetSaved",
    0x82f1e39f: "pyrogram.api.functions.contacts.GetSaved",
    0x8514bdda: "pyrogram.api.functions.contacts.ToggleTopPeers",
    0xe8f463d0: "pyrogram.api.functions.contacts.AddContact",
    0xf831a20f: "pyrogram.api.functions.contacts.AcceptContact",
    0x0a356056: "pyrogram.api.functions.contacts.GetLocated",
    0x63c66506: "pyrogram.api.functions.messages.GetMessages",
    0xa0ee3b73: "pyrogram.api.functions.messages.GetDialogs",
    0xdcbb8260: "pyrogram.api.functions.messages.GetHistory",
    0x8614ef68: "pyrogram.api.functions.messages.Search",
    0x0e306d3a: "pyrogram.api.functions.messages.ReadHistory",
    0x1c015b09: "pyrogram.api.functions.messages.DeleteHistory",
    0xe58e95d2: "pyrogram.api.functions.messages.DeleteMessages",
    0x05a954c0: "pyrogram.api.functions.messages.ReceivedMessages",
    0xa3825e50: "pyrogram.api.functions.messages.SetTyping",
    0x520c3870: "pyrogram.api.functions.messages.SendMessage",
    0x3491eba9: "pyrogram.api.functions.messages.SendMedia",
    0xd9fee60e: "pyrogram.api.functions.messages.ForwardMessages",
    0xcf1592db: "pyrogram.api.functions.messages.ReportSpam",
    0x3672e09c: "pyrogram.api.functions.messages.GetPeerSettings",
    0xbd82b658: "pyrogram.api.functions.messages.Report",
    0x3c6aa187: "pyrogram.api.functions.messages.GetChats",
    0x3b831c66: "pyrogram.api.functions.messages.GetFullChat",
    0xdc452855: "pyrogram.api.functions.messages.EditChatTitle",
    0xca4c79d8: "pyrogram.api.functions.messages.EditChatPhoto",
    0xf9a0aa09: "pyrogram.api.functions.messages.AddChatUser",
    0xe0611f16: "pyrogram.api.functions.messages.DeleteChatUser",
    0x09cb126e: "pyrogram.api.functions.messages.CreateChat",
    0x26cf8950: "pyrogram.api.functions.messages.GetDhConfig",
    0xf64daf43: "pyrogram.api.functions.messages.RequestEncryption",
    0x3dbc0415: "pyrogram.api.functions.messages.AcceptEncryption",
    0xedd923c5: "pyrogram.api.functions.messages.DiscardEncryption",
    0x791451ed: "pyrogram.api.functions.messages.SetEncryptedTyping",
    0x7f4b690a: "pyrogram.api.functions.messages.ReadEncryptedHistory",
    0xa9776773: "pyrogram.api.functions.messages.SendEncrypted",
    0x9a901b66: "pyrogram.api.functions.messages.SendEncryptedFile",
    0x32d439a4: "pyrogram.api.functions.messages.SendEncryptedService",
    0x55a5bb66: "pyrogram.api.functions.messages.ReceivedQueue",
    0x4b0c8c0f: "pyrogram.api.functions.messages.ReportEncryptedSpam",
    0x36a73f77: "pyrogram.api.functions.messages.ReadMessageContents",
    0x043d4f2c: "pyrogram.api.functions.messages.GetStickers",
    0x1c9618b1: "pyrogram.api.functions.messages.GetAllStickers",
    0x8b68b0cc: "pyrogram.api.functions.messages.GetWebPagePreview",
    0x0df7534c: "pyrogram.api.functions.messages.ExportChatInvite",
    0x3eadb1bb: "pyrogram.api.functions.messages.CheckChatInvite",
    0x6c50051c: "pyrogram.api.functions.messages.ImportChatInvite",
    0x2619a90e: "pyrogram.api.functions.messages.GetStickerSet",
    0xc78fe460: "pyrogram.api.functions.messages.InstallStickerSet",
    0xf96e55de: "pyrogram.api.functions.messages.UninstallStickerSet",
    0xe6df7378: "pyrogram.api.functions.messages.StartBot",
    0xc4c8a55d: "pyrogram.api.functions.messages.GetMessagesViews",
    0xa9e69f2e: "pyrogram.api.functions.messages.EditChatAdmin",
    0x15a3b8e3: "pyrogram.api.functions.messages.MigrateChat",
    0xbf7225a4: "pyrogram.api.functions.messages.SearchGlobal",
    0x78337739: "pyrogram.api.functions.messages.ReorderStickerSets",
    0x338e2464: "pyrogram.api.functions.messages.GetDocumentByHash",
    0xbf9a776b: "pyrogram.api.functions.messages.SearchGifs",
    0x83bf3d52: "pyrogram.api.functions.messages.GetSavedGifs",
    0x327a30cb: "pyrogram.api.functions.messages.SaveGif",
    0x514e999d: "pyrogram.api.functions.messages.GetInlineBotResults",
    0xeb5ea206: "pyrogram.api.functions.messages.SetInlineBotResults",
    0x220815b0: "pyrogram.api.functions.messages.SendInlineBotResult",
    0xfda68d36: "pyrogram.api.functions.messages.GetMessageEditData",
    0x48f71778: "pyrogram.api.functions.messages.EditMessage",
    0x83557dba: "pyrogram.api.functions.messages.EditInlineBotMessage",
    0x810a9fec: "pyrogram.api.functions.messages.GetBotCallbackAnswer",
    0xd58f130a: "pyrogram.api.functions.messages.SetBotCallbackAnswer",
    0xe470bcfd: "pyrogram.api.functions.messages.GetPeerDialogs",
    0xbc39e14b: "pyrogram.api.functions.messages.SaveDraft",
    0x6a3f8d65: "pyrogram.api.functions.messages.GetAllDrafts",
    0x2dacca4f: "pyrogram.api.functions.messages.GetFeaturedStickers",
    0x5b118126: "pyrogram.api.functions.messages.ReadFeaturedStickers",
    0x5ea192c9: "pyrogram.api.functions.messages.GetRecentStickers",
    0x392718f8: "pyrogram.api.functions.messages.SaveRecentSticker",
    0x8999602d: "pyrogram.api.functions.messages.ClearRecentStickers",
    0x57f17692: "pyrogram.api.functions.messages.GetArchivedStickers",
    0x65b8c79f: "pyrogram.api.functions.messages.GetMaskStickers",
    0xcc5b67cc: "pyrogram.api.functions.messages.GetAttachedStickers",
    0x8ef8ecc0: "pyrogram.api.functions.messages.SetGameScore",
    0x15ad9f64: "pyrogram.api.functions.messages.SetInlineGameScore",
    0xe822649d: "pyrogram.api.functions.messages.GetGameHighScores",
    0x0f635e1b: "pyrogram.api.functions.messages.GetInlineGameHighScores",
    0x0d0a48c4: "pyrogram.api.functions.messages.GetCommonChats",
    0xeba80ff0: "pyrogram.api.functions.messages.GetAllChats",
    0x32ca8f91: "pyrogram.api.functions.messages.GetWebPage",
    0xa731e257: "pyrogram.api.functions.messages.ToggleDialogPin",
    0x3b1adf37: "pyrogram.api.functions.messages.ReorderPinnedDialogs",
    0xd6b94df2: "pyrogram.api.functions.messages.GetPinnedDialogs",
    0xe5f672fa: "pyrogram.api.functions.messages.SetBotShippingResults",
    0x09c2dd95: "pyrogram.api.functions.messages.SetBotPrecheckoutResults",
    0x519bc2b1: "pyrogram.api.functions.messages.UploadMedia",
    0xc97df020: "pyrogram.api.functions.messages.SendScreenshotNotification",
    0x21ce0b0e: "pyrogram.api.functions.messages.GetFavedStickers",
    0xb9ffc55b: "pyrogram.api.functions.messages.FaveSticker",
    0x46578472: "pyrogram.api.functions.messages.GetUnreadMentions",
    0x0f0189d3: "pyrogram.api.functions.messages.ReadMentions",
    0xbbc45b09: "pyrogram.api.functions.messages.GetRecentLocations",
    0xcc0110cb: "pyrogram.api.functions.messages.SendMultiMedia",
    0x5057c497: "pyrogram.api.functions.messages.UploadEncryptedFile",
    0xc2b7d08b: "pyrogram.api.functions.messages.SearchStickerSets",
    0x1cff7e08: "pyrogram.api.functions.messages.GetSplitRanges",
    0xc286d98f: "pyrogram.api.functions.messages.MarkDialogUnread",
    0x22e24e22: "pyrogram.api.functions.messages.GetDialogUnreadMarks",
    0x7e58ee9c: "pyrogram.api.functions.messages.ClearAllDrafts",
    0xd2aaf7ec: "pyrogram.api.functions.messages.UpdatePinnedMessage",
    0x10ea6184: "pyrogram.api.functions.messages.SendVote",
    0x73bb643b: "pyrogram.api.functions.messages.GetPollResults",
    0x6e2be050: "pyrogram.api.functions.messages.GetOnlines",
    0x812c2ae6: "pyrogram.api.functions.messages.GetStatsURL",
    0xdef60797: "pyrogram.api.functions.messages.EditChatAbout",
    0xa5866b41: "pyrogram.api.functions.messages.EditChatDefaultBannedRights",
    0x35a0e062: "pyrogram.api.functions.messages.GetEmojiKeywords",
    0x1508b6af: "pyrogram.api.functions.messages.GetEmojiKeywordsDifference",
    0x4e9963b2: "pyrogram.api.functions.messages.GetEmojiKeywordsLanguages",
    0xd5b10c26: "pyrogram.api.functions.messages.GetEmojiURL",
    0x732eef00: "pyrogram.api.functions.messages.GetSearchCounters",
    0xe33f5613: "pyrogram.api.functions.messages.RequestUrlAuth",
    0xf729ea98: "pyrogram.api.functions.messages.AcceptUrlAuth",
    0x4facb138: "pyrogram.api.functions.messages.HidePeerSettingsBar",
    0xe2c2685b: "pyrogram.api.functions.messages.GetScheduledHistory",
    0xbdbb0464: "pyrogram.api.functions.messages.GetScheduledMessages",
    0xbd38850a: "pyrogram.api.functions.messages.SendScheduledMessages",
    0x59ae2b16: "pyrogram.api.functions.messages.DeleteScheduledMessages",
    0xedd4882a: "pyrogram.api.functions.updates.GetState",
    0x25939651: "pyrogram.api.functions.updates.GetDifference",
    0x03173d78: "pyrogram.api.functions.updates.GetChannelDifference",
    0xf0bb5152: "pyrogram.api.functions.photos.UpdateProfilePhoto",
    0x4f32c098: "pyrogram.api.functions.photos.UploadProfilePhoto",
    0x87cf7f2f: "pyrogram.api.functions.photos.DeletePhotos",
    0x91cd32a8: "pyrogram.api.functions.photos.GetUserPhotos",
    0xb304a621: "pyrogram.api.functions.upload.SaveFilePart",
    0xb15a9afc: "pyrogram.api.functions.upload.GetFile",
    0xde7b673d: "pyrogram.api.functions.upload.SaveBigFilePart",
    0x24e6818d: "pyrogram.api.functions.upload.GetWebFile",
    0x2000bcc3: "pyrogram.api.functions.upload.GetCdnFile",
    0x9b2754a8: "pyrogram.api.functions.upload.ReuploadCdnFile",
    0x4da54231: "pyrogram.api.functions.upload.GetCdnFileHashes",
    0xc7025931: "pyrogram.api.functions.upload.GetFileHashes",
    0xc4f9186b: "pyrogram.api.functions.help.GetConfig",
    0x1fb33026: "pyrogram.api.functions.help.GetNearestDc",
    0x522d5a7d: "pyrogram.api.functions.help.GetAppUpdate",
    0x4d392343: "pyrogram.api.functions.help.GetInviteText",
    0x9cdf08cd: "pyrogram.api.functions.help.GetSupport",
    0x9010ef6f: "pyrogram.api.functions.help.GetAppChangelog",
    0xec22cfcd: "pyrogram.api.functions.help.SetBotUpdatesStatus",
    0x52029342: "pyrogram.api.functions.help.GetCdnConfig",
    0x3dc0f114: "pyrogram.api.functions.help.GetRecentMeUrls",
    0x3d7758e1: "pyrogram.api.functions.help.GetProxyData",
    0x2ca51fd1: "pyrogram.api.functions.help.GetTermsOfServiceUpdate",
    0xee72f79a: "pyrogram.api.functions.help.AcceptTermsOfService",
    0x3fedc75f: "pyrogram.api.functions.help.GetDeepLinkInfo",
    0x98914110: "pyrogram.api.functions.help.GetAppConfig",
    0x6f02f748: "pyrogram.api.functions.help.SaveAppLog",
    0xc661ad08: "pyrogram.api.functions.help.GetPassportConfig",
    0xd360e72c: "pyrogram.api.functions.help.GetSupportName",
    0x038a08d3: "pyrogram.api.functions.help.GetUserInfo",
    0x66b91b70: "pyrogram.api.functions.help.EditUserInfo",
    0xcc104937: "pyrogram.api.functions.channels.ReadHistory",
    0x84c1fd4e: "pyrogram.api.functions.channels.DeleteMessages",
    0xd10dd71b: "pyrogram.api.functions.channels.DeleteUserHistory",
    0xfe087810: "pyrogram.api.functions.channels.ReportSpam",
    0xad8c9a23: "pyrogram.api.functions.channels.GetMessages",
    0x123e05e9: "pyrogram.api.functions.channels.GetParticipants",
    0x546dd7a6: "pyrogram.api.functions.channels.GetParticipant",
    0x0a7f6bbb: "pyrogram.api.functions.channels.GetChannels",
    0x08736a09: "pyrogram.api.functions.channels.GetFullChannel",
    0x3d5fb10f: "pyrogram.api.functions.channels.CreateChannel",
    0xd33c8902: "pyrogram.api.functions.channels.EditAdmin",
    0x566decd0: "pyrogram.api.functions.channels.EditTitle",
    0xf12e57c9: "pyrogram.api.functions.channels.EditPhoto",
    0x10e6bd2c: "pyrogram.api.functions.channels.CheckUsername",
    0x3514b3de: "pyrogram.api.functions.channels.UpdateUsername",
    0x24b524c5: "pyrogram.api.functions.channels.JoinChannel",
    0xf836aa95: "pyrogram.api.functions.channels.LeaveChannel",
    0x199f3a6c: "pyrogram.api.functions.channels.InviteToChannel",
    0xc0111fe3: "pyrogram.api.functions.channels.DeleteChannel",
    0xceb77163: "pyrogram.api.functions.channels.ExportMessageLink",
    0x1f69b606: "pyrogram.api.functions.channels.ToggleSignatures",
    0xf8b036af: "pyrogram.api.functions.channels.GetAdminedPublicChannels",
    0x72796912: "pyrogram.api.functions.channels.EditBanned",
    0x33ddf480: "pyrogram.api.functions.channels.GetAdminLog",
    0xea8ca4f9: "pyrogram.api.functions.channels.SetStickers",
    0xeab5dc38: "pyrogram.api.functions.channels.ReadMessageContents",
    0xaf369d42: "pyrogram.api.functions.channels.DeleteHistory",
    0xeabbb94c: "pyrogram.api.functions.channels.TogglePreHistoryHidden",
    0x8341ecc0: "pyrogram.api.functions.channels.GetLeftChannels",
    0xf5dad378: "pyrogram.api.functions.channels.GetGroupsForDiscussion",
    0x40582bb2: "pyrogram.api.functions.channels.SetDiscussionGroup",
    0x8f38cd1f: "pyrogram.api.functions.channels.EditCreator",
    0x58e63f6d: "pyrogram.api.functions.channels.EditLocation",
    0xedd49ef0: "pyrogram.api.functions.channels.ToggleSlowMode",
    0xaa2769ed: "pyrogram.api.functions.bots.SendCustomRequest",
    0xe6213f4d: "pyrogram.api.functions.bots.AnswerWebhookJSONQuery",
    0x99f09745: "pyrogram.api.functions.payments.GetPaymentForm",
    0xa092a980: "pyrogram.api.functions.payments.GetPaymentReceipt",
    0x770a8e74: "pyrogram.api.functions.payments.ValidateRequestedInfo",
    0x2b8879b3: "pyrogram.api.functions.payments.SendPaymentForm",
    0x227d824b: "pyrogram.api.functions.payments.GetSavedInfo",
    0xd83d70c1: "pyrogram.api.functions.payments.ClearSavedInfo",
    0x9bd86e6a: "pyrogram.api.functions.stickers.CreateStickerSet",
    0xf7760f51: "pyrogram.api.functions.stickers.RemoveStickerFromSet",
    0xffb6d4ca: "pyrogram.api.functions.stickers.ChangeStickerPosition",
    0x8653febe: "pyrogram.api.functions.stickers.AddStickerToSet",
    0x55451fa9: "pyrogram.api.functions.phone.GetCallConfig",
    0x42ff96ed: "pyrogram.api.functions.phone.RequestCall",
    0x3bd2b4a0: "pyrogram.api.functions.phone.AcceptCall",
    0x2efe1722: "pyrogram.api.functions.phone.ConfirmCall",
    0x17d54f61: "pyrogram.api.functions.phone.ReceivedCall",
    0xb2cbc1c0: "pyrogram.api.functions.phone.DiscardCall",
    0x59ead627: "pyrogram.api.functions.phone.SetCallRating",
    0x277add7e: "pyrogram.api.functions.phone.SaveCallDebug",
    0xf2f2330a: "pyrogram.api.functions.langpack.GetLangPack",
    0xefea3803: "pyrogram.api.functions.langpack.GetStrings",
    0xcd984aa5: "pyrogram.api.functions.langpack.GetDifference",
    0x42c6978f: "pyrogram.api.functions.langpack.GetLanguages",
    0x6a596502: "pyrogram.api.functions.langpack.GetLanguage",
    0x6847d0ab: "pyrogram.api.functions.folders.EditPeerFolders",
    0x1c295881: "pyrogram.api.functions.folders.DeleteFolder",
    0xbc799737: "pyrogram.api.core.BoolFalse",
    0x997275b5: "pyrogram.api.core.BoolTrue",
    0x1cb5c415: "pyrogram.api.core.Vector",
    0x73f1f8dc: "pyrogram.api.core.MsgContainer",
    0xae500895: "pyrogram.api.core.FutureSalts",
    0x0949d9dc: "pyrogram.api.core.FutureSalt",
    0x3072cfa1: "pyrogram.api.core.GzipPacked",
    0x5bb8e511: "pyrogram.api.core.Message",
}
