# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.serialization import FieldMetadata
from ..core.unchecked_base_model import UncheckedBaseModel
from .extract_async_submission_response_status import ExtractAsyncSubmissionResponseStatus


class ExtractAsyncResponse(UncheckedBaseModel):
    """
    Metadata describing the enqueued asynchronous extraction job.
    """

    job_id: str = pydantic.Field()
    """
    Identifier assigned to the asynchronous extraction job.
    """

    status: ExtractAsyncSubmissionResponseStatus = pydantic.Field()
    """
    Initial status reported by the extractor.
    """

    queued_at: typing_extensions.Annotated[typing.Optional[dt.datetime], FieldMetadata(alias="queuedAt")] = (
        pydantic.Field(default=None)
    )
    """
    Timestamp indicating when the job was accepted.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
