"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BootstraplessSynthesizer = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const _shared_1 = require("./_shared");
const default_synthesizer_1 = require("./default-synthesizer");
/**
 * Synthesizer that reuses bootstrap roles from a different region
 *
 * A special synthesizer that behaves similarly to `DefaultStackSynthesizer`,
 * but doesn't require bootstrapping the environment it operates in. Instead,
 * it will re-use the Roles that were created for a different region (which
 * is possible because IAM is a global service).
 *
 * However, it will not assume asset buckets or repositories have been created,
 * and therefore does not support assets.
 *
 * Used by the CodePipeline construct for the support stacks needed for
 * cross-region replication S3 buckets. App builders do not need to use this
 * synthesizer directly.
 */
class BootstraplessSynthesizer extends default_synthesizer_1.DefaultStackSynthesizer {
    constructor(props) {
        super({
            deployRoleArn: props.deployRoleArn,
            cloudFormationExecutionRole: props.cloudFormationExecutionRoleArn,
            generateBootstrapVersionRule: false,
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_core_BootstraplessSynthesizerProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, BootstraplessSynthesizer);
            }
            throw error;
        }
    }
    addFileAsset(_asset) {
        try {
            jsiiDeprecationWarnings._aws_cdk_core_FileAssetSource(_asset);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addFileAsset);
            }
            throw error;
        }
        throw new Error('Cannot add assets to a Stack that uses the BootstraplessSynthesizer');
    }
    addDockerImageAsset(_asset) {
        try {
            jsiiDeprecationWarnings._aws_cdk_core_DockerImageAssetSource(_asset);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addDockerImageAsset);
            }
            throw error;
        }
        throw new Error('Cannot add assets to a Stack that uses the BootstraplessSynthesizer');
    }
    synthesize(session) {
        try {
            jsiiDeprecationWarnings._aws_cdk_core_ISynthesisSession(session);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.synthesize);
            }
            throw error;
        }
        _shared_1.assertBound(this.stack);
        this.synthesizeStackTemplate(this.stack, session);
        // do _not_ treat the template as an asset,
        // because this synthesizer doesn't have a bootstrap bucket to put it in
        this.emitStackArtifact(this.stack, session, {
            assumeRoleArn: this.deployRoleArn,
            cloudFormationExecutionRoleArn: this.cloudFormationExecutionRoleArn,
        });
    }
}
exports.BootstraplessSynthesizer = BootstraplessSynthesizer;
_a = JSII_RTTI_SYMBOL_1;
BootstraplessSynthesizer[_a] = { fqn: "@aws-cdk/core.BootstraplessSynthesizer", version: "1.181.1" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYm9vdHN0cmFwbGVzcy1zeW50aGVzaXplci5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImJvb3RzdHJhcGxlc3Mtc3ludGhlc2l6ZXIudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBRUEsdUNBQXdDO0FBQ3hDLCtEQUFnRTtBQXNCaEU7Ozs7Ozs7Ozs7Ozs7O0dBY0c7QUFDSCxNQUFhLHdCQUF5QixTQUFRLDZDQUF1QjtJQUNuRSxZQUFZLEtBQW9DO1FBQzlDLEtBQUssQ0FBQztZQUNKLGFBQWEsRUFBRSxLQUFLLENBQUMsYUFBYTtZQUNsQywyQkFBMkIsRUFBRSxLQUFLLENBQUMsOEJBQThCO1lBQ2pFLDRCQUE0QixFQUFFLEtBQUs7U0FDcEMsQ0FBQyxDQUFDOzs7Ozs7K0NBTk0sd0JBQXdCOzs7O0tBT2xDO0lBRU0sWUFBWSxDQUFDLE1BQXVCOzs7Ozs7Ozs7O1FBQ3pDLE1BQU0sSUFBSSxLQUFLLENBQUMscUVBQXFFLENBQUMsQ0FBQztLQUN4RjtJQUVNLG1CQUFtQixDQUFDLE1BQThCOzs7Ozs7Ozs7O1FBQ3ZELE1BQU0sSUFBSSxLQUFLLENBQUMscUVBQXFFLENBQUMsQ0FBQztLQUN4RjtJQUVNLFVBQVUsQ0FBQyxPQUEwQjs7Ozs7Ozs7OztRQUMxQyxxQkFBVyxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsQ0FBQztRQUV4QixJQUFJLENBQUMsdUJBQXVCLENBQUMsSUFBSSxDQUFDLEtBQUssRUFBRSxPQUFPLENBQUMsQ0FBQztRQUVsRCwyQ0FBMkM7UUFDM0Msd0VBQXdFO1FBQ3hFLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsS0FBSyxFQUFFLE9BQU8sRUFBRTtZQUMxQyxhQUFhLEVBQUUsSUFBSSxDQUFDLGFBQWE7WUFDakMsOEJBQThCLEVBQUUsSUFBSSxDQUFDLDhCQUE4QjtTQUNwRSxDQUFDLENBQUM7S0FDSjs7QUE1QkgsNERBNkJDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgRG9ja2VySW1hZ2VBc3NldExvY2F0aW9uLCBEb2NrZXJJbWFnZUFzc2V0U291cmNlLCBGaWxlQXNzZXRMb2NhdGlvbiwgRmlsZUFzc2V0U291cmNlIH0gZnJvbSAnLi4vYXNzZXRzJztcbmltcG9ydCB7IElTeW50aGVzaXNTZXNzaW9uIH0gZnJvbSAnLi4vY29uc3RydWN0LWNvbXBhdCc7XG5pbXBvcnQgeyBhc3NlcnRCb3VuZCB9IGZyb20gJy4vX3NoYXJlZCc7XG5pbXBvcnQgeyBEZWZhdWx0U3RhY2tTeW50aGVzaXplciB9IGZyb20gJy4vZGVmYXVsdC1zeW50aGVzaXplcic7XG5cbi8qKlxuICogQ29uc3RydWN0aW9uIHByb3BlcnRpZXMgb2Yge0BsaW5rIEJvb3RzdHJhcGxlc3NTeW50aGVzaXplcn0uXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgQm9vdHN0cmFwbGVzc1N5bnRoZXNpemVyUHJvcHMge1xuICAvKipcbiAgICogVGhlIGRlcGxveSBSb2xlIEFSTiB0byB1c2UuXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gTm8gZGVwbG95IHJvbGUgKHVzZSBDTEkgY3JlZGVudGlhbHMpXG4gICAqXG4gICAqL1xuICByZWFkb25seSBkZXBsb3lSb2xlQXJuPzogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBUaGUgQ0ZOIGV4ZWN1dGlvbiBSb2xlIEFSTiB0byB1c2UuXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gTm8gQ2xvdWRGb3JtYXRpb24gcm9sZSAodXNlIENMSSBjcmVkZW50aWFscylcbiAgICovXG4gIHJlYWRvbmx5IGNsb3VkRm9ybWF0aW9uRXhlY3V0aW9uUm9sZUFybj86IHN0cmluZztcbn1cblxuLyoqXG4gKiBTeW50aGVzaXplciB0aGF0IHJldXNlcyBib290c3RyYXAgcm9sZXMgZnJvbSBhIGRpZmZlcmVudCByZWdpb25cbiAqXG4gKiBBIHNwZWNpYWwgc3ludGhlc2l6ZXIgdGhhdCBiZWhhdmVzIHNpbWlsYXJseSB0byBgRGVmYXVsdFN0YWNrU3ludGhlc2l6ZXJgLFxuICogYnV0IGRvZXNuJ3QgcmVxdWlyZSBib290c3RyYXBwaW5nIHRoZSBlbnZpcm9ubWVudCBpdCBvcGVyYXRlcyBpbi4gSW5zdGVhZCxcbiAqIGl0IHdpbGwgcmUtdXNlIHRoZSBSb2xlcyB0aGF0IHdlcmUgY3JlYXRlZCBmb3IgYSBkaWZmZXJlbnQgcmVnaW9uICh3aGljaFxuICogaXMgcG9zc2libGUgYmVjYXVzZSBJQU0gaXMgYSBnbG9iYWwgc2VydmljZSkuXG4gKlxuICogSG93ZXZlciwgaXQgd2lsbCBub3QgYXNzdW1lIGFzc2V0IGJ1Y2tldHMgb3IgcmVwb3NpdG9yaWVzIGhhdmUgYmVlbiBjcmVhdGVkLFxuICogYW5kIHRoZXJlZm9yZSBkb2VzIG5vdCBzdXBwb3J0IGFzc2V0cy5cbiAqXG4gKiBVc2VkIGJ5IHRoZSBDb2RlUGlwZWxpbmUgY29uc3RydWN0IGZvciB0aGUgc3VwcG9ydCBzdGFja3MgbmVlZGVkIGZvclxuICogY3Jvc3MtcmVnaW9uIHJlcGxpY2F0aW9uIFMzIGJ1Y2tldHMuIEFwcCBidWlsZGVycyBkbyBub3QgbmVlZCB0byB1c2UgdGhpc1xuICogc3ludGhlc2l6ZXIgZGlyZWN0bHkuXG4gKi9cbmV4cG9ydCBjbGFzcyBCb290c3RyYXBsZXNzU3ludGhlc2l6ZXIgZXh0ZW5kcyBEZWZhdWx0U3RhY2tTeW50aGVzaXplciB7XG4gIGNvbnN0cnVjdG9yKHByb3BzOiBCb290c3RyYXBsZXNzU3ludGhlc2l6ZXJQcm9wcykge1xuICAgIHN1cGVyKHtcbiAgICAgIGRlcGxveVJvbGVBcm46IHByb3BzLmRlcGxveVJvbGVBcm4sXG4gICAgICBjbG91ZEZvcm1hdGlvbkV4ZWN1dGlvblJvbGU6IHByb3BzLmNsb3VkRm9ybWF0aW9uRXhlY3V0aW9uUm9sZUFybixcbiAgICAgIGdlbmVyYXRlQm9vdHN0cmFwVmVyc2lvblJ1bGU6IGZhbHNlLFxuICAgIH0pO1xuICB9XG5cbiAgcHVibGljIGFkZEZpbGVBc3NldChfYXNzZXQ6IEZpbGVBc3NldFNvdXJjZSk6IEZpbGVBc3NldExvY2F0aW9uIHtcbiAgICB0aHJvdyBuZXcgRXJyb3IoJ0Nhbm5vdCBhZGQgYXNzZXRzIHRvIGEgU3RhY2sgdGhhdCB1c2VzIHRoZSBCb290c3RyYXBsZXNzU3ludGhlc2l6ZXInKTtcbiAgfVxuXG4gIHB1YmxpYyBhZGREb2NrZXJJbWFnZUFzc2V0KF9hc3NldDogRG9ja2VySW1hZ2VBc3NldFNvdXJjZSk6IERvY2tlckltYWdlQXNzZXRMb2NhdGlvbiB7XG4gICAgdGhyb3cgbmV3IEVycm9yKCdDYW5ub3QgYWRkIGFzc2V0cyB0byBhIFN0YWNrIHRoYXQgdXNlcyB0aGUgQm9vdHN0cmFwbGVzc1N5bnRoZXNpemVyJyk7XG4gIH1cblxuICBwdWJsaWMgc3ludGhlc2l6ZShzZXNzaW9uOiBJU3ludGhlc2lzU2Vzc2lvbik6IHZvaWQge1xuICAgIGFzc2VydEJvdW5kKHRoaXMuc3RhY2spO1xuXG4gICAgdGhpcy5zeW50aGVzaXplU3RhY2tUZW1wbGF0ZSh0aGlzLnN0YWNrLCBzZXNzaW9uKTtcblxuICAgIC8vIGRvIF9ub3RfIHRyZWF0IHRoZSB0ZW1wbGF0ZSBhcyBhbiBhc3NldCxcbiAgICAvLyBiZWNhdXNlIHRoaXMgc3ludGhlc2l6ZXIgZG9lc24ndCBoYXZlIGEgYm9vdHN0cmFwIGJ1Y2tldCB0byBwdXQgaXQgaW5cbiAgICB0aGlzLmVtaXRTdGFja0FydGlmYWN0KHRoaXMuc3RhY2ssIHNlc3Npb24sIHtcbiAgICAgIGFzc3VtZVJvbGVBcm46IHRoaXMuZGVwbG95Um9sZUFybixcbiAgICAgIGNsb3VkRm9ybWF0aW9uRXhlY3V0aW9uUm9sZUFybjogdGhpcy5jbG91ZEZvcm1hdGlvbkV4ZWN1dGlvblJvbGVBcm4sXG4gICAgfSk7XG4gIH1cbn1cbiJdfQ==