// SPDX-FileCopyrightText: 2024-present Proxima Fusion GmbH
// <info@proximafusion.com>
//
// SPDX-License-Identifier: MIT
#ifndef VMECPP_VMEC_OUTPUT_QUANTITIES_TEST_HELPERS_H_
#define VMECPP_VMEC_OUTPUT_QUANTITIES_TEST_HELPERS_H_

#include "gtest/gtest.h"
#include "vmecpp/vmec/output_quantities/output_quantities.h"

// check for equality of two `WOutFileContents` using the Google test framework
inline void CheckWOutEquality(const vmecpp::WOutFileContents& wout1,
                              const vmecpp::WOutFileContents& wout2) {
  EXPECT_EQ(wout1.version, wout2.version);
  EXPECT_EQ(wout1.sign_of_jacobian, wout2.sign_of_jacobian);
  EXPECT_EQ(wout1.gamma, wout2.gamma);
  EXPECT_EQ(wout1.pcurr_type, wout2.pcurr_type);
  EXPECT_EQ(wout1.pmass_type, wout2.pmass_type);
  EXPECT_EQ(wout1.piota_type, wout2.piota_type);
  EXPECT_EQ(wout1.am, wout2.am);
  EXPECT_EQ(wout1.ac, wout2.ac);
  EXPECT_EQ(wout1.ai, wout2.ai);
  EXPECT_EQ(wout1.am_aux_s, wout2.am_aux_s);
  EXPECT_EQ(wout1.am_aux_f, wout2.am_aux_f);
  EXPECT_EQ(wout1.ac_aux_s, wout2.ac_aux_s);
  EXPECT_EQ(wout1.ac_aux_f, wout2.ac_aux_f);
  EXPECT_EQ(wout1.ai_aux_s, wout2.ai_aux_s);
  EXPECT_EQ(wout1.ai_aux_f, wout2.ai_aux_f);
  EXPECT_EQ(wout1.nfp, wout2.nfp);
  EXPECT_EQ(wout1.mpol, wout2.mpol);
  EXPECT_EQ(wout1.ntor, wout2.ntor);
  EXPECT_EQ(wout1.lasym, wout2.lasym);
  EXPECT_EQ(wout1.ns, wout2.ns);
  EXPECT_EQ(wout1.ftolv, wout2.ftolv);
  EXPECT_EQ(wout1.maximum_iterations, wout2.maximum_iterations);
  EXPECT_EQ(wout1.lfreeb, wout2.lfreeb);
  EXPECT_EQ(wout1.mgrid_file, wout2.mgrid_file);
  EXPECT_EQ(wout1.extcur, wout2.extcur);
  EXPECT_EQ(wout1.mgrid_mode, wout2.mgrid_mode);
  EXPECT_EQ(wout1.wb, wout2.wb);
  EXPECT_EQ(wout1.wp, wout2.wp);
  EXPECT_EQ(wout1.rmax_surf, wout2.rmax_surf);
  EXPECT_EQ(wout1.rmin_surf, wout2.rmin_surf);
  EXPECT_EQ(wout1.zmax_surf, wout2.zmax_surf);
  EXPECT_EQ(wout1.mnmax, wout2.mnmax);
  EXPECT_EQ(wout1.mnmax_nyq, wout2.mnmax_nyq);
  EXPECT_EQ(wout1.ier_flag, wout2.ier_flag);
  EXPECT_EQ(wout1.aspect, wout2.aspect);
  EXPECT_EQ(wout1.betatot, wout2.betatot);
  EXPECT_EQ(wout1.betapol, wout2.betapol);
  EXPECT_EQ(wout1.betator, wout2.betator);
  EXPECT_EQ(wout1.betaxis, wout2.betaxis);
  EXPECT_EQ(wout1.b0, wout2.b0);
  EXPECT_EQ(wout1.rbtor0, wout2.rbtor0);
  EXPECT_EQ(wout1.rbtor, wout2.rbtor);
  EXPECT_EQ(wout1.IonLarmor, wout2.IonLarmor);
  EXPECT_EQ(wout1.VolAvgB, wout2.VolAvgB);
  EXPECT_EQ(wout1.ctor, wout2.ctor);
  EXPECT_EQ(wout1.Aminor_p, wout2.Aminor_p);
  EXPECT_EQ(wout1.Rmajor_p, wout2.Rmajor_p);
  EXPECT_EQ(wout1.volume_p, wout2.volume_p);
  EXPECT_EQ(wout1.fsqr, wout2.fsqr);
  EXPECT_EQ(wout1.fsqz, wout2.fsqz);
  EXPECT_EQ(wout1.fsql, wout2.fsql);
  EXPECT_EQ(wout1.iota_full, wout2.iota_full);
  EXPECT_EQ(wout1.safety_factor, wout2.safety_factor);
  EXPECT_EQ(wout1.pressure_full, wout2.pressure_full);
  EXPECT_EQ(wout1.toroidal_flux, wout2.toroidal_flux);
  EXPECT_EQ(wout1.phipf, wout2.phipf);
  EXPECT_EQ(wout1.poloidal_flux, wout2.poloidal_flux);
  EXPECT_EQ(wout1.chipf, wout2.chipf);
  EXPECT_EQ(wout1.jcuru, wout2.jcuru);
  EXPECT_EQ(wout1.jcurv, wout2.jcurv);
  EXPECT_EQ(wout1.iota_half, wout2.iota_half);
  EXPECT_EQ(wout1.mass, wout2.mass);
  EXPECT_EQ(wout1.pressure_half, wout2.pressure_half);
  EXPECT_EQ(wout1.beta, wout2.beta);
  EXPECT_EQ(wout1.buco, wout2.buco);
  EXPECT_EQ(wout1.bvco, wout2.bvco);
  EXPECT_EQ(wout1.dVds, wout2.dVds);
  EXPECT_EQ(wout1.spectral_width, wout2.spectral_width);
  EXPECT_EQ(wout1.phips, wout2.phips);
  EXPECT_EQ(wout1.overr, wout2.overr);
  EXPECT_EQ(wout1.jdotb, wout2.jdotb);
  EXPECT_EQ(wout1.bdotgradv, wout2.bdotgradv);
  EXPECT_EQ(wout1.DMerc, wout2.DMerc);
  EXPECT_EQ(wout1.Dshear, wout2.Dshear);
  EXPECT_EQ(wout1.Dwell, wout2.Dwell);
  EXPECT_EQ(wout1.Dcurr, wout2.Dcurr);
  EXPECT_EQ(wout1.Dgeod, wout2.Dgeod);
  EXPECT_EQ(wout1.equif, wout2.equif);
  EXPECT_EQ(wout1.curlabel, wout2.curlabel);
  EXPECT_EQ(wout1.potvac, wout2.potvac);
  EXPECT_EQ(wout1.xm, wout2.xm);
  EXPECT_EQ(wout1.xn, wout2.xn);
  EXPECT_EQ(wout1.xm_nyq, wout2.xm_nyq);
  EXPECT_EQ(wout1.xn_nyq, wout2.xn_nyq);
  EXPECT_EQ(wout1.raxis_c, wout2.raxis_c);
  EXPECT_EQ(wout1.zaxis_s, wout2.zaxis_s);
  EXPECT_EQ(wout1.rmnc, wout2.rmnc);
  EXPECT_EQ(wout1.zmns, wout2.zmns);
  EXPECT_EQ(wout1.lmns_full, wout2.lmns_full);
  EXPECT_EQ(wout1.lmns, wout2.lmns);
  EXPECT_EQ(wout1.gmnc, wout2.gmnc);
  EXPECT_EQ(wout1.bmnc, wout2.bmnc);
  EXPECT_EQ(wout1.bsubumnc, wout2.bsubumnc);
  EXPECT_EQ(wout1.bsubvmnc, wout2.bsubvmnc);
  EXPECT_EQ(wout1.bsubsmns, wout2.bsubsmns);
  EXPECT_EQ(wout1.bsubsmns_full, wout2.bsubsmns_full);
  EXPECT_EQ(wout1.bsupumnc, wout2.bsupumnc);
  EXPECT_EQ(wout1.bsupvmnc, wout2.bsupvmnc);
  EXPECT_EQ(wout1.raxis_s, wout2.raxis_s);
  EXPECT_EQ(wout1.zaxis_c, wout2.zaxis_c);
  EXPECT_EQ(wout1.rmns, wout2.rmns);
  EXPECT_EQ(wout1.zmnc, wout2.zmnc);
  EXPECT_EQ(wout1.lmnc_full, wout2.lmnc_full);
  EXPECT_EQ(wout1.lmnc, wout2.lmnc);
  EXPECT_EQ(wout1.gmns, wout2.gmns);
  EXPECT_EQ(wout1.bmns, wout2.bmns);
  EXPECT_EQ(wout1.bsubumns, wout2.bsubumns);
  EXPECT_EQ(wout1.bsubvmns, wout2.bsubvmns);
  EXPECT_EQ(wout1.bsubsmnc, wout2.bsubsmnc);
  EXPECT_EQ(wout1.bsubsmnc_full, wout2.bsubsmnc_full);
  EXPECT_EQ(wout1.bsupumns, wout2.bsupumns);
  EXPECT_EQ(wout1.bsupvmns, wout2.bsupvmns);
}

#endif  // VMECPP_VMEC_OUTPUT_QUANTITIES_TEST_HELPERS_H_"
