# coding: utf-8

"""
    Purplship Open Source Multi-carrier Shipping API

     Purplship is an open source multi-carrier shipping API that simplifies the integration of logistic carrier services  The **proxy** endpoints are stateless and forwards calls to carriers web services.   # noqa: E501

    OpenAPI spec version: v1-2020.10.0
    Contact: hello@purplship.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from purplship.api_client import ApiClient


class PickupsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def cancel(self, body, carrier_name, **kwargs):  # noqa: E501
        """Cancel a pickup  # noqa: E501

        **[proxy]**  Cancel a pickup previously scheduled  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cancel(body, carrier_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PickupCancelRequest body: (required)
        :param str carrier_name: (required)
        :param bool test:  The test flag indicates whether to use a carrier configured for test.  
        :return: OperationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.cancel_with_http_info(body, carrier_name, **kwargs)  # noqa: E501
        else:
            (data) = self.cancel_with_http_info(body, carrier_name, **kwargs)  # noqa: E501
            return data

    def cancel_with_http_info(self, body, carrier_name, **kwargs):  # noqa: E501
        """Cancel a pickup  # noqa: E501

        **[proxy]**  Cancel a pickup previously scheduled  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cancel_with_http_info(body, carrier_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PickupCancelRequest body: (required)
        :param str carrier_name: (required)
        :param bool test:  The test flag indicates whether to use a carrier configured for test.  
        :return: OperationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'carrier_name', 'test']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cancel" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `cancel`")  # noqa: E501
        # verify the required parameter 'carrier_name' is set
        if ('carrier_name' not in params or
                params['carrier_name'] is None):
            raise ValueError("Missing the required parameter `carrier_name` when calling `cancel`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'carrier_name' in params:
            path_params['carrier_name'] = params['carrier_name']  # noqa: E501

        query_params = []
        if 'test' in params:
            query_params.append(('test', params['test']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/proxy/pickups/{carrier_name}/cancel', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OperationResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def schedule(self, body, carrier_name, **kwargs):  # noqa: E501
        """Schedule a pickup  # noqa: E501

        **[proxy]**  Schedule one or many parcels pickup  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.schedule(body, carrier_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PickupRequest body: (required)
        :param str carrier_name: (required)
        :param bool test:  The test flag indicates whether to use a carrier configured for test.  
        :return: PickupResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.schedule_with_http_info(body, carrier_name, **kwargs)  # noqa: E501
        else:
            (data) = self.schedule_with_http_info(body, carrier_name, **kwargs)  # noqa: E501
            return data

    def schedule_with_http_info(self, body, carrier_name, **kwargs):  # noqa: E501
        """Schedule a pickup  # noqa: E501

        **[proxy]**  Schedule one or many parcels pickup  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.schedule_with_http_info(body, carrier_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PickupRequest body: (required)
        :param str carrier_name: (required)
        :param bool test:  The test flag indicates whether to use a carrier configured for test.  
        :return: PickupResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'carrier_name', 'test']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method schedule" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `schedule`")  # noqa: E501
        # verify the required parameter 'carrier_name' is set
        if ('carrier_name' not in params or
                params['carrier_name'] is None):
            raise ValueError("Missing the required parameter `carrier_name` when calling `schedule`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'carrier_name' in params:
            path_params['carrier_name'] = params['carrier_name']  # noqa: E501

        query_params = []
        if 'test' in params:
            query_params.append(('test', params['test']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/proxy/pickups/{carrier_name}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PickupResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update(self, body, carrier_name, **kwargs):  # noqa: E501
        """Update a pickup  # noqa: E501

        **[proxy]**  Modify a scheduled pickup  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update(body, carrier_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PickupUpdateRequest body: (required)
        :param str carrier_name: (required)
        :param bool test:  The test flag indicates whether to use a carrier configured for test.  
        :return: PickupResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_with_http_info(body, carrier_name, **kwargs)  # noqa: E501
        else:
            (data) = self.update_with_http_info(body, carrier_name, **kwargs)  # noqa: E501
            return data

    def update_with_http_info(self, body, carrier_name, **kwargs):  # noqa: E501
        """Update a pickup  # noqa: E501

        **[proxy]**  Modify a scheduled pickup  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_with_http_info(body, carrier_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PickupUpdateRequest body: (required)
        :param str carrier_name: (required)
        :param bool test:  The test flag indicates whether to use a carrier configured for test.  
        :return: PickupResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'carrier_name', 'test']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update`")  # noqa: E501
        # verify the required parameter 'carrier_name' is set
        if ('carrier_name' not in params or
                params['carrier_name'] is None):
            raise ValueError("Missing the required parameter `carrier_name` when calling `update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'carrier_name' in params:
            path_params['carrier_name'] = params['carrier_name']  # noqa: E501

        query_params = []
        if 'test' in params:
            query_params.append(('test', params['test']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/proxy/pickups/{carrier_name}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PickupResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
