# coding: utf-8

"""
    Purplship Open Source Multi-carrier Shipping API

     Purplship is an open source multi-carrier shipping API that simplifies the integration of logistic carrier services  The **proxy** endpoints are stateless and forwards calls to carriers web services.   # noqa: E501

    OpenAPI spec version: v1-2020.10.0
    Contact: hello@purplship.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from purplship.api_client import ApiClient


class TrackingApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def fetch(self, carrier_name, tracking_number, **kwargs):  # noqa: E501
        """Track a shipment  # noqa: E501

        **[proxy]**  You can track a shipment by specifying the carrier and the shipment tracking number.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.fetch(carrier_name, tracking_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str carrier_name: (required)
        :param str tracking_number: (required)
        :param bool test:  The test flag indicates whether to use a carrier configured for test.  
        :return: TrackingResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.fetch_with_http_info(carrier_name, tracking_number, **kwargs)  # noqa: E501
        else:
            (data) = self.fetch_with_http_info(carrier_name, tracking_number, **kwargs)  # noqa: E501
            return data

    def fetch_with_http_info(self, carrier_name, tracking_number, **kwargs):  # noqa: E501
        """Track a shipment  # noqa: E501

        **[proxy]**  You can track a shipment by specifying the carrier and the shipment tracking number.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.fetch_with_http_info(carrier_name, tracking_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str carrier_name: (required)
        :param str tracking_number: (required)
        :param bool test:  The test flag indicates whether to use a carrier configured for test.  
        :return: TrackingResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['carrier_name', 'tracking_number', 'test']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method fetch" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'carrier_name' is set
        if ('carrier_name' not in params or
                params['carrier_name'] is None):
            raise ValueError("Missing the required parameter `carrier_name` when calling `fetch`")  # noqa: E501
        # verify the required parameter 'tracking_number' is set
        if ('tracking_number' not in params or
                params['tracking_number'] is None):
            raise ValueError("Missing the required parameter `tracking_number` when calling `fetch`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'carrier_name' in params:
            path_params['carrier_name'] = params['carrier_name']  # noqa: E501
        if 'tracking_number' in params:
            path_params['tracking_number'] = params['tracking_number']  # noqa: E501

        query_params = []
        if 'test' in params:
            query_params.append(('test', params['test']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Token']  # noqa: E501

        return self.api_client.call_api(
            '/proxy/tracking/{carrier_name}/{tracking_number}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TrackingResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
