# coding: utf-8

"""
    Purplship Open Source Multi-carrier Shipping API

     Purplship is an open source multi-carrier shipping API that simplifies the integration of logistic carrier services  The **proxy** endpoints are stateless and forwards calls to carriers web services.   # noqa: E501

    OpenAPI spec version: v1-2020.10.0
    Contact: hello@purplship.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class Pickup(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'str',
        'carrier_name': 'str',
        'carrier_id': 'str',
        'confirmation_number': 'str',
        'pickup_date': 'str',
        'pickup_charge': 'Charge',
        'ready_time': 'str',
        'closing_time': 'str',
        'address': 'Address',
        'parcels': 'list[Parcel]',
        'instruction': 'str',
        'package_location': 'str',
        'options': 'object',
        'test_mode': 'bool'
    }

    attribute_map = {
        'id': 'id',
        'carrier_name': 'carrier_name',
        'carrier_id': 'carrier_id',
        'confirmation_number': 'confirmation_number',
        'pickup_date': 'pickup_date',
        'pickup_charge': 'pickup_charge',
        'ready_time': 'ready_time',
        'closing_time': 'closing_time',
        'address': 'address',
        'parcels': 'parcels',
        'instruction': 'instruction',
        'package_location': 'package_location',
        'options': 'options',
        'test_mode': 'test_mode'
    }

    def __init__(self, id=None, carrier_name=None, carrier_id=None, confirmation_number=None, pickup_date=None, pickup_charge=None, ready_time=None, closing_time=None, address=None, parcels=None, instruction=None, package_location=None, options=None, test_mode=None):  # noqa: E501
        """Pickup - a model defined in Swagger"""  # noqa: E501
        self._id = None
        self._carrier_name = None
        self._carrier_id = None
        self._confirmation_number = None
        self._pickup_date = None
        self._pickup_charge = None
        self._ready_time = None
        self._closing_time = None
        self._address = None
        self._parcels = None
        self._instruction = None
        self._package_location = None
        self._options = None
        self._test_mode = None
        self.discriminator = None
        if id is not None:
            self.id = id
        self.carrier_name = carrier_name
        self.carrier_id = carrier_id
        self.confirmation_number = confirmation_number
        if pickup_date is not None:
            self.pickup_date = pickup_date
        if pickup_charge is not None:
            self.pickup_charge = pickup_charge
        if ready_time is not None:
            self.ready_time = ready_time
        if closing_time is not None:
            self.closing_time = closing_time
        self.address = address
        self.parcels = parcels
        if instruction is not None:
            self.instruction = instruction
        if package_location is not None:
            self.package_location = package_location
        if options is not None:
            self.options = options
        self.test_mode = test_mode

    @property
    def id(self):
        """Gets the id of this Pickup.  # noqa: E501

        A unique pickup identifier  # noqa: E501

        :return: The id of this Pickup.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Pickup.

        A unique pickup identifier  # noqa: E501

        :param id: The id of this Pickup.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def carrier_name(self):
        """Gets the carrier_name of this Pickup.  # noqa: E501

        The pickup carrier  # noqa: E501

        :return: The carrier_name of this Pickup.  # noqa: E501
        :rtype: str
        """
        return self._carrier_name

    @carrier_name.setter
    def carrier_name(self, carrier_name):
        """Sets the carrier_name of this Pickup.

        The pickup carrier  # noqa: E501

        :param carrier_name: The carrier_name of this Pickup.  # noqa: E501
        :type: str
        """
        if carrier_name is None:
            raise ValueError("Invalid value for `carrier_name`, must not be `None`")  # noqa: E501

        self._carrier_name = carrier_name

    @property
    def carrier_id(self):
        """Gets the carrier_id of this Pickup.  # noqa: E501

        The pickup carrier configured name  # noqa: E501

        :return: The carrier_id of this Pickup.  # noqa: E501
        :rtype: str
        """
        return self._carrier_id

    @carrier_id.setter
    def carrier_id(self, carrier_id):
        """Sets the carrier_id of this Pickup.

        The pickup carrier configured name  # noqa: E501

        :param carrier_id: The carrier_id of this Pickup.  # noqa: E501
        :type: str
        """
        if carrier_id is None:
            raise ValueError("Invalid value for `carrier_id`, must not be `None`")  # noqa: E501

        self._carrier_id = carrier_id

    @property
    def confirmation_number(self):
        """Gets the confirmation_number of this Pickup.  # noqa: E501

        The pickup confirmation identifier  # noqa: E501

        :return: The confirmation_number of this Pickup.  # noqa: E501
        :rtype: str
        """
        return self._confirmation_number

    @confirmation_number.setter
    def confirmation_number(self, confirmation_number):
        """Sets the confirmation_number of this Pickup.

        The pickup confirmation identifier  # noqa: E501

        :param confirmation_number: The confirmation_number of this Pickup.  # noqa: E501
        :type: str
        """
        if confirmation_number is None:
            raise ValueError("Invalid value for `confirmation_number`, must not be `None`")  # noqa: E501

        self._confirmation_number = confirmation_number

    @property
    def pickup_date(self):
        """Gets the pickup_date of this Pickup.  # noqa: E501

        The pickup date  # noqa: E501

        :return: The pickup_date of this Pickup.  # noqa: E501
        :rtype: str
        """
        return self._pickup_date

    @pickup_date.setter
    def pickup_date(self, pickup_date):
        """Sets the pickup_date of this Pickup.

        The pickup date  # noqa: E501

        :param pickup_date: The pickup_date of this Pickup.  # noqa: E501
        :type: str
        """

        self._pickup_date = pickup_date

    @property
    def pickup_charge(self):
        """Gets the pickup_charge of this Pickup.  # noqa: E501


        :return: The pickup_charge of this Pickup.  # noqa: E501
        :rtype: Charge
        """
        return self._pickup_charge

    @pickup_charge.setter
    def pickup_charge(self, pickup_charge):
        """Sets the pickup_charge of this Pickup.


        :param pickup_charge: The pickup_charge of this Pickup.  # noqa: E501
        :type: Charge
        """

        self._pickup_charge = pickup_charge

    @property
    def ready_time(self):
        """Gets the ready_time of this Pickup.  # noqa: E501

        The pickup expected ready time  # noqa: E501

        :return: The ready_time of this Pickup.  # noqa: E501
        :rtype: str
        """
        return self._ready_time

    @ready_time.setter
    def ready_time(self, ready_time):
        """Sets the ready_time of this Pickup.

        The pickup expected ready time  # noqa: E501

        :param ready_time: The ready_time of this Pickup.  # noqa: E501
        :type: str
        """

        self._ready_time = ready_time

    @property
    def closing_time(self):
        """Gets the closing_time of this Pickup.  # noqa: E501

        The pickup expected closing or late time  # noqa: E501

        :return: The closing_time of this Pickup.  # noqa: E501
        :rtype: str
        """
        return self._closing_time

    @closing_time.setter
    def closing_time(self, closing_time):
        """Sets the closing_time of this Pickup.

        The pickup expected closing or late time  # noqa: E501

        :param closing_time: The closing_time of this Pickup.  # noqa: E501
        :type: str
        """

        self._closing_time = closing_time

    @property
    def address(self):
        """Gets the address of this Pickup.  # noqa: E501


        :return: The address of this Pickup.  # noqa: E501
        :rtype: Address
        """
        return self._address

    @address.setter
    def address(self, address):
        """Sets the address of this Pickup.


        :param address: The address of this Pickup.  # noqa: E501
        :type: Address
        """
        if address is None:
            raise ValueError("Invalid value for `address`, must not be `None`")  # noqa: E501

        self._address = address

    @property
    def parcels(self):
        """Gets the parcels of this Pickup.  # noqa: E501

        The shipment parcels to pickup.  # noqa: E501

        :return: The parcels of this Pickup.  # noqa: E501
        :rtype: list[Parcel]
        """
        return self._parcels

    @parcels.setter
    def parcels(self, parcels):
        """Sets the parcels of this Pickup.

        The shipment parcels to pickup.  # noqa: E501

        :param parcels: The parcels of this Pickup.  # noqa: E501
        :type: list[Parcel]
        """
        if parcels is None:
            raise ValueError("Invalid value for `parcels`, must not be `None`")  # noqa: E501

        self._parcels = parcels

    @property
    def instruction(self):
        """Gets the instruction of this Pickup.  # noqa: E501

         The pickup instruction.  eg: Handle with care.   # noqa: E501

        :return: The instruction of this Pickup.  # noqa: E501
        :rtype: str
        """
        return self._instruction

    @instruction.setter
    def instruction(self, instruction):
        """Sets the instruction of this Pickup.

         The pickup instruction.  eg: Handle with care.   # noqa: E501

        :param instruction: The instruction of this Pickup.  # noqa: E501
        :type: str
        """

        self._instruction = instruction

    @property
    def package_location(self):
        """Gets the package_location of this Pickup.  # noqa: E501

         The package(s) location.  eg: Behind the entrance door.   # noqa: E501

        :return: The package_location of this Pickup.  # noqa: E501
        :rtype: str
        """
        return self._package_location

    @package_location.setter
    def package_location(self, package_location):
        """Sets the package_location of this Pickup.

         The package(s) location.  eg: Behind the entrance door.   # noqa: E501

        :param package_location: The package_location of this Pickup.  # noqa: E501
        :type: str
        """

        self._package_location = package_location

    @property
    def options(self):
        """Gets the options of this Pickup.  # noqa: E501

        Advanced carrier specific pickup options  # noqa: E501

        :return: The options of this Pickup.  # noqa: E501
        :rtype: object
        """
        return self._options

    @options.setter
    def options(self, options):
        """Sets the options of this Pickup.

        Advanced carrier specific pickup options  # noqa: E501

        :param options: The options of this Pickup.  # noqa: E501
        :type: object
        """

        self._options = options

    @property
    def test_mode(self):
        """Gets the test_mode of this Pickup.  # noqa: E501

        Specified whether it was created with a carrier in test mode  # noqa: E501

        :return: The test_mode of this Pickup.  # noqa: E501
        :rtype: bool
        """
        return self._test_mode

    @test_mode.setter
    def test_mode(self, test_mode):
        """Sets the test_mode of this Pickup.

        Specified whether it was created with a carrier in test mode  # noqa: E501

        :param test_mode: The test_mode of this Pickup.  # noqa: E501
        :type: bool
        """
        if test_mode is None:
            raise ValueError("Invalid value for `test_mode`, must not be `None`")  # noqa: E501

        self._test_mode = test_mode

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Pickup, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Pickup):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
