# coding: utf-8

"""
    Purplship Open Source Multi-carrier Shipping API

     Purplship is an open source multi-carrier shipping API that simplifies the integration of logistic carrier services  The **proxy** endpoints are stateless and forwards calls to carriers web services.   # noqa: E501

    OpenAPI spec version: v1-2020.10.0
    Contact: hello@purplship.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class RateRequest(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'shipper': 'Address',
        'recipient': 'Address',
        'parcels': 'list[Parcel]',
        'services': 'list[str]',
        'options': 'object',
        'reference': 'str',
        'carrier_ids': 'list[str]'
    }

    attribute_map = {
        'shipper': 'shipper',
        'recipient': 'recipient',
        'parcels': 'parcels',
        'services': 'services',
        'options': 'options',
        'reference': 'reference',
        'carrier_ids': 'carrier_ids'
    }

    def __init__(self, shipper=None, recipient=None, parcels=None, services=None, options=None, reference=None, carrier_ids=None):  # noqa: E501
        """RateRequest - a model defined in Swagger"""  # noqa: E501
        self._shipper = None
        self._recipient = None
        self._parcels = None
        self._services = None
        self._options = None
        self._reference = None
        self._carrier_ids = None
        self.discriminator = None
        self.shipper = shipper
        self.recipient = recipient
        self.parcels = parcels
        if services is not None:
            self.services = services
        if options is not None:
            self.options = options
        if reference is not None:
            self.reference = reference
        if carrier_ids is not None:
            self.carrier_ids = carrier_ids

    @property
    def shipper(self):
        """Gets the shipper of this RateRequest.  # noqa: E501


        :return: The shipper of this RateRequest.  # noqa: E501
        :rtype: Address
        """
        return self._shipper

    @shipper.setter
    def shipper(self, shipper):
        """Sets the shipper of this RateRequest.


        :param shipper: The shipper of this RateRequest.  # noqa: E501
        :type: Address
        """
        if shipper is None:
            raise ValueError("Invalid value for `shipper`, must not be `None`")  # noqa: E501

        self._shipper = shipper

    @property
    def recipient(self):
        """Gets the recipient of this RateRequest.  # noqa: E501


        :return: The recipient of this RateRequest.  # noqa: E501
        :rtype: Address
        """
        return self._recipient

    @recipient.setter
    def recipient(self, recipient):
        """Sets the recipient of this RateRequest.


        :param recipient: The recipient of this RateRequest.  # noqa: E501
        :type: Address
        """
        if recipient is None:
            raise ValueError("Invalid value for `recipient`, must not be `None`")  # noqa: E501

        self._recipient = recipient

    @property
    def parcels(self):
        """Gets the parcels of this RateRequest.  # noqa: E501

        The shipment's parcels  # noqa: E501

        :return: The parcels of this RateRequest.  # noqa: E501
        :rtype: list[Parcel]
        """
        return self._parcels

    @parcels.setter
    def parcels(self, parcels):
        """Sets the parcels of this RateRequest.

        The shipment's parcels  # noqa: E501

        :param parcels: The parcels of this RateRequest.  # noqa: E501
        :type: list[Parcel]
        """
        if parcels is None:
            raise ValueError("Invalid value for `parcels`, must not be `None`")  # noqa: E501

        self._parcels = parcels

    @property
    def services(self):
        """Gets the services of this RateRequest.  # noqa: E501

         The requested carrier service for the shipment.<br/> Please consult [the reference](#operation/references) for specific carriers services.  Note that this is a list because on a Multi-carrier rate request you could specify a service per carrier.   # noqa: E501

        :return: The services of this RateRequest.  # noqa: E501
        :rtype: list[str]
        """
        return self._services

    @services.setter
    def services(self, services):
        """Sets the services of this RateRequest.

         The requested carrier service for the shipment.<br/> Please consult [the reference](#operation/references) for specific carriers services.  Note that this is a list because on a Multi-carrier rate request you could specify a service per carrier.   # noqa: E501

        :param services: The services of this RateRequest.  # noqa: E501
        :type: list[str]
        """

        self._services = services

    @property
    def options(self):
        """Gets the options of this RateRequest.  # noqa: E501

         The options available for the shipment.  Please consult [the reference](#operation/references) for additional specific carriers options.   # noqa: E501

        :return: The options of this RateRequest.  # noqa: E501
        :rtype: object
        """
        return self._options

    @options.setter
    def options(self, options):
        """Sets the options of this RateRequest.

         The options available for the shipment.  Please consult [the reference](#operation/references) for additional specific carriers options.   # noqa: E501

        :param options: The options of this RateRequest.  # noqa: E501
        :type: object
        """

        self._options = options

    @property
    def reference(self):
        """Gets the reference of this RateRequest.  # noqa: E501

        The shipment reference  # noqa: E501

        :return: The reference of this RateRequest.  # noqa: E501
        :rtype: str
        """
        return self._reference

    @reference.setter
    def reference(self, reference):
        """Sets the reference of this RateRequest.

        The shipment reference  # noqa: E501

        :param reference: The reference of this RateRequest.  # noqa: E501
        :type: str
        """

        self._reference = reference

    @property
    def carrier_ids(self):
        """Gets the carrier_ids of this RateRequest.  # noqa: E501

         The list of configured carriers you wish to get rates from.   # noqa: E501

        :return: The carrier_ids of this RateRequest.  # noqa: E501
        :rtype: list[str]
        """
        return self._carrier_ids

    @carrier_ids.setter
    def carrier_ids(self, carrier_ids):
        """Sets the carrier_ids of this RateRequest.

         The list of configured carriers you wish to get rates from.   # noqa: E501

        :param carrier_ids: The carrier_ids of this RateRequest.  # noqa: E501
        :type: list[str]
        """

        self._carrier_ids = carrier_ids

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(RateRequest, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, RateRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
