"""MR Star light device effects."""
from enum import Enum


class Effect(Enum):
    """MR Star light device effects."""
    # Basic
    AUTOMATIC_LOOP = 1
    SYMPHONY = 2
    COLORFUL_ENERGY = 3
    COLORFUL_JUMPS = 4
    # RGB_JUMPS = 5
    # YBP_JUMPS = 6
    RAINBOW_STROBE = 7
    RAINBOW_GRADIENT = 10
    COLORFUL_FLUTTERING = 26
    RGB_FLUTTERING = 27
    YCP_FLUTTERING = 28
    COLORFUL_BRUSHING = 29
    RGB_COLOR_BRUSHING = 30
    YCP_COLOR_BRUSHING = 31
    COLOR_BRUSH_CLOSED_PULL = 32
    # RGB_CLOSED_PULL = 33
    # YCP_CLOSED_PULL = 34
    # Open & Close
    RAINBOW_OPEN_CLOSE = 35
    RGB_OPEN_CLOSE = 36
    YCP_OPEN_CLOSE = 37
    RED_OPEN_CLOSE = 38
    GREEN_OPEN_CLOSE = 39
    BLUE_OPEN_CLOSE = 40
    YELLOW_OPEN_CLOSE = 41
    CYAN_OPEN_CLOSE = 42
    PURPLE_OPEN_CLOSE = 43
    WHITE_OPEN_CLOSE = 44
    # Transition
    RAINBOW_LIGHT_DARK_TRANSITION = 45
    RGB_LIGHT_DARK_TRANSITION = 46
    VGY_LIGHT_DARK_TRANSITION = 47
    RED_LIGHT_DARK_TRANSITION = 48
    GREEN_LIGHT_DARK_TRANSITION = 49
    BLUE_LIGHT_DARK_TRANSITION = 50
    CYAN_LIGHT_DARK_TRANSITION = 51
    YELLOW_LIGHT_DARK_TRANSITION = 52
    PURPLE_LIGHT_DARK_TRANSITION = 53
    WHITE_LIGHT_DARK_TRANSITION = 54
    # Flowing water
    RAINBOW_FLOWING_WATER = 55
    RGB_RUNNING_WATER = 56
    VY_RUNNING_WATER = 57
    RG_RUNNING_WATER = 58
    GB_RUNNING_WATER = 59
    YB_RUNNING_WATER = 60
    YC_RUNNING_WATER = 61
    GP_RUNNING_WATER = 62
    # BW_RUNNING_WATER = 63
    # Trailing
    RAINBOW_TRAILING = 76
    RED_TRAILING = 77
    GREEN_TRAILING = 78
    BLUE_TRAILING = 79
    YELLOW_TRAILING = 80
    CYAN_TRAILING = 81
    PURPLE_TRAILING = 82
    WHITE_TRAILING = 83
    # Running
    RED_RUNNING = 84
    GREEN_RUNNING = 85
    BLUE_RUNNING = 86
    YELLOW_RUNNING = 87
    CYAN_RUNNING = 88
    PURPLE_RUNNING = 89
    YPB_STROBE = 9
    WHITE_RUNNING = 90
    RAINBOW_RUNNING = 91
    BGR_RUNNING = 92
    PCY_RUNNING = 93
    BPCY_RUNNING = 94
    BGCY_RUNNING = 95
