import * as cdk from 'aws-cdk-lib';
import * as constructs from 'constructs';
/**
 * Manage a custom Tls Certificate upload
 *
 * @schema CfnCertificateProps
 */
export interface CfnCertificateProps {
    /**
     * @schema CfnCertificateProps#Type
     */
    readonly type?: string;
    /**
     * @schema CfnCertificateProps#Attributes
     */
    readonly attributes?: CfnCertificatePropsAttributes;
    /**
     * @schema CfnCertificateProps#Relationships
     */
    readonly relationships?: Relationships;
}
/**
 * Converts an object of type 'CfnCertificateProps' to JSON representation.
 */
export declare function toJson_CfnCertificateProps(obj: CfnCertificateProps | undefined): Record<string, any> | undefined;
/**
 * @schema CfnCertificatePropsAttributes
 */
export interface CfnCertificatePropsAttributes {
    /**
     * @schema CfnCertificatePropsAttributes#Name
     */
    readonly name?: string;
    /**
     * @schema CfnCertificatePropsAttributes#CertBlob
     */
    readonly certBlob: string;
    /**
     * @schema CfnCertificatePropsAttributes#CreatedAt
     */
    readonly createdAt?: Date;
    /**
     * @schema CfnCertificatePropsAttributes#Issuer
     */
    readonly issuer?: string;
    /**
     * @schema CfnCertificatePropsAttributes#NotAfter
     */
    readonly notAfter?: string;
    /**
     * @schema CfnCertificatePropsAttributes#NotBefore
     */
    readonly notBefore?: string;
    /**
     * @schema CfnCertificatePropsAttributes#SignatureAlgorithm
     */
    readonly signatureAlgorithm?: string;
    /**
     * @schema CfnCertificatePropsAttributes#SerialNumber
     */
    readonly serialNumber?: string;
    /**
     * @schema CfnCertificatePropsAttributes#UpdatedAt
     */
    readonly updatedAt?: Date;
    /**
     * @schema CfnCertificatePropsAttributes#Replace
     */
    readonly replace?: string;
    /**
     * @schema CfnCertificatePropsAttributes#IssuedTo
     */
    readonly issuedTo?: string;
}
/**
 * Converts an object of type 'CfnCertificatePropsAttributes' to JSON representation.
 */
export declare function toJson_CfnCertificatePropsAttributes(obj: CfnCertificatePropsAttributes | undefined): Record<string, any> | undefined;
/**
 * @schema Relationships
 */
export interface Relationships {
    /**
     * @schema Relationships#TlsDomains
     */
    readonly tlsDomains?: RelationshipsTlsDomains;
}
/**
 * Converts an object of type 'Relationships' to JSON representation.
 */
export declare function toJson_Relationships(obj: Relationships | undefined): Record<string, any> | undefined;
/**
 * @schema RelationshipsTlsDomains
 */
export interface RelationshipsTlsDomains {
    /**
     * @schema RelationshipsTlsDomains#Data
     */
    readonly data?: Data[];
}
/**
 * Converts an object of type 'RelationshipsTlsDomains' to JSON representation.
 */
export declare function toJson_RelationshipsTlsDomains(obj: RelationshipsTlsDomains | undefined): Record<string, any> | undefined;
/**
 * @schema Data
 */
export interface Data {
    /**
     * @schema Data#Id
     */
    readonly id?: string;
}
/**
 * Converts an object of type 'Data' to JSON representation.
 */
export declare function toJson_Data(obj: Data | undefined): Record<string, any> | undefined;
/**
 * A CloudFormation `Fastly::Tls::Certificate`
 *
 * @cloudformationResource Fastly::Tls::Certificate
 * @stability external
 * @link https://github.com/aws-ia/cloudformation-fastly-resource-providers
 */
export declare class CfnCertificate extends cdk.CfnResource {
    /**
    * The CloudFormation resource type name for this resource class.
    */
    static readonly CFN_RESOURCE_TYPE_NAME = "Fastly::Tls::Certificate";
    /**
     * Resource props.
     */
    readonly props: CfnCertificateProps;
    /**
     * Attribute `Fastly::Tls::Certificate.Id`
     * @link https://github.com/aws-ia/cloudformation-fastly-resource-providers
     */
    readonly attrId: string;
    /**
     * Create a new `Fastly::Tls::Certificate`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnCertificateProps);
}
