"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnCertificate = exports.toJson_Data = exports.toJson_RelationshipsTlsDomains = exports.toJson_Relationships = exports.toJson_CfnCertificatePropsAttributes = exports.toJson_CfnCertificateProps = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Generated by cdk-import
const cdk = require("aws-cdk-lib");
/**
 * Converts an object of type 'CfnCertificateProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnCertificateProps(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Type': obj.type,
        'Attributes': toJson_CfnCertificatePropsAttributes(obj.attributes),
        'Relationships': toJson_Relationships(obj.relationships),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnCertificateProps = toJson_CfnCertificateProps;
/**
 * Converts an object of type 'CfnCertificatePropsAttributes' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnCertificatePropsAttributes(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Name': obj.name,
        'CertBlob': obj.certBlob,
        'CreatedAt': obj.createdAt?.toISOString(),
        'Issuer': obj.issuer,
        'NotAfter': obj.notAfter,
        'NotBefore': obj.notBefore,
        'SignatureAlgorithm': obj.signatureAlgorithm,
        'SerialNumber': obj.serialNumber,
        'UpdatedAt': obj.updatedAt?.toISOString(),
        'Replace': obj.replace,
        'IssuedTo': obj.issuedTo,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnCertificatePropsAttributes = toJson_CfnCertificatePropsAttributes;
/**
 * Converts an object of type 'Relationships' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_Relationships(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'TlsDomains': toJson_RelationshipsTlsDomains(obj.tlsDomains),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_Relationships = toJson_Relationships;
/**
 * Converts an object of type 'RelationshipsTlsDomains' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_RelationshipsTlsDomains(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Data': obj.data?.map(y => toJson_Data(y)),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_RelationshipsTlsDomains = toJson_RelationshipsTlsDomains;
/**
 * Converts an object of type 'Data' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_Data(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Id': obj.id,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_Data = toJson_Data;
/* eslint-enable max-len, quote-props */
/**
 * A CloudFormation `Fastly::Tls::Certificate`
 *
 * @cloudformationResource Fastly::Tls::Certificate
 * @stability external
 * @link https://github.com/aws-ia/cloudformation-fastly-resource-providers
 */
class CfnCertificate extends cdk.CfnResource {
    /**
     * Create a new `Fastly::Tls::Certificate`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnCertificate.CFN_RESOURCE_TYPE_NAME, properties: toJson_CfnCertificateProps(props) });
        this.props = props;
        this.attrId = cdk.Token.asString(this.getAtt('Id'));
    }
}
exports.CfnCertificate = CfnCertificate;
_a = JSII_RTTI_SYMBOL_1;
CfnCertificate[_a] = { fqn: "@cdk-cloudformation/fastly-tls-certificate.CfnCertificate", version: "1.7.0-alpha.7" };
/**
* The CloudFormation resource type name for this resource class.
*/
CfnCertificate.CFN_RESOURCE_TYPE_NAME = "Fastly::Tls::Certificate";
//# sourceMappingURL=data:application/json;base64,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