# coding: utf-8

from __future__ import absolute_import

from datetime import date, datetime  # noqa: F401
from typing import Dict, List  # noqa: F401

from sunrise6g_opensdk.edgecloud.adapters.kubernetes.lib import util
from sunrise6g_opensdk.edgecloud.adapters.kubernetes.lib.models.base_model_ import Model
from sunrise6g_opensdk.edgecloud.adapters.kubernetes.lib.models.uri import (  # noqa: F401,E501
    Uri,
)


class AppManifestAppRepo(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    def __init__(
        self,
        type: str = None,
        image_path: Uri = None,
        user_name: str = None,
        credentials: str = None,
        auth_type: str = None,
        checksum: str = None,
    ):  # noqa: E501
        """AppManifestAppRepo - a model defined in Swagger

        :param type: The type of this AppManifestAppRepo.  # noqa: E501
        :type type: str
        :param image_path: The image_path of this AppManifestAppRepo.  # noqa: E501
        :type image_path: Uri
        :param user_name: The user_name of this AppManifestAppRepo.  # noqa: E501
        :type user_name: str
        :param credentials: The credentials of this AppManifestAppRepo.  # noqa: E501
        :type credentials: str
        :param auth_type: The auth_type of this AppManifestAppRepo.  # noqa: E501
        :type auth_type: str
        :param checksum: The checksum of this AppManifestAppRepo.  # noqa: E501
        :type checksum: str
        """
        self.swagger_types = {
            "type": str,
            "image_path": Uri,
            "user_name": str,
            "credentials": str,
            "auth_type": str,
            "checksum": str,
        }

        self.attribute_map = {
            "type": "type",
            "image_path": "imagePath",
            "user_name": "userName",
            "credentials": "credentials",
            "auth_type": "authType",
            "checksum": "checksum",
        }
        self._type = type
        self._image_path = image_path
        self._user_name = user_name
        self._credentials = credentials
        self._auth_type = auth_type
        self._checksum = checksum

    @classmethod
    def from_dict(cls, dikt) -> "AppManifestAppRepo":
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The AppManifest_appRepo of this AppManifestAppRepo.  # noqa: E501
        :rtype: AppManifestAppRepo
        """
        return util.deserialize_model(dikt, cls)

    @property
    def type(self) -> str:
        """Gets the type of this AppManifestAppRepo.

        Application repository and image URI information. PUBLICREPO is used of public urls like github, helm repo etc. PRIVATEREPO  is used for private repo managed by the application developer. Private repo can be accessed by using the app developer provided userName and password. Password is recommended to be the personal access token created by developer e.g. in Github repo.   # noqa: E501

        :return: The type of this AppManifestAppRepo.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type: str):
        """Sets the type of this AppManifestAppRepo.

        Application repository and image URI information. PUBLICREPO is used of public urls like github, helm repo etc. PRIVATEREPO  is used for private repo managed by the application developer. Private repo can be accessed by using the app developer provided userName and password. Password is recommended to be the personal access token created by developer e.g. in Github repo.   # noqa: E501

        :param type: The type of this AppManifestAppRepo.
        :type type: str
        """
        allowed_values = ["PRIVATEREPO", "PUBLICREPO"]  # noqa: E501
        if type not in allowed_values:
            raise ValueError(
                "Invalid value for `type` ({0}), must be one of {1}".format(
                    type, allowed_values
                )
            )

        self._type = type

    @property
    def image_path(self) -> Uri:
        """Gets the image_path of this AppManifestAppRepo.


        :return: The image_path of this AppManifestAppRepo.
        :rtype: Uri
        """
        return self._image_path

    @image_path.setter
    def image_path(self, image_path: Uri):
        """Sets the image_path of this AppManifestAppRepo.


        :param image_path: The image_path of this AppManifestAppRepo.
        :type image_path: Uri
        """
        if image_path is None:
            raise ValueError(
                "Invalid value for `image_path`, must not be `None`"
            )  # noqa: E501

        self._image_path = image_path

    @property
    def user_name(self) -> str:
        """Gets the user_name of this AppManifestAppRepo.

        Username to acces the Helm chart, docker-compose file or VM image repository   # noqa: E501

        :return: The user_name of this AppManifestAppRepo.
        :rtype: str
        """
        return self._user_name

    @user_name.setter
    def user_name(self, user_name: str):
        """Sets the user_name of this AppManifestAppRepo.

        Username to acces the Helm chart, docker-compose file or VM image repository   # noqa: E501

        :param user_name: The user_name of this AppManifestAppRepo.
        :type user_name: str
        """

        self._user_name = user_name

    @property
    def credentials(self) -> str:
        """Gets the credentials of this AppManifestAppRepo.

        Password or personal access token created by developer to acces the app repository. API users can generate a personal access token e.g. docker clients to use them as password.   # noqa: E501

        :return: The credentials of this AppManifestAppRepo.
        :rtype: str
        """
        return self._credentials

    @credentials.setter
    def credentials(self, credentials: str):
        """Sets the credentials of this AppManifestAppRepo.

        Password or personal access token created by developer to acces the app repository. API users can generate a personal access token e.g. docker clients to use them as password.   # noqa: E501

        :param credentials: The credentials of this AppManifestAppRepo.
        :type credentials: str
        """

        self._credentials = credentials

    @property
    def auth_type(self) -> str:
        """Gets the auth_type of this AppManifestAppRepo.

        The credentials can also be formatted as a Basic auth or Bearer auth in HTTP \"Authorization\" header.   # noqa: E501

        :return: The auth_type of this AppManifestAppRepo.
        :rtype: str
        """
        return self._auth_type

    @auth_type.setter
    def auth_type(self, auth_type: str):
        """Sets the auth_type of this AppManifestAppRepo.

        The credentials can also be formatted as a Basic auth or Bearer auth in HTTP \"Authorization\" header.   # noqa: E501

        :param auth_type: The auth_type of this AppManifestAppRepo.
        :type auth_type: str
        """
        allowed_values = ["DOCKER", "HTTP_BASIC", "HTTP_BEARER", "NONE"]  # noqa: E501
        if auth_type not in allowed_values:
            raise ValueError(
                "Invalid value for `auth_type` ({0}), must be one of {1}".format(
                    auth_type, allowed_values
                )
            )

        self._auth_type = auth_type

    @property
    def checksum(self) -> str:
        """Gets the checksum of this AppManifestAppRepo.

        MD5 checksum for VM and file-based images, sha256 digest for containers   # noqa: E501

        :return: The checksum of this AppManifestAppRepo.
        :rtype: str
        """
        return self._checksum

    @checksum.setter
    def checksum(self, checksum: str):
        """Sets the checksum of this AppManifestAppRepo.

        MD5 checksum for VM and file-based images, sha256 digest for containers   # noqa: E501

        :param checksum: The checksum of this AppManifestAppRepo.
        :type checksum: str
        """

        self._checksum = checksum
