# coding: utf-8

from __future__ import absolute_import

from datetime import date, datetime  # noqa: F401
from typing import Dict, List  # noqa: F401

from sunrise6g_opensdk.edgecloud.adapters.kubernetes.lib import util
from sunrise6g_opensdk.edgecloud.adapters.kubernetes.lib.models.app_manifest_network_interfaces import (  # noqa: F401,E501
    AppManifestNetworkInterfaces,
)
from sunrise6g_opensdk.edgecloud.adapters.kubernetes.lib.models.base_model_ import Model


class AppManifestComponentSpec(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    def __init__(
        self,
        component_name: str = None,
        network_interfaces: List[AppManifestNetworkInterfaces] = None,
    ):  # noqa: E501
        """AppManifestComponentSpec - a model defined in Swagger

        :param component_name: The component_name of this AppManifestComponentSpec.  # noqa: E501
        :type component_name: str
        :param network_interfaces: The network_interfaces of this AppManifestComponentSpec.  # noqa: E501
        :type network_interfaces: List[AppManifestNetworkInterfaces]
        """
        self.swagger_types = {
            "component_name": str,
            "network_interfaces": List[AppManifestNetworkInterfaces],
        }

        self.attribute_map = {
            "component_name": "componentName",
            "network_interfaces": "networkInterfaces",
        }
        self._component_name = component_name
        self._network_interfaces = network_interfaces

    @classmethod
    def from_dict(cls, dikt) -> "AppManifestComponentSpec":
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The AppManifest_componentSpec of this AppManifestComponentSpec.  # noqa: E501
        :rtype: AppManifestComponentSpec
        """
        return util.deserialize_model(dikt, cls)

    @property
    def component_name(self) -> str:
        """Gets the component_name of this AppManifestComponentSpec.

        Component name must be unique with an application  # noqa: E501

        :return: The component_name of this AppManifestComponentSpec.
        :rtype: str
        """
        return self._component_name

    @component_name.setter
    def component_name(self, component_name: str):
        """Sets the component_name of this AppManifestComponentSpec.

        Component name must be unique with an application  # noqa: E501

        :param component_name: The component_name of this AppManifestComponentSpec.
        :type component_name: str
        """
        if component_name is None:
            raise ValueError(
                "Invalid value for `component_name`, must not be `None`"
            )  # noqa: E501

        self._component_name = component_name

    @property
    def network_interfaces(self) -> List[AppManifestNetworkInterfaces]:
        """Gets the network_interfaces of this AppManifestComponentSpec.

        Each application component exposes some ports either for external users or for inter component communication. Application provider is required to specify which ports are to be exposed and the type of traffic that will flow through these ports.The underlying platform may assign a dynamic port against the \"extPort\" that the application clients will use to connect with edge application instance.   # noqa: E501

        :return: The network_interfaces of this AppManifestComponentSpec.
        :rtype: List[AppManifestNetworkInterfaces]
        """
        return self._network_interfaces

    @network_interfaces.setter
    def network_interfaces(
        self, network_interfaces: List[AppManifestNetworkInterfaces]
    ):
        """Sets the network_interfaces of this AppManifestComponentSpec.

        Each application component exposes some ports either for external users or for inter component communication. Application provider is required to specify which ports are to be exposed and the type of traffic that will flow through these ports.The underlying platform may assign a dynamic port against the \"extPort\" that the application clients will use to connect with edge application instance.   # noqa: E501

        :param network_interfaces: The network_interfaces of this AppManifestComponentSpec.
        :type network_interfaces: List[AppManifestNetworkInterfaces]
        """
        if network_interfaces is None:
            raise ValueError(
                "Invalid value for `network_interfaces`, must not be `None`"
            )  # noqa: E501

        self._network_interfaces = network_interfaces
