# coding: utf-8

from __future__ import absolute_import

import re  # noqa: F401,E501
from datetime import date, datetime  # noqa: F401
from typing import Dict, List  # noqa: F401

from sunrise6g_opensdk.edgecloud.adapters.kubernetes.lib import util
from sunrise6g_opensdk.edgecloud.adapters.kubernetes.lib.models.base_model_ import Model


class AppManifestNetworkInterfaces(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    def __init__(
        self,
        interface_id: str = None,
        protocol: str = None,
        port: int = None,
        visibility_type: str = None,
    ):  # noqa: E501
        """AppManifestNetworkInterfaces - a model defined in Swagger

        :param interface_id: The interface_id of this AppManifestNetworkInterfaces.  # noqa: E501
        :type interface_id: str
        :param protocol: The protocol of this AppManifestNetworkInterfaces.  # noqa: E501
        :type protocol: str
        :param port: The port of this AppManifestNetworkInterfaces.  # noqa: E501
        :type port: int
        :param visibility_type: The visibility_type of this AppManifestNetworkInterfaces.  # noqa: E501
        :type visibility_type: str
        """
        self.swagger_types = {
            "interface_id": str,
            "protocol": str,
            "port": int,
            "visibility_type": str,
        }

        self.attribute_map = {
            "interface_id": "interfaceId",
            "protocol": "protocol",
            "port": "port",
            "visibility_type": "visibilityType",
        }
        self._interface_id = interface_id
        self._protocol = protocol
        self._port = port
        self._visibility_type = visibility_type

    @classmethod
    def from_dict(cls, dikt) -> "AppManifestNetworkInterfaces":
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The AppManifest_networkInterfaces of this AppManifestNetworkInterfaces.  # noqa: E501
        :rtype: AppManifestNetworkInterfaces
        """
        return util.deserialize_model(dikt, cls)

    @property
    def interface_id(self) -> str:
        """Gets the interface_id of this AppManifestNetworkInterfaces.

        Each Port and corresponding traffic protocol exposed by the component is identified by a name. Application client on user device requires this to uniquley idenify the interface.   # noqa: E501

        :return: The interface_id of this AppManifestNetworkInterfaces.
        :rtype: str
        """
        return self._interface_id

    @interface_id.setter
    def interface_id(self, interface_id: str):
        """Sets the interface_id of this AppManifestNetworkInterfaces.

        Each Port and corresponding traffic protocol exposed by the component is identified by a name. Application client on user device requires this to uniquley idenify the interface.   # noqa: E501

        :param interface_id: The interface_id of this AppManifestNetworkInterfaces.
        :type interface_id: str
        """
        if interface_id is None:
            raise ValueError(
                "Invalid value for `interface_id`, must not be `None`"
            )  # noqa: E501

        self._interface_id = interface_id

    @property
    def protocol(self) -> str:
        """Gets the protocol of this AppManifestNetworkInterfaces.

        Defines the IP transport communication protocol i.e., TCP, UDP or ANY   # noqa: E501

        :return: The protocol of this AppManifestNetworkInterfaces.
        :rtype: str
        """
        return self._protocol

    @protocol.setter
    def protocol(self, protocol: str):
        """Sets the protocol of this AppManifestNetworkInterfaces.

        Defines the IP transport communication protocol i.e., TCP, UDP or ANY   # noqa: E501

        :param protocol: The protocol of this AppManifestNetworkInterfaces.
        :type protocol: str
        """
        allowed_values = ["TCP", "UDP", "ANY"]  # noqa: E501
        if protocol not in allowed_values:
            raise ValueError(
                "Invalid value for `protocol` ({0}), must be one of {1}".format(
                    protocol, allowed_values
                )
            )

        self._protocol = protocol

    @property
    def port(self) -> int:
        """Gets the port of this AppManifestNetworkInterfaces.

        Port number exposed by the component. Edge Cloud Provider may generate a dynamic port towards the component instance which forwards external traffic to the component port.   # noqa: E501

        :return: The port of this AppManifestNetworkInterfaces.
        :rtype: int
        """
        return self._port

    @port.setter
    def port(self, port: int):
        """Sets the port of this AppManifestNetworkInterfaces.

        Port number exposed by the component. Edge Cloud Provider may generate a dynamic port towards the component instance which forwards external traffic to the component port.   # noqa: E501

        :param port: The port of this AppManifestNetworkInterfaces.
        :type port: int
        """
        if port is None:
            raise ValueError(
                "Invalid value for `port`, must not be `None`"
            )  # noqa: E501

        self._port = port

    @property
    def visibility_type(self) -> str:
        """Gets the visibility_type of this AppManifestNetworkInterfaces.

        Defines whether the interface is exposed to outer world or not i.e., external, or internal. If this is set to \"external\", then it is  exposed to external applications otherwise it is exposed internally to edge application components within edge cloud. When exposed to external world, an external dynamic port is assigned for UC traffic and mapped to the extPort   # noqa: E501

        :return: The visibility_type of this AppManifestNetworkInterfaces.
        :rtype: str
        """
        return self._visibility_type

    @visibility_type.setter
    def visibility_type(self, visibility_type: str):
        """Sets the visibility_type of this AppManifestNetworkInterfaces.

        Defines whether the interface is exposed to outer world or not i.e., external, or internal. If this is set to \"external\", then it is  exposed to external applications otherwise it is exposed internally to edge application components within edge cloud. When exposed to external world, an external dynamic port is assigned for UC traffic and mapped to the extPort   # noqa: E501

        :param visibility_type: The visibility_type of this AppManifestNetworkInterfaces.
        :type visibility_type: str
        """
        allowed_values = ["VISIBILITY_EXTERNAL", "VISIBILITY_INTERNAL"]  # noqa: E501
        if visibility_type not in allowed_values:
            raise ValueError(
                "Invalid value for `visibility_type` ({0}), must be one of {1}".format(
                    visibility_type, allowed_values
                )
            )

        self._visibility_type = visibility_type
