# coding: utf-8

from __future__ import absolute_import

from datetime import date, datetime  # noqa: F401
from typing import Dict, List  # noqa: F401

from sunrise6g_opensdk.edgecloud.adapters.kubernetes.lib.models.base_model_ import Model
from sunrise6g_opensdk.edgecloud.adapters.kubernetes.lib.models.env_parameters import (  # noqa: F401,E501
    EnvParameters,
)
from sunrise6g_opensdk.edgecloud.adapters.kubernetes.lib.models.volume_mount_deploy import (  # noqa: F401,E501
    VolumeMountDeploy,
)
from sunrise6g_opensdk.edgecloud.adapters.kubernetes.lib.util import deserialize_model


class DeployServiceFunction(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    def __init__(
        self,
        service_function_name: str = None,
        service_function_instance_name: str = None,
        volume_mounts: List[VolumeMountDeploy] = None,
        autoscaling_metric: str = None,
        autoscaling_policy: str = None,
        count_min: int = None,
        count_max: int = None,
        location: str = None,
        all_node_ports: bool = None,
        monitoring_services: bool = None,
        node_ports: List[int] = None,
        env_parameters: List[EnvParameters] = None,
    ):  # noqa: E501
        """DeployServiceFunction - a model defined in Swagger

        :param service_function_name: The service_function_name of this DeployServiceFunction.  # noqa: E501
        :type service_function_name: str
        :param service_function_instance_name: The service_function_instance_name of this DeployServiceFunction.  # noqa: E501
        :type service_function_instance_name: str
        :param volume_mounts: The volume_mounts of this DeployServiceFunction.  # noqa: E501
        :type volume_mounts: List[VolumeMountDeploy]
        :param autoscaling_metric: The autoscaling_metric of this DeployServiceFunction.  # noqa: E501
        :type autoscaling_metric: str
        :param autoscaling_policy: The autoscaling_policy of this DeployServiceFunction.  # noqa: E501
        :type autoscaling_policy: str
        :param count_min: The count_min of this DeployServiceFunction.  # noqa: E501
        :type count_min: int
        :param count_max: The count_max of this DeployServiceFunction.  # noqa: E501
        :type count_max: int
        :param location: The location of this DeployServiceFunction.  # noqa: E501
        :type location: str
        :param all_node_ports: The all_node_ports of this DeployServiceFunction.  # noqa: E501
        :type all_node_ports: bool
        :param monitoring_services: The monitoring_services of this DeployServiceFunction.  # noqa: E501
        :type monitoring_services: bool
        :param node_ports: The node_ports of this DeployServiceFunction.  # noqa: E501
        :type node_ports: List[int]
        :param env_parameters: The env_parameters of this DeployServiceFunction.  # noqa: E501
        :type env_parameters: List[EnvParameters]
        """
        self.swagger_types = {
            "service_function_name": str,
            "service_function_instance_name": str,
            "volume_mounts": List[VolumeMountDeploy],
            "autoscaling_metric": str,
            "autoscaling_policy": str,
            "count_min": int,
            "count_max": int,
            "location": str,
            "all_node_ports": bool,
            "monitoring_services": bool,
            "node_ports": List[int],
            "env_parameters": List[EnvParameters],
        }

        self.attribute_map = {
            "service_function_name": "service_function_name",
            "service_function_instance_name": "service_function_instance_name",
            "volume_mounts": "volume_mounts",
            "autoscaling_metric": "autoscaling_metric",
            "autoscaling_policy": "autoscaling_policy",
            "count_min": "count_min",
            "count_max": "count_max",
            "location": "location",
            "all_node_ports": "all_node_ports",
            "monitoring_services": "monitoring_services",
            "node_ports": "node_ports",
            "env_parameters": "env_parameters",
        }
        self._service_function_name = service_function_name
        self._service_function_instance_name = service_function_instance_name
        self._volume_mounts = volume_mounts
        self._autoscaling_metric = autoscaling_metric
        self._autoscaling_policy = autoscaling_policy
        self._count_min = count_min
        self._count_max = count_max
        self._location = location
        self._all_node_ports = all_node_ports
        self._monitoring_services = monitoring_services
        self._node_ports = node_ports
        self._env_parameters = env_parameters

    @classmethod
    def from_dict(cls, dikt) -> "DeployServiceFunction":
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The deployServiceFunction of this DeployServiceFunction.  # noqa: E501
        :rtype: DeployServiceFunction
        """
        return deserialize_model(dikt, cls)

    @property
    def service_function_name(self) -> str:
        """Gets the service_function_name of this DeployServiceFunction.


        :return: The service_function_name of this DeployServiceFunction.
        :rtype: str
        """
        return self._service_function_name

    @service_function_name.setter
    def service_function_name(self, service_function_name: str):
        """Sets the service_function_name of this DeployServiceFunction.


        :param service_function_name: The service_function_name of this DeployServiceFunction.
        :type service_function_name: str
        """

        self._service_function_name = service_function_name

    @property
    def service_function_instance_name(self) -> str:
        """Gets the service_function_instance_name of this DeployServiceFunction.


        :return: The service_function_instance_name of this DeployServiceFunction.
        :rtype: str
        """
        return self._service_function_instance_name

    @service_function_instance_name.setter
    def service_function_instance_name(self, service_function_instance_name: str):
        """Sets the service_function_instance_name of this DeployServiceFunction.


        :param service_function_instance_name: The service_function_instance_name of this DeployServiceFunction.
        :type service_function_instance_name: str
        """

        self._service_function_instance_name = service_function_instance_name

    @property
    def volume_mounts(self) -> List[VolumeMountDeploy]:
        """Gets the volume_mounts of this DeployServiceFunction.


        :return: The volume_mounts of this DeployServiceFunction.
        :rtype: List[VolumeMountDeploy]
        """
        return self._volume_mounts

    @volume_mounts.setter
    def volume_mounts(self, volume_mounts: List[VolumeMountDeploy]):
        """Sets the volume_mounts of this DeployServiceFunction.


        :param volume_mounts: The volume_mounts of this DeployServiceFunction.
        :type volume_mounts: List[VolumeMountDeploy]
        """

        self._volume_mounts = volume_mounts

    @property
    def autoscaling_metric(self) -> str:
        """Gets the autoscaling_metric of this DeployServiceFunction.


        :return: The autoscaling_metric of this DeployServiceFunction.
        :rtype: str
        """
        return self._autoscaling_metric

    @autoscaling_metric.setter
    def autoscaling_metric(self, autoscaling_metric: str):
        """Sets the autoscaling_metric of this DeployServiceFunction.


        :param autoscaling_metric: The autoscaling_metric of this DeployServiceFunction.
        :type autoscaling_metric: str
        """

        self._autoscaling_metric = autoscaling_metric

    @property
    def autoscaling_policy(self) -> str:
        """Gets the autoscaling_policy of this DeployServiceFunction.


        :return: The autoscaling_policy of this DeployServiceFunction.
        :rtype: str
        """
        return self._autoscaling_policy

    @autoscaling_policy.setter
    def autoscaling_policy(self, autoscaling_policy: str):
        """Sets the autoscaling_policy of this DeployServiceFunction.


        :param autoscaling_policy: The autoscaling_policy of this DeployServiceFunction.
        :type autoscaling_policy: str
        """

        self._autoscaling_policy = autoscaling_policy

    @property
    def count_min(self) -> int:
        """Gets the count_min of this DeployServiceFunction.


        :return: The count_min of this DeployServiceFunction.
        :rtype: int
        """
        return self._count_min

    @count_min.setter
    def count_min(self, count_min: int):
        """Sets the count_min of this DeployServiceFunction.


        :param count_min: The count_min of this DeployServiceFunction.
        :type count_min: int
        """

        self._count_min = count_min

    @property
    def count_max(self) -> int:
        """Gets the count_max of this DeployServiceFunction.


        :return: The count_max of this DeployServiceFunction.
        :rtype: int
        """
        return self._count_max

    @count_max.setter
    def count_max(self, count_max: int):
        """Sets the count_max of this DeployServiceFunction.


        :param count_max: The count_max of this DeployServiceFunction.
        :type count_max: int
        """

        self._count_max = count_max

    @property
    def location(self) -> str:
        """Gets the location of this DeployServiceFunction.


        :return: The location of this DeployServiceFunction.
        :rtype: str
        """
        return self._location

    @location.setter
    def location(self, location: str):
        """Sets the location of this DeployServiceFunction.


        :param location: The location of this DeployServiceFunction.
        :type location: str
        """

        self._location = location

    @property
    def all_node_ports(self) -> bool:
        """Gets the all_node_ports of this DeployServiceFunction.


        :return: The all_node_ports of this DeployServiceFunction.
        :rtype: bool
        """
        return self._all_node_ports

    @all_node_ports.setter
    def all_node_ports(self, all_node_ports: bool):
        """Sets the all_node_ports of this DeployServiceFunction.


        :param all_node_ports: The all_node_ports of this DeployServiceFunction.
        :type all_node_ports: bool
        """

        self._all_node_ports = all_node_ports

    @property
    def monitoring_services(self) -> bool:
        """Gets the monitoring_services of this DeployServiceFunction.


        :return: The monitoring_services of this DeployServiceFunction.
        :rtype: bool
        """
        return self._monitoring_services

    @monitoring_services.setter
    def monitoring_services(self, monitoring_services: bool):
        """Sets the monitoring_services of this DeployServiceFunction.


        :param monitoring_services: The monitoring_services of this DeployServiceFunction.
        :type monitoring_services: bool
        """

        self._monitoring_services = monitoring_services

    @property
    def node_ports(self) -> List[int]:
        """Gets the node_ports of this DeployServiceFunction.


        :return: The node_ports of this DeployServiceFunction.
        :rtype: List[int]
        """
        return self._node_ports

    @node_ports.setter
    def node_ports(self, node_ports: List[int]):
        """Sets the node_ports of this DeployServiceFunction.


        :param node_ports: The node_ports of this DeployServiceFunction.
        :type node_ports: List[int]
        """

        self._node_ports = node_ports

    @property
    def env_parameters(self) -> List[EnvParameters]:
        """Gets the env_parameters of this DeployServiceFunction.


        :return: The env_parameters of this DeployServiceFunction.
        :rtype: List[EnvParameters]
        """
        return self._env_parameters

    @env_parameters.setter
    def env_parameters(self, env_parameters: List[EnvParameters]):
        """Sets the env_parameters of this DeployServiceFunction.


        :param env_parameters: The env_parameters of this DeployServiceFunction.
        :type env_parameters: List[EnvParameters]
        """

        self._env_parameters = env_parameters
