# coding: utf-8

from __future__ import absolute_import

from datetime import date, datetime  # noqa: F401
from typing import Dict, List  # noqa: F401

from sunrise6g_opensdk.edgecloud.adapters.kubernetes.lib import util
from sunrise6g_opensdk.edgecloud.adapters.kubernetes.lib.models.base_model_ import Model
from sunrise6g_opensdk.edgecloud.adapters.kubernetes.lib.models.edge_cloud_provider import (  # noqa: F401,E501
    EdgeCloudProvider,
)
from sunrise6g_opensdk.edgecloud.adapters.kubernetes.lib.models.edge_cloud_region import (  # noqa: F401,E501
    EdgeCloudRegion,
)
from sunrise6g_opensdk.edgecloud.adapters.kubernetes.lib.models.edge_cloud_zone_id import (  # noqa: F401,E501
    EdgeCloudZoneId,
)
from sunrise6g_opensdk.edgecloud.adapters.kubernetes.lib.models.edge_cloud_zone_name import (  # noqa: F401,E501
    EdgeCloudZoneName,
)
from sunrise6g_opensdk.edgecloud.adapters.kubernetes.lib.models.edge_cloud_zone_status import (  # noqa: F401,E501
    EdgeCloudZoneStatus,
)


class EdgeCloudZone(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    def __init__(
        self,
        edge_cloud_zone_id: str = None,
        edge_cloud_zone_name: str = None,
        edge_cloud_zone_status: str = None,
        edge_cloud_provider: str = None,
        edge_cloud_region: str = None,
    ):  # noqa: E501
        """EdgeCloudZone - a model defined in Swagger

        :param edge_cloud_zone_id: The edge_cloud_zone_id of this EdgeCloudZone.  # noqa: E501
        :type edge_cloud_zone_id: EdgeCloudZoneId
        :param edge_cloud_zone_name: The edge_cloud_zone_name of this EdgeCloudZone.  # noqa: E501
        :type edge_cloud_zone_name: EdgeCloudZoneName
        :param edge_cloud_zone_status: The edge_cloud_zone_status of this EdgeCloudZone.  # noqa: E501
        :type edge_cloud_zone_status: EdgeCloudZoneStatus
        :param edge_cloud_provider: The edge_cloud_provider of this EdgeCloudZone.  # noqa: E501
        :type edge_cloud_provider: EdgeCloudProvider
        :param edge_cloud_region: The edge_cloud_region of this EdgeCloudZone.  # noqa: E501
        :type edge_cloud_region: EdgeCloudRegion
        """
        self.swagger_types = {
            "edge_cloud_zone_id": str,
            "edge_cloud_zone_name": str,
            "edge_cloud_zone_status": str,
            "edge_cloud_provider": str,
            "edge_cloud_region": str,
        }

        self.attribute_map = {
            "edge_cloud_zone_id": "edgeCloudZoneId",
            "edge_cloud_zone_name": "edgeCloudZoneName",
            "edge_cloud_zone_status": "edgeCloudZoneStatus",
            "edge_cloud_provider": "edgeCloudProvider",
            "edge_cloud_region": "edgeCloudRegion",
        }
        self._edge_cloud_zone_id = edge_cloud_zone_id
        self._edge_cloud_zone_name = edge_cloud_zone_name
        self._edge_cloud_zone_status = edge_cloud_zone_status
        self._edge_cloud_provider = edge_cloud_provider
        self._edge_cloud_region = edge_cloud_region

    @classmethod
    def from_dict(cls, dikt) -> str:
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The EdgeCloudZone of this EdgeCloudZone.  # noqa: E501
        :rtype: EdgeCloudZone
        """
        return util.deserialize_model(dikt, cls)

    @property
    def edge_cloud_zone_id(self) -> str:
        """Gets the edge_cloud_zone_id of this EdgeCloudZone.


        :return: The edge_cloud_zone_id of this EdgeCloudZone.
        :rtype: EdgeCloudZoneId
        """
        return self._edge_cloud_zone_id

    @edge_cloud_zone_id.setter
    def edge_cloud_zone_id(self, edge_cloud_zone_id: str):
        """Sets the edge_cloud_zone_id of this EdgeCloudZone.


        :param edge_cloud_zone_id: The edge_cloud_zone_id of this EdgeCloudZone.
        :type edge_cloud_zone_id: EdgeCloudZoneId
        """

        self._edge_cloud_zone_id = edge_cloud_zone_id

    @property
    def edge_cloud_zone_name(self) -> str:
        """Gets the edge_cloud_zone_name of this EdgeCloudZone.


        :return: The edge_cloud_zone_name of this EdgeCloudZone.
        :rtype: EdgeCloudZoneName
        """
        return self._edge_cloud_zone_name

    @edge_cloud_zone_name.setter
    def edge_cloud_zone_name(self, edge_cloud_zone_name: str):
        """Sets the edge_cloud_zone_name of this EdgeCloudZone.


        :param edge_cloud_zone_name: The edge_cloud_zone_name of this EdgeCloudZone.
        :type edge_cloud_zone_name: EdgeCloudZoneName
        """

        self._edge_cloud_zone_name = edge_cloud_zone_name

    @property
    def edge_cloud_zone_status(self) -> str:
        """Gets the edge_cloud_zone_status of this EdgeCloudZone.


        :return: The edge_cloud_zone_status of this EdgeCloudZone.
        :rtype: EdgeCloudZoneStatus
        """
        return self._edge_cloud_zone_status

    @edge_cloud_zone_status.setter
    def edge_cloud_zone_status(self, edge_cloud_zone_status: str):
        """Sets the edge_cloud_zone_status of this EdgeCloudZone.


        :param edge_cloud_zone_status: The edge_cloud_zone_status of this EdgeCloudZone.
        :type edge_cloud_zone_status: EdgeCloudZoneStatus
        """

        self._edge_cloud_zone_status = edge_cloud_zone_status

    @property
    def edge_cloud_provider(self) -> str:
        """Gets the edge_cloud_provider of this EdgeCloudZone.


        :return: The edge_cloud_provider of this EdgeCloudZone.
        :rtype: EdgeCloudProvider
        """
        return self._edge_cloud_provider

    @edge_cloud_provider.setter
    def edge_cloud_provider(self, edge_cloud_provider: str):
        """Sets the edge_cloud_provider of this EdgeCloudZone.


        :param edge_cloud_provider: The edge_cloud_provider of this EdgeCloudZone.
        :type edge_cloud_provider: EdgeCloudProvider
        """

        self._edge_cloud_provider = edge_cloud_provider

    @property
    def edge_cloud_region(self) -> str:
        """Gets the edge_cloud_region of this EdgeCloudZone.


        :return: The edge_cloud_region of this EdgeCloudZone.
        :rtype: EdgeCloudRegion
        """
        return self._edge_cloud_region

    @edge_cloud_region.setter
    def edge_cloud_region(self, edge_cloud_region: str):
        """Sets the edge_cloud_region of this EdgeCloudZone.


        :param edge_cloud_region: The edge_cloud_region of this EdgeCloudZone.
        :type edge_cloud_region: EdgeCloudRegion
        """

        self._edge_cloud_region = edge_cloud_region
