# coding: utf-8

from __future__ import absolute_import

from datetime import date, datetime  # noqa: F401
from typing import Dict, List  # noqa: F401

from sunrise6g_opensdk.edgecloud.adapters.kubernetes.lib import util
from sunrise6g_opensdk.edgecloud.adapters.kubernetes.lib.models.base_model_ import Model


class OperatingSystem(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    def __init__(
        self,
        architecture: str = None,
        family: str = None,
        version: str = None,
        license: str = None,
    ):  # noqa: E501
        """OperatingSystem - a model defined in Swagger

        :param architecture: The architecture of this OperatingSystem.  # noqa: E501
        :type architecture: str
        :param family: The family of this OperatingSystem.  # noqa: E501
        :type family: str
        :param version: The version of this OperatingSystem.  # noqa: E501
        :type version: str
        :param license: The license of this OperatingSystem.  # noqa: E501
        :type license: str
        """
        self.swagger_types = {
            "architecture": str,
            "family": str,
            "version": str,
            "license": str,
        }

        self.attribute_map = {
            "architecture": "architecture",
            "family": "family",
            "version": "version",
            "license": "license",
        }
        self._architecture = architecture
        self._family = family
        self._version = version
        self._license = license

    @classmethod
    def from_dict(cls, dikt) -> "OperatingSystem":
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The OperatingSystem of this OperatingSystem.  # noqa: E501
        :rtype: OperatingSystem
        """
        return util.deserialize_model(dikt, cls)

    @property
    def architecture(self) -> str:
        """Gets the architecture of this OperatingSystem.

        Type of the OS Architecture  # noqa: E501

        :return: The architecture of this OperatingSystem.
        :rtype: str
        """
        return self._architecture

    @architecture.setter
    def architecture(self, architecture: str):
        """Sets the architecture of this OperatingSystem.

        Type of the OS Architecture  # noqa: E501

        :param architecture: The architecture of this OperatingSystem.
        :type architecture: str
        """
        allowed_values = ["x86_64", "x86"]  # noqa: E501
        if architecture not in allowed_values:
            raise ValueError(
                "Invalid value for `architecture` ({0}), must be one of {1}".format(
                    architecture, allowed_values
                )
            )

        self._architecture = architecture

    @property
    def family(self) -> str:
        """Gets the family of this OperatingSystem.

        Family to which OS belongs  # noqa: E501

        :return: The family of this OperatingSystem.
        :rtype: str
        """
        return self._family

    @family.setter
    def family(self, family: str):
        """Sets the family of this OperatingSystem.

        Family to which OS belongs  # noqa: E501

        :param family: The family of this OperatingSystem.
        :type family: str
        """
        allowed_values = ["RHEL", "UBUNTU", "COREOS", "WINDOWS", "OTHER"]  # noqa: E501
        if family not in allowed_values:
            raise ValueError(
                "Invalid value for `family` ({0}), must be one of {1}".format(
                    family, allowed_values
                )
            )

        self._family = family

    @property
    def version(self) -> str:
        """Gets the version of this OperatingSystem.

        Version of the OS  # noqa: E501

        :return: The version of this OperatingSystem.
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version: str):
        """Sets the version of this OperatingSystem.

        Version of the OS  # noqa: E501

        :param version: The version of this OperatingSystem.
        :type version: str
        """
        allowed_values = [
            "OS_VERSION_UBUNTU_2204_LTS",
            "OS_VERSION_RHEL_8",
            "OS_MS_WINDOWS_2022",
            "OTHER",
        ]  # noqa: E501
        if version not in allowed_values:
            raise ValueError(
                "Invalid value for `version` ({0}), must be one of {1}".format(
                    version, allowed_values
                )
            )

        self._version = version

    @property
    def license(self) -> str:
        """Gets the license of this OperatingSystem.

        License needed to activate the OS  # noqa: E501

        :return: The license of this OperatingSystem.
        :rtype: str
        """
        return self._license

    @license.setter
    def license(self, license: str):
        """Sets the license of this OperatingSystem.

        License needed to activate the OS  # noqa: E501

        :param license: The license of this OperatingSystem.
        :type license: str
        """
        allowed_values = [
            "OS_LICENSE_TYPE_FREE",
            "OS_LICENSE_TYPE_ON_DEMAND",
            "OTHER",
        ]  # noqa: E501
        if license not in allowed_values:
            raise ValueError(
                "Invalid value for `license` ({0}), must be one of {1}".format(
                    license, allowed_values
                )
            )

        self._license = license
