/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AppServiceSourceControlSlotConfig extends cdktf.TerraformMetaArguments {
    /**
    * The URL for the repository
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/app_service_source_control_slot#branch AppServiceSourceControlSlot#branch}
    */
    readonly branch?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/app_service_source_control_slot#id AppServiceSourceControlSlot#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The branch name to use for deployments.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/app_service_source_control_slot#repo_url AppServiceSourceControlSlot#repo_url}
    */
    readonly repoUrl?: string;
    /**
    * Should the Deployment Rollback be enabled? Defaults to `false`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/app_service_source_control_slot#rollback_enabled AppServiceSourceControlSlot#rollback_enabled}
    */
    readonly rollbackEnabled?: boolean | cdktf.IResolvable;
    /**
    * The ID of the Linux or Windows Web App Slot.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/app_service_source_control_slot#slot_id AppServiceSourceControlSlot#slot_id}
    */
    readonly slotId: string;
    /**
    * Should the Slot use local Git configuration.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/app_service_source_control_slot#use_local_git AppServiceSourceControlSlot#use_local_git}
    */
    readonly useLocalGit?: boolean | cdktf.IResolvable;
    /**
    * Should code be deployed manually. Set to `true` to disable continuous integration, such as webhooks into online repos such as GitHub. Defaults to `false`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/app_service_source_control_slot#use_manual_integration AppServiceSourceControlSlot#use_manual_integration}
    */
    readonly useManualIntegration?: boolean | cdktf.IResolvable;
    /**
    * The repository specified is Mercurial. Defaults to `false`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/app_service_source_control_slot#use_mercurial AppServiceSourceControlSlot#use_mercurial}
    */
    readonly useMercurial?: boolean | cdktf.IResolvable;
    /**
    * github_action_configuration block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/app_service_source_control_slot#github_action_configuration AppServiceSourceControlSlot#github_action_configuration}
    */
    readonly githubActionConfiguration?: AppServiceSourceControlSlotGithubActionConfiguration;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/app_service_source_control_slot#timeouts AppServiceSourceControlSlot#timeouts}
    */
    readonly timeouts?: AppServiceSourceControlSlotTimeouts;
}
export interface AppServiceSourceControlSlotGithubActionConfigurationCodeConfiguration {
    /**
    * The value to use for the Runtime Stack in the workflow file content for code base apps.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/app_service_source_control_slot#runtime_stack AppServiceSourceControlSlot#runtime_stack}
    */
    readonly runtimeStack: string;
    /**
    * The value to use for the Runtime Version in the workflow file content for code base apps.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/app_service_source_control_slot#runtime_version AppServiceSourceControlSlot#runtime_version}
    */
    readonly runtimeVersion: string;
}
export declare function appServiceSourceControlSlotGithubActionConfigurationCodeConfigurationToTerraform(struct?: AppServiceSourceControlSlotGithubActionConfigurationCodeConfigurationOutputReference | AppServiceSourceControlSlotGithubActionConfigurationCodeConfiguration): any;
export declare class AppServiceSourceControlSlotGithubActionConfigurationCodeConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppServiceSourceControlSlotGithubActionConfigurationCodeConfiguration | undefined;
    set internalValue(value: AppServiceSourceControlSlotGithubActionConfigurationCodeConfiguration | undefined);
    private _runtimeStack?;
    get runtimeStack(): string;
    set runtimeStack(value: string);
    get runtimeStackInput(): string | undefined;
    private _runtimeVersion?;
    get runtimeVersion(): string;
    set runtimeVersion(value: string);
    get runtimeVersionInput(): string | undefined;
}
export interface AppServiceSourceControlSlotGithubActionConfigurationContainerConfiguration {
    /**
    * The image name for the build.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/app_service_source_control_slot#image_name AppServiceSourceControlSlot#image_name}
    */
    readonly imageName: string;
    /**
    * The password used to upload the image to the container registry.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/app_service_source_control_slot#registry_password AppServiceSourceControlSlot#registry_password}
    */
    readonly registryPassword?: string;
    /**
    * The server URL for the container registry where the build will be hosted.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/app_service_source_control_slot#registry_url AppServiceSourceControlSlot#registry_url}
    */
    readonly registryUrl: string;
    /**
    * The username used to upload the image to the container registry.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/app_service_source_control_slot#registry_username AppServiceSourceControlSlot#registry_username}
    */
    readonly registryUsername?: string;
}
export declare function appServiceSourceControlSlotGithubActionConfigurationContainerConfigurationToTerraform(struct?: AppServiceSourceControlSlotGithubActionConfigurationContainerConfigurationOutputReference | AppServiceSourceControlSlotGithubActionConfigurationContainerConfiguration): any;
export declare class AppServiceSourceControlSlotGithubActionConfigurationContainerConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppServiceSourceControlSlotGithubActionConfigurationContainerConfiguration | undefined;
    set internalValue(value: AppServiceSourceControlSlotGithubActionConfigurationContainerConfiguration | undefined);
    private _imageName?;
    get imageName(): string;
    set imageName(value: string);
    get imageNameInput(): string | undefined;
    private _registryPassword?;
    get registryPassword(): string;
    set registryPassword(value: string);
    resetRegistryPassword(): void;
    get registryPasswordInput(): string | undefined;
    private _registryUrl?;
    get registryUrl(): string;
    set registryUrl(value: string);
    get registryUrlInput(): string | undefined;
    private _registryUsername?;
    get registryUsername(): string;
    set registryUsername(value: string);
    resetRegistryUsername(): void;
    get registryUsernameInput(): string | undefined;
}
export interface AppServiceSourceControlSlotGithubActionConfiguration {
    /**
    * Should the service generate the GitHub Action Workflow file. Defaults to `true`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/app_service_source_control_slot#generate_workflow_file AppServiceSourceControlSlot#generate_workflow_file}
    */
    readonly generateWorkflowFile?: boolean | cdktf.IResolvable;
    /**
    * code_configuration block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/app_service_source_control_slot#code_configuration AppServiceSourceControlSlot#code_configuration}
    */
    readonly codeConfiguration?: AppServiceSourceControlSlotGithubActionConfigurationCodeConfiguration;
    /**
    * container_configuration block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/app_service_source_control_slot#container_configuration AppServiceSourceControlSlot#container_configuration}
    */
    readonly containerConfiguration?: AppServiceSourceControlSlotGithubActionConfigurationContainerConfiguration;
}
export declare function appServiceSourceControlSlotGithubActionConfigurationToTerraform(struct?: AppServiceSourceControlSlotGithubActionConfigurationOutputReference | AppServiceSourceControlSlotGithubActionConfiguration): any;
export declare class AppServiceSourceControlSlotGithubActionConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppServiceSourceControlSlotGithubActionConfiguration | undefined;
    set internalValue(value: AppServiceSourceControlSlotGithubActionConfiguration | undefined);
    private _generateWorkflowFile?;
    get generateWorkflowFile(): boolean | cdktf.IResolvable;
    set generateWorkflowFile(value: boolean | cdktf.IResolvable);
    resetGenerateWorkflowFile(): void;
    get generateWorkflowFileInput(): boolean | cdktf.IResolvable | undefined;
    get linuxAction(): cdktf.IResolvable;
    private _codeConfiguration;
    get codeConfiguration(): AppServiceSourceControlSlotGithubActionConfigurationCodeConfigurationOutputReference;
    putCodeConfiguration(value: AppServiceSourceControlSlotGithubActionConfigurationCodeConfiguration): void;
    resetCodeConfiguration(): void;
    get codeConfigurationInput(): AppServiceSourceControlSlotGithubActionConfigurationCodeConfiguration | undefined;
    private _containerConfiguration;
    get containerConfiguration(): AppServiceSourceControlSlotGithubActionConfigurationContainerConfigurationOutputReference;
    putContainerConfiguration(value: AppServiceSourceControlSlotGithubActionConfigurationContainerConfiguration): void;
    resetContainerConfiguration(): void;
    get containerConfigurationInput(): AppServiceSourceControlSlotGithubActionConfigurationContainerConfiguration | undefined;
}
export interface AppServiceSourceControlSlotTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/app_service_source_control_slot#create AppServiceSourceControlSlot#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/app_service_source_control_slot#delete AppServiceSourceControlSlot#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/app_service_source_control_slot#read AppServiceSourceControlSlot#read}
    */
    readonly read?: string;
}
export declare function appServiceSourceControlSlotTimeoutsToTerraform(struct?: AppServiceSourceControlSlotTimeouts | cdktf.IResolvable): any;
export declare class AppServiceSourceControlSlotTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppServiceSourceControlSlotTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: AppServiceSourceControlSlotTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/app_service_source_control_slot azurerm_app_service_source_control_slot}
*/
export declare class AppServiceSourceControlSlot extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_app_service_source_control_slot";
    /**
    * Generates CDKTF code for importing a AppServiceSourceControlSlot resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the AppServiceSourceControlSlot to import
    * @param importFromId The id of the existing AppServiceSourceControlSlot that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/app_service_source_control_slot#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the AppServiceSourceControlSlot to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/app_service_source_control_slot azurerm_app_service_source_control_slot} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AppServiceSourceControlSlotConfig
    */
    constructor(scope: Construct, id: string, config: AppServiceSourceControlSlotConfig);
    private _branch?;
    get branch(): string;
    set branch(value: string);
    resetBranch(): void;
    get branchInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _repoUrl?;
    get repoUrl(): string;
    set repoUrl(value: string);
    resetRepoUrl(): void;
    get repoUrlInput(): string | undefined;
    private _rollbackEnabled?;
    get rollbackEnabled(): boolean | cdktf.IResolvable;
    set rollbackEnabled(value: boolean | cdktf.IResolvable);
    resetRollbackEnabled(): void;
    get rollbackEnabledInput(): boolean | cdktf.IResolvable | undefined;
    get scmType(): string;
    private _slotId?;
    get slotId(): string;
    set slotId(value: string);
    get slotIdInput(): string | undefined;
    private _useLocalGit?;
    get useLocalGit(): boolean | cdktf.IResolvable;
    set useLocalGit(value: boolean | cdktf.IResolvable);
    resetUseLocalGit(): void;
    get useLocalGitInput(): boolean | cdktf.IResolvable | undefined;
    private _useManualIntegration?;
    get useManualIntegration(): boolean | cdktf.IResolvable;
    set useManualIntegration(value: boolean | cdktf.IResolvable);
    resetUseManualIntegration(): void;
    get useManualIntegrationInput(): boolean | cdktf.IResolvable | undefined;
    private _useMercurial?;
    get useMercurial(): boolean | cdktf.IResolvable;
    set useMercurial(value: boolean | cdktf.IResolvable);
    resetUseMercurial(): void;
    get useMercurialInput(): boolean | cdktf.IResolvable | undefined;
    get usesGithubAction(): cdktf.IResolvable;
    private _githubActionConfiguration;
    get githubActionConfiguration(): AppServiceSourceControlSlotGithubActionConfigurationOutputReference;
    putGithubActionConfiguration(value: AppServiceSourceControlSlotGithubActionConfiguration): void;
    resetGithubActionConfiguration(): void;
    get githubActionConfigurationInput(): AppServiceSourceControlSlotGithubActionConfiguration | undefined;
    private _timeouts;
    get timeouts(): AppServiceSourceControlSlotTimeoutsOutputReference;
    putTimeouts(value: AppServiceSourceControlSlotTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | AppServiceSourceControlSlotTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
