/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ArcKubernetesFluxConfigurationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/arc_kubernetes_flux_configuration#cluster_id ArcKubernetesFluxConfiguration#cluster_id}
    */
    readonly clusterId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/arc_kubernetes_flux_configuration#continuous_reconciliation_enabled ArcKubernetesFluxConfiguration#continuous_reconciliation_enabled}
    */
    readonly continuousReconciliationEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/arc_kubernetes_flux_configuration#id ArcKubernetesFluxConfiguration#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/arc_kubernetes_flux_configuration#name ArcKubernetesFluxConfiguration#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/arc_kubernetes_flux_configuration#namespace ArcKubernetesFluxConfiguration#namespace}
    */
    readonly namespace: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/arc_kubernetes_flux_configuration#scope ArcKubernetesFluxConfiguration#scope}
    */
    readonly scope?: string;
    /**
    * blob_storage block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/arc_kubernetes_flux_configuration#blob_storage ArcKubernetesFluxConfiguration#blob_storage}
    */
    readonly blobStorage?: ArcKubernetesFluxConfigurationBlobStorage;
    /**
    * bucket block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/arc_kubernetes_flux_configuration#bucket ArcKubernetesFluxConfiguration#bucket}
    */
    readonly bucket?: ArcKubernetesFluxConfigurationBucket;
    /**
    * git_repository block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/arc_kubernetes_flux_configuration#git_repository ArcKubernetesFluxConfiguration#git_repository}
    */
    readonly gitRepository?: ArcKubernetesFluxConfigurationGitRepository;
    /**
    * kustomizations block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/arc_kubernetes_flux_configuration#kustomizations ArcKubernetesFluxConfiguration#kustomizations}
    */
    readonly kustomizations: ArcKubernetesFluxConfigurationKustomizations[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/arc_kubernetes_flux_configuration#timeouts ArcKubernetesFluxConfiguration#timeouts}
    */
    readonly timeouts?: ArcKubernetesFluxConfigurationTimeouts;
}
export interface ArcKubernetesFluxConfigurationBlobStorageServicePrincipal {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/arc_kubernetes_flux_configuration#client_certificate_base64 ArcKubernetesFluxConfiguration#client_certificate_base64}
    */
    readonly clientCertificateBase64?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/arc_kubernetes_flux_configuration#client_certificate_password ArcKubernetesFluxConfiguration#client_certificate_password}
    */
    readonly clientCertificatePassword?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/arc_kubernetes_flux_configuration#client_certificate_send_chain ArcKubernetesFluxConfiguration#client_certificate_send_chain}
    */
    readonly clientCertificateSendChain?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/arc_kubernetes_flux_configuration#client_id ArcKubernetesFluxConfiguration#client_id}
    */
    readonly clientId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/arc_kubernetes_flux_configuration#client_secret ArcKubernetesFluxConfiguration#client_secret}
    */
    readonly clientSecret?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/arc_kubernetes_flux_configuration#tenant_id ArcKubernetesFluxConfiguration#tenant_id}
    */
    readonly tenantId: string;
}
export declare function arcKubernetesFluxConfigurationBlobStorageServicePrincipalToTerraform(struct?: ArcKubernetesFluxConfigurationBlobStorageServicePrincipalOutputReference | ArcKubernetesFluxConfigurationBlobStorageServicePrincipal): any;
export declare class ArcKubernetesFluxConfigurationBlobStorageServicePrincipalOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ArcKubernetesFluxConfigurationBlobStorageServicePrincipal | undefined;
    set internalValue(value: ArcKubernetesFluxConfigurationBlobStorageServicePrincipal | undefined);
    private _clientCertificateBase64?;
    get clientCertificateBase64(): string;
    set clientCertificateBase64(value: string);
    resetClientCertificateBase64(): void;
    get clientCertificateBase64Input(): string | undefined;
    private _clientCertificatePassword?;
    get clientCertificatePassword(): string;
    set clientCertificatePassword(value: string);
    resetClientCertificatePassword(): void;
    get clientCertificatePasswordInput(): string | undefined;
    private _clientCertificateSendChain?;
    get clientCertificateSendChain(): boolean | cdktf.IResolvable;
    set clientCertificateSendChain(value: boolean | cdktf.IResolvable);
    resetClientCertificateSendChain(): void;
    get clientCertificateSendChainInput(): boolean | cdktf.IResolvable | undefined;
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
    private _clientSecret?;
    get clientSecret(): string;
    set clientSecret(value: string);
    resetClientSecret(): void;
    get clientSecretInput(): string | undefined;
    private _tenantId?;
    get tenantId(): string;
    set tenantId(value: string);
    get tenantIdInput(): string | undefined;
}
export interface ArcKubernetesFluxConfigurationBlobStorage {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/arc_kubernetes_flux_configuration#account_key ArcKubernetesFluxConfiguration#account_key}
    */
    readonly accountKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/arc_kubernetes_flux_configuration#container_id ArcKubernetesFluxConfiguration#container_id}
    */
    readonly containerId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/arc_kubernetes_flux_configuration#local_auth_reference ArcKubernetesFluxConfiguration#local_auth_reference}
    */
    readonly localAuthReference?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/arc_kubernetes_flux_configuration#sas_token ArcKubernetesFluxConfiguration#sas_token}
    */
    readonly sasToken?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/arc_kubernetes_flux_configuration#sync_interval_in_seconds ArcKubernetesFluxConfiguration#sync_interval_in_seconds}
    */
    readonly syncIntervalInSeconds?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/arc_kubernetes_flux_configuration#timeout_in_seconds ArcKubernetesFluxConfiguration#timeout_in_seconds}
    */
    readonly timeoutInSeconds?: number;
    /**
    * service_principal block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/arc_kubernetes_flux_configuration#service_principal ArcKubernetesFluxConfiguration#service_principal}
    */
    readonly servicePrincipal?: ArcKubernetesFluxConfigurationBlobStorageServicePrincipal;
}
export declare function arcKubernetesFluxConfigurationBlobStorageToTerraform(struct?: ArcKubernetesFluxConfigurationBlobStorageOutputReference | ArcKubernetesFluxConfigurationBlobStorage): any;
export declare class ArcKubernetesFluxConfigurationBlobStorageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ArcKubernetesFluxConfigurationBlobStorage | undefined;
    set internalValue(value: ArcKubernetesFluxConfigurationBlobStorage | undefined);
    private _accountKey?;
    get accountKey(): string;
    set accountKey(value: string);
    resetAccountKey(): void;
    get accountKeyInput(): string | undefined;
    private _containerId?;
    get containerId(): string;
    set containerId(value: string);
    get containerIdInput(): string | undefined;
    private _localAuthReference?;
    get localAuthReference(): string;
    set localAuthReference(value: string);
    resetLocalAuthReference(): void;
    get localAuthReferenceInput(): string | undefined;
    private _sasToken?;
    get sasToken(): string;
    set sasToken(value: string);
    resetSasToken(): void;
    get sasTokenInput(): string | undefined;
    private _syncIntervalInSeconds?;
    get syncIntervalInSeconds(): number;
    set syncIntervalInSeconds(value: number);
    resetSyncIntervalInSeconds(): void;
    get syncIntervalInSecondsInput(): number | undefined;
    private _timeoutInSeconds?;
    get timeoutInSeconds(): number;
    set timeoutInSeconds(value: number);
    resetTimeoutInSeconds(): void;
    get timeoutInSecondsInput(): number | undefined;
    private _servicePrincipal;
    get servicePrincipal(): ArcKubernetesFluxConfigurationBlobStorageServicePrincipalOutputReference;
    putServicePrincipal(value: ArcKubernetesFluxConfigurationBlobStorageServicePrincipal): void;
    resetServicePrincipal(): void;
    get servicePrincipalInput(): ArcKubernetesFluxConfigurationBlobStorageServicePrincipal | undefined;
}
export interface ArcKubernetesFluxConfigurationBucket {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/arc_kubernetes_flux_configuration#access_key ArcKubernetesFluxConfiguration#access_key}
    */
    readonly accessKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/arc_kubernetes_flux_configuration#bucket_name ArcKubernetesFluxConfiguration#bucket_name}
    */
    readonly bucketName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/arc_kubernetes_flux_configuration#local_auth_reference ArcKubernetesFluxConfiguration#local_auth_reference}
    */
    readonly localAuthReference?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/arc_kubernetes_flux_configuration#secret_key_base64 ArcKubernetesFluxConfiguration#secret_key_base64}
    */
    readonly secretKeyBase64?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/arc_kubernetes_flux_configuration#sync_interval_in_seconds ArcKubernetesFluxConfiguration#sync_interval_in_seconds}
    */
    readonly syncIntervalInSeconds?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/arc_kubernetes_flux_configuration#timeout_in_seconds ArcKubernetesFluxConfiguration#timeout_in_seconds}
    */
    readonly timeoutInSeconds?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/arc_kubernetes_flux_configuration#tls_enabled ArcKubernetesFluxConfiguration#tls_enabled}
    */
    readonly tlsEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/arc_kubernetes_flux_configuration#url ArcKubernetesFluxConfiguration#url}
    */
    readonly url: string;
}
export declare function arcKubernetesFluxConfigurationBucketToTerraform(struct?: ArcKubernetesFluxConfigurationBucketOutputReference | ArcKubernetesFluxConfigurationBucket): any;
export declare class ArcKubernetesFluxConfigurationBucketOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ArcKubernetesFluxConfigurationBucket | undefined;
    set internalValue(value: ArcKubernetesFluxConfigurationBucket | undefined);
    private _accessKey?;
    get accessKey(): string;
    set accessKey(value: string);
    resetAccessKey(): void;
    get accessKeyInput(): string | undefined;
    private _bucketName?;
    get bucketName(): string;
    set bucketName(value: string);
    get bucketNameInput(): string | undefined;
    private _localAuthReference?;
    get localAuthReference(): string;
    set localAuthReference(value: string);
    resetLocalAuthReference(): void;
    get localAuthReferenceInput(): string | undefined;
    private _secretKeyBase64?;
    get secretKeyBase64(): string;
    set secretKeyBase64(value: string);
    resetSecretKeyBase64(): void;
    get secretKeyBase64Input(): string | undefined;
    private _syncIntervalInSeconds?;
    get syncIntervalInSeconds(): number;
    set syncIntervalInSeconds(value: number);
    resetSyncIntervalInSeconds(): void;
    get syncIntervalInSecondsInput(): number | undefined;
    private _timeoutInSeconds?;
    get timeoutInSeconds(): number;
    set timeoutInSeconds(value: number);
    resetTimeoutInSeconds(): void;
    get timeoutInSecondsInput(): number | undefined;
    private _tlsEnabled?;
    get tlsEnabled(): boolean | cdktf.IResolvable;
    set tlsEnabled(value: boolean | cdktf.IResolvable);
    resetTlsEnabled(): void;
    get tlsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _url?;
    get url(): string;
    set url(value: string);
    get urlInput(): string | undefined;
}
export interface ArcKubernetesFluxConfigurationGitRepository {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/arc_kubernetes_flux_configuration#https_ca_cert_base64 ArcKubernetesFluxConfiguration#https_ca_cert_base64}
    */
    readonly httpsCaCertBase64?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/arc_kubernetes_flux_configuration#https_key_base64 ArcKubernetesFluxConfiguration#https_key_base64}
    */
    readonly httpsKeyBase64?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/arc_kubernetes_flux_configuration#https_user ArcKubernetesFluxConfiguration#https_user}
    */
    readonly httpsUser?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/arc_kubernetes_flux_configuration#local_auth_reference ArcKubernetesFluxConfiguration#local_auth_reference}
    */
    readonly localAuthReference?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/arc_kubernetes_flux_configuration#reference_type ArcKubernetesFluxConfiguration#reference_type}
    */
    readonly referenceType: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/arc_kubernetes_flux_configuration#reference_value ArcKubernetesFluxConfiguration#reference_value}
    */
    readonly referenceValue: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/arc_kubernetes_flux_configuration#ssh_known_hosts_base64 ArcKubernetesFluxConfiguration#ssh_known_hosts_base64}
    */
    readonly sshKnownHostsBase64?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/arc_kubernetes_flux_configuration#ssh_private_key_base64 ArcKubernetesFluxConfiguration#ssh_private_key_base64}
    */
    readonly sshPrivateKeyBase64?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/arc_kubernetes_flux_configuration#sync_interval_in_seconds ArcKubernetesFluxConfiguration#sync_interval_in_seconds}
    */
    readonly syncIntervalInSeconds?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/arc_kubernetes_flux_configuration#timeout_in_seconds ArcKubernetesFluxConfiguration#timeout_in_seconds}
    */
    readonly timeoutInSeconds?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/arc_kubernetes_flux_configuration#url ArcKubernetesFluxConfiguration#url}
    */
    readonly url: string;
}
export declare function arcKubernetesFluxConfigurationGitRepositoryToTerraform(struct?: ArcKubernetesFluxConfigurationGitRepositoryOutputReference | ArcKubernetesFluxConfigurationGitRepository): any;
export declare class ArcKubernetesFluxConfigurationGitRepositoryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ArcKubernetesFluxConfigurationGitRepository | undefined;
    set internalValue(value: ArcKubernetesFluxConfigurationGitRepository | undefined);
    private _httpsCaCertBase64?;
    get httpsCaCertBase64(): string;
    set httpsCaCertBase64(value: string);
    resetHttpsCaCertBase64(): void;
    get httpsCaCertBase64Input(): string | undefined;
    private _httpsKeyBase64?;
    get httpsKeyBase64(): string;
    set httpsKeyBase64(value: string);
    resetHttpsKeyBase64(): void;
    get httpsKeyBase64Input(): string | undefined;
    private _httpsUser?;
    get httpsUser(): string;
    set httpsUser(value: string);
    resetHttpsUser(): void;
    get httpsUserInput(): string | undefined;
    private _localAuthReference?;
    get localAuthReference(): string;
    set localAuthReference(value: string);
    resetLocalAuthReference(): void;
    get localAuthReferenceInput(): string | undefined;
    private _referenceType?;
    get referenceType(): string;
    set referenceType(value: string);
    get referenceTypeInput(): string | undefined;
    private _referenceValue?;
    get referenceValue(): string;
    set referenceValue(value: string);
    get referenceValueInput(): string | undefined;
    private _sshKnownHostsBase64?;
    get sshKnownHostsBase64(): string;
    set sshKnownHostsBase64(value: string);
    resetSshKnownHostsBase64(): void;
    get sshKnownHostsBase64Input(): string | undefined;
    private _sshPrivateKeyBase64?;
    get sshPrivateKeyBase64(): string;
    set sshPrivateKeyBase64(value: string);
    resetSshPrivateKeyBase64(): void;
    get sshPrivateKeyBase64Input(): string | undefined;
    private _syncIntervalInSeconds?;
    get syncIntervalInSeconds(): number;
    set syncIntervalInSeconds(value: number);
    resetSyncIntervalInSeconds(): void;
    get syncIntervalInSecondsInput(): number | undefined;
    private _timeoutInSeconds?;
    get timeoutInSeconds(): number;
    set timeoutInSeconds(value: number);
    resetTimeoutInSeconds(): void;
    get timeoutInSecondsInput(): number | undefined;
    private _url?;
    get url(): string;
    set url(value: string);
    get urlInput(): string | undefined;
}
export interface ArcKubernetesFluxConfigurationKustomizations {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/arc_kubernetes_flux_configuration#depends_on ArcKubernetesFluxConfiguration#depends_on}
    */
    readonly dependsOn?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/arc_kubernetes_flux_configuration#garbage_collection_enabled ArcKubernetesFluxConfiguration#garbage_collection_enabled}
    */
    readonly garbageCollectionEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/arc_kubernetes_flux_configuration#name ArcKubernetesFluxConfiguration#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/arc_kubernetes_flux_configuration#path ArcKubernetesFluxConfiguration#path}
    */
    readonly path?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/arc_kubernetes_flux_configuration#recreating_enabled ArcKubernetesFluxConfiguration#recreating_enabled}
    */
    readonly recreatingEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/arc_kubernetes_flux_configuration#retry_interval_in_seconds ArcKubernetesFluxConfiguration#retry_interval_in_seconds}
    */
    readonly retryIntervalInSeconds?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/arc_kubernetes_flux_configuration#sync_interval_in_seconds ArcKubernetesFluxConfiguration#sync_interval_in_seconds}
    */
    readonly syncIntervalInSeconds?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/arc_kubernetes_flux_configuration#timeout_in_seconds ArcKubernetesFluxConfiguration#timeout_in_seconds}
    */
    readonly timeoutInSeconds?: number;
}
export declare function arcKubernetesFluxConfigurationKustomizationsToTerraform(struct?: ArcKubernetesFluxConfigurationKustomizations | cdktf.IResolvable): any;
export declare class ArcKubernetesFluxConfigurationKustomizationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ArcKubernetesFluxConfigurationKustomizations | cdktf.IResolvable | undefined;
    set internalValue(value: ArcKubernetesFluxConfigurationKustomizations | cdktf.IResolvable | undefined);
    private _dependsOn?;
    get dependsOn(): string[];
    set dependsOn(value: string[]);
    resetDependsOn(): void;
    get dependsOnInput(): string[] | undefined;
    private _garbageCollectionEnabled?;
    get garbageCollectionEnabled(): boolean | cdktf.IResolvable;
    set garbageCollectionEnabled(value: boolean | cdktf.IResolvable);
    resetGarbageCollectionEnabled(): void;
    get garbageCollectionEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _recreatingEnabled?;
    get recreatingEnabled(): boolean | cdktf.IResolvable;
    set recreatingEnabled(value: boolean | cdktf.IResolvable);
    resetRecreatingEnabled(): void;
    get recreatingEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _retryIntervalInSeconds?;
    get retryIntervalInSeconds(): number;
    set retryIntervalInSeconds(value: number);
    resetRetryIntervalInSeconds(): void;
    get retryIntervalInSecondsInput(): number | undefined;
    private _syncIntervalInSeconds?;
    get syncIntervalInSeconds(): number;
    set syncIntervalInSeconds(value: number);
    resetSyncIntervalInSeconds(): void;
    get syncIntervalInSecondsInput(): number | undefined;
    private _timeoutInSeconds?;
    get timeoutInSeconds(): number;
    set timeoutInSeconds(value: number);
    resetTimeoutInSeconds(): void;
    get timeoutInSecondsInput(): number | undefined;
}
export declare class ArcKubernetesFluxConfigurationKustomizationsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ArcKubernetesFluxConfigurationKustomizations[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ArcKubernetesFluxConfigurationKustomizationsOutputReference;
}
export interface ArcKubernetesFluxConfigurationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/arc_kubernetes_flux_configuration#create ArcKubernetesFluxConfiguration#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/arc_kubernetes_flux_configuration#delete ArcKubernetesFluxConfiguration#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/arc_kubernetes_flux_configuration#read ArcKubernetesFluxConfiguration#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/arc_kubernetes_flux_configuration#update ArcKubernetesFluxConfiguration#update}
    */
    readonly update?: string;
}
export declare function arcKubernetesFluxConfigurationTimeoutsToTerraform(struct?: ArcKubernetesFluxConfigurationTimeouts | cdktf.IResolvable): any;
export declare class ArcKubernetesFluxConfigurationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ArcKubernetesFluxConfigurationTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ArcKubernetesFluxConfigurationTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/arc_kubernetes_flux_configuration azurerm_arc_kubernetes_flux_configuration}
*/
export declare class ArcKubernetesFluxConfiguration extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_arc_kubernetes_flux_configuration";
    /**
    * Generates CDKTF code for importing a ArcKubernetesFluxConfiguration resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ArcKubernetesFluxConfiguration to import
    * @param importFromId The id of the existing ArcKubernetesFluxConfiguration that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/arc_kubernetes_flux_configuration#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ArcKubernetesFluxConfiguration to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/resources/arc_kubernetes_flux_configuration azurerm_arc_kubernetes_flux_configuration} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ArcKubernetesFluxConfigurationConfig
    */
    constructor(scope: Construct, id: string, config: ArcKubernetesFluxConfigurationConfig);
    private _clusterId?;
    get clusterId(): string;
    set clusterId(value: string);
    get clusterIdInput(): string | undefined;
    private _continuousReconciliationEnabled?;
    get continuousReconciliationEnabled(): boolean | cdktf.IResolvable;
    set continuousReconciliationEnabled(value: boolean | cdktf.IResolvable);
    resetContinuousReconciliationEnabled(): void;
    get continuousReconciliationEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    get namespaceInput(): string | undefined;
    private _scope?;
    get scope(): string;
    set scope(value: string);
    resetScope(): void;
    get scopeInput(): string | undefined;
    private _blobStorage;
    get blobStorage(): ArcKubernetesFluxConfigurationBlobStorageOutputReference;
    putBlobStorage(value: ArcKubernetesFluxConfigurationBlobStorage): void;
    resetBlobStorage(): void;
    get blobStorageInput(): ArcKubernetesFluxConfigurationBlobStorage | undefined;
    private _bucket;
    get bucket(): ArcKubernetesFluxConfigurationBucketOutputReference;
    putBucket(value: ArcKubernetesFluxConfigurationBucket): void;
    resetBucket(): void;
    get bucketInput(): ArcKubernetesFluxConfigurationBucket | undefined;
    private _gitRepository;
    get gitRepository(): ArcKubernetesFluxConfigurationGitRepositoryOutputReference;
    putGitRepository(value: ArcKubernetesFluxConfigurationGitRepository): void;
    resetGitRepository(): void;
    get gitRepositoryInput(): ArcKubernetesFluxConfigurationGitRepository | undefined;
    private _kustomizations;
    get kustomizations(): ArcKubernetesFluxConfigurationKustomizationsList;
    putKustomizations(value: ArcKubernetesFluxConfigurationKustomizations[] | cdktf.IResolvable): void;
    get kustomizationsInput(): cdktf.IResolvable | ArcKubernetesFluxConfigurationKustomizations[] | undefined;
    private _timeouts;
    get timeouts(): ArcKubernetesFluxConfigurationTimeoutsOutputReference;
    putTimeouts(value: ArcKubernetesFluxConfigurationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ArcKubernetesFluxConfigurationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
