/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermActiveDirectoryDomainServiceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/data-sources/active_directory_domain_service#id DataAzurermActiveDirectoryDomainService#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/data-sources/active_directory_domain_service#name DataAzurermActiveDirectoryDomainService#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/data-sources/active_directory_domain_service#resource_group_name DataAzurermActiveDirectoryDomainService#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/data-sources/active_directory_domain_service#tags DataAzurermActiveDirectoryDomainService#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/data-sources/active_directory_domain_service#timeouts DataAzurermActiveDirectoryDomainService#timeouts}
    */
    readonly timeouts?: DataAzurermActiveDirectoryDomainServiceTimeouts;
}
export interface DataAzurermActiveDirectoryDomainServiceNotifications {
}
export declare function dataAzurermActiveDirectoryDomainServiceNotificationsToTerraform(struct?: DataAzurermActiveDirectoryDomainServiceNotifications): any;
export declare class DataAzurermActiveDirectoryDomainServiceNotificationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermActiveDirectoryDomainServiceNotifications | undefined;
    set internalValue(value: DataAzurermActiveDirectoryDomainServiceNotifications | undefined);
    get additionalRecipients(): string[];
    get notifyDcAdmins(): cdktf.IResolvable;
    get notifyGlobalAdmins(): cdktf.IResolvable;
}
export declare class DataAzurermActiveDirectoryDomainServiceNotificationsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermActiveDirectoryDomainServiceNotificationsOutputReference;
}
export interface DataAzurermActiveDirectoryDomainServiceReplicaSets {
}
export declare function dataAzurermActiveDirectoryDomainServiceReplicaSetsToTerraform(struct?: DataAzurermActiveDirectoryDomainServiceReplicaSets): any;
export declare class DataAzurermActiveDirectoryDomainServiceReplicaSetsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermActiveDirectoryDomainServiceReplicaSets | undefined;
    set internalValue(value: DataAzurermActiveDirectoryDomainServiceReplicaSets | undefined);
    get domainControllerIpAddresses(): string[];
    get externalAccessIpAddress(): string;
    get id(): string;
    get location(): string;
    get serviceStatus(): string;
    get subnetId(): string;
}
export declare class DataAzurermActiveDirectoryDomainServiceReplicaSetsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermActiveDirectoryDomainServiceReplicaSetsOutputReference;
}
export interface DataAzurermActiveDirectoryDomainServiceSecureLdap {
}
export declare function dataAzurermActiveDirectoryDomainServiceSecureLdapToTerraform(struct?: DataAzurermActiveDirectoryDomainServiceSecureLdap): any;
export declare class DataAzurermActiveDirectoryDomainServiceSecureLdapOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermActiveDirectoryDomainServiceSecureLdap | undefined;
    set internalValue(value: DataAzurermActiveDirectoryDomainServiceSecureLdap | undefined);
    get certificateExpiry(): string;
    get certificateThumbprint(): string;
    get enabled(): cdktf.IResolvable;
    get externalAccessEnabled(): cdktf.IResolvable;
    get publicCertificate(): string;
}
export declare class DataAzurermActiveDirectoryDomainServiceSecureLdapList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermActiveDirectoryDomainServiceSecureLdapOutputReference;
}
export interface DataAzurermActiveDirectoryDomainServiceSecurity {
}
export declare function dataAzurermActiveDirectoryDomainServiceSecurityToTerraform(struct?: DataAzurermActiveDirectoryDomainServiceSecurity): any;
export declare class DataAzurermActiveDirectoryDomainServiceSecurityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermActiveDirectoryDomainServiceSecurity | undefined;
    set internalValue(value: DataAzurermActiveDirectoryDomainServiceSecurity | undefined);
    get kerberosArmoringEnabled(): cdktf.IResolvable;
    get kerberosRc4EncryptionEnabled(): cdktf.IResolvable;
    get ntlmV1Enabled(): cdktf.IResolvable;
    get syncKerberosPasswords(): cdktf.IResolvable;
    get syncNtlmPasswords(): cdktf.IResolvable;
    get syncOnPremPasswords(): cdktf.IResolvable;
    get tlsV1Enabled(): cdktf.IResolvable;
}
export declare class DataAzurermActiveDirectoryDomainServiceSecurityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermActiveDirectoryDomainServiceSecurityOutputReference;
}
export interface DataAzurermActiveDirectoryDomainServiceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/data-sources/active_directory_domain_service#read DataAzurermActiveDirectoryDomainService#read}
    */
    readonly read?: string;
}
export declare function dataAzurermActiveDirectoryDomainServiceTimeoutsToTerraform(struct?: DataAzurermActiveDirectoryDomainServiceTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermActiveDirectoryDomainServiceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermActiveDirectoryDomainServiceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermActiveDirectoryDomainServiceTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/data-sources/active_directory_domain_service azurerm_active_directory_domain_service}
*/
export declare class DataAzurermActiveDirectoryDomainService extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_active_directory_domain_service";
    /**
    * Generates CDKTF code for importing a DataAzurermActiveDirectoryDomainService resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermActiveDirectoryDomainService to import
    * @param importFromId The id of the existing DataAzurermActiveDirectoryDomainService that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/data-sources/active_directory_domain_service#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermActiveDirectoryDomainService to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/data-sources/active_directory_domain_service azurerm_active_directory_domain_service} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermActiveDirectoryDomainServiceConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermActiveDirectoryDomainServiceConfig);
    get deploymentId(): string;
    get domainConfigurationType(): string;
    get domainName(): string;
    get filteredSyncEnabled(): cdktf.IResolvable;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _notifications;
    get notifications(): DataAzurermActiveDirectoryDomainServiceNotificationsList;
    private _replicaSets;
    get replicaSets(): DataAzurermActiveDirectoryDomainServiceReplicaSetsList;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get resourceId(): string;
    private _secureLdap;
    get secureLdap(): DataAzurermActiveDirectoryDomainServiceSecureLdapList;
    private _security;
    get security(): DataAzurermActiveDirectoryDomainServiceSecurityList;
    get sku(): string;
    get syncOwner(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    get tenantId(): string;
    get version(): number;
    private _timeouts;
    get timeouts(): DataAzurermActiveDirectoryDomainServiceTimeoutsOutputReference;
    putTimeouts(value: DataAzurermActiveDirectoryDomainServiceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermActiveDirectoryDomainServiceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
