/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermAppServiceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/data-sources/app_service#id DataAzurermAppService#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/data-sources/app_service#name DataAzurermAppService#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/data-sources/app_service#resource_group_name DataAzurermAppService#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/data-sources/app_service#timeouts DataAzurermAppService#timeouts}
    */
    readonly timeouts?: DataAzurermAppServiceTimeouts;
}
export interface DataAzurermAppServiceConnectionString {
}
export declare function dataAzurermAppServiceConnectionStringToTerraform(struct?: DataAzurermAppServiceConnectionString): any;
export declare class DataAzurermAppServiceConnectionStringOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermAppServiceConnectionString | undefined;
    set internalValue(value: DataAzurermAppServiceConnectionString | undefined);
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class DataAzurermAppServiceConnectionStringList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermAppServiceConnectionStringOutputReference;
}
export interface DataAzurermAppServiceSiteConfigCors {
}
export declare function dataAzurermAppServiceSiteConfigCorsToTerraform(struct?: DataAzurermAppServiceSiteConfigCors): any;
export declare class DataAzurermAppServiceSiteConfigCorsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermAppServiceSiteConfigCors | undefined;
    set internalValue(value: DataAzurermAppServiceSiteConfigCors | undefined);
    get allowedOrigins(): string[];
    get supportCredentials(): cdktf.IResolvable;
}
export declare class DataAzurermAppServiceSiteConfigCorsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermAppServiceSiteConfigCorsOutputReference;
}
export interface DataAzurermAppServiceSiteConfigIpRestrictionHeaders {
}
export declare function dataAzurermAppServiceSiteConfigIpRestrictionHeadersToTerraform(struct?: DataAzurermAppServiceSiteConfigIpRestrictionHeaders): any;
export declare class DataAzurermAppServiceSiteConfigIpRestrictionHeadersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermAppServiceSiteConfigIpRestrictionHeaders | undefined;
    set internalValue(value: DataAzurermAppServiceSiteConfigIpRestrictionHeaders | undefined);
    get xAzureFdid(): string[];
    get xFdHealthProbe(): string[];
    get xForwardedFor(): string[];
    get xForwardedHost(): string[];
}
export declare class DataAzurermAppServiceSiteConfigIpRestrictionHeadersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermAppServiceSiteConfigIpRestrictionHeadersOutputReference;
}
export interface DataAzurermAppServiceSiteConfigIpRestriction {
}
export declare function dataAzurermAppServiceSiteConfigIpRestrictionToTerraform(struct?: DataAzurermAppServiceSiteConfigIpRestriction): any;
export declare class DataAzurermAppServiceSiteConfigIpRestrictionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermAppServiceSiteConfigIpRestriction | undefined;
    set internalValue(value: DataAzurermAppServiceSiteConfigIpRestriction | undefined);
    get action(): string;
    private _headers;
    get headers(): DataAzurermAppServiceSiteConfigIpRestrictionHeadersList;
    get ipAddress(): string;
    get name(): string;
    get priority(): number;
    get serviceTag(): string;
    get virtualNetworkSubnetId(): string;
}
export declare class DataAzurermAppServiceSiteConfigIpRestrictionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermAppServiceSiteConfigIpRestrictionOutputReference;
}
export interface DataAzurermAppServiceSiteConfigScmIpRestrictionHeaders {
}
export declare function dataAzurermAppServiceSiteConfigScmIpRestrictionHeadersToTerraform(struct?: DataAzurermAppServiceSiteConfigScmIpRestrictionHeaders): any;
export declare class DataAzurermAppServiceSiteConfigScmIpRestrictionHeadersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermAppServiceSiteConfigScmIpRestrictionHeaders | undefined;
    set internalValue(value: DataAzurermAppServiceSiteConfigScmIpRestrictionHeaders | undefined);
    get xAzureFdid(): string[];
    get xFdHealthProbe(): string[];
    get xForwardedFor(): string[];
    get xForwardedHost(): string[];
}
export declare class DataAzurermAppServiceSiteConfigScmIpRestrictionHeadersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermAppServiceSiteConfigScmIpRestrictionHeadersOutputReference;
}
export interface DataAzurermAppServiceSiteConfigScmIpRestriction {
}
export declare function dataAzurermAppServiceSiteConfigScmIpRestrictionToTerraform(struct?: DataAzurermAppServiceSiteConfigScmIpRestriction): any;
export declare class DataAzurermAppServiceSiteConfigScmIpRestrictionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermAppServiceSiteConfigScmIpRestriction | undefined;
    set internalValue(value: DataAzurermAppServiceSiteConfigScmIpRestriction | undefined);
    get action(): string;
    private _headers;
    get headers(): DataAzurermAppServiceSiteConfigScmIpRestrictionHeadersList;
    get ipAddress(): string;
    get name(): string;
    get priority(): number;
    get serviceTag(): string;
    get virtualNetworkSubnetId(): string;
}
export declare class DataAzurermAppServiceSiteConfigScmIpRestrictionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermAppServiceSiteConfigScmIpRestrictionOutputReference;
}
export interface DataAzurermAppServiceSiteConfig {
}
export declare function dataAzurermAppServiceSiteConfigToTerraform(struct?: DataAzurermAppServiceSiteConfig): any;
export declare class DataAzurermAppServiceSiteConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermAppServiceSiteConfig | undefined;
    set internalValue(value: DataAzurermAppServiceSiteConfig | undefined);
    get acrUseManagedIdentityCredentials(): cdktf.IResolvable;
    get acrUserManagedIdentityClientId(): string;
    get alwaysOn(): cdktf.IResolvable;
    get appCommandLine(): string;
    private _cors;
    get cors(): DataAzurermAppServiceSiteConfigCorsList;
    get defaultDocuments(): string[];
    get dotnetFrameworkVersion(): string;
    get ftpsState(): string;
    get healthCheckPath(): string;
    get http2Enabled(): cdktf.IResolvable;
    private _ipRestriction;
    get ipRestriction(): DataAzurermAppServiceSiteConfigIpRestrictionList;
    get javaContainer(): string;
    get javaContainerVersion(): string;
    get javaVersion(): string;
    get linuxFxVersion(): string;
    get localMysqlEnabled(): cdktf.IResolvable;
    get managedPipelineMode(): string;
    get minTlsVersion(): string;
    get numberOfWorkers(): number;
    get phpVersion(): string;
    get pythonVersion(): string;
    get remoteDebuggingEnabled(): cdktf.IResolvable;
    get remoteDebuggingVersion(): string;
    private _scmIpRestriction;
    get scmIpRestriction(): DataAzurermAppServiceSiteConfigScmIpRestrictionList;
    get scmType(): string;
    get scmUseMainIpRestriction(): cdktf.IResolvable;
    get use32BitWorkerProcess(): cdktf.IResolvable;
    get vnetRouteAllEnabled(): cdktf.IResolvable;
    get websocketsEnabled(): cdktf.IResolvable;
    get windowsFxVersion(): string;
}
export declare class DataAzurermAppServiceSiteConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermAppServiceSiteConfigOutputReference;
}
export interface DataAzurermAppServiceSiteCredential {
}
export declare function dataAzurermAppServiceSiteCredentialToTerraform(struct?: DataAzurermAppServiceSiteCredential): any;
export declare class DataAzurermAppServiceSiteCredentialOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermAppServiceSiteCredential | undefined;
    set internalValue(value: DataAzurermAppServiceSiteCredential | undefined);
    get password(): string;
    get username(): string;
}
export declare class DataAzurermAppServiceSiteCredentialList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermAppServiceSiteCredentialOutputReference;
}
export interface DataAzurermAppServiceSourceControl {
}
export declare function dataAzurermAppServiceSourceControlToTerraform(struct?: DataAzurermAppServiceSourceControl): any;
export declare class DataAzurermAppServiceSourceControlOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermAppServiceSourceControl | undefined;
    set internalValue(value: DataAzurermAppServiceSourceControl | undefined);
    get branch(): string;
    get manualIntegration(): cdktf.IResolvable;
    get repoUrl(): string;
    get rollbackEnabled(): cdktf.IResolvable;
    get useMercurial(): cdktf.IResolvable;
}
export declare class DataAzurermAppServiceSourceControlList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermAppServiceSourceControlOutputReference;
}
export interface DataAzurermAppServiceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/data-sources/app_service#read DataAzurermAppService#read}
    */
    readonly read?: string;
}
export declare function dataAzurermAppServiceTimeoutsToTerraform(struct?: DataAzurermAppServiceTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermAppServiceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermAppServiceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermAppServiceTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/data-sources/app_service azurerm_app_service}
*/
export declare class DataAzurermAppService extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_app_service";
    /**
    * Generates CDKTF code for importing a DataAzurermAppService resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermAppService to import
    * @param importFromId The id of the existing DataAzurermAppService that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/data-sources/app_service#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermAppService to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/data-sources/app_service azurerm_app_service} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermAppServiceConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermAppServiceConfig);
    get appServicePlanId(): string;
    private _appSettings;
    get appSettings(): cdktf.StringMap;
    get clientAffinityEnabled(): cdktf.IResolvable;
    get clientCertEnabled(): cdktf.IResolvable;
    private _connectionString;
    get connectionString(): DataAzurermAppServiceConnectionStringList;
    get customDomainVerificationId(): string;
    get defaultSiteHostname(): string;
    get enabled(): cdktf.IResolvable;
    get httpsOnly(): cdktf.IResolvable;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get outboundIpAddressList(): string[];
    get outboundIpAddresses(): string;
    get possibleOutboundIpAddressList(): string[];
    get possibleOutboundIpAddresses(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _siteConfig;
    get siteConfig(): DataAzurermAppServiceSiteConfigList;
    private _siteCredential;
    get siteCredential(): DataAzurermAppServiceSiteCredentialList;
    private _sourceControl;
    get sourceControl(): DataAzurermAppServiceSourceControlList;
    private _tags;
    get tags(): cdktf.StringMap;
    private _timeouts;
    get timeouts(): DataAzurermAppServiceTimeoutsOutputReference;
    putTimeouts(value: DataAzurermAppServiceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermAppServiceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
