/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermAutomationVariablesConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/data-sources/automation_variables#automation_account_id DataAzurermAutomationVariables#automation_account_id}
    */
    readonly automationAccountId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/data-sources/automation_variables#id DataAzurermAutomationVariables#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/data-sources/automation_variables#timeouts DataAzurermAutomationVariables#timeouts}
    */
    readonly timeouts?: DataAzurermAutomationVariablesTimeouts;
}
export interface DataAzurermAutomationVariablesBool {
}
export declare function dataAzurermAutomationVariablesBoolToTerraform(struct?: DataAzurermAutomationVariablesBool): any;
export declare class DataAzurermAutomationVariablesBoolOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermAutomationVariablesBool | undefined;
    set internalValue(value: DataAzurermAutomationVariablesBool | undefined);
    get description(): string;
    get encrypted(): cdktf.IResolvable;
    get id(): string;
    get name(): string;
    get value(): cdktf.IResolvable;
}
export declare class DataAzurermAutomationVariablesBoolList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermAutomationVariablesBoolOutputReference;
}
export interface DataAzurermAutomationVariablesDatetime {
}
export declare function dataAzurermAutomationVariablesDatetimeToTerraform(struct?: DataAzurermAutomationVariablesDatetime): any;
export declare class DataAzurermAutomationVariablesDatetimeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermAutomationVariablesDatetime | undefined;
    set internalValue(value: DataAzurermAutomationVariablesDatetime | undefined);
    get description(): string;
    get encrypted(): cdktf.IResolvable;
    get id(): string;
    get name(): string;
    get value(): string;
}
export declare class DataAzurermAutomationVariablesDatetimeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermAutomationVariablesDatetimeOutputReference;
}
export interface DataAzurermAutomationVariablesEncrypted {
}
export declare function dataAzurermAutomationVariablesEncryptedToTerraform(struct?: DataAzurermAutomationVariablesEncrypted): any;
export declare class DataAzurermAutomationVariablesEncryptedOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermAutomationVariablesEncrypted | undefined;
    set internalValue(value: DataAzurermAutomationVariablesEncrypted | undefined);
    get description(): string;
    get encrypted(): cdktf.IResolvable;
    get id(): string;
    get name(): string;
    get value(): string;
}
export declare class DataAzurermAutomationVariablesEncryptedList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermAutomationVariablesEncryptedOutputReference;
}
export interface DataAzurermAutomationVariablesInt {
}
export declare function dataAzurermAutomationVariablesIntToTerraform(struct?: DataAzurermAutomationVariablesInt): any;
export declare class DataAzurermAutomationVariablesIntOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermAutomationVariablesInt | undefined;
    set internalValue(value: DataAzurermAutomationVariablesInt | undefined);
    get description(): string;
    get encrypted(): cdktf.IResolvable;
    get id(): string;
    get name(): string;
    get value(): number;
}
export declare class DataAzurermAutomationVariablesIntList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermAutomationVariablesIntOutputReference;
}
export interface DataAzurermAutomationVariablesNull {
}
export declare function dataAzurermAutomationVariablesNullToTerraform(struct?: DataAzurermAutomationVariablesNull): any;
export declare class DataAzurermAutomationVariablesNullOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermAutomationVariablesNull | undefined;
    set internalValue(value: DataAzurermAutomationVariablesNull | undefined);
    get description(): string;
    get encrypted(): cdktf.IResolvable;
    get id(): string;
    get name(): string;
    get value(): string;
}
export declare class DataAzurermAutomationVariablesNullList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermAutomationVariablesNullOutputReference;
}
export interface DataAzurermAutomationVariablesObject {
}
export declare function dataAzurermAutomationVariablesObjectToTerraform(struct?: DataAzurermAutomationVariablesObject): any;
export declare class DataAzurermAutomationVariablesObjectOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermAutomationVariablesObject | undefined;
    set internalValue(value: DataAzurermAutomationVariablesObject | undefined);
    get description(): string;
    get encrypted(): cdktf.IResolvable;
    get id(): string;
    get name(): string;
    get value(): string;
}
export declare class DataAzurermAutomationVariablesObjectList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermAutomationVariablesObjectOutputReference;
}
export interface DataAzurermAutomationVariablesString {
}
export declare function dataAzurermAutomationVariablesStringToTerraform(struct?: DataAzurermAutomationVariablesString): any;
export declare class DataAzurermAutomationVariablesStringOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermAutomationVariablesString | undefined;
    set internalValue(value: DataAzurermAutomationVariablesString | undefined);
    get description(): string;
    get encrypted(): cdktf.IResolvable;
    get id(): string;
    get name(): string;
    get value(): string;
}
export declare class DataAzurermAutomationVariablesStringList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermAutomationVariablesStringOutputReference;
}
export interface DataAzurermAutomationVariablesTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/data-sources/automation_variables#read DataAzurermAutomationVariables#read}
    */
    readonly read?: string;
}
export declare function dataAzurermAutomationVariablesTimeoutsToTerraform(struct?: DataAzurermAutomationVariablesTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermAutomationVariablesTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermAutomationVariablesTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermAutomationVariablesTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/data-sources/automation_variables azurerm_automation_variables}
*/
export declare class DataAzurermAutomationVariables extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_automation_variables";
    /**
    * Generates CDKTF code for importing a DataAzurermAutomationVariables resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermAutomationVariables to import
    * @param importFromId The id of the existing DataAzurermAutomationVariables that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/data-sources/automation_variables#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermAutomationVariables to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/data-sources/automation_variables azurerm_automation_variables} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermAutomationVariablesConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermAutomationVariablesConfig);
    private _automationAccountId?;
    get automationAccountId(): string;
    set automationAccountId(value: string);
    get automationAccountIdInput(): string | undefined;
    private _bool;
    get bool(): DataAzurermAutomationVariablesBoolList;
    private _datetime;
    get datetime(): DataAzurermAutomationVariablesDatetimeList;
    private _encrypted;
    get encrypted(): DataAzurermAutomationVariablesEncryptedList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _int;
    get int(): DataAzurermAutomationVariablesIntList;
    private _null;
    get null(): DataAzurermAutomationVariablesNullList;
    private _object;
    get object(): DataAzurermAutomationVariablesObjectList;
    private _string;
    get string(): DataAzurermAutomationVariablesStringList;
    private _timeouts;
    get timeouts(): DataAzurermAutomationVariablesTimeoutsOutputReference;
    putTimeouts(value: DataAzurermAutomationVariablesTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermAutomationVariablesTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
