/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermSentinelAlertRuleAnomalyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/data-sources/sentinel_alert_rule_anomaly#display_name DataAzurermSentinelAlertRuleAnomaly#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/data-sources/sentinel_alert_rule_anomaly#id DataAzurermSentinelAlertRuleAnomaly#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/data-sources/sentinel_alert_rule_anomaly#log_analytics_workspace_id DataAzurermSentinelAlertRuleAnomaly#log_analytics_workspace_id}
    */
    readonly logAnalyticsWorkspaceId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/data-sources/sentinel_alert_rule_anomaly#name DataAzurermSentinelAlertRuleAnomaly#name}
    */
    readonly name?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/data-sources/sentinel_alert_rule_anomaly#timeouts DataAzurermSentinelAlertRuleAnomaly#timeouts}
    */
    readonly timeouts?: DataAzurermSentinelAlertRuleAnomalyTimeouts;
}
export interface DataAzurermSentinelAlertRuleAnomalyMultiSelectObservation {
}
export declare function dataAzurermSentinelAlertRuleAnomalyMultiSelectObservationToTerraform(struct?: DataAzurermSentinelAlertRuleAnomalyMultiSelectObservation): any;
export declare class DataAzurermSentinelAlertRuleAnomalyMultiSelectObservationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermSentinelAlertRuleAnomalyMultiSelectObservation | undefined;
    set internalValue(value: DataAzurermSentinelAlertRuleAnomalyMultiSelectObservation | undefined);
    get description(): string;
    get name(): string;
    get supportedValues(): string[];
    get values(): string[];
}
export declare class DataAzurermSentinelAlertRuleAnomalyMultiSelectObservationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermSentinelAlertRuleAnomalyMultiSelectObservationOutputReference;
}
export interface DataAzurermSentinelAlertRuleAnomalyPrioritizedExcludeObservation {
}
export declare function dataAzurermSentinelAlertRuleAnomalyPrioritizedExcludeObservationToTerraform(struct?: DataAzurermSentinelAlertRuleAnomalyPrioritizedExcludeObservation): any;
export declare class DataAzurermSentinelAlertRuleAnomalyPrioritizedExcludeObservationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermSentinelAlertRuleAnomalyPrioritizedExcludeObservation | undefined;
    set internalValue(value: DataAzurermSentinelAlertRuleAnomalyPrioritizedExcludeObservation | undefined);
    get description(): string;
    get exclude(): string;
    get name(): string;
    get prioritize(): string;
}
export declare class DataAzurermSentinelAlertRuleAnomalyPrioritizedExcludeObservationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermSentinelAlertRuleAnomalyPrioritizedExcludeObservationOutputReference;
}
export interface DataAzurermSentinelAlertRuleAnomalyRequiredDataConnector {
}
export declare function dataAzurermSentinelAlertRuleAnomalyRequiredDataConnectorToTerraform(struct?: DataAzurermSentinelAlertRuleAnomalyRequiredDataConnector): any;
export declare class DataAzurermSentinelAlertRuleAnomalyRequiredDataConnectorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermSentinelAlertRuleAnomalyRequiredDataConnector | undefined;
    set internalValue(value: DataAzurermSentinelAlertRuleAnomalyRequiredDataConnector | undefined);
    get connectorId(): string;
    get dataTypes(): string[];
}
export declare class DataAzurermSentinelAlertRuleAnomalyRequiredDataConnectorList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermSentinelAlertRuleAnomalyRequiredDataConnectorOutputReference;
}
export interface DataAzurermSentinelAlertRuleAnomalySingleSelectObservation {
}
export declare function dataAzurermSentinelAlertRuleAnomalySingleSelectObservationToTerraform(struct?: DataAzurermSentinelAlertRuleAnomalySingleSelectObservation): any;
export declare class DataAzurermSentinelAlertRuleAnomalySingleSelectObservationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermSentinelAlertRuleAnomalySingleSelectObservation | undefined;
    set internalValue(value: DataAzurermSentinelAlertRuleAnomalySingleSelectObservation | undefined);
    get description(): string;
    get name(): string;
    get supportedValues(): string[];
    get value(): string;
}
export declare class DataAzurermSentinelAlertRuleAnomalySingleSelectObservationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermSentinelAlertRuleAnomalySingleSelectObservationOutputReference;
}
export interface DataAzurermSentinelAlertRuleAnomalyThresholdObservation {
}
export declare function dataAzurermSentinelAlertRuleAnomalyThresholdObservationToTerraform(struct?: DataAzurermSentinelAlertRuleAnomalyThresholdObservation): any;
export declare class DataAzurermSentinelAlertRuleAnomalyThresholdObservationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermSentinelAlertRuleAnomalyThresholdObservation | undefined;
    set internalValue(value: DataAzurermSentinelAlertRuleAnomalyThresholdObservation | undefined);
    get description(): string;
    get max(): string;
    get min(): string;
    get name(): string;
    get value(): string;
}
export declare class DataAzurermSentinelAlertRuleAnomalyThresholdObservationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermSentinelAlertRuleAnomalyThresholdObservationOutputReference;
}
export interface DataAzurermSentinelAlertRuleAnomalyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/data-sources/sentinel_alert_rule_anomaly#read DataAzurermSentinelAlertRuleAnomaly#read}
    */
    readonly read?: string;
}
export declare function dataAzurermSentinelAlertRuleAnomalyTimeoutsToTerraform(struct?: DataAzurermSentinelAlertRuleAnomalyTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermSentinelAlertRuleAnomalyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermSentinelAlertRuleAnomalyTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermSentinelAlertRuleAnomalyTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/data-sources/sentinel_alert_rule_anomaly azurerm_sentinel_alert_rule_anomaly}
*/
export declare class DataAzurermSentinelAlertRuleAnomaly extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_sentinel_alert_rule_anomaly";
    /**
    * Generates CDKTF code for importing a DataAzurermSentinelAlertRuleAnomaly resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermSentinelAlertRuleAnomaly to import
    * @param importFromId The id of the existing DataAzurermSentinelAlertRuleAnomaly that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/data-sources/sentinel_alert_rule_anomaly#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermSentinelAlertRuleAnomaly to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/data-sources/sentinel_alert_rule_anomaly azurerm_sentinel_alert_rule_anomaly} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermSentinelAlertRuleAnomalyConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermSentinelAlertRuleAnomalyConfig);
    get anomalySettingsVersion(): number;
    get anomalyVersion(): string;
    get description(): string;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    get enabled(): cdktf.IResolvable;
    get frequency(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _logAnalyticsWorkspaceId?;
    get logAnalyticsWorkspaceId(): string;
    set logAnalyticsWorkspaceId(value: string);
    get logAnalyticsWorkspaceIdInput(): string | undefined;
    get mode(): string;
    private _multiSelectObservation;
    get multiSelectObservation(): DataAzurermSentinelAlertRuleAnomalyMultiSelectObservationList;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _prioritizedExcludeObservation;
    get prioritizedExcludeObservation(): DataAzurermSentinelAlertRuleAnomalyPrioritizedExcludeObservationList;
    private _requiredDataConnector;
    get requiredDataConnector(): DataAzurermSentinelAlertRuleAnomalyRequiredDataConnectorList;
    get settingsDefinitionId(): string;
    private _singleSelectObservation;
    get singleSelectObservation(): DataAzurermSentinelAlertRuleAnomalySingleSelectObservationList;
    get tactics(): string[];
    get techniques(): string[];
    private _thresholdObservation;
    get thresholdObservation(): DataAzurermSentinelAlertRuleAnomalyThresholdObservationList;
    private _timeouts;
    get timeouts(): DataAzurermSentinelAlertRuleAnomalyTimeoutsOutputReference;
    putTimeouts(value: DataAzurermSentinelAlertRuleAnomalyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermSentinelAlertRuleAnomalyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
