/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermSpringCloudServiceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/data-sources/spring_cloud_service#id DataAzurermSpringCloudService#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/data-sources/spring_cloud_service#name DataAzurermSpringCloudService#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/data-sources/spring_cloud_service#resource_group_name DataAzurermSpringCloudService#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/data-sources/spring_cloud_service#timeouts DataAzurermSpringCloudService#timeouts}
    */
    readonly timeouts?: DataAzurermSpringCloudServiceTimeouts;
}
export interface DataAzurermSpringCloudServiceConfigServerGitSettingHttpBasicAuth {
}
export declare function dataAzurermSpringCloudServiceConfigServerGitSettingHttpBasicAuthToTerraform(struct?: DataAzurermSpringCloudServiceConfigServerGitSettingHttpBasicAuth): any;
export declare class DataAzurermSpringCloudServiceConfigServerGitSettingHttpBasicAuthOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermSpringCloudServiceConfigServerGitSettingHttpBasicAuth | undefined;
    set internalValue(value: DataAzurermSpringCloudServiceConfigServerGitSettingHttpBasicAuth | undefined);
    get password(): string;
    get username(): string;
}
export declare class DataAzurermSpringCloudServiceConfigServerGitSettingHttpBasicAuthList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermSpringCloudServiceConfigServerGitSettingHttpBasicAuthOutputReference;
}
export interface DataAzurermSpringCloudServiceConfigServerGitSettingRepositoryHttpBasicAuth {
}
export declare function dataAzurermSpringCloudServiceConfigServerGitSettingRepositoryHttpBasicAuthToTerraform(struct?: DataAzurermSpringCloudServiceConfigServerGitSettingRepositoryHttpBasicAuth): any;
export declare class DataAzurermSpringCloudServiceConfigServerGitSettingRepositoryHttpBasicAuthOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermSpringCloudServiceConfigServerGitSettingRepositoryHttpBasicAuth | undefined;
    set internalValue(value: DataAzurermSpringCloudServiceConfigServerGitSettingRepositoryHttpBasicAuth | undefined);
    get password(): string;
    get username(): string;
}
export declare class DataAzurermSpringCloudServiceConfigServerGitSettingRepositoryHttpBasicAuthList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermSpringCloudServiceConfigServerGitSettingRepositoryHttpBasicAuthOutputReference;
}
export interface DataAzurermSpringCloudServiceConfigServerGitSettingRepositorySshAuth {
}
export declare function dataAzurermSpringCloudServiceConfigServerGitSettingRepositorySshAuthToTerraform(struct?: DataAzurermSpringCloudServiceConfigServerGitSettingRepositorySshAuth): any;
export declare class DataAzurermSpringCloudServiceConfigServerGitSettingRepositorySshAuthOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermSpringCloudServiceConfigServerGitSettingRepositorySshAuth | undefined;
    set internalValue(value: DataAzurermSpringCloudServiceConfigServerGitSettingRepositorySshAuth | undefined);
    get hostKey(): string;
    get hostKeyAlgorithm(): string;
    get privateKey(): string;
    get strictHostKeyCheckingEnabled(): cdktf.IResolvable;
}
export declare class DataAzurermSpringCloudServiceConfigServerGitSettingRepositorySshAuthList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermSpringCloudServiceConfigServerGitSettingRepositorySshAuthOutputReference;
}
export interface DataAzurermSpringCloudServiceConfigServerGitSettingRepository {
}
export declare function dataAzurermSpringCloudServiceConfigServerGitSettingRepositoryToTerraform(struct?: DataAzurermSpringCloudServiceConfigServerGitSettingRepository): any;
export declare class DataAzurermSpringCloudServiceConfigServerGitSettingRepositoryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermSpringCloudServiceConfigServerGitSettingRepository | undefined;
    set internalValue(value: DataAzurermSpringCloudServiceConfigServerGitSettingRepository | undefined);
    private _httpBasicAuth;
    get httpBasicAuth(): DataAzurermSpringCloudServiceConfigServerGitSettingRepositoryHttpBasicAuthList;
    get label(): string;
    get name(): string;
    get pattern(): string[];
    get searchPaths(): string[];
    private _sshAuth;
    get sshAuth(): DataAzurermSpringCloudServiceConfigServerGitSettingRepositorySshAuthList;
    get uri(): string;
}
export declare class DataAzurermSpringCloudServiceConfigServerGitSettingRepositoryList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermSpringCloudServiceConfigServerGitSettingRepositoryOutputReference;
}
export interface DataAzurermSpringCloudServiceConfigServerGitSettingSshAuth {
}
export declare function dataAzurermSpringCloudServiceConfigServerGitSettingSshAuthToTerraform(struct?: DataAzurermSpringCloudServiceConfigServerGitSettingSshAuth): any;
export declare class DataAzurermSpringCloudServiceConfigServerGitSettingSshAuthOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermSpringCloudServiceConfigServerGitSettingSshAuth | undefined;
    set internalValue(value: DataAzurermSpringCloudServiceConfigServerGitSettingSshAuth | undefined);
    get hostKey(): string;
    get hostKeyAlgorithm(): string;
    get privateKey(): string;
    get strictHostKeyCheckingEnabled(): cdktf.IResolvable;
}
export declare class DataAzurermSpringCloudServiceConfigServerGitSettingSshAuthList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermSpringCloudServiceConfigServerGitSettingSshAuthOutputReference;
}
export interface DataAzurermSpringCloudServiceConfigServerGitSetting {
}
export declare function dataAzurermSpringCloudServiceConfigServerGitSettingToTerraform(struct?: DataAzurermSpringCloudServiceConfigServerGitSetting): any;
export declare class DataAzurermSpringCloudServiceConfigServerGitSettingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermSpringCloudServiceConfigServerGitSetting | undefined;
    set internalValue(value: DataAzurermSpringCloudServiceConfigServerGitSetting | undefined);
    private _httpBasicAuth;
    get httpBasicAuth(): DataAzurermSpringCloudServiceConfigServerGitSettingHttpBasicAuthList;
    get label(): string;
    private _repository;
    get repository(): DataAzurermSpringCloudServiceConfigServerGitSettingRepositoryList;
    get searchPaths(): string[];
    private _sshAuth;
    get sshAuth(): DataAzurermSpringCloudServiceConfigServerGitSettingSshAuthList;
    get uri(): string;
}
export declare class DataAzurermSpringCloudServiceConfigServerGitSettingList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermSpringCloudServiceConfigServerGitSettingOutputReference;
}
export interface DataAzurermSpringCloudServiceRequiredNetworkTrafficRules {
}
export declare function dataAzurermSpringCloudServiceRequiredNetworkTrafficRulesToTerraform(struct?: DataAzurermSpringCloudServiceRequiredNetworkTrafficRules): any;
export declare class DataAzurermSpringCloudServiceRequiredNetworkTrafficRulesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermSpringCloudServiceRequiredNetworkTrafficRules | undefined;
    set internalValue(value: DataAzurermSpringCloudServiceRequiredNetworkTrafficRules | undefined);
    get direction(): string;
    get fqdns(): string[];
    get ipAddresses(): string[];
    get port(): number;
    get protocol(): string;
}
export declare class DataAzurermSpringCloudServiceRequiredNetworkTrafficRulesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermSpringCloudServiceRequiredNetworkTrafficRulesOutputReference;
}
export interface DataAzurermSpringCloudServiceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/data-sources/spring_cloud_service#read DataAzurermSpringCloudService#read}
    */
    readonly read?: string;
}
export declare function dataAzurermSpringCloudServiceTimeoutsToTerraform(struct?: DataAzurermSpringCloudServiceTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermSpringCloudServiceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermSpringCloudServiceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermSpringCloudServiceTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/data-sources/spring_cloud_service azurerm_spring_cloud_service}
*/
export declare class DataAzurermSpringCloudService extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_spring_cloud_service";
    /**
    * Generates CDKTF code for importing a DataAzurermSpringCloudService resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermSpringCloudService to import
    * @param importFromId The id of the existing DataAzurermSpringCloudService that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/data-sources/spring_cloud_service#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermSpringCloudService to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.77.0/docs/data-sources/spring_cloud_service azurerm_spring_cloud_service} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermSpringCloudServiceConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermSpringCloudServiceConfig);
    private _configServerGitSetting;
    get configServerGitSetting(): DataAzurermSpringCloudServiceConfigServerGitSettingList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get outboundPublicIpAddresses(): string[];
    private _requiredNetworkTrafficRules;
    get requiredNetworkTrafficRules(): DataAzurermSpringCloudServiceRequiredNetworkTrafficRulesList;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags;
    get tags(): cdktf.StringMap;
    private _timeouts;
    get timeouts(): DataAzurermSpringCloudServiceTimeoutsOutputReference;
    putTimeouts(value: DataAzurermSpringCloudServiceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermSpringCloudServiceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
